Name Player_Stealth

CONST
END	//Const

////////// State machine Main ///////////////
MACHINE "Command"

	///////  CancelTask  ////////////////////////////////////
	STATE	CancelTask
	
		RULE 	event In	
			:action
				O:tClearCommand();
			:end
		END
		
	END	//STATE CancelTask
			
	///////  Approach  ////////////////////////////////////	
	STATE	Approach
	
		RULE 	event In 	
			:action				
				SelectDevices(74, O.Own_Ship, S.working & InSet(S.this, 9));		//Stealth device
				If(NumOf(74), ExecList(74, ActivateDevice(S.this, 1)));
				
				ChooseFirst(
					O.Cmd_Beh=1, GetMachine("Behaviour"):ChangeState(Aggressive, 0), 		// aggressziv allapot
					O.Cmd_Beh=2, GetMachine("Behaviour"):ChangeState(Defensive, 0), 		// defenziv allapot
					O.Cmd_Beh=3, GetMachine("Behaviour"):ChangeState(Cautious, 0),			// menekulo allapot
					O.Cmd_Beh=4, GetMachine("Behaviour"):ChangeState(NoFire, 0)	 			// clirnyos allapot
				);
			:end
		END
		
		////////// State machine Behaviour ///////////////
		MACHINE "Behaviour"
		
			///////  Aggressive  ///////////////////////////////////
			STATE Aggressive
			
				RULE 	event In 	
					:action
						O:tClearForbid(0);
						O:tSetForbid(#FORBID_MOTION_MOTIVATION);		//Osszes sajat mozgas tiltasa
						O:tSetForbid(#FORBID_FIRE+#FORBID_SHIELD);		//nincs tzels, nincs sajt pajzskezels

						LocalEvent(CollectDevices, 0);
						ExecList(70, ActivateDevice(S.this, 0));
						ExecList(71, ActivateDevice(S.this, 0));
						ExecList(72, ActivateDevice(S.this, 0));
						ExecList(73, ActivateDevice(S.this, 0));

						If(O.Main_Target:gate, 
							While(VSqLen(kozelito:=VSub(O.Own_Ship:position, O.Main_Target:position))=0, 0);
							kozelito:=VAdd(O.Main_Target:position, VMul(2500, VNorm(kozelito)));
							CloseAbs(O.Own_Ship, kozelito,0,0);
							O:tSetForbid(#FORBID_MOTION);
						,
							O:tMoveTo(O.Main_Target, 2, 1);		//Move to optimal Range
						);
						O:tEngineMode(3);						
					:end
				END

				RULE 	event Tick
					:action
						SelectShips(20, S.race=O.Main_Target:O.Own_Ship:race & GetRelation(O.Own_Ship:race, S.race)=2 & GetDetected(O.Own_Ship, S.race) & Range(S.this, O.Own_Ship)<=3);	// minden artillerynel kozelebb levo engem detektalt ellenseges hajo levalogatasa
						If(NumOf(20), 
							ExecList(71, ActivateDevice(S.this, 1))
							, 
							ExecList(71, ActivateDevice(S.this, 0))
						);
					:end
				END
				Tick 5.5
				
				#include "Behaviour_Rules.inc"

			END	//STATE Aggressive
			
			///////  Defensive  ///////////////////////////////////
			STATE Defensive

				RULE 	event In 	
					:action
						O:tClearForbid(0);
						O:tSetForbid(#FORBID_MOTION_MOTIVATION);		//Osszes sajat mozgas tiltasa
						O:tSetForbid(#FORBID_FIRE+#FORBID_SHIELD);		//nincs tzels, nincs sajt pajzskezels

						LocalEvent(CollectDevices, 0);
						ExecList(70, ActivateDevice(S.this, 0));
						ExecList(71, ActivateDevice(S.this, 0));
						ExecList(72, ActivateDevice(S.this, 0));
						ExecList(73, ActivateDevice(S.this, 0));

						If(O.Main_Target:gate, 
							While(VSqLen(kozelito:=VSub(O.Own_Ship:position, O.Main_Target:position))=0, 0);
							kozelito:=VAdd(O.Main_Target:position, VMul(2500, VNorm(kozelito)));
							CloseAbs(O.Own_Ship, kozelito,0,0);
							O:tSetForbid(#FORBID_MOTION);
						,
							O:tMoveTo(O.Main_Target, 2, 1);		//Move to optimal Range
						);
						
						O:tEngineMode(3);
					:end
				END

				RULE 	event Tick
					:action
						SelectShips(20, S.race=O.Main_Target:O.Own_Ship:race & GetRelation(O.Own_Ship:race, S.race)=2 & GetDetected(O.Own_Ship, S.race) & Range(S.this, O.Own_Ship)<=3);	// minden artillerynel kozelebb levo engem detektalt ellenseges hajo levalogatasa
						If(NumOf(20), 
							ExecList(73, ActivateDevice(S.this, 1));
							ExecList(71, ActivateDevice(S.this, 1))
							, 
							ExecList(73, ActivateDevice(S.this, 0));
							ExecList(71, ActivateDevice(S.this, 0))
						);
					:end
				END
				Tick 5.5

				#include "Behaviour_Rules.inc"

			END	//STATE Defensive
			
			///////  Cautious  ///////////////////////////////////
			STATE Cautious

				RULE 	event In 	
					:action
						O:tClearForbid(0);
						O:tSetForbid(#FORBID_MOTION_MOTIVATION);		//Osszes sajat mozgas tiltasa
						O:tClearForbid(#FORBID_MOTION_MOTIVATION_AWAY);			//Osszes sajat mozgas tiltasa, kivve Away
						O:tSetForbid(#FORBID_FIRE+#FORBID_SHIELD);		//nincs tzels, nincs sajt pajzskezels
						
						LocalEvent(CollectDevices, 0);
						ExecList(70, ActivateDevice(S.this, 0));
						ExecList(71, ActivateDevice(S.this, 1));
						ExecList(72, ActivateDevice(S.this, 0));

						If(O.Main_Target:gate, 
							While(VSqLen(kozelito:=VSub(O.Own_Ship:position, O.Main_Target:position))=0, 0);
							kozelito:=VAdd(O.Main_Target:position, VMul(2500, VNorm(kozelito)));
							CloseAbs(O.Own_Ship, kozelito,0,0);
							O:tSetForbid(#FORBID_MOTION);
						,
							O:tMoveTo(O.Main_Target, 2, 1);		//Move to optimal Range
						);
						O:tEngineMode(3);
					:end
				END

				RULE 	event Tick
					:action		
						SelectShips(20, S.race!=O.Own_Ship:race & GetRelation(O.Own_Ship:race, S.race)=2 & GetDetected(O.Own_Ship, S.race) & Range(S.this, O.Own_Ship)<=3);	// minden artillerynel kozelebb levo engem detektalt ellenseges hajo levalogatasa
						If(NumOf(20), 
							ExecList(73, ActivateDevice(S.this, 1))
							, 
							ExecList(73, ActivateDevice(S.this, 0))
						);
					:end
				END
				Tick 5.5

				#include "Behaviour_Rules.inc"

			END	//STATE Cautious
			
			///////  NoFire  ///////////////////////////////////
			STATE NoFire

				RULE 	event In 	
					:action
						O:tClearForbid(0);
						O:tSetForbid(#FORBID_MOTION_MOTIVATION);		//Osszes sajat mozgas tiltasa
						O:tSetForbid(#FORBID_FIRE+#FORBID_SHIELD);		//nincs tzels, nincs sajt pajzskezels

						LocalEvent(CollectDevices, 0);
						ExecList(70, ActivateDevice(S.this, 0));
						ExecList(71, ActivateDevice(S.this, 0));
						ExecList(72, ActivateDevice(S.this, 0));
						ExecList(73, ActivateDevice(S.this, 0));
						
						If(O.Main_Target:gate, 
							While(VSqLen(kozelito:=VSub(O.Own_Ship:position, O.Main_Target:position))=0, 0);
							kozelito:=VAdd(O.Main_Target:position, VMul(2500, VNorm(kozelito)));
							CloseAbs(O.Own_Ship, kozelito,0,0);
							O:tSetForbid(#FORBID_MOTION);
						,
							O:tMoveTo(O.Main_Target, 2, 1);		//Move to optimal Range
						);
						O:tEngineMode(3);
					:end
				END

				#include "Behaviour_Rules.inc"

			END	//STATE NoFire
		
		END	//MACHINE "Behaviour"
				
		#include "Command_Rules.inc"

		RULE 	event CO_EnginesDisabled			// Motorok uzemkeptelenek
				condition E.ship=O.Own_Ship
			:action
				O:tSetWarning(#Warn_TaskFailed);		//Warning: Engines disabled!! Unable to complete command!
			:end
		END	//CO_EnginesDisabled
				
	END	//STATE Approach
	
END	//MACHINE "Command"
	

////////// Global command events ///////////////

RULE	event CommandInit
	:action
		Cmd_Beh:=commandBehaviour;
		Main_Target:=commandTarget;		// az egyseg, amit tamadnia kell
		Own_Ship:=this; 				//Store own ship
		Fire_Mode:=0;

		tClearMove();
		tClearFire();
		tClearTerritory();

		GetMachine("Command"):ChangeState(Approach, 0);
	:end
END

RULE	event ClearCommand
	:action
		tClearMove();
		tClearFire();
		tClearTerritory();
		tPlayerControl(1);
	:end
END
