Name Player_Recon

CONST
END	//Const

//70-szkenner
//71-ecm
//72-eccm
//73-shield
//74-cloaking

////////// State machine command ///////////////
MACHINE "Command"

	///////  CancelTask  ////////////////////////////////////
	STATE	CancelTask
	
		RULE 	event In	
			:action
				SelectDevices(75, O.Own_Ship, InSet(S.this, 26));
				If(NumOf(75),
					furkesz:=PickFirst(75);
					ActivateDevice(furkesz, 0);			
				);
				O:tClearCommand();
			:end
		END
		
	END	//STATE CancelTask

	///////  Aggressive  ///////////////////////////////////
	STATE Aggressive

		RULE 	event In 	
			:action
				O:tClearForbid(0);
				O:tSetForbid(#FORBID_MOTION_MOTIVATION);				//Osszes sajat mozgas tiltasa
				O:tSetForbid(#FORBID_FIRE_BOMBER);						//csak bomberkuldes tiltva, minden mas tuzeles engedelyezve				
				LocalEvent(SelDev, 0);								
				
				EnableFortPass(O.Own_Ship, 1);							//fortshielden thaladhat
				If(alca, ActivateDevice(alca, 0)); 
				LocalEvent(DevTurnOn, E.dev:=szenzor);
				SelectDevices(75, O.Own_Ship, InSet(S.this, 26));
				If(NumOf(75),
					furkesz:=PickFirst(75);
				,
					furkesz:=0;
				);
				
				Move_Range:=2;
				Move_Type:=0;

				LocalEvent(Tick, 0);
			:end
		END

		RULE 	event Tick
			:action
				LocalEvent(Approach, 0);
				If(O.Main_Target & Range(O.Main_Target, O.Own_Ship)!=Move_Range,
					O:tEngineMode(1);
					SelectShips(10, S.race!=O.Own_Ship:race & GetRelation(O.Own_Ship:race, S.race)=2 & GetDetected(S.this, O.Own_Ship:race) & Range(S.this, O.Own_Ship)<=3);	// minden artillerynel kozelebb levo detektalt ellenseges hajo levalogatasa
					If(NumOf(10), 
						LocalEvent(DevTurnOn, E.dev:=ecm);
						LocalEvent(DevTurnOn, E.dev:=eccm);
					, 
						If(ecm, ActivateDevice(ecm, 0));
						If(eccm, ActivateDevice(eccm, 0));
					);
				,
					O:tEngineMode(2);
					LocalEvent(DevTurnOn, E.dev:=ecm);
					O:tSetForbid(#FORBID_SHIELD);
					If(pajzs, ActivateDevice(pajzs, 0));
					If(furkesz & !furkesz:active,
						O:tSetForbid(#FORBID_FIRE);
						SelectDevices(77, O.Own_Ship, InSet(S.this, 1) & InSet(S.this, 2) & InSet(S.this, 3) & InSet(S.this, 4) & InSet(S.this, 5));
						ExecList(77, ActivateDevice(S.this, 0));
						If(!O.Main_Target:gate & O.Main_Target:race>=0, SetRelation(O.Own_Ship:race, O.Main_Target:race, 2));						
						furkesz:=PickFirst(75);
						TargetWeapon(furkesz, O.Main_Target);			
						If(!O.Main_Target:gate & O.Main_Target:availTheoryPoints<=0 & O.Main_Target:missingSecretPoints<=0,
							LocalEvent(CheckEnd, E.ok:=0);
						);
					);
				);
			:end
		END
		Tick 5.5
		
		#include "Player_X_Rules.inc"

		RULE	event GateLocked			//Ha nem volt Titok
				condition E.gate=O.Main_Target
			:action
				O:tSetWarning(#Warn_TaskCompleted);	//Report: Target closed. Mission accomplished.
				If(furkesz,	ActivateDevice(furkesz, 0));
				LocalEvent(CheckEnd, E.ok:=2);
			:end
		END	//GateLocked

		RULE	event GateUnlocked			//Ha nem volt Titok
				condition E.gate=O.Main_Target
			:action
				O:tSetWarning(#Warn_TaskCompleted);	//Report: Target opened. Mission accomplished.
				If(furkesz,	ActivateDevice(furkesz, 0));
				LocalEvent(CheckEnd, E.ok:=2);
			:end
		END	//GateLocked

		RULE	event GateScanFinished			//Ha nem volt Titok
				condition E.target=O.Main_Target
			:action
				O:tSetWarning(#Warn_TaskCompleted);	//Report: Target scanned. Mission accomplished.
				If(furkesz,	ActivateDevice(furkesz, 0));
				LocalEvent(CheckEnd, E.ok:=2);
			:end
		END	//TheoryScanFinished

		RULE	event TheoryScanFinished			//Ha nem volt Titok
				condition E.target=O.Main_Target&E.target:secret=0
			:action
				O:tSetWarning(#Warn_TaskCompleted);	//Report: Target scanned. Mission accomplished.
				If(furkesz,	ActivateDevice(furkesz, 0));
				LocalEvent(CheckEnd, E.ok:=0);
			:end
		END	//TheoryScanFinished
				
		RULE	event TheoryScanFinished			//Ha van Titok, s mr nem dolgozik rajta
				condition E.target=O.Main_Target&E.target:secret&E.target:missingSecretPoints<=0
			:action
				O:tSetWarning(#Warn_TaskCompleted);	//Report: Target scanned. Mission accomplished.
				If(furkesz,	ActivateDevice(furkesz, 0));
				LocalEvent(CheckEnd, E.ok:=0);
			:end
		END	//TheoryScanFinished
		
		RULE 	event SecretScanFinished			//Ha a Titok kszl el ksbb
				condition E.target=O.Main_Target&E.target:availTheoryPoints<=0
			:action
				O:tSetWarning(#Warn_TaskCompleted);	//Report: Target scanned. Mission accomplished.
				If(furkesz,	ActivateDevice(furkesz, 0));
				LocalEvent(CheckEnd, E.ok:=0);
			:end
		END	//ShipSecretScanFinished
		
		RULE	event CO_DeviceDisabled		// Scanner uzemkeptelen
				condition E.ship=O.Own_Ship&InSet(E.device,26)
			:action
				O:tSetWarning(#Warn_TaskFailed);		//Warning: Scanner disabled! 
			:end
		END	//DeviceDisabled

		RULE 	event Scanned
				condition E.race=O.Own_Ship:race
			:action
				O:tSetWarning(#Warn_TaskCompleted);	//Report: Target scanned. Mission accomplished.
				LocalEvent(CheckEnd, E.ok:=0);
			:end
		END	//Scanned

		RULE	event CheckEnd				// Vge ellenrzse
			:action
				ChooseFirst(
					E.ok=2 | O.Main_Target:gate,
						ChangeState(CancelTask, 0);,
					GetScanned(O.Main_Target, O.Own_Ship:race) & furkesz=0,
						ChangeState(CancelTask, 0);,
					GetScanned(O.Main_Target, O.Own_Ship:race) & O.Main_Target:availTheoryPoints<=0 & O.Main_Target:missingSecretPoints<=0,
						ChangeState(CancelTask, 0);,
					O.Main_Target:availTheoryPoints<=0 & O.Main_Target:missingSecretPoints<=0,
						If(furkesz,	ActivateDevice(furkesz, 0));,
				);
			:end
		END	//CheckEnd

	END	//STATE Aggressive

	///////  Defensive  ///////////////////////////////////
	STATE Defensive

		RULE 	event In 	
			:action
				O:tClearForbid(0);
				O:tSetForbid(#FORBID_MOTION_MOTIVATION);				//Osszes sajat mozgas tiltasa
				O:tSetForbid(#FORBID_FIRE_BOMBER);						//csak bomberkuldes tiltva, minden mas tuzeles engedelyezve				
				O:tSetForbid(#FORBID_FIRE_NOTSHOTBY);					//csak vdekez tzels
				O:tSetForbid(#FORBID_SHIELD);
				LocalEvent(SelDev, 0);								

				If(eccm, ActivateDevice(eccm, 0));
				If(alca, ActivateDevice(alca, 0)); 
				LocalEvent(DevTurnOn, E.dev:=szenzor);
				SelectDevices(75, O.Own_Ship, InSet(S.this, 26));
				If(NumOf(75),
					furkesz:=PickFirst(75);
				,
					furkesz:=0;
				);
				
				Move_Range:=2;
				Move_Type:=0;
				O:tEngineMode(2);

				LocalEvent(Tick, 0);
			:end
		END

		RULE 	event Tick
			:action
				If(O.Own_ship:fort, 
					EnableFortPass(O.Own_Ship, 0);							//fortshielden nem haladhat t
				,
					EnableFortPass(O.Own_Ship, 1);							//fortshielden thaladhat
				);

				LocalEvent(Approach, 0);
				If(O.Main_Target & Range(O.Main_Target, O.Own_Ship)!=Move_Range,
					SelectShips(10, S.race!=O.Own_Ship:race & GetRelation(O.Own_Ship:race, S.race)=2 & GetDetected(S.this, O.Own_Ship:race) & Range(S.this, O.Own_Ship)<=3);	// minden artillerynel kozelebb levo detektalt ellenseges hajo levalogatasa
					SelectShips(15, S.race!=O.Own_Ship:race & (GetRelation(O.Own_Ship:race, S.race)=2 | GetRelation(O.Own_Ship:race, S.race)=3) & GetDetected(S.this, O.Own_Ship:race));		//detektlt ellensges haj van	
					If(NumOf(10), LocalEvent(DevTurnOn, E.dev:=ecm), If(ecm, ActivateDevice(ecm, 0)));				
					If(NumOf(15), If(pajzs, ActivateDevice(pajzs, 1)));
				,
					O:tEngineMode(2);				
					SelectShips(15, S.race!=O.Own_Ship:race & (GetRelation(O.Own_Ship:race, S.race)=2 | GetRelation(O.Own_Ship:race, S.race)=3) & GetDetected(S.this, O.Own_Ship:race));		//detektlt ellensges haj van	
					LocalEvent(DevTurnOn, E.dev:=ecm);
					If(NumOf(15), If(pajzs, ActivateDevice(pajzs, 1)));
					O:tSetForbid(#FORBID_SHIELD);
					If(pajzs, ActivateDevice(pajzs, 0));
					If(furkesz & !furkesz:active,
						O:tSetForbid(#FORBID_FIRE);
						SelectDevices(77, O.Own_Ship, InSet(S.this, 1) & InSet(S.this, 2) & InSet(S.this, 3) & InSet(S.this, 4) & InSet(S.this, 5));
						ExecList(77, ActivateDevice(S.this, 0));
						If(!O.Main_Target:gate & O.Main_Target:race>=0, SetRelation(O.Own_Ship:race, O.Main_Target:race, 2));						
						furkesz:=PickFirst(75);
						TargetWeapon(furkesz, O.Main_Target);			
						If(!O.Main_Target:gate & O.Main_Target:availTheoryPoints<=0 & O.Main_Target:missingSecretPoints<=0,
							LocalEvent(CheckEnd, E.ok:=0);
						);
					);
				);
			:end
		END
		Tick 5.5

		#include "Player_X_Rules.inc"

		RULE	event GateLocked			//Ha nem volt Titok
				condition E.gate=O.Main_Target
			:action
				O:tSetWarning(#Warn_TaskCompleted);	//Report: Target closed. Mission accomplished.
				If(furkesz,	ActivateDevice(furkesz, 0));
				LocalEvent(CheckEnd, E.ok:=2);
			:end
		END	//GateLocked

		RULE	event GateUnlocked			//Ha nem volt Titok
				condition E.gate=O.Main_Target
			:action
				O:tSetWarning(#Warn_TaskCompleted);	//Report: Target opened. Mission accomplished.
				If(furkesz,	ActivateDevice(furkesz, 0));
				LocalEvent(CheckEnd, E.ok:=2);
			:end
		END	//GateLocked

		RULE	event GateScanFinished			//Ha nem volt Titok
				condition E.target=O.Main_Target
			:action
				O:tSetWarning(#Warn_TaskCompleted);	//Report: Target scanned. Mission accomplished.
				If(furkesz,	ActivateDevice(furkesz, 0));
				LocalEvent(CheckEnd, E.ok:=2);
			:end
		END	//TheoryScanFinished

		RULE	event TheoryScanFinished			//Ha nem volt Titok
				condition E.target=O.Main_Target&E.target:secret=0
			:action
				O:tSetWarning(#Warn_TaskCompleted);	//Report: Target scanned. Mission accomplished.
				If(furkesz,	ActivateDevice(furkesz, 0));
				LocalEvent(CheckEnd, E.ok:=0);
			:end
		END	//TheoryScanFinished
				
		RULE	event TheoryScanFinished			//Ha van Titok, s mr nem dolgozik rajta
				condition E.target=O.Main_Target&E.target:secret&E.target:missingSecretPoints<=0
			:action
				O:tSetWarning(#Warn_TaskCompleted);	//Report: Target scanned. Mission accomplished.
				If(furkesz,	ActivateDevice(furkesz, 0));
				LocalEvent(CheckEnd, E.ok:=0);
			:end
		END	//TheoryScanFinished
		
		RULE 	event SecretScanFinished			//Ha a Titok kszl el ksbb
				condition E.target=O.Main_Target&E.target:availTheoryPoints<=0
			:action
				O:tSetWarning(#Warn_TaskCompleted);	//Report: Target scanned. Mission accomplished.
				If(furkesz,	ActivateDevice(furkesz, 0));
				LocalEvent(CheckEnd, E.ok:=0);
			:end
		END	//ShipSecretScanFinished
		
		RULE	event CO_DeviceDisabled		// Scanner uzemkeptelen
				condition E.ship=O.Own_Ship&InSet(E.device,26)
			:action
				O:tSetWarning(#Warn_TaskFailed);		//Warning: Scanner disabled! 
			:end
		END	//DeviceDisabled

		RULE 	event Scanned
				condition E.race=O.Own_Ship:race
			:action
				O:tSetWarning(#Warn_TaskCompleted);	//Report: Target scanned. Mission accomplished.
				LocalEvent(CheckEnd, E.ok:=0);
			:end
		END	//Scanned

		RULE	event CheckEnd				// Vge ellenrzse
			:action
				ChooseFirst(
					E.ok=2 | O.Main_Target:gate,
						ChangeState(CancelTask, 0);,
					GetScanned(O.Main_Target, O.Own_Ship:race) & furkesz=0,
						ChangeState(CancelTask, 0);,
					GetScanned(O.Main_Target, O.Own_Ship:race) & O.Main_Target:availTheoryPoints<=0 & O.Main_Target:missingSecretPoints<=0,
						ChangeState(CancelTask, 0);,
					O.Main_Target:availTheoryPoints<=0 & O.Main_Target:missingSecretPoints<=0,
						If(furkesz,	ActivateDevice(furkesz, 0));,
				);
			:end
		END	//CheckEnd

	END	//STATE Defensive

	///////  Stealth  ///////////////////////////////////
	STATE Stealth

		RULE 	event In 	
			:action
				O:tClearForbid(0);
				O:tSetForbid(#FORBID_MOTION_MOTIVATION);				//Osszes sajat mozgas tiltasa
				O:tSetForbid(#FORBID_FIRE);								//Lvldzs tiltsa
				O:tSetForbid(#FORBID_SHIELD);				 				//Pajzs letiltsa
				LocalEvent(SelDev, 0);								
				
				EnableFortPass(O.Own_Ship, 1);							//fortshielden thaladhat
				If(szenzor, ActivateDevice(szenzor, 0));
				If(ecm, ActivateDevice(ecm, 0));
				If(eccm, ActivateDevice(eccm, 0));
				Move_Range:=2;				
				If(O.Main_Target & Range(O.Main_Target, O.Own_Ship)>Move_Range, 	
					If(pajzs, ActivateDevice(pajzs, 0));
					LocalEvent(DevTurnOn, E.dev:=alca);
					seen:=0;
					SelectDevices(77, O.Own_Ship, S.weapon & !InSet(S.this, 20) & !InSet(S.this, 21) & !InSet(S.this, 22) & !InSet(S.this, 25));				//fegyverek kikapcsolsa
					ExecList(77, ActivateDevice(S.this, 0));
				);
				SelectDevices(75, O.Own_Ship, InSet(S.this, 26));
				If(NumOf(75),
					furkesz:=PickFirst(75);
				,
					furkesz:=0;
				);
				
				If(NumOf(74), 
					Move_Type:=0;							
				,
					Move_Type:=1;
				);
				
				O:tEngineMode(3);										
				
				LocalEvent(Tick, 0);				
			:end
		END

		RULE 	event Tick
			:action		
				LocalEvent(Approach, 0);
				If(O.Main_Target & Range(O.Main_Target, O.Own_Ship)=Move_Range,
					O:tSetForbid(#FORBID_SHIELD);
					If(pajzs, ActivateDevice(pajzs, 0));				
					If(furkesz & !furkesz:active,
						O:tSetForbid(#FORBID_FIRE);
						SelectDevices(77, O.Own_Ship, InSet(S.this, 1) & InSet(S.this, 2) & InSet(S.this, 3) & InSet(S.this, 4) & InSet(S.this, 5));
						ExecList(77, ActivateDevice(S.this, 0));
						furkesz:=PickFirst(75);
						TargetWeapon(furkesz, O.Main_Target);			
						If(!O.Main_Target:gate & O.Main_Target:availTheoryPoints<=0 & O.Main_Target:missingSecretPoints<=0,
							LocalEvent(CheckEnd, E.ok:=0);
						);
					);
				);
			:end
		END
		Tick 5.5

		#include "Player_X_Rules.inc"

		RULE	event GateLocked			//Ha nem volt Titok
				condition E.gate=O.Main_Target
			:action
				O:tSetWarning(#Warn_TaskCompleted);	//Report: Target closed. Mission accomplished.
				If(furkesz,	ActivateDevice(furkesz, 0));
				LocalEvent(CheckEnd, E.ok:=2);
			:end
		END	//GateLocked

		RULE	event GateUnlocked			//Ha nem volt Titok
				condition E.gate=O.Main_Target
			:action
				O:tSetWarning(#Warn_TaskCompleted);	//Report: Target opened. Mission accomplished.
				If(furkesz,	ActivateDevice(furkesz, 0));
				LocalEvent(CheckEnd, E.ok:=2);
			:end
		END	//GateLocked

		RULE	event GateScanFinished			//Ha nem volt Titok
				condition E.target=O.Main_Target
			:action
				O:tSetWarning(#Warn_TaskCompleted);	//Report: Target scanned. Mission accomplished.
				If(furkesz,	ActivateDevice(furkesz, 0));
				LocalEvent(CheckEnd, E.ok:=2);
			:end
		END	//TheoryScanFinished

		RULE	event TheoryScanFinished			//Ha nem volt Titok
				condition E.target=O.Main_Target&E.target:secret=0
			:action
				O:tSetWarning(#Warn_TaskCompleted);	//Report: Target scanned. Mission accomplished.
				If(furkesz,	ActivateDevice(furkesz, 0));
				LocalEvent(CheckEnd, E.ok:=0);
			:end
		END	//TheoryScanFinished
				
		RULE	event TheoryScanFinished			//Ha van Titok, s mr nem dolgozik rajta
				condition E.target=O.Main_Target&E.target:secret&E.target:missingSecretPoints<=0
			:action
				O:tSetWarning(#Warn_TaskCompleted);	//Report: Target scanned. Mission accomplished.
				If(furkesz,	ActivateDevice(furkesz, 0));
				LocalEvent(CheckEnd, E.ok:=0);
			:end
		END	//TheoryScanFinished
		
		RULE 	event SecretScanFinished			//Ha a Titok kszl el ksbb
				condition E.target=O.Main_Target&E.target:availTheoryPoints<=0
			:action
				O:tSetWarning(#Warn_TaskCompleted);	//Report: Target scanned. Mission accomplished.
				If(furkesz,	ActivateDevice(furkesz, 0));
				LocalEvent(CheckEnd, E.ok:=0);
			:end
		END	//ShipSecretScanFinished
		
		RULE	event CO_DeviceDisabled		// Scanner uzemkeptelen
				condition E.ship=O.Own_Ship&InSet(E.device,26)
			:action
				O:tSetWarning(#Warn_TaskFailed);		//Warning: Scanner disabled! 
			:end
		END	//DeviceDisabled

		RULE 	event Scanned
				condition E.race=O.Own_Ship:race
			:action
				O:tSetWarning(#Warn_TaskCompleted);	//Report: Target scanned. Mission accomplished.
				LocalEvent(CheckEnd, E.ok:=0);
			:end
		END	//Scanned

		RULE	event CheckEnd				// Vge ellenrzse
			:action
				ChooseFirst(
					E.ok=2 | O.Main_Target:gate,
						ChangeState(CancelTask, 0);,
					GetScanned(O.Main_Target, O.Own_Ship:race) & furkesz=0,
						ChangeState(CancelTask, 0);,
					GetScanned(O.Main_Target, O.Own_Ship:race) & O.Main_Target:availTheoryPoints<=0 & O.Main_Target:missingSecretPoints<=0,
						ChangeState(CancelTask, 0);,
					O.Main_Target:availTheoryPoints<=0 & O.Main_Target:missingSecretPoints<=0,
						If(furkesz,	ActivateDevice(furkesz, 0));,
				);
			:end
		END	//CheckEnd

	END	//STATE Stealth

	///////  NoFire  ///////////////////////////////////
	STATE NoFire

		RULE 	event In 	
			:action
				O:tClearForbid(0);
				O:tSetForbid(#FORBID_MOTION_MOTIVATION);		//Osszes sajat mozgas tiltasa
				O:tSetForbid(#FORBID_FIRE_BOMBER);				//csak bomberkuldes tiltva, minden mas tuzeles engedelyezve				
				O:tSetForbid(#FORBID_FIRE_FREE);					//CO tzels tiltsa
				LocalEvent(SelDev, 0);								

				EnableFortPass(O.Own_Ship, 1);					//fortshielden thaladhat
				If(alca, ActivateDevice(alca, 0)); 
				If(eccm, ActivateDevice(eccm, 0));
				SelectDevices(75, O.Own_Ship, InSet(S.this, 26));
				If(NumOf(75),
					furkesz:=PickFirst(75);
				,
					furkesz:=0;
				);
				
				Move_Range:=2;
				Move_Type:=0;

				LocalEvent(Tick, 0);
			:end
		END

		RULE 	event Tick
			:action
				LocalEvent(Approach, 0);
				If(O.Main_Target & Range(O.Main_Target, O.Own_Ship)!=Move_Range,
					O:tEngineMode(1);
					SelectShips(10, S.race!=O.Own_Ship:race & GetRelation(O.Own_Ship:race, S.race)=2 & GetDetected(S.this, O.Own_Ship:race) & Range(S.this, O.Own_Ship)<=3);	// minden artillerynel kozelebb levo detektalt ellenseges hajo levalogatasa
					LocalEvent(DevTurnOn, E.dev:=szenzor);				
					If(NumOf(10),
						LocalEvent(DevTurnOn, E.dev:=ecm);											
					,
						If(ecm, ActivateDevice(ecm, 0));
					);
				,
					O:tEngineMode(2);
					LocalEvent(DevTurnOn, E.dev:=szenzor);
					LocalEvent(DevTurnOn, E.dev:=ecm);
					O:tSetForbid(#FORBID_SHIELD);
					If(pajzs, ActivateDevice(pajzs, 0));					
					If(furkesz & !furkesz:active,
						O:tSetForbid(#FORBID_FIRE);
						SelectDevices(77, O.Own_Ship, InSet(S.this, 1) & InSet(S.this, 2) & InSet(S.this, 3) & InSet(S.this, 4) & InSet(S.this, 5));
						ExecList(77, ActivateDevice(S.this, 0));
						If(!O.Main_Target:gate & O.Main_Target:race>=0, SetRelation(O.Own_Ship:race, O.Main_Target:race, 2));						
						furkesz:=PickFirst(75);
						TargetWeapon(furkesz, O.Main_Target);			
						If(!O.Main_Target:gate & O.Main_Target:availTheoryPoints<=0 & O.Main_Target:missingSecretPoints<=0,
							LocalEvent(CheckEnd, E.ok:=0);
						);
					);
				);
			:end
		END
		Tick 5.5
		
		#include "Player_X_Rules.inc"

		RULE	event GateLocked			//Ha nem volt Titok
				condition E.gate=O.Main_Target
			:action
				O:tSetWarning(#Warn_TaskCompleted);	//Report: Target closed. Mission accomplished.
				If(furkesz,	ActivateDevice(furkesz, 0));
				LocalEvent(CheckEnd, E.ok:=2);
			:end
		END	//GateLocked

		RULE	event GateUnlocked			//Ha nem volt Titok
				condition E.gate=O.Main_Target
			:action
				O:tSetWarning(#Warn_TaskCompleted);	//Report: Target opened. Mission accomplished.
				If(furkesz,	ActivateDevice(furkesz, 0));
				LocalEvent(CheckEnd, E.ok:=2);
			:end
		END	//GateLocked

		RULE	event GateScanFinished			//Ha nem volt Titok
				condition E.target=O.Main_Target
			:action
				O:tSetWarning(#Warn_TaskCompleted);	//Report: Target scanned. Mission accomplished.
				If(furkesz,	ActivateDevice(furkesz, 0));
				LocalEvent(CheckEnd, E.ok:=2);
			:end
		END	//TheoryScanFinished

		RULE	event TheoryScanFinished			//Ha nem volt Titok
				condition E.target=O.Main_Target&E.target:secret=0
			:action
				O:tSetWarning(#Warn_TaskCompleted);	//Report: Target scanned. Mission accomplished.
				If(furkesz,	ActivateDevice(furkesz, 0));
				LocalEvent(CheckEnd, E.ok:=0);
			:end
		END	//TheoryScanFinished
				
		RULE	event TheoryScanFinished			//Ha van Titok, s mr nem dolgozik rajta
				condition E.target=O.Main_Target&E.target:secret&E.target:missingSecretPoints<=0
			:action
				O:tSetWarning(#Warn_TaskCompleted);	//Report: Target scanned. Mission accomplished.
				If(furkesz,	ActivateDevice(furkesz, 0));
				LocalEvent(CheckEnd, E.ok:=0);
			:end
		END	//TheoryScanFinished
		
		RULE 	event SecretScanFinished			//Ha a Titok kszl el ksbb
				condition E.target=O.Main_Target&E.target:availTheoryPoints<=0
			:action
				O:tSetWarning(#Warn_TaskCompleted);	//Report: Target scanned. Mission accomplished.
				If(furkesz,	ActivateDevice(furkesz, 0));
				LocalEvent(CheckEnd, E.ok:=0);
			:end
		END	//ShipSecretScanFinished
		
		RULE	event CO_DeviceDisabled		// Scanner uzemkeptelen
				condition E.ship=O.Own_Ship&InSet(E.device,26)
			:action
				O:tSetWarning(#Warn_TaskFailed);		//Warning: Scanner disabled! 
			:end
		END	//DeviceDisabled

		RULE 	event Scanned
				condition E.race=O.Own_Ship:race
			:action
				O:tSetWarning(#Warn_TaskCompleted);	//Report: Target scanned. Mission accomplished.
				LocalEvent(CheckEnd, E.ok:=0);
			:end
		END	//Scanned

		RULE	event CheckEnd				// Vge ellenrzse
			:action
				ChooseFirst(
					E.ok=2 | O.Main_Target:gate,
						ChangeState(CancelTask, 0);,
					GetScanned(O.Main_Target, O.Own_Ship:race) & furkesz=0,
						ChangeState(CancelTask, 0);,
					GetScanned(O.Main_Target, O.Own_Ship:race) & O.Main_Target:availTheoryPoints<=0 & O.Main_Target:missingSecretPoints<=0,
						ChangeState(CancelTask, 0);,
					O.Main_Target:availTheoryPoints<=0 & O.Main_Target:missingSecretPoints<=0,
						If(furkesz,	ActivateDevice(furkesz, 0));,
				);
			:end
		END	//CheckEnd

	END	//STATE NoFire
	
END	//MACHINE "Command"
	

////////// Global command events ///////////////

RULE	event CommandInit
	:action
		Cmd_Beh:=commandBehaviour;
		Main_Target:=commandTarget;		// az egyseg, amit tamadnia kell
		Own_Ship:=this; 				//Store own ship
		Fire_Mode:=0;

		tClearMove();
		tClearFire();
		tClearTerritory();
		
		ChooseFirst(
			O.Cmd_Beh=1, GetMachine("Command"):ChangeState(Aggressive, 0), 		// aggressziv allapot
			O.Cmd_Beh=2, GetMachine("Command"):ChangeState(Defensive, 0),	 		// defenziv allapot
			O.Cmd_Beh=3, GetMachine("Command"):ChangeState(Stealth, 0),				// menekulo allapot
			O.Cmd_Beh=4, GetMachine("Command"):ChangeState(NoFire, 0)	 			// clirnyos allapot
		);
	:end
END

RULE	event ClearCommand
	:action
		SelectDevices(75, O.Own_Ship, InSet(S.this, 26));
		If(NumOf(75),
			furkesz:=PickFirst(75);
			ActivateDevice(furkesz, 0);			
		);

		tClearMove();
		tClearFire();
		tClearTerritory();
		tPlayerControl(1);
	:end
END
