Name Player_HoldPosition

CONST
END	//Const

//70-szkenner
//71-ecm
//72-eccm
//73-shield
//74-cloaking

////////// State machine command ///////////////
MACHINE "Command"

	///////  CancelTask  ////////////////////////////////////
	STATE	CancelTask
	
		RULE 	event In	
			:action
				O:tClearCommand();
			:end
		END
		
	END	//STATE CancelTask

	///////  Aggressive  ///////////////////////////////////
	STATE Aggressive

		RULE 	event In 	
			:action
				O:tClearForbid(0);
				O:tSetForbid(#FORBID_MOTION_MOTIVATION);				//Osszes sajat mozgas tiltasa
				O:tSetForbid(#FORBID_FIRE_BOMBER);						//csak bomberkuldes tiltva, minden mas tuzeles engedelyezve				
				LocalEvent(SelDev, 0);								
				LocalEvent(CollectAbility, 0);
				
				EnableFortPass(O.Own_Ship, 1);							//fortshielden thaladhat
				If(alca, ActivateDevice(alca, 0)); 
				
				Move_Range:=2;
				Move_Type:=0;
				O.Stealth:=0;
				O:tEngineMode(0);
				O:tSetTerritory(O.np, 0, 500, 500, 10, 1);

				LocalEvent(Tick, 0);
			:end
		END

		RULE 	event Tick
			:action
				SelectShips(10, S.race!=O.Own_Ship:race & GetRelation(O.Own_Ship:race, S.race)=2 & GetDetected(S.this, O.Own_Ship:race) & Range(S.this, O.Own_Ship)<=3);	// minden artillerynel kozelebb levo detektalt ellenseges hajo levalogatasa
				LocalEvent(DevTurnOn, E.dev:=szenzor);
				If(NumOf(10), 
					LocalEvent(DevTurnOn, E.dev:=ecm);
					LocalEvent(DevTurnOn, E.dev:=eccm);
				, 
					If(ecm, ActivateDevice(ecm, 0));
					If(eccm, ActivateDevice(eccm, 0));
				);

				Sec_Target:=Call(ClosestEnemy, E.target:=O.Own_Ship; E.maxrange:=3);						//celpontvalasztas, ha nem tamadja senki a vdencet
				If(Sec_Target,
					Range_Sec_Target:=Range(Sec_Target, O.Own_Ship);		//Aktualis tavolsag a masodlagos celponttol
					If(Sec_Target:isShielded, 				//ha van az ellensegen pajzs, pajzsrombolo fegyvereket hasznal, ha nincs, akkor hullt rombol (ha van a kello cucc)
						ChooseFirst(
							Ability_Shield, O:tFireTo(C.Sec_Target, 1), 
							Ability_Hull & O:tDamage(C.Sec_Target, C.Range_Sec_Target, 2)!=0, O:tFireTo(C.Sec_Target, 2), 
							Ability_Device & O:tDamage(C.Sec_Target, C.Range_Sec_Target, 3)!=0, O:tFireTo(C.Sec_Target, 3)
						)
					, 
						ChooseFirst(
							Ability_Hull & O:tDamage(C.Sec_Target, C.Range_Sec_Target, 2)!=0, O:tFireTo(C.Sec_Target, 2), 
							Ability_Device & O:tDamage(C.Sec_Target, C.Range_Sec_Target, 3)!=0, O:tFireTo(C.Sec_Target, 3)
						)
					)
				);
			:end
		END
		Tick 5.5
		
		#include "Player_X_Rules.inc"

	END	//STATE Aggressive

	///////  Defensive  ///////////////////////////////////
	STATE Defensive

		RULE 	event In 	
			:action
				O:tClearForbid(0);
				O:tSetForbid(#FORBID_MOTION_MOTIVATION);				//Osszes sajat mozgas tiltasa
				O:tSetForbid(#FORBID_FIRE_BOMBER);						//csak bomberkuldes tiltva, minden mas tuzeles engedelyezve				
				O:tSetForbid(#FORBID_FIRE_NOTSHOTBY);					//csak vdekez tzels
				O:tSetForbid(#FORBID_SHIELD);
				LocalEvent(SelDev, 0);		
				LocalEvent(CollectAbility, 0);

				If(eccm, ActivateDevice(eccm, 0));
				If(alca, ActivateDevice(alca, 0)); 

				O:tSetTerritory(O.np, 0, 500, 1000, 10, 1);
				O:tEngineMode(2);
				
				Move_Range:=2;
				Move_Type:=0;
				O.Stealth:=0;

				LocalEvent(Tick, 0);
			:end
		END

		RULE 	event Tick
			:action
				If(O.Own_ship:fort, 
					EnableFortPass(O.Own_Ship, 0);							//fortshielden nem haladhat t
				,
					EnableFortPass(O.Own_Ship, 1);							//fortshielden thaladhat
				);
				SelectShips(10, S.race!=O.Own_Ship:race & GetRelation(O.Own_Ship:race, S.race)=2 & GetDetected(S.this, O.Own_Ship:race) & Range(S.this, O.Own_Ship)<=3);	// minden artillerynel kozelebb levo detektalt ellenseges hajo levalogatasa
				SelectShips(20, S.race!=O.Own_Ship:race & GetRelation(O.Own_Ship:race, S.race)=2 & GetDetected(S.this, O.Own_Ship:race) & GetDetected(O.Own_Ship, S.race) & Range(S.this, O.Own_Ship)<=3);	// minden artillerynel kozelebb levo engem detektalt ellenseges hajo levalogatasa
				SelectShips(15, S.race!=O.Own_Ship:race & (GetRelation(O.Own_Ship:race, S.race)=2 | GetRelation(O.Own_Ship:race, S.race)=3) & GetDetected(S.this, O.Own_Ship:race));		//detektlt ellensges haj van	
				If(NumOf(10), LocalEvent(DevTurnOn, E.dev:=ecm), If(ecm, ActivateDevice(ecm, 0)));				
				If(NumOf(20), LocalEvent(DevTurnOn, E.dev:=szenzor), If(szenzor, ActivateDevice(szenzor, 0)));
				If(NumOf(15), If(pajzs, ActivateDevice(pajzs, 1)));

				Sec_Target:=Call(ClosestEnemy, E.target:=O.Own_Ship; E.maxrange:=3; E.defensive:=1);	//celpontvalasztas, ha nem tamadja senki a vdencet, de minket tmad
				If(Sec_Target,
					Range_Sec_Target:=Range(Sec_Target, O.Own_Ship);		//Aktualis tavolsag a msodlagos celponttol
					If(Sec_Target:isShielded, 				//ha van az ellensegen pajzs, pajzsrombolo fegyvereket hasznal, ha nincs, akkor hullt rombol (ha van a kello cucc)
						ChooseFirst(
							Ability_Shield, O:tFireTo(C.Sec_Target, 1), 
							Ability_Hull & O:tDamage(C.Sec_Target, C.Range_Sec_Target, 2)!=0, O:tFireTo(C.Sec_Target, 2), 
							Ability_Device & O:tDamage(C.Sec_Target, C.Range_Sec_Target, 3)!=0, O:tFireTo(C.Sec_Target, 3)
						)
					, 
						ChooseFirst(
							Ability_Hull & O:tDamage(C.Sec_Target, C.Range_Sec_Target, 2)!=0, O:tFireTo(C.Sec_Target, 2), 
							Ability_Device & O:tDamage(C.Sec_Target, C.Range_Sec_Target, 3)!=0, O:tFireTo(C.Sec_Target, 3)
						)
					)
				);
			:end
		END
		Tick 5.5

		#include "Player_X_Rules.inc"

	END	//STATE Defensive

	///////  Stealth  ///////////////////////////////////
	STATE Stealth

		RULE 	event In 	
			:action
				O:tClearForbid(0);
				O:tSetForbid(#FORBID_MOTION_MOTIVATION);				//Osszes sajat mozgas tiltasa
				O:tSetForbid(#FORBID_FIRE);								//Lvldzs tiltsa
				O:tSetForbid(#FORBID_SHIELD);				 				//Pajzs letiltsa
				O:tSetForbid(#FORBID_ENGINE);				 				//Engine letiltsa
				LocalEvent(SelDev, 0);								
				
				EnableFortPass(O.Own_Ship, 1);							//fortshielden thaladhat
				If(szenzor, ActivateDevice(szenzor, 0));
				If(ecm, ActivateDevice(ecm, 0));
				If(eccm, ActivateDevice(eccm, 0));
				Move_Range:=2;				
				If(pajzs, ActivateDevice(pajzs, 0));
				LocalEvent(DevTurnOn, E.dev:=alca);
				seen:=0;
				SelectDevices(77, O.Own_Ship, S.weapon & !InSet(S.this, 20) & !InSet(S.this, 21) & !InSet(S.this, 22) & !InSet(S.this, 25));				//fegyverek kikapcsolsa
				ExecList(77, ActivateDevice(S.this, 0));
		
				If(NumOf(74), 
					Move_Type:=0;							
				,
					Move_Type:=1;
				);
				O:tEngineMode(3);				
				O.Stealth:=1;
				SelectDevices(75, O.Own_Ship, S.working & InSet(S.this, 56));		//Stealth engine be
				ExecList(75, ActivateDevice(S.this, 1));
				SelectDevices(75, O.Own_Ship, S.working & InSet(S.this, 50));		//Engines
				ExecList(75, ActivateDevice(S.this, 0)); 
				
				LocalEvent(Tick, 0);				
			:end
		END

		RULE 	event Tick
			:action		
			:end
		END
		Tick 5.5

		#include "Player_X_Rules.inc"

	END	//STATE Stealth

	///////  NoFire  ///////////////////////////////////
	STATE NoFire

		RULE 	event In 	
			:action
				O:tClearForbid(0);
				O:tSetForbid(#FORBID_MOTION_MOTIVATION);		//Osszes sajat mozgas tiltasa
				O:tSetForbid(#FORBID_FIRE_BOMBER);				//csak bomberkuldes tiltva, minden mas tuzeles engedelyezve				
				O:tSetForbid(#FORBID_FIRE_FREE);					//CO tzels tiltsa
				LocalEvent(SelDev, 0);								

				EnableFortPass(O.Own_Ship, 1);					//fortshielden thaladhat
				If(alca, ActivateDevice(alca, 0)); 
				If(eccm, ActivateDevice(eccm, 0));
				
				Move_Range:=2;
				Move_Type:=0;
				O.Stealth:=0;
				O:tSetTerritory(O.np, 0, 500, 1000, 10, 1);
				O:tEngineMode(0);
				
				LocalEvent(Tick, 0);
			:end
		END

		RULE 	event Tick
			:action
				SelectShips(10, S.race!=O.Own_Ship:race & GetRelation(O.Own_Ship:race, S.race)=2 & GetDetected(S.this, O.Own_Ship:race) & Range(S.this, O.Own_Ship)<=3);	// minden artillerynel kozelebb levo detektalt ellenseges hajo levalogatasa
				LocalEvent(DevTurnOn, E.dev:=szenzor);				
				If(NumOf(10),
					LocalEvent(DevTurnOn, E.dev:=ecm);					
				,
					If(ecm, ActivateDevice(ecm, 0));
				);
			:end
		END
		Tick 5.5
		
		#include "Player_X_Rules.inc"

	END	//STATE NoFire
	
END	//MACHINE "Command"
	

////////// Global command events ///////////////

RULE	event CommandInit
	:action
		Cmd_Beh:=commandBehaviour;
		Main_Target:=commandTarget;		// az egyseg, amit tamadnia kell
		Own_Ship:=this; 				//Store own ship
		Fire_Mode:=0;
		O.Stealth:=0;

		tClearMove();
		tClearFire();
		tClearTerritory();

		ForceOrient(O.Own_Ship, O.Own_Ship:heading, O.Own_Ship:pitch, O.Own_Ship:bank);
		np:=AddNavigPoint("Center", VAdd(Own_Ship:position, VMul(300, VNorm(Own_Ship:velocity))),0,0, 1,1,1, 10);

		ChooseFirst(
			O.Cmd_Beh=1, GetMachine("Command"):ChangeState(Aggressive, 0), 		// aggressziv allapot
			O.Cmd_Beh=2, GetMachine("Command"):ChangeState(Defensive, 0),	 		// defenziv allapot
			O.Cmd_Beh=3, GetMachine("Command"):ChangeState(Stealth, 0),			// menekulo allapot
			O.Cmd_Beh=4, GetMachine("Command"):ChangeState(NoFire, 0)	 			// clirnyos allapot
		);
	:end
END

RULE	event ClearCommand
	:action
		If(O.Stealth, 
			SelectDevices(75, O.Own_Ship, S.working & InSet(S.this, 56));		//Engines
			ExecList(75, ActivateDevice(S.this, 1)); 
		);
		tClearMove();
		tClearFire();
		tClearTerritory();
		O:tPlayerControl(1);
	:end
END