Name Player_Guard

CONST
END	//Const

//70-szkenner
//71-ecm
//72-eccm
//73-shield
//74-cloaking

////////// State machine command ///////////////
MACHINE "Command"

	///////  CancelTask  ////////////////////////////////////
	STATE	CancelTask
	
		RULE 	event In	
			:action
				O:tClearCommand();
			:end
		END
		
	END	//STATE CancelTask

	///////  Aggressive  ///////////////////////////////////
	STATE Aggressive

		RULE 	event In 	
			:action
				O:tClearForbid(0);
				O:tSetForbid(#FORBID_MOTION_MOTIVATION);				//Osszes sajat mozgas tiltasa
				O:tSetForbid(#FORBID_FIRE_BOMBER);						//csak bomberkuldes tiltva, minden mas tuzeles engedelyezve				
				LocalEvent(SelDev, 0);								
				
				EnableFortPass(O.Own_Ship, 1);							//fortshielden thaladhat
				If(alca, ActivateDevice(alca, 0)); 

				O:tSetTerritory(O.Main_Target, 800, 2000, 4000, 100, 2);
				
				Move_Range:=2;
				Move_Type:=0;

				LocalEvent(Tick, 0);
			:end
		END

		RULE 	event Tick
			:action
				//LocalEvent(Approach, 0);
				SelectShips(10, S.race!=O.Own_Ship:race & GetRelation(O.Own_Ship:race, S.race)=2 & GetDetected(S.this, O.Own_Ship:race) & Range(S.this, O.Own_Ship)<=3);	// minden artillerynel kozelebb levo detektalt ellenseges hajo levalogatasa
				LocalEvent(DevTurnOn, E.dev:=szenzor);
				If(NumOf(10), 
					LocalEvent(DevTurnOn, E.dev:=ecm);
					LocalEvent(DevTurnOn, E.dev:=eccm);
				, 
					If(ecm, ActivateDevice(ecm, 0));
					If(eccm, ActivateDevice(eccm, 0));
				);

				O:tEngineMode(0);
			:end
		END
		Tick 5.5
		
		#include "Player_X_Rules.inc"

	END	//STATE Aggressive

	///////  Defensive  ///////////////////////////////////
	STATE Defensive

		RULE 	event In 	
			:action
				O:tClearForbid(0);
				O:tSetForbid(#FORBID_MOTION_MOTIVATION);				//Osszes sajat mozgas tiltasa
				O:tSetForbid(#FORBID_FIRE_BOMBER);						//csak bomberkuldes tiltva, minden mas tuzeles engedelyezve				
				O:tSetForbid(#FORBID_FIRE_NOTSHOTBY);					//csak vdekez tzels
				O:tSetForbid(#FORBID_SHIELD);
				LocalEvent(SelDev, 0);								

				If(eccm, ActivateDevice(eccm, 0));
				If(alca, ActivateDevice(alca, 0)); 

				O:tSetTerritory(O.Main_Target, 800, 1500, 3000, 200, 2);
				
				Move_Range:=2;
				Move_Type:=0;
				O:tEngineMode(2);

				LocalEvent(Tick, 0);
			:end
		END

		RULE 	event Tick
			:action
				If(O.Own_Ship:fort, 
					EnableFortPass(O.Own_Ship, 0);							//fortshielden nem haladhat t
				,
					EnableFortPass(O.Own_Ship, 1);							//fortshielden thaladhat
				);
				//LocalEvent(Approach, 0);
				Sec_Target:=Call(ClosestEnemy, E.target:=O.Main_Target; E.maxrange:=2; E.defensive:=1);
				If(Sec_Target,
					O:tClearForbid(#FORBID_FIRE_NOTSHOTBY);					//nem csak vdekez tzels
				,
					O:tSetForbid(#FORBID_FIRE_NOTSHOTBY);						//csak vdekez tzels
				);
				SelectShips(10, S.race!=O.Own_Ship:race & GetRelation(O.Own_Ship:race, S.race)=2 & GetDetected(S.this, O.Own_Ship:race) & Range(S.this, O.Own_Ship)<=3);	// minden artillerynel kozelebb levo detektalt ellenseges hajo levalogatasa
				SelectShips(20, S.race!=O.Own_Ship:race & GetRelation(O.Own_Ship:race, S.race)=2 & GetDetected(S.this, O.Own_Ship:race) & GetDetected(O.Own_Ship, S.race) & Range(S.this, O.Own_Ship)<=3);	// minden artillerynel kozelebb levo engem detektalt ellenseges hajo levalogatasa
				SelectShips(15, S.race!=O.Own_Ship:race & (GetRelation(O.Own_Ship:race, S.race)=2 | GetRelation(O.Own_Ship:race, S.race)=3) & GetDetected(S.this, O.Own_Ship:race));		//detektlt ellensges haj van	
				If(NumOf(10), LocalEvent(DevTurnOn, E.dev:=ecm), If(ecm, ActivateDevice(ecm, 0)));				
				If(NumOf(20), LocalEvent(DevTurnOn, E.dev:=szenzor), If(szenzor, ActivateDevice(szenzor, 0)));
				If(NumOf(15), If(pajzs, ActivateDevice(pajzs, 1)));
			:end
		END
		Tick 5.5

		#include "Player_X_Rules.inc"

	END	//STATE Defensive

	///////  Stealth  ///////////////////////////////////
	STATE Stealth

		RULE 	event In 	
			:action
				O:tClearForbid(0);
				O:tSetForbid(#FORBID_MOTION_MOTIVATION);				//Osszes sajat mozgas tiltasa
				O:tSetForbid(#FORBID_FIRE);								//lvldzs tiltva				
				O:tSetForbid(#FORBID_SHIELD);				 				//Pajzs letiltsa
				LocalEvent(SelDev, 0);								
				
				EnableFortPass(O.Own_Ship, 1);							//fortshielden thaladhat
				If(szenzor, ActivateDevice(szenzor, 0));
				If(ecm, ActivateDevice(ecm, 0));
				If(eccm, ActivateDevice(eccm, 0));
				Move_Range:=2;				
				If(O.Main_Target & Range(O.Main_Target, O.Own_Ship)>Move_Range, 
					If(pajzs, ActivateDevice(pajzs, 0));
					LocalEvent(DevTurnOn, E.dev:=alca);
					seen:=0;
					SelectDevices(77, O.Own_Ship, S.weapon & !InSet(S.this, 20) & !InSet(S.this, 21) & !InSet(S.this, 22) & !InSet(S.this, 25));				//fegyverek kikapcsolsa
					ExecList(77, ActivateDevice(S.this, 0));
				);

				O:tSetTerritory(O.Main_Target, 800, 1500, 2000, 200, 2);
				
				If(NumOf(74), 
					Move_Type:=0;							
				,
					Move_Type:=1;
				);
				
				O:tEngineMode(3);										
				
				LocalEvent(Tick, 0);				
			:end
		END

		RULE 	event Tick
			:action		
				//LocalEvent(Approach, 0);
				Sec_Target:=Call(ClosestEnemy, E.target:=O.Main_Target; E.maxrange:=3; E.defensive:=1);
				If(!Sec_Target,
					seen:=0;
					SelectShips(10, S.race!=O.Own_Ship:race & GetRelation(O.Own_Ship:race, S.race)=2 & GetDetected(O.Own_Ship, S.race) & GetDetected(S.this, O.Own_Ship:race) & Range(S.this, O.Own_Ship)<=3);	// minden artillerynel kozelebb levo engem detektalt ellenseges hajo levalogatasa
					If(NumOf(10), 
						LocalEvent(DevTurnOn, E.dev:=szenzor);
						LocalEvent(DevTurnOn, E.dev:=ecm);
						LocalEvent(DevTurnOn, E.dev:=eccm);
						O:tClearForbid(#FORBID_SHIELD);				 	//Pajzs engedlyezse
					, 
						If(ecm, ActivateDevice(ecm, 0));
						If(eccm, ActivateDevice(eccm, 0));
						O:tSetForbid(#FORBID_SHIELD);					 	//Pajzs letiltsa
						If(pajzs, ActivateDevice(pajzs, 0));
					);
				,
					// TMADS
					seen:=1;
					O:tClearForbid(#FORBID_SHIELD);				 	//Pajzs engedlyezse
					O:tClearForbid(#FORBID_FIRE);					 	//Lvldzs engedlyezse
					O:tSetForbid(#FORBID_FIRE_BOMBER);				//csak bomberkuldes tiltva, minden mas tuzeles engedelyezve									
					Timer(ShowTime, 20, 0);
				);					
			:end
		END
		Tick 5.5

		#include "Player_X_Rules.inc"

		RULE	event Detected
				condition Sec_Target&E.ship=O.Own_Ship&E.race=Sec_Target:race
			:action
				If(seen & alca, ActivateDevice(alca, 0)); 		//lczs lekapcsolsa				
			:end
		END
		
		RULE	event ShowTime
			:action
				If(alca, ActivateDevice(alca, 0)); 		//lczs lekapcsolsa
			:end
		END

	END	//STATE Stealth

	///////  NoFire  ///////////////////////////////////
	STATE NoFire

		RULE 	event In 	
			:action
				O:tClearForbid(0);
				O:tSetForbid(#FORBID_MOTION_MOTIVATION);		//Osszes sajat mozgas tiltasa
				O:tSetForbid(#FORBID_FIRE_BOMBER);				//csak bomberkuldes tiltva, minden mas tuzeles engedelyezve				
				O:tSetForbid(#FORBID_FIRE_FREE);					//CO tzels tiltsa
				LocalEvent(SelDev, 0);								

				EnableFortPass(O.Own_Ship, 1);					//fortshielden thaladhat
				If(alca, ActivateDevice(alca, 0)); 
				If(eccm, ActivateDevice(eccm, 0));

				O:tSetTerritory(O.Main_Target, 800, 1500, 3000, 200, 2);
				
				Move_Range:=2;
				Move_Type:=0;

				LocalEvent(Tick, 0);
			:end
		END

		RULE 	event Tick
			:action
				//LocalEvent(Approach, 0);
				SelectShips(10, S.race!=O.Own_Ship:race & GetRelation(O.Own_Ship:race, S.race)=2 & GetDetected(S.this, O.Own_Ship:race) & Range(S.this, O.Own_Ship)<=3);	// minden artillerynel kozelebb levo detektalt ellenseges hajo levalogatasa
				LocalEvent(DevTurnOn, E.dev:=szenzor);				
				If(NumOf(10),
					LocalEvent(DevTurnOn, E.dev:=ecm);					
				,
					If(ecm, ActivateDevice(ecm, 0));
				);
				
				O:tEngineMode(0);
			:end
		END
		Tick 5.5
		
		#include "Player_X_Rules.inc"

	END	//STATE NoFire
	
END	//MACHINE "Command"
	

////////// Global command events ///////////////

RULE	event CommandInit
	:action
		Cmd_Beh:=commandBehaviour;
		Main_Target:=commandTarget;		// az egyseg, amit tamadnia kell
		Own_Ship:=this; 				//Store own ship
		Fire_Mode:=0;

		tClearMove();
		tClearFire();
		tClearTerritory();
		
		ChooseFirst(
			O.Cmd_Beh=1, GetMachine("Command"):ChangeState(Aggressive, 0), 		// aggressziv allapot
			O.Cmd_Beh=2, GetMachine("Command"):ChangeState(Defensive, 0),	 		// defenziv allapot
			O.Cmd_Beh=3, GetMachine("Command"):ChangeState(Stealth, 0),			// menekulo allapot
			O.Cmd_Beh=4, GetMachine("Command"):ChangeState(NoFire, 0)	 			// clirnyos allapot
		);
	:end
END

RULE	event ClearCommand
	:action
		tClearMove();
		tClearFire();
		tClearTerritory();
		O:tPlayerControl(1);
	:end
END
