Name Player_Artillery

CONST
END	//Const

//70-szkenner
//71-ecm
//72-eccm
//73-shield
//74-cloaking

////////// State machine Command ///////////////
MACHINE "Command"

	///////  CancelTask  ////////////////////////////////////
	STATE	CancelTask
	
		RULE 	event In	
			:action
				ExecList(35, TargetWeapon(S.this, 0));						// tuzersegi energiatamadas letiltsa
				ExecList(34, TargetWeapon(S.this, 0));						// tuzersegi tamadas meghivasa
				O:tClearCommand();
			:end
		END
		
	END	//STATE CancelTask

	///////  Aggressive  ///////////////////////////////////
	STATE Aggressive

		RULE 	event In 	
			:action
				O:tClearForbid(0);
				O:tSetForbid(#FORBID_MOTION_MOTIVATION);				//Osszes sajat mozgas tiltasa
				O:tSetForbid(#FORBID_FIRE_BOMBER);						//csak bomberkuldes tiltva, minden mas tuzeles engedelyezve				
				O:tSetForbid(#FORBID_FIRE_MISSILE);						//raktakezels tiltva				
				LocalEvent(SelDev, 0);								
				LocalEvent(CollectAbility, 0);
				LocalEvent(PurposeDisabled, E.Ability:=Ability_Missile+Ability_EBomb);				
				
				EnableFortPass(O.Own_Ship, 1);							//fortshielden thaladhat
				If(alca, ActivateDevice(alca, 0)); 
				
				Move_Range:=3;
				Move_Type:=0;

				LocalEvent(Tick, 0);
			:end
		END

		RULE 	event Tick
			:action
				LocalEvent(Approach, 0);
				if(O.Main_Target,
					Range_Main_Target:=Range(O.Main_Target, O.Own_Ship); 	//Aktualis tavolsag az elsodleges celponttol
				,
					Range_Main_Target:=Move_Range;
				);
				If(Range_Main_Target<Move_Range | Range_Main_Target>4,
					
					// MEGKZELTS
					O:tEngineMode(1);
					SelectShips(10, S.race!=O.Own_Ship:race & GetRelation(O.Own_Ship:race, S.race)=2 & GetDetected(S.this, O.Own_Ship:race) & Range(S.this, O.Own_Ship)<=3);	// minden artillerynel kozelebb levo detektalt ellenseges hajo levalogatasa
					LocalEvent(DevTurnOn, E.dev:=szenzor);
					If(NumOf(10), 
						LocalEvent(DevTurnOn, E.dev:=ecm);
						LocalEvent(DevTurnOn, E.dev:=eccm);
					, 
						If(ecm, ActivateDevice(ecm, 0));
						If(eccm, ActivateDevice(eccm, 0));
					);
				,
					// TMADS					
					O:tEngineMode(0);

					n:=0;
					Ammo_Sum:=0;
					While(n<NumOf(34), 
						Ammo_Weap:=PickN(34, n):count;
						Ammo_Sum:=(Ammo_Sum+Ammo_Weap);
						n:=n+1
					);
					If(Ammo_Sum/n-1<=2, LocalEvent(RunOutOfAmmo, 0));

					SelectShips(21, S.race=O.Main_Target:race & (Distance(S.this, O.Main_Target)=2000 | S.this=O.Main_Target) & S.this:isShielded);			// minden ellensges pajzsolt hajo Main_Target koruli combat Range-ben
					If(NumOf(21)>0, O.Enemy_Shielded:=1, O.Enemy_Shielded:=0);										// jelz billentese, ha van pajzsos egyseg a robbanasnal
					
					If(O.Enemy_Shielded, 
						ExecList(35, TargetWeapon(S.this, O.Main_Target))			// tuzersegi energiatamadas meghivasa
					,
						ExecList(35, TargetWeapon(S.this, 0))						// tuzersegi energiatamadas letiltsa
					);
					ExecList(34, TargetWeapon(S.this, O.Main_Target));			// tuzersegi tamadas meghivasa
				);
			:end
		END
		Tick 5.5

		RULE	event Out
			:action
				LocalEvent(CollectAbility, 0);
				Execlist(34, TargetWeapon(S.this, 0));			// tuzersegi tamadas letiltsa
				Execlist(35, TargetWeapon(S.this, 0));			// tuzersegi energiatamadas letiltsa			
			:end
		END
		
		#include "Player_X_Rules.inc"

		RULE	event ShieldDown	// Main_Target pajzsa leomlott, sajat fegyverek ujraertekelese
				condition E.ship:race=O.Main_Target:race
			:action
				SelectShips(21, S.race=O.Main_Target:race & (Distance(S.this, O.Main_Target)=2000 | S.this=O.Main_Target) & S.this:isShielded);			// minden ellensges pajzsolt hajo Main_Target koruli combat Range-ben
				If(NumOf(21)>0, O.Enemy_Shielded:=1, O.Enemy_Shielded:=0);										// jelz billentese, ha van pajzsos egyseg a robbanasnal
			:end
		END	//CO_ShieldDown

		RULE	event ShieldUp	// Main_Target pajzsa leomlott, sajat fegyverek ujraertekelese
				condition E.ship:race=O.Main_Target:race
			:action
				SelectShips(21, S.race=O.Main_Target:race & (Distance(S.this, O.Main_Target)=2000 | S.this=O.Main_Target) & S.this:isShielded);			// minden ellensges pajzsolt hajo Main_Target koruli combat Range-ben
				If(NumOf(21)>0, O.Enemy_Shielded:=1, O.Enemy_Shielded:=0);										// jelz billentese, ha van pajzsos egyseg a robbanasnal
			:end
		END	//CO_ShieldUp

		RULE	event RunOutOfAmmo			// Kifogy az osszes raketa
			:action
				//Warning: Most of missiles were fired!
			:end
		END	//RunOutOfAmmo

	END	//STATE Aggressive

	///////  Defensive  ///////////////////////////////////
	STATE Defensive

		RULE 	event In 	
			:action
				O:tClearForbid(0);
				O:tSetForbid(#FORBID_MOTION_MOTIVATION);				//Osszes sajat mozgas tiltasa
				O:tSetForbid(#FORBID_FIRE_BOMBER);						//csak bomberkuldes tiltva, minden mas tuzeles engedelyezve				
				O:tSetForbid(#FORBID_FIRE_MISSILE);						//raktakezels tiltva				
				O:tSetForbid(#FORBID_FIRE_NOTSHOTBY);					//csak vdekez tzels
				O:tSetForbid(#FORBID_SHIELD);
				LocalEvent(SelDev, 0);								
				LocalEvent(CollectAbility, 0);
				LocalEvent(PurposeDisabled, E.Ability:=Ability_Missile+Ability_EBomb);				

				If(eccm, ActivateDevice(eccm, 0));
				If(alca, ActivateDevice(alca, 0)); 
				
				Move_Range:=3;
				Move_Type:=0;

				LocalEvent(Tick, 0);

				O:tEngineMode(2);
			:end
		END

		RULE 	event Tick
			:action
				If(O.Own_ship:fort, 
					EnableFortPass(O.Own_Ship, 0);							//fortshielden nem haladhat t
				,
					EnableFortPass(O.Own_Ship, 1);							//fortshielden thaladhat
				);
				LocalEvent(Approach, 0);
				if(O.Main_Target,
					Range_Main_Target:=Range(O.Main_Target, O.Own_Ship); 	//Aktualis tavolsag az elsodleges celponttol
				,
					Range_Main_Target:=Move_Range;
				);
				If(Range_Main_Target<Move_Range | Range_Main_Target>4,
					
					// MEGKZELTS
					SelectShips(10, S.race!=O.Own_Ship:race & GetRelation(O.Own_Ship:race, S.race)=2 & GetDetected(S.this, O.Own_Ship:race) & Range(S.this, O.Own_Ship)<=3);	// minden artillerynel kozelebb levo detektalt ellenseges hajo levalogatasa
					SelectShips(20, S.race!=O.Own_Ship:race & GetRelation(O.Own_Ship:race, S.race)=2 & GetDetected(S.this, O.Own_Ship:race) & GetDetected(O.Own_Ship, S.race) & Range(S.this, O.Own_Ship)<=3);	// minden artillerynel kozelebb levo engem detektalt ellenseges hajo levalogatasa
					SelectShips(15, S.race!=O.Own_Ship:race & (GetRelation(O.Own_Ship:race, S.race)=2 | GetRelation(O.Own_Ship:race, S.race)=3) & GetDetected(S.this, O.Own_Ship:race));		//detektlt ellensges haj van	
					If(NumOf(10), LocalEvent(DevTurnOn, E.dev:=ecm), If(ecm, ActivateDevice(ecm, 0)));				
					If(NumOf(20), LocalEvent(DevTurnOn, E.dev:=szenzor), If(szenzor, ActivateDevice(szenzor, 0)));
					If(NumOf(15), If(pajzs, ActivateDevice(pajzs, 1)));
				,
					// TMADS
					SelectShips(10, S.race!=O.Own_Ship:race & GetRelation(O.Own_Ship:race, S.race)=2 & GetDetected(S.this, O.Own_Ship:race) & Range(S.this, O.Own_Ship)<=3);	// minden artillerynel kozelebb levo detektalt ellenseges hajo levalogatasa
					SelectShips(20, S.race!=O.Own_Ship:race & GetRelation(O.Own_Ship:race, S.race)=2 & GetDetected(S.this, O.Own_Ship:race) & GetDetected(O.Own_Ship, S.race) & Range(S.this, O.Own_Ship)<=3);	// minden artillerynel kozelebb levo engem detektalt ellenseges hajo levalogatasa
					SelectShips(15, S.race!=O.Own_Ship:race & (GetRelation(O.Own_Ship:race, S.race)=2 | GetRelation(O.Own_Ship:race, S.race)=3) & GetDetected(S.this, O.Own_Ship:race));		//detektlt ellensges haj van	
					If(NumOf(10), LocalEvent(DevTurnOn, E.dev:=ecm), If(ecm, ActivateDevice(ecm, 0)));				
					LocalEvent(DevTurnOn, E.dev:=eccm);
					If(NumOf(20), LocalEvent(DevTurnOn, E.dev:=szenzor), If(szenzor, ActivateDevice(szenzor, 0)));
					If(NumOf(15), If(pajzs, ActivateDevice(pajzs, 1)));					

					SelectShips(21, S.race=O.Main_Target:race & (Distance(S.this, O.Main_Target)=2000 | S.this=O.Main_Target) & S.this:isShielded);			// minden ellensges pajzsolt hajo Main_Target koruli combat Range-ben
					If(NumOf(21)>0, O.Enemy_Shielded:=1, O.Enemy_Shielded:=0);										// jelz billentese, ha van pajzsos egyseg a robbanasnal

					SelectShips(22, S.race=O.Own_Ship:race & Distance(S.this, O.Main_Target)=2000);			// minden sajat hajo Main_Target koruli combat Range-ben
					If(NumOf(22)>0, O.Own_In_Danger:=1, O.Own_In_Danger:=0);							// veszely billentese, ha van sajat egyseg a robbanasnal

					n:=0;
					Ammo_Sum:=0;
					While(n<NumOf(34), 
						Ammo_Weap:=PickN(34, n):count;
						Ammo_Sum:=(Ammo_Sum+Ammo_Weap);
						n:=n+1
					);
					If(Ammo_Sum/n-1<=2, LocalEvent(RunOutOfAmmo, 0));

					If(O.Enemy_Shielded & O.Own_In_Danger=0, 
						ExecList(35, TargetWeapon(S.this, O.Main_Target))			// tuzersegi energiatamadas meghivasa
					,
						ExecList(35, TargetWeapon(S.this, 0))						// tuzersegi energiatamadas letiltsa
					);
					ExecList(34, TargetWeapon(S.this, O.Main_Target));			// tuzersegi tamadas meghivasa
				);
			:end
		END
		Tick 5.5

		RULE	event Out
			:action
				LocalEvent(CollectAbility, 0);
				Execlist(34, TargetWeapon(S.this, 0));			// tuzersegi tamadas letiltsa
				Execlist(35, TargetWeapon(S.this, 0));			// tuzersegi energiatamadas letiltsa			
			:end
		END

		#include "Player_X_Rules.inc"

		RULE	event ShieldDown	// Main_Target pajzsa leomlott, sajat fegyverek ujraertekelese
				condition E.ship:race=O.Main_Target:race
			:action
				SelectShips(21, S.race=O.Main_Target:race & (Distance(S.this, O.Main_Target)=2000 | S.this=O.Main_Target) & S.this:isShielded);			// minden ellensges pajzsolt hajo Main_Target koruli combat Range-ben
				If(NumOf(21)>0, O.Enemy_Shielded:=1, O.Enemy_Shielded:=0);										// jelz billentese, ha van pajzsos egyseg a robbanasnal
			:end
		END	//CO_ShieldDown

		RULE	event ShieldUp	// Main_Target pajzsa leomlott, sajat fegyverek ujraertekelese
				condition E.ship:race=O.Main_Target:race
			:action
				SelectShips(21, S.race=O.Main_Target:race & (Distance(S.this, O.Main_Target)=2000 | S.this=O.Main_Target) & S.this:isShielded);			// minden ellensges pajzsolt hajo Main_Target koruli combat Range-ben
				If(NumOf(21)>0, O.Enemy_Shielded:=1, O.Enemy_Shielded:=0);										// jelz billentese, ha van pajzsos egyseg a robbanasnal
			:end
		END	//CO_ShieldUp

		RULE	event RunOutOfAmmo			// Kifogy az osszes raketa
			:action
				//Warning: Most of missiles were fired!
			:end
		END	//RunOutOfAmmo

	END	//STATE Defensive

	///////  Stealth  ///////////////////////////////////
	STATE Stealth

		RULE 	event In 	
			:action
				O:tClearForbid(0);
				O:tSetForbid(#FORBID_MOTION_MOTIVATION);				//Osszes sajat mozgas tiltasa
				O:tSetForbid(#FORBID_FIRE);								//lvldzs tiltva
				O:tSetForbid(#FORBID_FIRE_MISSILE);						//raktakezels tiltva				
				O:tSetForbid(#FORBID_SHIELD);				 				//Pajzs letiltsa				
				LocalEvent(SelDev, 0);								
				LocalEvent(CollectAbility, 0);
				LocalEvent(PurposeDisabled, E.Ability:=Ability_Missile+Ability_EBomb);				
				
				EnableFortPass(O.Own_Ship, 1);							//fortshielden thaladhat
				If(szenzor, ActivateDevice(szenzor, 0));
				If(ecm, ActivateDevice(ecm, 0));
				If(eccm, ActivateDevice(eccm, 0));
				Move_Range:=3;				
				If(O.Main_Target & Range(O.Main_Target, O.Own_Ship)=Move_Range, 
					If(pajzs, ActivateDevice(pajzs, 0));
					LocalEvent(DevTurnOn, E.dev:=alca);
					SelectDevices(77, O.Own_Ship, S.weapon & !InSet(S.this, 20) & !InSet(S.this, 21) & !InSet(S.this, 22) & !InSet(S.this, 25));				//fegyverek kikapcsolsa
					ExecList(77, ActivateDevice(S.this, 0));
					seen:=0;
				);
				
				If(NumOf(74), 
					Move_Type:=0;							
				,
					Move_Type:=1;
				);
				
				O:tEngineMode(3);										
				
				LocalEvent(Tick, 0);				
			:end
		END

		RULE 	event Tick
			:action		
				LocalEvent(Approach, 0);
				if(O.Main_Target,
					Range_Main_Target:=Range(O.Main_Target, O.Own_Ship); 	//Aktualis tavolsag az elsodleges celponttol
				,
					Range_Main_Target:=Move_Range;
				);
				If(Range_Main_Target>=Move_Range & Range_Main_Target<=4,
				,
					// TMADS
					O:tClearForbid(#FORBID_SHIELD);				 	//Pajzs engedlyezse
					
					n:=0;
					Ammo_Sum:=0;
					While(n<NumOf(34), 
						Ammo_Weap:=PickN(34, n):count;
						Ammo_Sum:=(Ammo_Sum+Ammo_Weap);
						n:=n+1
					);
					If(Ammo_Sum/n-1<=2, LocalEvent(RunOutOfAmmo, 0));

					SelectShips(21, S.race=O.Main_Target:race & (Distance(S.this, O.Main_Target)=2000 | S.this=O.Main_Target) & S.this:isShielded);			// minden ellensges pajzsolt hajo Main_Target koruli combat Range-ben
					If(NumOf(21)>0, O.Enemy_Shielded:=1, O.Enemy_Shielded:=0);										// jelz billentese, ha van pajzsos egyseg a robbanasnal

					If(O.Enemy_Shielded, 
						ExecList(35, TargetWeapon(S.this, O.Main_Target))			// tuzersegi energiatamadas meghivasa
					,
						ExecList(35, TargetWeapon(S.this, 0))						// tuzersegi energiatamadas letiltsa
					);
					ExecList(34, TargetWeapon(S.this, O.Main_Target));			// tuzersegi tamadas meghivasa
				);	
			:end
		END
		Tick 5.5

		RULE	event Out
			:action
				LocalEvent(CollectAbility, 0);
				Execlist(34, TargetWeapon(S.this, 0));			// tuzersegi tamadas letiltsa
				Execlist(35, TargetWeapon(S.this, 0));			// tuzersegi energiatamadas letiltsa			
			:end
		END

		#include "Player_X_Rules.inc"

		RULE	event ShieldDown	// Main_Target pajzsa leomlott, sajat fegyverek ujraertekelese
				condition E.ship:race=O.Main_Target:race
			:action
				SelectShips(21, S.race=O.Main_Target:race & (Distance(S.this, O.Main_Target)=2000 | S.this=O.Main_Target) & S.this:isShielded);			// minden ellensges pajzsolt hajo Main_Target koruli combat Range-ben
				If(NumOf(21)>0, O.Enemy_Shielded:=1, O.Enemy_Shielded:=0);										// jelz billentese, ha van pajzsos egyseg a robbanasnal
			:end
		END	//CO_ShieldDown

		RULE	event ShieldUp	// Main_Target pajzsa leomlott, sajat fegyverek ujraertekelese
				condition E.ship:race=O.Main_Target:race
			:action
				SelectShips(21, S.race=O.Main_Target:race & (Distance(S.this, O.Main_Target)=2000 | S.this=O.Main_Target) & S.this:isShielded);			// minden ellensges pajzsolt hajo Main_Target koruli combat Range-ben
				If(NumOf(21)>0, O.Enemy_Shielded:=1, O.Enemy_Shielded:=0);										// jelz billentese, ha van pajzsos egyseg a robbanasnal
			:end
		END	//CO_ShieldUp

		RULE	event RunOutOfAmmo			// Kifogy az osszes raketa
			:action
				//Warning: Most of missiles were fired!
			:end
		END	//RunOutOfAmmo

	END	//STATE Stealth

	///////  NoFire  ///////////////////////////////////
	STATE NoFire

		RULE 	event In 	
			:action
				O:tClearForbid(0);
				O:tSetForbid(#FORBID_MOTION_MOTIVATION);		//Osszes sajat mozgas tiltasa
				O:tSetForbid(#FORBID_FIRE_BOMBER);				//csak bomberkuldes tiltva, minden mas tuzeles engedelyezve				
				O:tSetForbid(#FORBID_FIRE_MISSILE);				//raktakezels tiltva				
				O:tSetForbid(#FORBID_FIRE_FREE);					//CO tzels tiltsa
				LocalEvent(SelDev, 0);								
				LocalEvent(CollectAbility, 0);
				LocalEvent(PurposeDisabled, E.Ability:=Ability_Missile+Ability_EBomb);				

				EnableFortPass(O.Own_Ship, 1);					//fortshielden thaladhat
				If(alca, ActivateDevice(alca, 0)); 
				
				Move_Range:=3;
				Move_Type:=0;

				LocalEvent(Tick, 0);
			:end
		END

		RULE 	event Tick
			:action
				LocalEvent(Approach, 0);
				if(O.Main_Target,
					Range_Main_Target:=Range(O.Main_Target, O.Own_Ship); 	//Aktualis tavolsag az elsodleges celponttol
				,
					Range_Main_Target:=Move_Range;
				);
				If(Range_Main_Target<Move_Range | Range_Main_Target>4,
					
					// MEGKZELTS
					O:tEngineMode(1);
					SelectShips(10, S.race!=O.Own_Ship:race & GetRelation(O.Own_Ship:race, S.race)=2 & GetDetected(S.this, O.Own_Ship:race) & Range(S.this, O.Own_Ship)<=3);	// minden artillerynel kozelebb levo detektalt ellenseges hajo levalogatasa
					LocalEvent(DevTurnOn, E.dev:=szenzor);				
					If(NumOf(10),
						LocalEvent(DevTurnOn, E.dev:=eccm);					
						LocalEvent(DevTurnOn, E.dev:=ecm);											
					,
						If(eccm, ActivateDevice(eccm, 0));
						If(ecm, ActivateDevice(ecm, 0));
					);
				,
					// TMADS
					O:tEngineMode(0);
					SelectShips(10, S.race!=O.Own_Ship:race & GetRelation(O.Own_Ship:race, S.race)=2 & GetDetected(S.this, O.Own_Ship:race) & Range(S.this, O.Own_Ship)<=3);	// minden artillerynel kozelebb levo detektalt ellenseges hajo levalogatasa
					LocalEvent(DevTurnOn, E.dev:=szenzor);				
					If(NumOf(10),
						LocalEvent(DevTurnOn, E.dev:=eccm);					
						LocalEvent(DevTurnOn, E.dev:=ecm);											
					,
						If(eccm, ActivateDevice(eccm, 0));
						If(ecm, ActivateDevice(ecm, 0));
					);

					n:=0;
					Ammo_Sum:=0;
					While(n<NumOf(34), 
						Ammo_Weap:=PickN(34, n):count;
						Ammo_Sum:=(Ammo_Sum+Ammo_Weap);
						n:=n+1
					);
					If(Ammo_Sum/n-1<=2, LocalEvent(RunOutOfAmmo, 0));

					SelectShips(21, S.race=O.Main_Target:race & (Distance(S.this, O.Main_Target)=2000 | S.this=O.Main_Target) & S.this:isShielded);			// minden ellensges pajzsolt hajo Main_Target koruli combat Range-ben
					If(NumOf(21)>0, O.Enemy_Shielded:=1, O.Enemy_Shielded:=0);										// jelz billentese, ha van pajzsos egyseg a robbanasnal

					If(O.Enemy_Shielded, 
						ExecList(35, TargetWeapon(S.this, O.Main_Target))			// tuzersegi energiatamadas meghivasa
					,
						ExecList(35, TargetWeapon(S.this, 0))						// tuzersegi energiatamadas letiltsa
					);
					ExecList(34, TargetWeapon(S.this, O.Main_Target));			// tuzersegi tamadas meghivasa
				);
			:end
		END
		Tick 5.5

		RULE	event Out
			:action
				LocalEvent(CollectAbility, 0);
				Execlist(34, TargetWeapon(S.this, 0));			// tuzersegi tamadas letiltsa
				Execlist(35, TargetWeapon(S.this, 0));			// tuzersegi energiatamadas letiltsa			
			:end
		END
		
		#include "Player_X_Rules.inc"

		RULE	event ShieldDown	// Main_Target pajzsa leomlott, sajat fegyverek ujraertekelese
				condition E.ship:race=O.Main_Target:race
			:action
				SelectShips(21, S.race=O.Main_Target:race & (Distance(S.this, O.Main_Target)=2000 | S.this=O.Main_Target) & S.this:isShielded);			// minden ellensges pajzsolt hajo Main_Target koruli combat Range-ben
				If(NumOf(21)>0, O.Enemy_Shielded:=1, O.Enemy_Shielded:=0);										// jelz billentese, ha van pajzsos egyseg a robbanasnal
			:end
		END	//CO_ShieldDown

		RULE	event ShieldUp	// Main_Target pajzsa leomlott, sajat fegyverek ujraertekelese
				condition E.ship:race=O.Main_Target:race
			:action
				SelectShips(21, S.race=O.Main_Target:race & (Distance(S.this, O.Main_Target)=2000 | S.this=O.Main_Target) & S.this:isShielded);			// minden ellensges pajzsolt hajo Main_Target koruli combat Range-ben
				If(NumOf(21)>0, O.Enemy_Shielded:=1, O.Enemy_Shielded:=0);										// jelz billentese, ha van pajzsos egyseg a robbanasnal
			:end
		END	//CO_ShieldUp

		RULE	event RunOutOfAmmo			// Kifogy az osszes raketa
			:action
				//Warning: Most of missiles were fired!
			:end
		END	//RunOutOfAmmo

	END	//STATE NoFire

END	//MACHINE "Command"
	

////////// Global command events ///////////////

RULE	event CommandInit
	:action
		Cmd_Beh:=commandBehaviour;
		Main_Target:=commandTarget;		// az egyseg, amit tamadnia kell
		Own_Ship:=this; 				//Store own ship
		Fire_Mode:=4;
		Enemy_Shielded:=0;
		Own_In_Danger:=0;

		tClearMove();
		tClearFire();
		tClearTerritory();
		
		If(Main_Target:race>=0,
			SetRelation(race, Main_Target:race, 2);
		);

		ChooseFirst(
			O.Cmd_Beh=1, GetMachine("Command"):ChangeState(Aggressive, 0), 		// aggressziv allapot
			O.Cmd_Beh=2, GetMachine("Command"):ChangeState(Defensive, 0),	 		// defenziv allapot
			O.Cmd_Beh=3, GetMachine("Command"):ChangeState(Stealth, 0),				// menekulo allapot
			O.Cmd_Beh=4, GetMachine("Command"):ChangeState(NoFire, 0)	 			// clirnyos allapot
		);
	:end
END

RULE	event ClearCommand
	:action
		tClearMove();
		tClearFire();
		tClearTerritory();
		O:tPlayerControl(1);
	:end
END
