RULE 	event Clearforbid	
	:action
		O:tClearForbid(#FORBID_MOTION);
		O:tClearForbid(#FORBID_FIRE_FREE);
		O:tClearForbid(#FORBID_FIRE_BOMBER);
		O:tClearForbid(#FORBID_FIRE_NOTSHOTBY);
		O:tClearForbid(#FORBID_SHIELD);
		O:tClearForbid(#FORBID_ENGINE);
	:end
END

RULE 	event SelDev 	
	:action
		If(SelectDevices(70, O.Own_Ship, S.working & InSet(S.this, 18)),		//szenzor
			szenzor:=PickFirst(70);
		,
			szenzor:=0;
		);
		If(SelectDevices(71, O.Own_Ship, S.working & InSet(S.this, 16)),		//ecm
			ecm:=PickFirst(71);
		,
			ecm:=0;
		);
		If(SelectDevices(72, O.Own_Ship, S.working & InSet(S.this, 17)),		//eccm												
			eccm:=PickFirst(72);
		,
			eccm:=0;
		);
		If(SelectDevices(73, O.Own_Ship, S.working & InSet(S.this, 8)),		//pajzs
			pajzs:=PickFirst(73);
		,
			pajzs:=0;
		);
		If(SelectDevices(74, O.Own_Ship, S.working & InSet(S.this, 9)),		//cloaking
			alca:=PickFirst(74);
		,
			alca:=0;
		);
		If(szenzor, ActivateDevice(szenzor, 0));
		If(ecm, ActivateDevice(ecm, 0));
		If(eccm, ActivateDevice(eccm, 0));
	:end
END

RULE 	event DevTurnOn
	:action
		energie:=O.Own_Ship:availSuppForDevices;
		If(szenzor & szenzor:active, energie:=energie-szenzor:energyIn);
		If(ecm & ecm:active, energie:=energie-ecm:energyIn);
		If(eccm & eccm:active, energie:=energie-eccm:energyIn);
		If(alca & alca:active, energie:=energie-alca:energyIn);
		If(E.dev & energie>=E.dev:energyIn, ActivateDevice(E.dev, 1));
	:end
END

RULE 	event Approach 	
	:action
		If(IsValid(O.Main_Target),
			If(O.Main_Target:gate, 
				ChooseFirst(
					Move_Range=2, Move_Dist:=1500;,
					Move_Range=3, Move_Dist:=7500;,
					Move_Range=4, Move_Dist:=14500;,
					Move_Range=5, Move_Dist:=25000;,
				);
				If(VSqLen(kozelito:=VSub(O.Own_Ship:position, O.Main_Target:position))=0,
					kozelito:=VRandomDir();
				,
					kozelito:=VNorm(kozelito);
				);
				kozelito:=VAdd(O.Main_Target:position, VMul(Move_Dist, VNorm(kozelito)));
				O:tMoveTo(C.kozelito,0,0, C.Move_Type);
			,
				O:tMoveTo(O.Main_Target, C.Move_Range, C.Move_Type);		//Move to optimal Range
			);
		,
			ChangeState(CancelTask, 0);
		);
	:end
END

RULE	event ToFormation
		condition E.commander=O:groupLeader&!O:isGroupLeader
	:action
		O:tFollow(E.lead, C.Follow_Rad, 1);
		information:=1;
		Move_Range:=E.mrange;
		LocalEvent(Tick, 0);
	:end
END

RULE	event BreakFormation
		condition E.commander=O:groupLeader&!O:isGroupLeader
	:action
		O:tClearFollow();
		LocalEvent(AIFire, 0);
		information:=0;
		Move_Range:=E.mrange;
		LocalEvent(Tick, 0);
	:end
END

RULE	event LeaveFormation
	:action	
		newformation_s:=1;
	:end
END

RULE	event CO_DeviceDisabled
		condition E.ship=O.Own_Ship&!E.device:weapon
	:action
		ChooseFirst(
			InSet(E.device, 18),	
				If(SelectDevices(70, O.Own_Ship, S.working & InSet(S.this, 18)),		//szenzor
					szenzor:=PickFirst(70);
				,
					szenzor:=0;
				);,
			InSet(E.device, 16), 
				If(SelectDevices(71, O.Own_Ship, S.working & InSet(S.this, 16)),		//ecm
					ecm:=PickFirst(71);
				,
					ecm:=0;
				);,
			InSet(E.device, 17),	
				If(SelectDevices(72, O.Own_Ship, S.working & InSet(S.this, 17)),		//eccm												
					eccm:=PickFirst(72);
				,
					eccm:=0;
				);,
			InSet(E.device, 8), 	
				If(SelectDevices(73, O.Own_Ship, S.working & InSet(S.this, 8)),		//pajzs
					pajzs:=PickFirst(73);
				,
					pajzs:=0;
				);,
			InSet(E.device, 9), 	
				If(SelectDevices(74, O.Own_Ship, S.working & InSet(S.this, 9)),		//cloaking
					alca:=PickFirst(74);
				,
					alca:=0;
				);,
		);
	:end
END

RULE	event CollectAbility
	:action
		SelectDevices(31, O.Own_Ship, S.weapon & S.working & S.shieldValue=1 & S.count!=0);		// minden a hajon levo mukodo pajzsrombolo fegyver (purpose alapjan)
		SelectDevices(32, O.Own_Ship, S.weapon & S.working & S.hullValue=1 & S.count!=0);			// minden a hajon levo mukodo hullrombolo fegyver (purpose alapjan)
		SelectDevices(33, O.Own_Ship, S.weapon & S.working & S.deviceValue=1 & S.count!=0);		// minden a hajon levo mukodo berendezesrombolo fegyver (purpose alapjan)
		SelectDevices(34, O.Own_Ship, S.weapon & S.working & InSet(S.this, 2) & InSet(S.this, 5) & S.count!=0); 	//Raketak levalogatasa
		SelectDevices(35, O.Own_Ship, S.weapon & S.working & InSet(S.this, 3) & InSet(S.this, 5) & S.count!=0); 	//E-bombk levalogatasa
		If(NumOf(31)>0, Ability_Shield:=1, Ability_Shield:=0);
		If(NumOf(32)>0, Ability_Hull:=2, Ability_Hull:=0);
		If(NumOf(33)>0, Ability_Device:=3, Ability_Device:=0);
		If(NumOf(34)>0, Ability_Missile:=4, Ability_Missile:=0);
		If(NumOf(35)>0, Ability_EBomb:=5, Ability_EBomb:=0);
	:end
END

RULE	event PurposeDisabled	//fegyverzet uzemkeptelen
		condition E.Ability=0
	:action
		O:tSetWarning(#Warn_TaskFailed);		//Warning: Main weapons are offline, We are unable to complete task.
		O:tClearFire();
	:end
END	//PurposeDisabled

RULE	event CO_DeviceDisabled
		condition E.ship=O.Own_Ship&E.device:weapon
	:action
		LocalEvent(CollectAbility, 0);
		ChooseFirst(
			O.Fire_Mode=0, 
				0, 																								// Nem is tzelnk
			O.Fire_Mode=1, 
				LocalEvent(PurposeDisabled, E.Ability:=Ability_Shield),							// Pajzsrombols
			O.Fire_Mode=2, 
				LocalEvent(PurposeDisabled, E.Ability:=Ability_Hull),								// Hullrombols
			O.Fire_Mode=3, 
				LocalEvent(PurposeDisabled, E.Ability:=Ability_Device),							// Devicerombols
			O.Fire_Mode=4, 
				LocalEvent(PurposeDisabled, E.Ability:=Ability_Missile+Ability_EBomb)		// Missile
		);
	:end
END

RULE	event ShieldDown	// Sajt pajzs leomlott
		condition E.ship=O.Own_Ship&O.Cmd_Beh=3&alca&seen
	:action
		If(szenzor, ActivateDevice(szenzor, 0));
		If(ecm, ActivateDevice(ecm, 0));
		If(eccm, ActivateDevice(eccm, 0));
		LocalEvent(DevTurnOn, E.dev:=alca);
		LocalEvent(DevTurnOn, E.dev:=ecm);
	:end
END	//CO_ShieldDown

RULE	event Detected
		condition E.ship=O.Own_Ship&E.race=O.Main_Target:race
	:action
		seen:=1;
		O:tClearForbid(#FORBID_SHIELD);				 	//Pajzs engedlyezse
		SelectShips(10, S.race!=O.Own_Ship:race & GetRelation(O.Own_Ship:race, S.race)=2 & GetDetected(O.Own_Ship, S.race) & GetDetected(S.this, O.Own_Ship:race) & Range(S.this, O.Own_Ship)<=3);	// minden artillerynel kozelebb levo engem detektalt ellenseges hajo levalogatasa
		If(NumOf(10), 				
			O:tClearForbid(#FORBID_FIRE);					 	//Lvldzs engedlyezse
			O:tSetForbid(#FORBID_FIRE_BOMBER);				//csak bomberkuldes tiltva, minden mas tuzeles engedelyezve				
			LocalEvent(DevTurnOn, E.dev:=ecm);
		);
		If(Range_Main_Target=Move_Range,
			LocalEvent(DevTurnOn, E.dev:=eccm);
		); 		//lczs lekapcsolsa				
	:end
END

RULE	event UnDetected	// Sajt haj eltnt
		condition E.ship=O.Own_Ship&E.race=O.Main_Target:race&O.Cmd_Beh=3
	:action
		seen:=0;
		If(szenzor, ActivateDevice(szenzor, 0));
		If(ecm, ActivateDevice(ecm, 0));
		If(eccm, ActivateDevice(eccm, 0));
		If(Range_Main_Target>Move_Range,
			O:tSetForbid(#FORBID_SHIELD);					 	//Pajzs letiltsa
			If(pajzs, ActivateDevice(pajzs, 0));
		);
	:end
END	//CO_ShieldDown

RULE	event ShieldUp	// Sajt pajzs felplt
		condition E.ship=O.Own_Ship&O.Cmd_Beh=3&alca
	:action
		If(Range_Main_Target=Move_Range,
			If(alca, ActivateDevice(alca, 0));
			LocalEvent(DevTurnOn, E.dev:=ecm);
			LocalEvent(DevTurnOn, E.dev:=szenzor);
			LocalEvent(DevTurnOn, E.dev:=eccm);
		);
	:end
END	//CO_ShieldDown

RULE	event UnDetected		//clpont haj eltnt
		condition E.ship=O.Main_Target&E.race=race
	:action
		O:tSetWarning(#Warn_TaskFailed);		//Warning: enemy undetected!			
		Prev_Target:=O.Main_Target;
		O.Main_Target:=E.navpoint;
	:end
END	//Main UnDetected

RULE	event Detected		//clpont haj feltnt
		condition E.race=race&E.navpoint=O.Main_Target
	:action
		O.Main_Target:=E.ship;
		Prev_Target:=0;
	:end
END	//Main Detected		

RULE	event Deleted	//Celpont hajo megsemmisult
		condition E.ship=O.Main_Target
	:action				
		If(E.class!=0, 
			If(O.Fire_Mode!=2&O.Fire_Mode!=4,
				O:tSetWarning(#Warn_TaskFailed);		//Report: Target ship is destroyed. Task canceled.
			,						
				O:tSetWarning(#Warn_TaskCompleted);		//Report: Target ship is destroyed. Task canceled.
			);
		);
		ChangeState(CancelTask, 0);
	:end
END	//Main Deleted

RULE	event ShieldDown	// Main_Target pajzsa leomlott
		condition E.ship=O.Main_Target&O.Fire_Mode=1
	:action
		O:tSetWarning(#Warn_TaskCompleted);		//Report: Target ship is unshielded.
	:end
END	//CO_ShieldDown

RULE	event CO_DeviceDisabled		//Celpont kijelolt berendezese/osszes berendezese uzemkeptelen
		condition E.ship=O.Main_Target&O.Fire_Mode=3
	:action		
		SelectDevices(80, O.Main_Target, S.destroyed=0);										// minden Main_Targeten levo nem teljesen lepusztult device
		Dump(80);
		If(NumOf(80)=1, 
			O:tSetWarning(#Warn_TaskCompleted);	//Report: All devices destroyed. Task completed.
			ChangeState(CancelTask, 0)
		, 
			0
		);	
	:end
END	//Devicedisabled

RULE	event Collapsed	//Celpont hajo megvltozott
		condition E.ship=O.Main_Target
	:action
		O:tSetWarning(#Warn_TaskFailed);		//Report: Target ship is destroyed. Task canceled.
		ChangeState(CancelTask, 0);
	:end
END	//Main Collapsed

RULE	event Splitted		//Celpont hajo megvltozott
		condition E.ship=O.Main_Target
	:action
		O:tSetWarning(#Warn_TaskFailed);		//Report: Target ship is destroyed. Task canceled.
		ChangeState(CancelTask, 0);
	:end
END	//Main Splitted

RULE	event RunAway	//Celpont hajo elszguld
		condition E.ship=O.Main_Target
	:action
		O:tSetWarning(#Warn_TaskFailed);		//Report: Target ship is run away. Task canceled.
		ChangeState(CancelTask, 0);
	:end
END	//Main RunAway

RULE	event JumpedOut	//Celpont hajo elugrik
		condition E.ship=O.Main_Target
	:action
		O:tSetWarning(#Warn_TaskFailed);		//Report: Target ship is jumped out. Task canceled.
		ChangeState(CancelTask, 0);
	:end
END	//Main JumpedOut

RULE	event TurnOff	//Command kls lekapcsolsa
		condition E.shp=O.Own_Ship
	:action
		ChooseFirst(
			E.msg=0, 
				O:tSetWarning(#Warn_TaskFailed);
				ChangeState(CancelTask, 0);,
			E.msg=1, 
				O:tSetWarning(#Warn_TaskCompleted);
				ChangeState(CancelTask, 0);,
			E.msg=2, 
				ChangeState(CancelTask, 0);,
			1, 
				ChangeState(CancelTask, 0);
		);
	:end
END	//TurnOff

RULE	event Beh_Changed		//Viselkedes megvaltozott
	:action
		O.Cmd_Beh:=E.commandBehaviour;
		ChooseFirst(
			O.Cmd_Beh=1, ChangeState(Aggressive, 0), 		// aggressziv allapot
			O.Cmd_Beh=2, ChangeState(Defensive, 0), 		// defenziv allapot
			O.Cmd_Beh=3, ChangeState(Stealth, 0),			// menekulo allapot
			O.Cmd_Beh=4, ChangeState(NoFire, 0)	 			// clirnyos allapot
		);
		EventEx(ForcedBeh, E.commander:=O:groupLeader;E.beh:=O.Cmd_Beh);
	:end
END	//Beh_Changed

RULE	event ForcedBeh		//Viselkedes megvaltoztatsa leader ltal
		condition E.commander=O:groupLeader
	:action
		O.Cmd_Beh:=E.beh;
		O:commandBehaviour:=O.Cmd_Beh;
		ChooseFirst(
			O.Cmd_Beh=1, ChangeState(Aggressive, 0), 		// aggressziv allapot
			O.Cmd_Beh=2, ChangeState(Defensive, 0), 		// defenziv allapot
			O.Cmd_Beh=3, ChangeState(Stealth, 0),			// menekulo allapot
			O.Cmd_Beh=4, ChangeState(NoFire, 0)	 			// clirnyos allapot
		);
	:end
END	//Beh_Changed

RULE	event ForcedBeh		//Viselkedes megvaltoztatsa leader ltal
		condition E.shp=O.Own_Ship
	:action
		O.Cmd_Beh:=E.beh;
		O:commandBehaviour:=O.Cmd_Beh;
		ChooseFirst(
			O.Cmd_Beh=1, ChangeState(Aggressive, 0), 		// aggressziv allapot
			O.Cmd_Beh=2, ChangeState(Defensive, 0), 		// defenziv allapot
			O.Cmd_Beh=3, ChangeState(Stealth, 0),			// menekulo allapot
			O.Cmd_Beh=4, ChangeState(NoFire, 0)	 			// clirnyos allapot
		);
	:end
END	//Beh_Changed
