Name Player_Siege_Group

CONST
END	//Const

////////// State machine Main ///////////////
MACHINE "Command"

	///////  CancelTask  ////////////////////////////////////
	STATE	CancelTask

		RULE 	event In	
			:action
				O:tClearCommand();				
			:end
		END
			
	END	//STATE CancelTask

	///////  Aggressive  ///////////////////////////////////
	STATE Aggressive

		RULE 	event In 	
			:action
				O:tClearForbid(0);
				O:tSetForbid(#FORBID_MOTION_MOTIVATION);	//Osszes sajat mozgas tiltasa
				O:tSetForbid(#FORBID_FIRE);							//csak bomberkuldes tiltva, minden mas tuzeles engedelyezve				
				LocalEvent(SelDev, 0);								
				
				EnableFortPass(O.Own_Ship, 1);							//fortshielden thaladhat
				If(alca, ActivateDevice(alca, 0)); 				

				Move_Type:=0;				
				Move_Range:=4;  // Kivanatos tavolsag az elsodleges celpot tamadasahoz
				O:tEngineMode(0);
				ForceOrient(O.Own_Ship, O.Main_Target, O.Own_Ship:bank);
				
				Follow_Rad:=500;
				
				newformation_s:=1;
				information:=2;				
			:end
		END
		
		Tick 5.5

		// Leader //////////////////////////		
		RULE	event Formed
				condition E.formation=O.Sig_Form&O:isGroupLeader
			:action
				TargetWeapon(O.Sig_Laser, O.Main_Target);
				information:=1;
			:end
		END

		RULE 	event Tick
				condition O:isGroupLeader
			:action
				If(newformation_s, 
					SelectShips(1, S.groupLeader=O.Own_Ship);
					If(NumOf(1)<3,
						ChangeState(Canceltask, 0);
					,
						If(!O.Sig_Laser, 
							ChangeState(CancelTask, 0);
						,							
							O.Sig_Form := StartFormation(1, O.Own_Ship, O.Sig_Laser_Type);							
							newformation_s:=0;					
						);
					);
				,
					Range_Main_Target:=Range(O.Main_Target, O.Own_Ship); 	//Aktualis tavolsag az elsodleges celponttol
					If(Range_Main_Target>Move_Range|Range_Main_Target<Move_Range-1,					
						// MEGKZELTS					
						LocalEvent(Approach, 0);
						SelectShips(10, S.race!=O.Own_Ship:race & GetRelation(O.Own_Ship:race, S.race)=2 & GetDetected(S.this, O.Own_Ship:race) & Range(S.this, O.Own_Ship)<=3);	// minden artillerynel kozelebb levo detektalt ellenseges hajo levalogatasa
						LocalEvent(DevTurnOn, E.dev:=szenzor);
						If(NumOf(10), 
							LocalEvent(DevTurnOn, E.dev:=eccm);
							LocalEvent(DevTurnOn, E.dev:=ecm);
						, 
							If(eccm, ActivateDevice(eccm, 0));
							If(ecm, ActivateDevice(ecm, 0));
						);
					,
						// TMADS								
						information:=0;
						O.Own_Ship:tClearMove();
						SelectShips(10, S.race!=O.Own_Ship:race & GetRelation(O.Own_Ship:race, S.race)=2 & GetDetected(S.this, O.Own_Ship:race) & Range(S.this, O.Own_Ship)<=3);	// minden artillerynel kozelebb levo detektalt ellenseges hajo levalogatasa
						If(NumOf(10), 
							LocalEvent(DevTurnOn, E.dev:=eccm);
							LocalEvent(DevTurnOn, E.dev:=ecm);
						, 
							If(eccm, ActivateDevice(eccm, 0));
							If(ecm, ActivateDevice(ecm, 0));
						);
						LocalEvent(DevTurnOn, E.dev:=szenzor);
					);
				);
			:end
		END

		// Wingman //////////////////////////
		RULE 	event Tick
				condition !O:isGroupLeader
			:action
				If(!SelectDevices(2, O.Own_Ship, S.working & (InSet(S.this, 70) | S.devType=#supp_secWGen | S.devType=#supp_secWGen2)),
					information:=2;
					ChangeState(CancelTask, 0);
				);
			:end
		END

		RULE 	event Tick
				condition !O:isGroupLeader&information!=2
			:action
				If(information,					
					// MEGKZELTS
					SelectShips(10, S.race!=O.Own_Ship:race & GetRelation(O.Own_Ship:race, S.race)=2 & GetDetected(S.this, O.Own_Ship:race) & Range(S.this, O.Own_Ship)<=3);	// minden artillerynel kozelebb levo detektalt ellenseges hajo levalogatasa
					LocalEvent(DevTurnOn, E.dev:=szenzor);
					If(NumOf(10), 
						LocalEvent(DevTurnOn, E.dev:=eccm);
						LocalEvent(DevTurnOn, E.dev:=ecm);
					, 
						If(eccm, ActivateDevice(eccm, 0));
						If(ecm, ActivateDevice(ecm, 0));
					);
				,
					// TMADS					
					SelectShips(10, S.race!=O.Own_Ship:race & GetRelation(O.Own_Ship:race, S.race)=2 & GetDetected(S.this, O.Own_Ship:race) & Range(S.this, O.Own_Ship)<=3);	// minden artillerynel kozelebb levo detektalt ellenseges hajo levalogatasa
					If(NumOf(10), 
						LocalEvent(DevTurnOn, E.dev:=eccm);
						LocalEvent(DevTurnOn, E.dev:=ecm);
					, 
						If(eccm, ActivateDevice(eccm, 0));
						If(ecm, ActivateDevice(ecm, 0));
					);
					LocalEvent(DevTurnOn, E.dev:=szenzor);
				);
			:end
		END

		#include "Group_X_Rules.inc"

	END	//STATE Aggressive

	///////  Defensive  ///////////////////////////////////
	STATE Defensive

		RULE 	event In 	
			:action
				O:tClearForbid(0);
				O:tSetForbid(#FORBID_MOTION_MOTIVATION);				//Osszes sajat mozgas tiltasa
				O:tSetForbid(#FORBID_FIRE_BOMBER);						//csak bomberkuldes tiltva, minden mas tuzeles engedelyezve				
				O:tSetForbid(#FORBID_FIRE_NOTSHOTBY);					//csak vdekez tzels
				O:tSetForbid(#FORBID_SHIELD);
				LocalEvent(SelDev, 0);								

				If(eccm, ActivateDevice(eccm, 0));
				If(alca, ActivateDevice(alca, 0)); 
				LocalEvent(DevTurnOn, E.dev:=ecm);
				
				Move_Range:=4;  // Kivanatos tavolsag az elsodleges celpot tamadasahoz
				Move_Type:=0;
				O:tEngineMode(2);
				ForceOrient(O.Own_Ship, O.Main_Target, O.Own_Ship:bank);
				
				Follow_Rad:=3000;
				
				newformation_s:=1;
				information:=2;				
			:end
		END
		
		RULE 	event Tick
			:action
				If(O:fort, 
					EnableFortPass(O.Own_Ship, 0);							//fortshielden nem haladhat t
				,
					EnableFortPass(O.Own_Ship, 1);							//fortshielden thaladhat
				);
			:end
		END
		Tick 5.5

		// Leader //////////////////////////		
		RULE	event Formed
				condition E.formation=O.Sig_Form&O:isGroupLeader
			:action
				TargetWeapon(O.Sig_Laser, O.Main_Target);
				information:=1;
			:end
		END

		RULE 	event Tick
				condition O:isGroupLeader
			:action
				If(newformation_s, 
					SelectShips(1, S.groupLeader=O.Own_Ship);
					If(NumOf(1)<3,
						ChangeState(Canceltask, 0);
					,
						If(!O.Sig_Laser, 
							ChangeState(CancelTask, 0);
						,							
							O.Sig_Form := StartFormation(1, O.Own_Ship, O.Sig_Laser_Type);
							TargetWeapon(O.Sig_Laser, O.Main_Target);
							newformation_s:=0;					
						);
					);
				,
					Range_Main_Target:=Range(O.Main_Target, O.Own_Ship); 	//Aktualis tavolsag az elsodleges celponttol
					If(Range_Main_Target>Move_Range|Range_Main_Target<Move_Range-1,					
						// MEGKZELTS					
						LocalEvent(Approach, 0);
						SelectShips(20, S.race!=O.Own_Ship:race & GetRelation(O.Own_Ship:race, S.race)=2 & GetDetected(S.this, O.Own_Ship:race) & GetDetected(O.Own_Ship, S.race) & Range(S.this, O.Own_Ship)<=3);	// minden artillerynel kozelebb levo engem detektalt ellenseges hajo levalogatasa
						SelectShips(15, S.race!=O.Own_Ship:race & (GetRelation(O.Own_Ship:race, S.race)=2 | GetRelation(O.Own_Ship:race, S.race)=3) & GetDetected(S.this, O.Own_Ship:race));		//detektlt ellensges haj van	
						If(NumOf(20), LocalEvent(DevTurnOn, E.dev:=szenzor), If(szenzor, ActivateDevice(szenzor, 0)));
						If(NumOf(15), If(pajzs, ActivateDevice(pajzs, 1)));									
					,
						// TMADS	
						information:=0;
						O.Own_Ship:tClearMove();
						SelectShips(20, S.race!=O.Own_Ship:race & GetRelation(O.Own_Ship:race, S.race)=2 & GetDetected(S.this, O.Own_Ship:race) & GetDetected(O.Own_Ship, S.race) & Range(S.this, O.Own_Ship)<=3);	// minden artillerynel kozelebb levo engem detektalt ellenseges hajo levalogatasa
						SelectShips(15, S.race!=O.Own_Ship:race & (GetRelation(O.Own_Ship:race, S.race)=2 | GetRelation(O.Own_Ship:race, S.race)=3) & GetDetected(S.this, O.Own_Ship:race));		//detektlt ellensges haj van	
						LocalEvent(DevTurnOn, E.dev:=eccm);
						If(NumOf(20), LocalEvent(DevTurnOn, E.dev:=szenzor), If(szenzor, ActivateDevice(szenzor, 0)));
						If(NumOf(15), If(pajzs, ActivateDevice(pajzs, 1)));									
					);
				);
			:end
		END

		// Wingman //////////////////////////
		RULE 	event Tick
				condition !O:isGroupLeader
			:action
				If(!SelectDevices(2, O.Own_Ship, S.working & (InSet(S.this, 70) | S.devType=#supp_secWGen | S.devType=#supp_secWGen2)),
					information:=2;
					ChangeState(CancelTask, 0);
				);
			:end
		END

		RULE 	event Tick
				condition !O:isGroupLeader&information!=2
			:action
				If(information,					
					// MEGKZELTS
					SelectShips(20, S.race!=O.Own_Ship:race & GetRelation(O.Own_Ship:race, S.race)=2 & GetDetected(S.this, O.Own_Ship:race) & GetDetected(O.Own_Ship, S.race) & Range(S.this, O.Own_Ship)<=3);	// minden artillerynel kozelebb levo engem detektalt ellenseges hajo levalogatasa
					SelectShips(15, S.race!=O.Own_Ship:race & (GetRelation(O.Own_Ship:race, S.race)=2 | GetRelation(O.Own_Ship:race, S.race)=3) & GetDetected(S.this, O.Own_Ship:race));		//detektlt ellensges haj van	
					If(NumOf(20), LocalEvent(DevTurnOn, E.dev:=szenzor), If(szenzor, ActivateDevice(szenzor, 0)));
					If(NumOf(15), If(pajzs, ActivateDevice(pajzs, 1)));									
				,
					// TMADS					
					SelectShips(20, S.race!=O.Own_Ship:race & GetRelation(O.Own_Ship:race, S.race)=2 & GetDetected(S.this, O.Own_Ship:race) & GetDetected(O.Own_Ship, S.race) & Range(S.this, O.Own_Ship)<=3);	// minden artillerynel kozelebb levo engem detektalt ellenseges hajo levalogatasa
					SelectShips(15, S.race!=O.Own_Ship:race & (GetRelation(O.Own_Ship:race, S.race)=2 | GetRelation(O.Own_Ship:race, S.race)=3) & GetDetected(S.this, O.Own_Ship:race));		//detektlt ellensges haj van	
					LocalEvent(DevTurnOn, E.dev:=eccm);
					If(NumOf(20), LocalEvent(DevTurnOn, E.dev:=szenzor), If(szenzor, ActivateDevice(szenzor, 0)));
					If(NumOf(15), If(pajzs, ActivateDevice(pajzs, 1)));									
				);
			:end
		END

		#include "Group_X_Rules.inc"

	END	//STATE Defensive

	///////  Stealth  ///////////////////////////////////
	STATE Stealth

		RULE 	event In 	
			:action
				O:tClearForbid(0);
				O:tSetForbid(#FORBID_MOTION_MOTIVATION);				//Osszes sajat mozgas tiltasa
				O:tSetForbid(#FORBID_FIRE);								//Lvldzs tiltsa
				O:tSetForbid(#FORBID_SHIELD);				 				//Pajzs letiltsa
				LocalEvent(SelDev, 0);								
			
				EnableFortPass(O.Own_Ship, 1);							//fortshielden thaladhat
				If(szenzor, ActivateDevice(szenzor, 0));
				If(ecm, ActivateDevice(ecm, 0));
				If(eccm, ActivateDevice(eccm, 0));
				If(pajzs, ActivateDevice(pajzs, 0));
				LocalEvent(DevTurnOn, E.dev:=alca);
				seen:=0;
				SelectDevices(77, O.Own_Ship, S.weapon & !InSet(S.this, 20) & !InSet(S.this, 21) & !InSet(S.this, 22) & !InSet(S.this, 25));				//fegyverek kikapcsolsa
				ExecList(77, ActivateDevice(S.this, 0));
			
				Move_Range:=4;  // Kivanatos tavolsag az elsodleges celpot tamadasahoz
				If(NumOf(74), 
					Move_Type:=0;							
				,
					Move_Type:=1;
				);				
				O:tEngineMode(3);													
				ForceOrient(O.Own_Ship, O.Main_Target, O.Own_Ship:bank);
				
				Follow_Rad:=1000;

				newformation_s:=1;
				information:=2;				
			:end
		END
		
		Tick 5.5

		// Leader //////////////////////////		
		RULE	event Formed
				condition E.formation=O.Sig_Form&O:isGroupLeader
			:action
				TargetWeapon(O.Sig_Laser, O.Main_Target);
				information:=1;
			:end
		END

		RULE 	event Tick
				condition O:isGroupLeader
			:action
				If(newformation_s, 
					SelectShips(1, S.groupLeader=O.Own_Ship);
					If(NumOf(1)<3,
						ChangeState(Canceltask, 0);
					,
						If(!O.Sig_Laser, 
							ChangeState(CancelTask, 0);
						,
							O.Sig_Form := StartFormation(1, O.Own_Ship, O.Sig_Laser_Type);
							TargetWeapon(O.Sig_Laser, O.Main_Target);
							newformation_s:=0;					
						);
					);
				,
					Range_Main_Target:=Range(O.Main_Target, O.Own_Ship); 	//Aktualis tavolsag az elsodleges celponttol
					If(Range_Main_Target=Move_Range|Range_Main_Target=Move_Range-1,					
						// TMADS		
						information:=0;
						O.Own_Ship:tClearMove();
						O:tClearForbid(#FORBID_SHIELD);				 	//Pajzs engedlyezse
						O:tClearForbid(#FORBID_FIRE);					 	//Lvldzs engedlyezse
						O:tSetForbid(#FORBID_FIRE_BOMBER);				//csak bomberkuldes tiltva, minden mas tuzeles engedelyezve				
					, 
						LocalEvent(Approach, 0);
					);
				);
			:end
		END

		// Wingman //////////////////////////
		RULE 	event Tick
				condition !O:isGroupLeader
			:action
				If(!SelectDevices(2, O.Own_Ship, S.working & (InSet(S.this, 70) | S.devType=#supp_secWGen | S.devType=#supp_secWGen2)),
					information:=2;
					ChangeState(CancelTask, 0);
				);
			:end
		END

		RULE 	event Tick
				condition !O:isGroupLeader&information!=2
			:action
				If(!information,					
					// TMADS					
					O:tClearForbid(#FORBID_SHIELD);				 	//Pajzs engedlyezse
					O:tClearForbid(#FORBID_FIRE);					 	//Lvldzs engedlyezse
					O:tSetForbid(#FORBID_FIRE_BOMBER);				//csak bomberkuldes tiltva, minden mas tuzeles engedelyezve				
				);
			:end
		END

		#include "Group_X_Rules.inc"
		
	END	//STATE Stealth

	///////  NoFire  ///////////////////////////////////
	STATE NoFire

		RULE 	event In 	
			:action
				O:tClearForbid(0);
				O:tSetForbid(#FORBID_MOTION_MOTIVATION);		//Osszes sajat mozgas tiltasa
				O:tSetForbid(#FORBID_FIRE_BOMBER);				//csak bomberkuldes tiltva, minden mas tuzeles engedelyezve				
				O:tSetForbid(#FORBID_FIRE_FREE);					//CO tzels tiltsa
				LocalEvent(SelDev, 0);								

				EnableFortPass(O.Own_Ship, 1);					//fortshielden thaladhat
				If(alca, ActivateDevice(alca, 0)); 
				
				Move_Range:=4;  // Kivanatos tavolsag az elsodleges celpot tamadasahoz
				Move_Type:=0;
				Follow_Rad:=500;
				O:tEngineMode(0);
				ForceOrient(O.Own_Ship, O.Main_Target, O.Own_Ship:bank);
				
				newformation_s:=1;
				information:=2;				
			:end
		END
		
		Tick 5.5

		// Leader //////////////////////////		
		RULE	event Formed
				condition E.formation=O.Sig_Form&O:isGroupLeader
			:action
				TargetWeapon(O.Sig_Laser, O.Main_Target);
				information:=1;
			:end
		END

		RULE 	event Tick
				condition O:isGroupLeader
			:action
				If(newformation_s, 
					SelectShips(1, S.groupLeader=O.Own_Ship);
					If(NumOf(1)<3,
						ChangeState(Canceltask, 0);
					,
						If(!O.Sig_Laser, 
							ChangeState(CancelTask, 0);
						,
							O.Sig_Form := StartFormation(1, O.Own_Ship, O.Sig_Laser_Type);
							TargetWeapon(O.Sig_Laser, O.Main_Target);
							newformation_s:=0;					
						);
					);
				,
					Range_Main_Target:=Range(O.Main_Target, O.Own_Ship); 	//Aktualis tavolsag az elsodleges celponttol
					If(Range_Main_Target>Move_Range|Range_Main_Target<Move_Range-1,					
						// MEGKZELTS					
						LocalEvent(Approach, 0);
						SelectDevices(77, O.Own_Ship, S.weapon & !InSet(S.this, 20) & !InSet(S.this, 21) & !InSet(S.this, 22) & !InSet(S.this, 25));				//fegyverek kikapcsolsa
						ExecList(77, ActivateDevice(S.this, 0));
						SelectShips(10, S.race!=O.Own_Ship:race & GetRelation(O.Own_Ship:race, S.race)=2 & GetDetected(S.this, O.Own_Ship:race) & Range(S.this, O.Own_Ship)<=3);	// minden artillerynel kozelebb levo detektalt ellenseges hajo levalogatasa
						LocalEvent(DevTurnOn, E.dev:=szenzor);				
						If(NumOf(10),
							LocalEvent(DevTurnOn, E.dev:=eccm);					
							LocalEvent(DevTurnOn, E.dev:=ecm);											
						,
							If(eccm, ActivateDevice(eccm, 0));
							If(ecm, ActivateDevice(ecm, 0));
						);					
					,
						// TMADS		
						information:=0;
						O.Own_Ship:tClearMove();
						SelectShips(10, S.race!=O.Own_Ship:race & GetRelation(O.Own_Ship:race, S.race)=2 & GetDetected(S.this, O.Own_Ship:race) & Range(S.this, O.Own_Ship)<=3);	// minden artillerynel kozelebb levo detektalt ellenseges hajo levalogatasa
						LocalEvent(DevTurnOn, E.dev:=szenzor);				
						If(NumOf(10),
							LocalEvent(DevTurnOn, E.dev:=eccm);					
							LocalEvent(DevTurnOn, E.dev:=ecm);											
						,
							If(eccm, ActivateDevice(eccm, 0));
							If(ecm, ActivateDevice(ecm, 0));
						);
						O:tEngineMode(0);
					);
				);
			:end
		END

		// Wingman //////////////////////////
		RULE 	event Tick
				condition !O:isGroupLeader
			:action
				If(!SelectDevices(2, O.Own_Ship, S.working & (InSet(S.this, 70) | S.devType=#supp_secWGen | S.devType=#supp_secWGen2)),
					information:=2;
					ChangeState(CancelTask, 0);
				);
			:end
		END

		RULE 	event Tick
				condition !O:isGroupLeader&information!=2
			:action
				If(information,					
					// MEGKZELTS
					SelectDevices(77, O.Own_Ship, S.weapon & !InSet(S.this, 20) & !InSet(S.this, 21) & !InSet(S.this, 22) & !InSet(S.this, 25));				//fegyverek kikapcsolsa
					ExecList(77, ActivateDevice(S.this, 0));
					SelectShips(10, S.race!=O.Own_Ship:race & GetRelation(O.Own_Ship:race, S.race)=2 & GetDetected(S.this, O.Own_Ship:race) & Range(S.this, O.Own_Ship)<=3);	// minden artillerynel kozelebb levo detektalt ellenseges hajo levalogatasa
					LocalEvent(DevTurnOn, E.dev:=szenzor);				
					If(NumOf(10),
						LocalEvent(DevTurnOn, E.dev:=eccm);					
						LocalEvent(DevTurnOn, E.dev:=ecm);											
					,
						If(eccm, ActivateDevice(eccm, 0));
						If(ecm, ActivateDevice(ecm, 0));
					);
				,
					// TMADS					
					SelectShips(10, S.race!=O.Own_Ship:race & GetRelation(O.Own_Ship:race, S.race)=2 & GetDetected(S.this, O.Own_Ship:race) & Range(S.this, O.Own_Ship)<=3);	// minden artillerynel kozelebb levo detektalt ellenseges hajo levalogatasa
					LocalEvent(DevTurnOn, E.dev:=szenzor);				
					If(NumOf(10),
						LocalEvent(DevTurnOn, E.dev:=eccm);					
						LocalEvent(DevTurnOn, E.dev:=ecm);											
					,
						If(eccm, ActivateDevice(eccm, 0));
						If(ecm, ActivateDevice(ecm, 0));
					);
					O:tEngineMode(0);
				);
			:end
		END

		#include "Group_X_Rules.inc"

	END	//STATE NoFire

END	//MACHINE "Command"
	

////////// Global command events ///////////////

RULE	event CommandInit
	:action
		Cmd_Beh:=commandBehaviour;
		Main_Target:=commandTarget;		// az egyseg, amit tamadnia kell
		Own_Ship:=this; 				//Store own ship
		Fire_Mode:=0;
		Form_Mode:=5;

		SelectDevices(1, Own_Ship, InSet(S.this, 33));
		Sig_Laser:=PickFirst(1);		
		If(Sig_Laser, Sig_Laser_Type:=Sig_Laser:devType);
		Sig_Form:=0;

		tClearMove();
		tClearFire();
		tClearTerritory();
		
		ChooseFirst(
			O.Cmd_Beh=1, GetMachine("Command"):ChangeState(Aggressive, 0), 		// aggressziv allapot
			O.Cmd_Beh=2, GetMachine("Command"):ChangeState(Defensive, 0),	 		// defenziv allapot
			O.Cmd_Beh=3, GetMachine("Command"):ChangeState(Stealth, 0),				// menekulo allapot
			O.Cmd_Beh=4, GetMachine("Command"):ChangeState(NoFire, 0)	 			// clirnyos allapot
		);
	:end
END

RULE	event ClearCommand
	:action		
		If(O.Sig_Laser, 
			ActivateDevice(O.Sig_Laser, 0)
		);
		If(O.Sig_Form, 
			Debug(O.Sig_Form);
			EndFormation(O.Sig_Form);
		);
		EventEx(LeaveFormation, 0);				
		tClearMove();
		tClearFire();
		tClearTerritory();
		O:tPlayerControl(1);
	:end
END