Name Player_HoldPosition_Group

CONST
END	//Const

////////// State machine Main ///////////////
MACHINE "Command"

	///////  CancelTask  ////////////////////////////////////
	STATE	CancelTask
	
		RULE 	event In	
			:action
				O:tClearCommand();
			:end
		END
		
	END	//STATE CancelTask

	///////  Aggressive  ///////////////////////////////////
	STATE Aggressive

		RULE 	event In 	
			:action
				O:tClearForbid(0);
				O:tSetForbid(#FORBID_MOTION_MOTIVATION);				//Osszes sajat mozgas tiltasa
				O:tSetForbid(#FORBID_FIRE_BOMBER);						//csak bomberkuldes tiltva, minden mas tuzeles engedelyezve				
				LocalEvent(SelDev, 0);								
				LocalEvent(CollectAbility, 0);
				
				EnableFortPass(O.Own_Ship, 1);							//fortshielden thaladhat
				If(alca, ActivateDevice(alca, 0)); 				
				
				Follow_Rad:=500;
				ForceOrient(O.Own_Ship, O.Own_Ship:groupleader:heading, O.Own_Ship:groupleader:pitch, O.Own_Ship:groupleader:bank);
				
				newformation:=1;
			:end
		END
		
		Tick 5.5

		RULE 	event AIFire
			:action
			:end
		END

		// Leader //////////////////////////		
		RULE 	event Tick
				condition O:isGroupLeader
			:action
				If(newformation, 
					O:tSetFormation(O.Form_Mode, 1);					// a formci vezrhaj clpontjt lvi
					EventEx(ToFormation, E.commander:=O.Own_Ship;E.lead:=O.Own_Ship;E.mrange:=Move_Range);
					information:=1;
					newformation:=0;
				);
				O:tSetTerritory(O.np, 0, 500, 500, 10, 1);

				SelectShips(10, S.race!=O.Own_Ship:race & GetRelation(O.Own_Ship:race, S.race)=2 & GetDetected(S.this, O.Own_Ship:race) & Range(S.this, O.Own_Ship)<=3);	// minden artillerynel kozelebb levo detektalt ellenseges hajo levalogatasa
				LocalEvent(DevTurnOn, E.dev:=szenzor);
				If(NumOf(10), 
					LocalEvent(DevTurnOn, E.dev:=ecm);
					LocalEvent(DevTurnOn, E.dev:=eccm);
				, 
					If(ecm, ActivateDevice(ecm, 0));
					If(eccm, ActivateDevice(eccm, 0));
				);
			:end
		END

		// Wingman //////////////////////////
		RULE 	event Tick
				condition !O:isGroupLeader
			:action
				SelectShips(10, S.race!=O.Own_Ship:race & GetRelation(O.Own_Ship:race, S.race)=2 & GetDetected(S.this, O.Own_Ship:race) & Range(S.this, O.Own_Ship)<=3);	// minden artillerynel kozelebb levo detektalt ellenseges hajo levalogatasa
				LocalEvent(DevTurnOn, E.dev:=szenzor);
				If(NumOf(10), 
					LocalEvent(DevTurnOn, E.dev:=ecm);
					LocalEvent(DevTurnOn, E.dev:=eccm);
				, 
					If(ecm, ActivateDevice(ecm, 0));
					If(eccm, ActivateDevice(eccm, 0));
				);
			:end
		END

		#include "Group_X_Rules.inc"

	END	//STATE Aggressive

	///////  Defensive  ///////////////////////////////////
	STATE Defensive

		RULE 	event In 	
			:action
				O:tClearForbid(0);
				O:tSetForbid(#FORBID_MOTION_MOTIVATION);				//Osszes sajat mozgas tiltasa
				O:tSetForbid(#FORBID_FIRE_BOMBER);						//csak bomberkuldes tiltva, minden mas tuzeles engedelyezve				
				O:tSetForbid(#FORBID_FIRE_NOTSHOTBY);					//csak vdekez tzels
				O:tSetForbid(#FORBID_SHIELD);
				LocalEvent(SelDev, 0);								
				LocalEvent(CollectAbility, 0);
				
				If(eccm, ActivateDevice(eccm, 0));
				If(alca, ActivateDevice(alca, 0)); 
				LocalEvent(DevTurnOn, E.dev:=ecm);
				
				O:tEngineMode(2);

				Follow_Rad:=3000;
				ForceOrient(O.Own_Ship, O.Own_Ship:groupleader:heading, O.Own_Ship:groupleader:pitch, O.Own_Ship:groupleader:bank);
				
				newformation:=1;
			:end
		END
		
		RULE 	event Tick
			:action
				If(O:fort, 
					EnableFortPass(O.Own_Ship, 0);							//fortshielden nem haladhat t
				,
					EnableFortPass(O.Own_Ship, 1);							//fortshielden thaladhat
				);
			:end
		END
		Tick 5.5

		RULE 	event AIFire
			:action
			:end
		END

		// Leader //////////////////////////		
		RULE 	event Tick
				condition O:isGroupLeader
			:action
				If(newformation, 
					O:tSetFormation(O.Form_Mode, 1);					// a formci a vezrhaj clpontjt lvi
					EventEx(ToFormation, E.commander:=O.Own_Ship;E.lead:=O.Own_Ship;E.mrange:=Move_Range);
					information:=1;
					newformation:=0;
				);

				O:tSetTerritory(O.np, 0, 500, 1000, 10, 1);

				SelectShips(20, S.race!=O.Own_Ship:race & GetRelation(O.Own_Ship:race, S.race)=2 & GetDetected(S.this, O.Own_Ship:race) & GetDetected(O.Own_Ship, S.race) & Range(S.this, O.Own_Ship)<=3);	// minden artillerynel kozelebb levo engem detektalt ellenseges hajo levalogatasa
				SelectShips(15, S.race!=O.Own_Ship:race & (GetRelation(O.Own_Ship:race, S.race)=2 | GetRelation(O.Own_Ship:race, S.race)=3) & GetDetected(S.this, O.Own_Ship:race));		//detektlt ellensges haj van	
				If(NumOf(20), LocalEvent(DevTurnOn, E.dev:=szenzor), If(szenzor, ActivateDevice(szenzor, 0)));
				If(NumOf(15), If(pajzs, ActivateDevice(pajzs, 1)));									
			:end
		END

		// Wingman //////////////////////////
		RULE 	event Tick
				condition !O:isGroupLeader
			:action
				SelectShips(20, S.race!=O.Own_Ship:race & GetRelation(O.Own_Ship:race, S.race)=2 & GetDetected(S.this, O.Own_Ship:race) & GetDetected(O.Own_Ship, S.race) & Range(S.this, O.Own_Ship)<=3);	// minden artillerynel kozelebb levo engem detektalt ellenseges hajo levalogatasa
				SelectShips(15, S.race!=O.Own_Ship:race & (GetRelation(O.Own_Ship:race, S.race)=2 | GetRelation(O.Own_Ship:race, S.race)=3) & GetDetected(S.this, O.Own_Ship:race));		//detektlt ellensges haj van	
				If(NumOf(20), LocalEvent(DevTurnOn, E.dev:=szenzor), If(szenzor, ActivateDevice(szenzor, 0)));
				If(NumOf(15), If(pajzs, ActivateDevice(pajzs, 1)));									
			:end
		END

		#include "Group_X_Rules.inc"

	END	//STATE Defensive

	///////  Stealth  ///////////////////////////////////
	STATE Stealth

		RULE 	event In 	
			:action
				O:tClearForbid(0);
				O:tSetForbid(#FORBID_MOTION_MOTIVATION);				//Osszes sajat mozgas tiltasa
				O:tSetForbid(#FORBID_FIRE);								//Lvldzs tiltsa
				O:tSetForbid(#FORBID_SHIELD);				 				//Pajzs letiltsa
				LocalEvent(SelDev, 0);								
				LocalEvent(CollectAbility, 0);
			
				EnableFortPass(O.Own_Ship, 1);							//fortshielden thaladhat
				If(szenzor, ActivateDevice(szenzor, 0));
				If(ecm, ActivateDevice(ecm, 0));
				If(eccm, ActivateDevice(eccm, 0));
				If(pajzs, ActivateDevice(pajzs, 0));
				LocalEvent(DevTurnOn, E.dev:=alca);

				SelectDevices(77, O.Own_Ship, S.weapon & !InSet(S.this, 20) & !InSet(S.this, 21) & !InSet(S.this, 22) & !InSet(S.this, 25));				//fegyverek kikapcsolsa
				ExecList(77, ActivateDevice(S.this, 0));
			
				O:tEngineMode(3);													
				
				Follow_Rad:=1000;
				ForceOrient(O.Own_Ship, O.Own_Ship:groupleader:heading, O.Own_Ship:groupleader:pitch, O.Own_Ship:groupleader:bank);

				newformation:=1;
			:end
		END
		
		Tick 5.5

		RULE 	event AIFire
			:action
			:end
		END

		// Leader //////////////////////////		
		RULE 	event Tick
				condition O:isGroupLeader
			:action
				If(newformation, 
					O:tSetFormation(O.Form_Mode, 1);					// a formci vezrhaj clpontjt lvi
					EventEx(ToFormation, E.commander:=O.Own_Ship;E.lead:=O.Own_Ship;E.mrange:=Move_Range);
					information:=1;
					newformation:=0;
				);

				O:tSetTerritory(O.np, 0, 500, 1000, 10, 1);

				SelectShips(10, S.race!=O.Own_Ship:race & GetRelation(O.Own_Ship:race, S.race)=2 & GetDetected(O.Own_Ship, S.race) & GetDetected(S.this, O.Own_Ship:race) & Range(S.this, O.Own_Ship)<=3);	// minden artillerynel kozelebb levo engem detektalt ellenseges hajo levalogatasa
				If(NumOf(10), 
					O:tClearForbid(#FORBID_ENGINE);				 				//Engine engedlyezse
				, 
					O:tSetForbid(#FORBID_ENGINE);				 				//Engine letiltsa
				);
			:end
		END

		// Wingman //////////////////////////
		RULE 	event Tick
				condition !O:isGroupLeader
			:action
				SelectShips(10, S.race!=O.Own_Ship:race & GetRelation(O.Own_Ship:race, S.race)=2 & GetDetected(O.Own_Ship, S.race) & GetDetected(S.this, O.Own_Ship:race) & Range(S.this, O.Own_Ship)<=3);	// minden artillerynel kozelebb levo engem detektalt ellenseges hajo levalogatasa
				If(NumOf(10), 
					O:tClearForbid(#FORBID_ENGINE);				 				//Engine engedlyezse
				, 
					O:tSetForbid(#FORBID_ENGINE);				 				//Engine letiltsa
				);
			:end
		END

		#include "Group_X_Rules.inc"
		
	END	//STATE Stealth

	///////  NoFire  ///////////////////////////////////
	STATE NoFire

		RULE 	event In 	
			:action
				O:tClearForbid(0);
				O:tSetForbid(#FORBID_MOTION_MOTIVATION);		//Osszes sajat mozgas tiltasa
				O:tSetForbid(#FORBID_FIRE_BOMBER);				//csak bomberkuldes tiltva, minden mas tuzeles engedelyezve				
				O:tSetForbid(#FORBID_FIRE_FREE);					//CO tzels tiltsa
				LocalEvent(SelDev, 0);								
				LocalEvent(CollectAbility, 0);

				EnableFortPass(O.Own_Ship, 1);					//fortshielden thaladhat
				If(alca, ActivateDevice(alca, 0)); 
				SelectDevices(77, O.Own_Ship, S.weapon & !InSet(S.this, 20) & !InSet(S.this, 21) & !InSet(S.this, 22) & !InSet(S.this, 25));				//fegyverek kikapcsolsa
				ExecList(77, ActivateDevice(S.this, 0));
				
				O:tEngineMode(0);
				Follow_Rad:=500;
				ForceOrient(O.Own_Ship, O.Own_Ship:groupleader:heading, O.Own_Ship:groupleader:pitch, O.Own_Ship:groupleader:bank);
				
				newformation:=1;
			:end
		END
		
		Tick 5.5

		RULE 	event AIFire
			:action
			:end
		END

		// Leader //////////////////////////		
		RULE 	event Tick
				condition O:isGroupLeader
			:action
				If(newformation, 
					O:tSetFormation(O.Form_Mode, 1);					// a formci vezrhaj clpontjt lvi
					EventEx(ToFormation, E.commander:=O.Own_Ship;E.lead:=O.Own_Ship;E.mrange:=Move_Range);
					information:=1;
					newformation:=0;
				);

				SelectShips(10, S.race!=O.Own_Ship:race & GetRelation(O.Own_Ship:race, S.race)=2 & GetDetected(S.this, O.Own_Ship:race) & Range(S.this, O.Own_Ship)<=3);	// minden artillerynel kozelebb levo detektalt ellenseges hajo levalogatasa
				LocalEvent(DevTurnOn, E.dev:=szenzor);				
				If(NumOf(10),
					LocalEvent(DevTurnOn, E.dev:=eccm);					
					LocalEvent(DevTurnOn, E.dev:=ecm);											
				,
					If(eccm, ActivateDevice(eccm, 0));
					If(ecm, ActivateDevice(ecm, 0));
				);
			:end
		END

		// Wingman //////////////////////////
		RULE 	event Tick
				condition !O:isGroupLeader
			:action
				SelectShips(10, S.race!=O.Own_Ship:race & GetRelation(O.Own_Ship:race, S.race)=2 & GetDetected(S.this, O.Own_Ship:race) & Range(S.this, O.Own_Ship)<=3);	// minden artillerynel kozelebb levo detektalt ellenseges hajo levalogatasa
				LocalEvent(DevTurnOn, E.dev:=szenzor);				
				If(NumOf(10),
					LocalEvent(DevTurnOn, E.dev:=eccm);					
					LocalEvent(DevTurnOn, E.dev:=ecm);											
				,
					If(eccm, ActivateDevice(eccm, 0));
					If(ecm, ActivateDevice(ecm, 0));
				);
			:end
		END

		#include "Group_X_Rules.inc"

	END	//STATE NoFire

END	//MACHINE "Command"
	

////////// Global command events ///////////////

RULE	event CommandInit
	:action
		Cmd_Beh:=commandBehaviour;
		Main_Target:=commandTarget;		// az egyseg, amit tamadnia kell
		Own_Ship:=this; 				//Store own ship
		Fire_Mode:=0;
		Form_Mode:=3;

		tClearMove();
		tClearFire();
		tClearTerritory();
		
		np:=AddNavigPoint("Center", VAdd(Own_Ship:position, VMul(300, VNorm(Own_Ship:velocity))),0,0, 1,1,1, 10);

		ChooseFirst(
			O.Cmd_Beh=1, GetMachine("Command"):ChangeState(Aggressive, 0), 		// aggressziv allapot
			O.Cmd_Beh=2, GetMachine("Command"):ChangeState(Defensive, 0),	 		// defenziv allapot
			O.Cmd_Beh=3, GetMachine("Command"):ChangeState(Stealth, 0),				// menekulo allapot
			O.Cmd_Beh=4, GetMachine("Command"):ChangeState(NoFire, 0)	 			// clirnyos allapot
		);
	:end
END

RULE	event ClearCommand
	:action
		O:tClearFollow();
		O:tClearFormation();
		tClearMove();
		tClearFire();
		tClearTerritory();
		O:tPlayerControl(1);
	:end
END