Name Player_DrainShield_Group
CONST
END	//Const

////////// State machine Main ///////////////
MACHINE "Command"

	///////  CancelTask  ////////////////////////////////////
	STATE	CancelTask
	
		RULE 	event In	
			:action
				O:tClearCommand();
			:end
		END
		
	END	//STATE CancelTask

	///////  Aggressive  ///////////////////////////////////
	STATE Aggressive

		RULE 	event In 	
			:action
				O:tClearForbid(0);
				O:tSetForbid(#FORBID_MOTION_MOTIVATION);				//Osszes sajat mozgas tiltasa
				O:tSetForbid(#FORBID_FIRE_BOMBER);						//csak bomberkuldes tiltva, minden mas tuzeles engedelyezve				
				LocalEvent(SelDev, 0);								
				
				EnableFortPass(O.Own_Ship, 1);							//fortshielden thaladhat
				If(alca, ActivateDevice(alca, 0)); 				

				Move_Type:=0;				
				Move_Range:=Call(CalcRangeToFiremode, E.ship:=O.Own_Ship; E.mode:=O.Fire_Mode; E.beh:=O.Cmd_Beh; E.trg:=O.Main_Target; E.refvalue:=O.Main_Target:hpmax);  // Kivanatos tavolsag az elsodleges celpot tamadasahoz
				
				Follow_Rad:=500;
				LocalEvent(AIFire, 0);
				
				newformation:=1;
				information:=2;				
			:end
		END
		
		Tick 5.5

		RULE 	event AIFire
			:action
				O:tFireTo(Main_Target, Fire_Mode);
				LocalEvent(CollectAbility, 0);
				LocalEvent(PurposeDisabled, E.Ability:=Ability_Shield);
			:end
		END

		// Leader //////////////////////////		
		RULE 	event Tick
				condition O:isGroupLeader
			:action
				If(information!=2, LocalEvent(Approach, 0));
				Range_Main_Target:=Range(O.Main_Target, O.Own_Ship); 	//Aktualis tavolsag az elsodleges celponttol
				If(Range_Main_Target!=Move_Range,					
					// MEGKZELTS					
					If(newformation, 
						O:tSetFormation(O.Form_Mode, 1);					// a formci vezrhaj clpontjt lvi
						EventEx(ToFormation, E.commander:=O.Own_Ship;E.lead:=O.Own_Ship;E.mrange:=Move_Range);
						information:=1;
						newformation:=0;
					);
					O:tEngineMode(1);
					SelectShips(10, S.race!=O.Own_Ship:race & GetRelation(O.Own_Ship:race, S.race)=2 & GetDetected(S.this, O.Own_Ship:race) & Range(S.this, O.Own_Ship)<=3);	// minden artillerynel kozelebb levo detektalt ellenseges hajo levalogatasa
					LocalEvent(DevTurnOn, E.dev:=szenzor);
					If(NumOf(10), 
						LocalEvent(DevTurnOn, E.dev:=eccm);
						LocalEvent(DevTurnOn, E.dev:=ecm);
					, 
						If(eccm, ActivateDevice(eccm, 0));
						If(ecm, ActivateDevice(ecm, 0));
					);
				,
					// TMADS		
					If(information,, 
						EventEx(BreakFormation, E.commander:=O:groupLeader;E.mrange:=Move_Range);
						O:tClearFormation();
						newformation:=1;
					);
					information:=0;
					O:tEngineMode(0);
					SelectShips(10, S.race!=O.Own_Ship:race & GetRelation(O.Own_Ship:race, S.race)=2 & GetDetected(S.this, O.Own_Ship:race) & Range(S.this, O.Own_Ship)<=3);	// minden artillerynel kozelebb levo detektalt ellenseges hajo levalogatasa
					If(NumOf(10), 
						LocalEvent(DevTurnOn, E.dev:=eccm);
						LocalEvent(DevTurnOn, E.dev:=ecm);
					, 
						If(eccm, ActivateDevice(eccm, 0));
						If(ecm, ActivateDevice(ecm, 0));
					);
					LocalEvent(DevTurnOn, E.dev:=szenzor);
				);
			:end
		END

		// Wingman //////////////////////////
		RULE 	event Tick
				condition !O:isGroupLeader&information!=2
			:action
				If(information,					
					// MEGKZELTS
					O:tEngineMode(1);
					SelectShips(10, S.race!=O.Own_Ship:race & GetRelation(O.Own_Ship:race, S.race)=2 & GetDetected(S.this, O.Own_Ship:race) & Range(S.this, O.Own_Ship)<=3);	// minden artillerynel kozelebb levo detektalt ellenseges hajo levalogatasa
					LocalEvent(DevTurnOn, E.dev:=szenzor);
					If(NumOf(10), 
						LocalEvent(DevTurnOn, E.dev:=eccm);
						LocalEvent(DevTurnOn, E.dev:=ecm);
					, 
						If(eccm, ActivateDevice(eccm, 0));
						If(ecm, ActivateDevice(ecm, 0));
					);
				,
					// TMADS					
					LocalEvent(Approach, 0);
					O:tEngineMode(0);
					SelectShips(10, S.race!=O.Own_Ship:race & GetRelation(O.Own_Ship:race, S.race)=2 & GetDetected(S.this, O.Own_Ship:race) & Range(S.this, O.Own_Ship)<=3);	// minden artillerynel kozelebb levo detektalt ellenseges hajo levalogatasa
					If(NumOf(10), 
						LocalEvent(DevTurnOn, E.dev:=eccm);
						LocalEvent(DevTurnOn, E.dev:=ecm);
					, 
						If(eccm, ActivateDevice(eccm, 0));
						If(ecm, ActivateDevice(ecm, 0));
					);
					LocalEvent(DevTurnOn, E.dev:=szenzor);
				);
			:end
		END

		#include "Group_X_Rules.inc"

	END	//STATE Aggressive

	///////  Defensive  ///////////////////////////////////
	STATE Defensive

		RULE 	event In 	
			:action
				O:tClearForbid(0);
				O:tSetForbid(#FORBID_MOTION_MOTIVATION);				//Osszes sajat mozgas tiltasa
				O:tSetForbid(#FORBID_FIRE_BOMBER);						//csak bomberkuldes tiltva, minden mas tuzeles engedelyezve				
				O:tSetForbid(#FORBID_FIRE_NOTSHOTBY);					//csak vdekez tzels
				O:tSetForbid(#FORBID_SHIELD);
				LocalEvent(SelDev, 0);								

				If(eccm, ActivateDevice(eccm, 0));
				If(alca, ActivateDevice(alca, 0)); 
				LocalEvent(DevTurnOn, E.dev:=ecm);
				
				Move_Range:=Call(CalcRangeToFiremode, E.ship:=O.Own_Ship; E.mode:=O.Fire_Mode; E.beh:=O.Cmd_Beh; E.trg:=O.Main_Target; E.refvalue:=O.Main_Target:hpmax);  // Kivanatos tavolsag az elsodleges celpot tamadasahoz
				Move_Type:=0;
				O:tEngineMode(2);

				Follow_Rad:=3000;
				LocalEvent(AIFire, 0);
				
		Debug(O.Own_Ship);
		Debug(information);
		Debug("--------In---------");
				newformation:=1;
				information:=2;				
			:end
		END
		
		RULE 	event Tick
			:action
				If(O:fort, 
					EnableFortPass(O.Own_Ship, 0);							//fortshielden nem haladhat t
				,
					EnableFortPass(O.Own_Ship, 1);							//fortshielden thaladhat
				);
			:end
		END
		Tick 5.5

		RULE 	event AIFire
			:action
				O:tFireTo(Main_Target, Fire_Mode);
				LocalEvent(CollectAbility, 0);
				LocalEvent(PurposeDisabled, E.Ability:=Ability_Shield);
			:end
		END

		// Leader //////////////////////////		
		RULE 	event Tick
				condition O:isGroupLeader
			:action
				If(information!=2, LocalEvent(Approach, 0));
				Range_Main_Target:=Range(O.Main_Target, O.Own_Ship); 	//Aktualis tavolsag az elsodleges celponttol
				If(Range_Main_Target!=Move_Range,					
					// MEGKZELTS					
					If(newformation, 
						O:tSetFormation(O.Form_Mode, 2);					// a formci a vezrhajra tzelt lvi
						EventEx(ToFormation, E.commander:=O.Own_Ship;E.lead:=O.Own_Ship;E.mrange:=Move_Range);
						information:=1;
						newformation:=0;
					);
					SelectShips(20, S.race!=O.Own_Ship:race & GetRelation(O.Own_Ship:race, S.race)=2 & GetDetected(S.this, O.Own_Ship:race) & GetDetected(O.Own_Ship, S.race) & Range(S.this, O.Own_Ship)<=3);	// minden artillerynel kozelebb levo engem detektalt ellenseges hajo levalogatasa
					SelectShips(15, S.race!=O.Own_Ship:race & (GetRelation(O.Own_Ship:race, S.race)=2 | GetRelation(O.Own_Ship:race, S.race)=3) & GetDetected(S.this, O.Own_Ship:race));		//detektlt ellensges haj van	
					If(NumOf(20), LocalEvent(DevTurnOn, E.dev:=szenzor), If(szenzor, ActivateDevice(szenzor, 0)));
					If(NumOf(15), If(pajzs, ActivateDevice(pajzs, 1)));									
				,
					// TMADS		
					If(information,, 
						EventEx(BreakFormation, E.commander:=O:groupLeader;E.mrange:=Move_Range);
						O:tClearFormation();
						newformation:=1;						
					);
					information:=0;
					SelectShips(20, S.race!=O.Own_Ship:race & GetRelation(O.Own_Ship:race, S.race)=2 & GetDetected(S.this, O.Own_Ship:race) & GetDetected(O.Own_Ship, S.race) & Range(S.this, O.Own_Ship)<=3);	// minden artillerynel kozelebb levo engem detektalt ellenseges hajo levalogatasa
					SelectShips(15, S.race!=O.Own_Ship:race & (GetRelation(O.Own_Ship:race, S.race)=2 | GetRelation(O.Own_Ship:race, S.race)=3) & GetDetected(S.this, O.Own_Ship:race));		//detektlt ellensges haj van	
					LocalEvent(DevTurnOn, E.dev:=eccm);
					If(NumOf(20), LocalEvent(DevTurnOn, E.dev:=szenzor), If(szenzor, ActivateDevice(szenzor, 0)));
					If(NumOf(15), If(pajzs, ActivateDevice(pajzs, 1)));									
				);
			:end
		END

		// Wingman //////////////////////////
		RULE 	event Tick
				condition !O:isGroupLeader&information!=2
			:action
				If(information,					
					// MEGKZELTS
					SelectShips(20, S.race!=O.Own_Ship:race & GetRelation(O.Own_Ship:race, S.race)=2 & GetDetected(S.this, O.Own_Ship:race) & GetDetected(O.Own_Ship, S.race) & Range(S.this, O.Own_Ship)<=3);	// minden artillerynel kozelebb levo engem detektalt ellenseges hajo levalogatasa
					SelectShips(15, S.race!=O.Own_Ship:race & (GetRelation(O.Own_Ship:race, S.race)=2 | GetRelation(O.Own_Ship:race, S.race)=3) & GetDetected(S.this, O.Own_Ship:race));		//detektlt ellensges haj van	
					If(NumOf(20), LocalEvent(DevTurnOn, E.dev:=szenzor), If(szenzor, ActivateDevice(szenzor, 0)));
					If(NumOf(15), If(pajzs, ActivateDevice(pajzs, 1)));									
				,
					// TMADS				
					LocalEvent(Approach, 0);
					SelectShips(20, S.race!=O.Own_Ship:race & GetRelation(O.Own_Ship:race, S.race)=2 & GetDetected(S.this, O.Own_Ship:race) & GetDetected(O.Own_Ship, S.race) & Range(S.this, O.Own_Ship)<=3);	// minden artillerynel kozelebb levo engem detektalt ellenseges hajo levalogatasa
					SelectShips(15, S.race!=O.Own_Ship:race & (GetRelation(O.Own_Ship:race, S.race)=2 | GetRelation(O.Own_Ship:race, S.race)=3) & GetDetected(S.this, O.Own_Ship:race));		//detektlt ellensges haj van	
					LocalEvent(DevTurnOn, E.dev:=eccm);
					If(NumOf(20), LocalEvent(DevTurnOn, E.dev:=szenzor), If(szenzor, ActivateDevice(szenzor, 0)));
					If(NumOf(15), If(pajzs, ActivateDevice(pajzs, 1)));									
				);
			:end
		END

		#include "Group_X_Rules.inc"

	END	//STATE Defensive

	///////  Stealth  ///////////////////////////////////
	STATE Stealth

		RULE 	event In 	
			:action
				O:tClearForbid(0);
				O:tSetForbid(#FORBID_MOTION_MOTIVATION);				//Osszes sajat mozgas tiltasa
				O:tSetForbid(#FORBID_FIRE);								//Lvldzs tiltsa
				O:tSetForbid(#FORBID_SHIELD);				 				//Pajzs letiltsa
				LocalEvent(SelDev, 0);								
			
				EnableFortPass(O.Own_Ship, 1);							//fortshielden thaladhat
				If(szenzor, ActivateDevice(szenzor, 0));
				If(ecm, ActivateDevice(ecm, 0));
				If(eccm, ActivateDevice(eccm, 0));
				If(pajzs, ActivateDevice(pajzs, 0));
				LocalEvent(DevTurnOn, E.dev:=alca);
				seen:=0;
				SelectDevices(77, O.Own_Ship, S.weapon & !InSet(S.this, 20) & !InSet(S.this, 21) & !InSet(S.this, 22) & !InSet(S.this, 25));				//fegyverek kikapcsolsa
				ExecList(77, ActivateDevice(S.this, 0));
			
				Move_Range:=Call(CalcRangeToFiremode, E.ship:=O.Own_Ship; E.mode:=O.Fire_Mode; E.beh:=O.Cmd_Beh; E.trg:=O.Main_Target; E.refvalue:=O.Main_Target:hpmax);  // Kivanatos tavolsag az elsodleges celpot tamadasahoz
				If(NumOf(74), 
					Move_Type:=0;							
				,
					Move_Type:=1;
				);				
				O:tEngineMode(3);													
				
				Follow_Rad:=1000;

				newformation:=1;
				information:=2;				
			:end
		END
		
		Tick 5.5

		RULE 	event AIFire
			:action
				O:tFireTo(Main_Target, Fire_Mode);
				LocalEvent(CollectAbility, 0);
				LocalEvent(PurposeDisabled, E.Ability:=Ability_Shield);
			:end
		END

		// Leader //////////////////////////		
		RULE 	event Tick
				condition O:isGroupLeader
			:action
				If(information!=2, LocalEvent(Approach, 0));
				Range_Main_Target:=Range(O.Main_Target, O.Own_Ship); 	//Aktualis tavolsag az elsodleges celponttol
				If(Range_Main_Target!=Move_Range,					
					// MEGKZELTS					
					If(newformation, 
						O:tSetFormation(O.Form_Mode, 0);					// a formci vezrhaj clpontjt lvi
						EventEx(ToFormation, E.commander:=O.Own_Ship;E.lead:=O.Own_Ship;E.mrange:=Move_Range);
						information:=1;
						newformation:=0;
					);
				,
					// TMADS		
					If(information,, 
						EventEx(BreakFormation, E.commander:=O:groupLeader;E.mrange:=Move_Range);
						O:tClearFormation();
						newformation:=1;
					);
					information:=0;
					O:tClearForbid(#FORBID_SHIELD);				 	//Pajzs engedlyezse
					O:tClearForbid(#FORBID_FIRE);					 	//Lvldzs engedlyezse
					O:tSetForbid(#FORBID_FIRE_BOMBER);				//csak bomberkuldes tiltva, minden mas tuzeles engedelyezve				
					LocalEvent(AIFire, 0);
				);
			:end
		END

		// Wingman //////////////////////////
		RULE 	event Tick
				condition !O:isGroupLeader&information!=2
			:action
				If(!information,					
					// TMADS					
					LocalEvent(Approach, 0);
					O:tClearForbid(#FORBID_SHIELD);				 	//Pajzs engedlyezse
					O:tClearForbid(#FORBID_FIRE);					 	//Lvldzs engedlyezse
					O:tSetForbid(#FORBID_FIRE_BOMBER);				//csak bomberkuldes tiltva, minden mas tuzeles engedelyezve				
					LocalEvent(AIFire, 0);
				);
			:end
		END

		#include "Group_X_Rules.inc"

	END	//STATE Stealth

	///////  NoFire  ///////////////////////////////////
	STATE NoFire

		RULE 	event In 	
			:action
				O:tClearForbid(0);
				O:tSetForbid(#FORBID_MOTION_MOTIVATION);		//Osszes sajat mozgas tiltasa
				O:tSetForbid(#FORBID_FIRE_BOMBER);				//csak bomberkuldes tiltva, minden mas tuzeles engedelyezve				
				O:tSetForbid(#FORBID_FIRE_FREE);					//CO tzels tiltsa
				LocalEvent(SelDev, 0);								

				EnableFortPass(O.Own_Ship, 1);					//fortshielden thaladhat
				If(alca, ActivateDevice(alca, 0)); 
				
				Move_Range:=Call(CalcRangeToFiremode, E.ship:=O.Own_Ship; E.mode:=O.Fire_Mode; E.beh:=O.Cmd_Beh; E.trg:=O.Main_Target; E.refvalue:=O.Main_Target:hpmax);  // Kivanatos tavolsag az elsodleges celpot tamadasahoz
				Move_Type:=0;
				Follow_Rad:=500;
				LocalEvent(AIFire, 0);
				
				newformation:=1;
				information:=2;				
			:end
		END
		
		Tick 5.5

		RULE 	event AIFire
			:action
				O:tFireTo(Main_Target, Fire_Mode);
				LocalEvent(CollectAbility, 0);
				LocalEvent(PurposeDisabled, E.Ability:=Ability_Shield);
			:end
		END

		// Leader //////////////////////////		
		RULE 	event Tick
				condition O:isGroupLeader
			:action
				If(information!=2, LocalEvent(Approach, 0));
				Range_Main_Target:=Range(O.Main_Target, O.Own_Ship); 	//Aktualis tavolsag az elsodleges celponttol
				If(Range_Main_Target!=Move_Range,					
					// MEGKZELTS					
					If(newformation, 
						O:tSetFormation(O.Form_Mode, 1);					// a formci vezrhaj clpontjt lvi
						EventEx(ToFormation, E.commander:=O.Own_Ship;E.lead:=O.Own_Ship;E.mrange:=Move_Range);
						information:=1;
						newformation:=0;
					);
					SelectDevices(77, O.Own_Ship, S.weapon & !InSet(S.this, 20) & !InSet(S.this, 21) & !InSet(S.this, 22) & !InSet(S.this, 25));				//fegyverek kikapcsolsa
					ExecList(77, ActivateDevice(S.this, 0));
					O:tEngineMode(1);
					SelectShips(10, S.race!=O.Own_Ship:race & GetRelation(O.Own_Ship:race, S.race)=2 & GetDetected(S.this, O.Own_Ship:race) & Range(S.this, O.Own_Ship)<=3);	// minden artillerynel kozelebb levo detektalt ellenseges hajo levalogatasa
					LocalEvent(DevTurnOn, E.dev:=szenzor);				
					If(NumOf(10),
						LocalEvent(DevTurnOn, E.dev:=eccm);					
						LocalEvent(DevTurnOn, E.dev:=ecm);											
					,
						If(eccm, ActivateDevice(eccm, 0));
						If(ecm, ActivateDevice(ecm, 0));
					);
				,
					// TMADS		
					If(information,, 
						EventEx(BreakFormation, E.commander:=O:groupLeader;E.mrange:=Move_Range);
						O:tClearFormation();
						newformation:=1;
					);
					information:=0;
					SelectShips(10, S.race!=O.Own_Ship:race & GetRelation(O.Own_Ship:race, S.race)=2 & GetDetected(S.this, O.Own_Ship:race) & Range(S.this, O.Own_Ship)<=3);	// minden artillerynel kozelebb levo detektalt ellenseges hajo levalogatasa
					LocalEvent(DevTurnOn, E.dev:=szenzor);				
					If(NumOf(10),
						LocalEvent(DevTurnOn, E.dev:=eccm);					
						LocalEvent(DevTurnOn, E.dev:=ecm);											
					,
						If(eccm, ActivateDevice(eccm, 0));
						If(ecm, ActivateDevice(ecm, 0));
					);
					O:tEngineMode(0);
				);
			:end
		END

		// Wingman //////////////////////////
		RULE 	event Tick
				condition !O:isGroupLeader&information!=2
			:action
				If(information,					
					// MEGKZELTS
					SelectDevices(77, O.Own_Ship, S.weapon & !InSet(S.this, 20) & !InSet(S.this, 21) & !InSet(S.this, 22) & !InSet(S.this, 25));				//fegyverek kikapcsolsa
					ExecList(77, ActivateDevice(S.this, 0));
					O:tEngineMode(1);
					SelectShips(10, S.race!=O.Own_Ship:race & GetRelation(O.Own_Ship:race, S.race)=2 & GetDetected(S.this, O.Own_Ship:race) & Range(S.this, O.Own_Ship)<=3);	// minden artillerynel kozelebb levo detektalt ellenseges hajo levalogatasa
					LocalEvent(DevTurnOn, E.dev:=szenzor);				
					If(NumOf(10),
						LocalEvent(DevTurnOn, E.dev:=eccm);					
						LocalEvent(DevTurnOn, E.dev:=ecm);											
					,
						If(eccm, ActivateDevice(eccm, 0));
						If(ecm, ActivateDevice(ecm, 0));
					);
				,
					// TMADS					
					LocalEvent(Approach, 0);
					SelectShips(10, S.race!=O.Own_Ship:race & GetRelation(O.Own_Ship:race, S.race)=2 & GetDetected(S.this, O.Own_Ship:race) & Range(S.this, O.Own_Ship)<=3);	// minden artillerynel kozelebb levo detektalt ellenseges hajo levalogatasa
					LocalEvent(DevTurnOn, E.dev:=szenzor);				
					If(NumOf(10),
						LocalEvent(DevTurnOn, E.dev:=eccm);					
						LocalEvent(DevTurnOn, E.dev:=ecm);											
					,
						If(eccm, ActivateDevice(eccm, 0));
						If(ecm, ActivateDevice(ecm, 0));
					);
					O:tEngineMode(0);
				);
			:end
		END

		#include "Group_X_Rules.inc"

	END	//STATE NoFire

END	//MACHINE "Command"
	

////////// Global command events ///////////////

RULE	event CommandInit
	:action
		Cmd_Beh:=commandBehaviour;
		Main_Target:=commandTarget;		// az egyseg, amit tamadnia kell
		Own_Ship:=this; 				//Store own ship
		Fire_Mode:=1;
		Form_Mode:=3;

		tClearMove();
		tClearFire();
		tClearTerritory();
		
		If(Main_Target:race>=0,
			SetRelation(race, Main_Target:race, 2);
		);

		ChooseFirst(
			O.Cmd_Beh=1, GetMachine("Command"):ChangeState(Aggressive, 0), 		// aggressziv allapot
			O.Cmd_Beh=2, GetMachine("Command"):ChangeState(Defensive, 0),	 		// defenziv allapot
			O.Cmd_Beh=3, GetMachine("Command"):ChangeState(Stealth, 0),				// menekulo allapot
			O.Cmd_Beh=4, GetMachine("Command"):ChangeState(NoFire, 0)	 			// clirnyos allapot
		);
	:end
END

RULE	event ClearCommand
	:action
		O:tClearFollow();
		O:tClearFormation();
		tClearMove();
		tClearFire();
		tClearTerritory();
		O:tPlayerControl(1);
	:end
END