RULE	event CollectAbility
	:action
		SelectDevices(31, O.Own_Ship, S.weapon & S.working & S.shieldValue=1 & S.count!=0);		// minden a hajon levo mukodo pajzsrombolo fegyver (purpose alapjan)
		SelectDevices(32, O.Own_Ship, S.weapon & S.working & S.hullValue=1 & S.count!=0);			// minden a hajon levo mukodo hullrombolo fegyver (purpose alapjan)
		SelectDevices(33, O.Own_Ship, S.weapon & S.working & S.deviceValue=1 & S.count!=0);		// minden a hajon levo mukodo berendezesrombolo fegyver (purpose alapjan)
		SelectDevices(34, O.Own_Ship, S.weapon & S.working & InSet(S.this, 2) & InSet(S.this, 5) & S.count!=0); 	//Raketak levalogatasa
		SelectDevices(35, O.Own_Ship, S.weapon & S.working & InSet(S.this, 3) & InSet(S.this, 5) & S.count!=0); 	//E-bombk levalogatasa
		If(NumOf(31)>0, Ability_Shield:=1, Ability_Shield:=0);
		If(NumOf(32)>0, Ability_Hull:=2, Ability_Hull:=0);
		If(NumOf(33)>0, Ability_Device:=3, Ability_Device:=0);
		If(NumOf(34)>0, Ability_Missile:=4, Ability_Missile:=0);
		If(NumOf(35)>0, Ability_EBomb:=5, Ability_EBomb:=0);
	:end
END

RULE	event PurposeDisabled	//fegyverzet uzemkeptelen
		condition E.Ability=0
	:action
		O:tSetWarning(#Warn_TaskFailed);		//Warning: Main weapons are offline, We are unable to complete task.
		ChangeState(CancelTask, 0);
	:end
END	//PurposeDisabled

RULE	event CO_DeviceDisabled
		condition E.ship=O.this&E.device:weapon
	:action
		LocalEvent(CollectAbility, 0);
		ChooseFirst(
			O.Fire_Mode=0, 0, 																							// Nem is tzelnk
			O.Fire_Mode=1, LocalEvent(PurposeDisabled, E.Ability:=Ability_Shield),						// Pajzsrombols
			O.Fire_Mode=2, LocalEvent(PurposeDisabled, E.Ability:=Ability_Hull), 						// Hullrombols
			O.Fire_Mode=3, LocalEvent(PurposeDisabled, E.Ability:=Ability_Device), 						// Devicerombols
			O.Fire_Mode=4, LocalEvent(PurposeDisabled, E.Ability:=Ability_Missile+Ability_EBomb)	// Missile
		);
	:end
END

RULE	event Deleted	//Celpont hajo megsemmisult
		condition E.ship=O.Main_Target&O.Fire_Mode!=2&O.Fire_Mode!=4
	:action
		If(E.class!=0, O:tSetWarning(#Warn_TaskFailed));		//Report: Target ship is destroyed. Task canceled.
		ChangeState(CancelTask, 0);
	:end
END	//Deleted

RULE	event Collapsed	//Celpont hajo megvltozott
		condition E.ship=O.Main_Target
	:action
		O:tSetWarning(#Warn_TaskFailed);		//Report: Target ship is destroyed. Task canceled.
		ChangeState(CancelTask, 0);
	:end
END	//Collapsed

RULE	event Splitted		//Celpont hajo megvltozott
		condition E.ship=O.Main_Target
	:action
		O:tSetWarning(#Warn_TaskFailed);		//Report: Target ship is destroyed. Task canceled.
		ChangeState(CancelTask, 0);
	:end
END	//Splitted

RULE	event RunAway	//Celpont hajo elszguld
		condition E.ship=O.Main_Target
	:action
		O:tSetWarning(#Warn_TaskFailed);		//Report: Target ship is run away. Task canceled.
		ChangeState(CancelTask, 0);
	:end
END	//RunAway

RULE	event JumpedOut	//Celpont hajo elugrik
		condition E.ship=O.Main_Target
	:action
		O:tSetWarning(#Warn_TaskFailed);		//Report: Target ship is jumped out. Task canceled.
		ChangeState(CancelTask, 0);
	:end
END	//JumpedOut

RULE	event TurnOff	//Command kls lekapcsolsa
		condition E.shp=O.Own_Ship
	:action
		ChooseFirst(
			E.msg=0, 
				O:tSetWarning(#Warn_TaskFailed);
				ChangeState(CancelTask, 0);,
			E.msg=1, 
				O:tSetWarning(#Warn_TaskCompleted);
				ChangeState(CancelTask, 0);,
			E.msg=2, 
				ChangeState(CancelTask, 0);,
			1, 
				ChangeState(CancelTask, 0);
		);
	:end
END	//TurnOff

RULE	event UnDetected		//clpont haj eltnt
		condition E.ship=O.Main_Target&E.race=race
	:action
		O:tSetWarning(#Warn_TaskFailed);		//Warning: enemy undetected!			
		Prev_Target:=O.Main_Target;
		O.Main_Target:=E.navpoint;
	:end
END	//Main UnDetected

RULE	event Detected		//clpont haj feltnt
		condition E.race=race&E.navpoint=O.Main_Target
	:action
		O.Main_Target:=E.ship;
		Prev_Target:=0;
	:end
END	//Main Detected		
