Name AI_Close

CONST
END	//Const

////////// State machine Main ///////////////
MACHINE "Command"

	///////  CancelTask  ////////////////////////////////////
	STATE	CancelTask
	
		RULE 	event In	
			:action
				O:tClearCommand();
			:end
		END
		
	END	//STATE CancelTask
			
	///////  Approach  ////////////////////////////////////	
	STATE	Approach
	
		RULE 	event In 	
			:action		
				ChooseFirst(
					O.Cmd_Beh=1, GetMachine("Behaviour"):ChangeState(Aggressive, 0), 		// aggressziv allapot
					O.Cmd_Beh=2, GetMachine("Behaviour"):ChangeState(Defensive, 0), 		// defenziv allapot
					O.Cmd_Beh=3, GetMachine("Behaviour"):ChangeState(Cautious, 0),			// menekulo allapot
					O.Cmd_Beh=4, GetMachine("Behaviour"):ChangeState(NoFire, 0)	 			// clirnyos allapot
				);
			:end
		END
		
		////////// State machine Behaviour ///////////////
		MACHINE "Behaviour"
		
			///////  Aggressive  ///////////////////////////////////
			STATE Aggressive
			
				RULE 	event In 	
					:action
						O:tClearForbid(0);
						O:tSetForbid(#FORBID_MOTION_MOTIVATION);		//Osszes sajat mozgas tiltasa
						O:tSetForbid(#FORBID_FIRE_BOMBER);				//csak bomberkuldes tiltva, minden mas tuzeles engedelyezve				

						LocalEvent(CollectDevices, 0);

						O:tMoveTo(O.Main_Target, 2, 0);		//Move to optimal Range
					:end
				END

				RULE 	event Tick
					:action
						SelectShips(10, S.race!=O.Own_Ship:race & GetRelation(O.Own_Ship:race, S.race)=2 & GetDetected(S.this, O.Own_Ship:race) & Range(S.this, O.Own_Ship)<=3);	// minden artillerynel kozelebb levo detektalt ellenseges hajo levalogatasa
						ExecList(70, ActivateDevice(S.this, 1));
						If(NumOf(10)!=0, ExecList(71, ActivateDevice(S.this, 1)), ExecList(71, ActivateDevice(S.this, 0)));
						If(NumOf(10)!=0, ExecList(72, ActivateDevice(S.this, 1)), ExecList(72, ActivateDevice(S.this, 0)));					
						
						If(Range(O.Main_Target, O.Own_Ship)=2,	O:tEngineMode(0),	O:tEngineMode(1));
					:end
				END
				Tick 5.5
				
				#include "AIBehaviour_Rules.inc"

			END	//STATE Aggressive
			
			///////  Defensive  ///////////////////////////////////
			STATE Defensive

				RULE 	event In 	
					:action
						O:tClearForbid(0);
						O:tSetForbid(#FORBID_MOTION_MOTIVATION);		//Osszes sajat mozgas tiltasa
						O:tSetForbid(#FORBID_FIRE_BOMBER);				//csak bomberkuldes tiltva, minden mas tuzeles engedelyezve				
						O:tSetForbid(#FORBID_FIRE_NOTSHOTBY);						//csak vdekez tzels

						LocalEvent(CollectDevices, 0);

						O:tMoveTo(O.Main_Target, 2, 0);		//Move to optimal Range
						
						O:tEngineMode(0);
					:end
				END

				RULE 	event Tick
					:action
						SelectShips(10, S.race!=O.Own_Ship:race & GetRelation(O.Own_Ship:race, S.race)=2 & GetDetected(S.this, O.Own_Ship:race) & Range(S.this, O.Own_Ship)<=3);	// minden artillerynel kozelebb levo detektalt ellenseges hajo levalogatasa
						SelectShips(20, S.race!=O.Own_Ship:race & GetRelation(O.Own_Ship:race, S.race)=2 & GetDetected(O.Own_Ship, S.race) & Range(S.this, O.Own_Ship)<=3);	// minden artillerynel kozelebb levo engem detektalt ellenseges hajo levalogatasa
						If(NumOf(20)!=0, ExecList(70, ActivateDevice(S.this, 1)), ExecList(70, ActivateDevice(S.this, 0)));
						If(NumOf(10)!=0, ExecList(71, ActivateDevice(S.this, 1)), ExecList(71, ActivateDevice(S.this, 0)));
						ExecList(72, ActivateDevice(S.this, 0));
					:end
				END
				Tick 5.5

				#include "AIBehaviour_Rules.inc"

			END	//STATE Defensive
			
			///////  Cautious  ///////////////////////////////////
			STATE Cautious

				RULE 	event In 	
					:action
						O:tClearForbid(0);
						O:tSetForbid(#FORBID_MOTION_MOTIVATION);		//Osszes sajat mozgas tiltasa
						O:tSetForbid(#FORBID_FIRE_BOMBER);				//csak bomberkuldes tiltva, minden mas tuzeles engedelyezve				
						O:tClearForbid(#FORBID_MOTION_MOTIVATION_AWAY);			//Osszes sajat mozgas tiltasa, kivve Away
						O:tSetForbid(#FORBID_FIRE_NOTSHOTBY);					 	//csak vdekez tzels
						
						LocalEvent(CollectDevices, 0);

						O:tMoveTo(O.Main_Target, 2, 0);		//Move to optimal Range
					:end
				END

				RULE 	event Tick
					:action		
						Range_Main_Target:=Range(O.Main_Target, O.Own_Ship); 	//Aktualis tavolsag az elsodleges celponttol
						If(Range_Main_Target=2,	O:tEngineMode(2),	O:tEngineMode(0));

						SelectShips(10, S.race!=O.Own_Ship:race & GetRelation(O.Own_Ship:race, S.race)=2 & GetDetected(S.this, O.Own_Ship:race) & Range(S.this, O.Own_Ship)<=3);	// minden artillerynel kozelebb levo detektalt ellenseges hajo levalogatasa
						SelectShips(20, S.race!=O.Own_Ship:race & GetRelation(O.Own_Ship:race, S.race)=2 & GetDetected(O.Own_Ship, S.race) & Range(S.this, O.Own_Ship)<=3);	// minden artillerynel kozelebb levo engem detektalt ellenseges hajo levalogatasa
						If(NumOf(20)!=0, ExecList(70, ActivateDevice(S.this, 1)), ExecList(70, ActivateDevice(S.this, 0)));
						If(NumOf(10)!=0, ExecList(71, ActivateDevice(S.this, 1)), ExecList(71, ActivateDevice(S.this, 0)));
						If(NumOf(10)!=0, ExecList(72, ActivateDevice(S.this, 1)), ExecList(72, ActivateDevice(S.this, 0)));
					:end
				END
				Tick 5.5

				#include "AIBehaviour_Rules.inc"

			END	//STATE Cautious
			
			///////  NoFire  ///////////////////////////////////
			STATE NoFire

				RULE 	event In 	
					:action
						O:tClearForbid(0);
						O:tSetForbid(#FORBID_MOTION_MOTIVATION);		//Osszes sajat mozgas tiltasa
						O:tSetForbid(#FORBID_FIRE_BOMBER);				//csak bomberkuldes tiltva, minden mas tuzeles engedelyezve				
						O:tSetForbid(#FORBID_FIRE_FREE);								//CO tzels tiltsa

						LocalEvent(CollectDevices, 0);

						O:tMoveTo(O.Main_Target, 2, 0);		//Move to optimal Range
					:end
				END

				RULE	event Tick
					:action
						SelectShips(10, S.race!=O.Own_Ship:race & GetRelation(O.Own_Ship:race, S.race)=2 & GetDetected(S.this, O.Own_Ship:race) & Range(S.this, O.Own_Ship)<=3);	// minden artillerynel kozelebb levo detektalt ellenseges hajo levalogatasa
						SelectShips(20, S.race!=O.Own_Ship:race & GetRelation(O.Own_Ship:race, S.race)=2 & GetDetected(O.Own_Ship, S.race) & Range(S.this, O.Own_Ship)<=3);	// minden artillerynel kozelebb levo engem detektalt ellenseges hajo levalogatasa
						If(NumOf(20)!=0, ExecList(70, ActivateDevice(S.this, 1)), ExecList(70, ActivateDevice(S.this, 0)));
						If(NumOf(10)!=0, ExecList(71, ActivateDevice(S.this, 1)), ExecList(71, ActivateDevice(S.this, 0)));
						If(NumOf(10)!=0, ExecList(72, ActivateDevice(S.this, 1)), ExecList(72, ActivateDevice(S.this, 0)));
						
						Range_Main_Target:=Range(O.Main_Target, O.Own_Ship); 	//Aktualis tavolsag az elsodleges celponttol
						If(Range_Main_Target=2,	O:tEngineMode(0),	O:tEngineMode(1));
					:end
				END
				Tick 5.5

				#include "AIBehaviour_Rules.inc"

			END	//STATE NoFire
		
		END	//MACHINE "Behaviour"
				
		#include "AICommand_Rules.inc"
				
	END	//STATE Approach
	
END	//MACHINE "Command"
	

////////// Global command events ///////////////

RULE	event CommandInit
	:action
		Cmd_Beh:=E.behaviour;			//kapott behaviour
		Main_Target:=E.target;		// az egyseg, amit tamadnia kell
		Own_Ship:=this; 				//Store own ship
		Fire_Mode:=0;

		tClearMove();
		tClearFire();
		tClearTerritory();

		GetMachine("Command"):ChangeState(Approach, 0);
	:end
END

RULE	event ClearCommand
	:action
		tClearMove();
		tClearFire();
		tClearTerritory();
		tPlayerControl(1);
	:end
END
