Name AI_AttackDevice

CONST
END	//Const

////////// State machine Main ///////////////
MACHINE "Command"

	///////  CancelTask  ////////////////////////////////////
	STATE	CancelTask
	
		RULE 	event In	
			:action
				O:tClearCommand();
			:end
		END
		
	END	//STATE CancelTask
			
	///////  Approach  ////////////////////////////////////	
	STATE	Approach
	
		RULE 	event In 	
			:action
				O:tClearFire();
				
				ChooseFirst(
					O.Cmd_Beh=1, GetMachine("Behaviour"):ChangeState(Aggressive, 0), 		// aggressziv allapot
					O.Cmd_Beh=2, GetMachine("Behaviour"):ChangeState(Defensive, 0), 		// defenziv allapot
					O.Cmd_Beh=3, GetMachine("Behaviour"):ChangeState(Cautious, 0),			// menekulo allapot
					O.Cmd_Beh=4, GetMachine("Behaviour"):ChangeState(NoFire, 0)	 			// clirnyos allapot
				);
				
				LocalEvent(CollectAbility, 0);
				PEvent(PurposeDisabled, E.Ability:=Ability_Device);
			:end
		END
		
		RULE 	event Tick 	
			:action
				Range_Main_Target:=Range(O.Main_Target, O.Own_Ship); 	//Aktualis tavolsag az elsodleges celponttol
				Move_Range:=Call(CalcRangeToFiremode, E.ship:=O.Own_Ship; E.mode:=3; E.beh:=O.Cmd_Beh; E.trg:=O.Main_Target; E.refvalue:=O.Main_Target:hpmax);  // Kivanatos tavolsag az elsodleges celpot tamadasahoz!
				If(Range_Main_Target=2 | Range_Main_Target=3, 
					Dam_Main_Target:=O:tDamage(Main_Target, C.Range_Main_Target, 3),
					Dam_Main_Target:=0
				);
				O:tMoveTo(O.Main_Target, C.Move_Range, 0);		//Move to optimal Range
				
				If(Dam_Main_Target!=0 | Range_Main_Target<=Move_Range, ChangeState(Executer, 0));
			:end
		END
		Tick 5.5
		
		////////// State machine Behaviour ///////////////
		MACHINE "Behaviour"
		
			///////  Aggressive  ///////////////////////////////////
			STATE Aggressive
			
				RULE 	event In 	
					:action
						O:tClearForbid(0);
						O:tSetForbid(#FORBID_MOTION_MOTIVATION);		//Osszes sajat mozgas tiltasa
						O:tSetForbid(#FORBID_FIRE_BOMBER);				//csak bomberkuldes tiltva, minden mas tuzeles engedelyezve				

						LocalEvent(CollectDevices, 0);

						O:tEngineMode(1);
					:end
				END

				RULE 	event Tick
					:action
						SelectShips(10, S.race!=O.Own_Ship:race & GetRelation(O.Own_Ship:race, S.race)=2 & GetDetected(S.this, O.Own_Ship:race) & Range(S.this, O.Own_Ship)<=3);	// minden artillerynel kozelebb levo detektalt ellenseges hajo levalogatasa
						ExecList(70, ActivateDevice(S.this, 1));
						If(NumOf(10)!=0, ExecList(71, ActivateDevice(S.this, 1)), ExecList(71, ActivateDevice(S.this, 0)));
						If(NumOf(10)!=0, ExecList(72, ActivateDevice(S.this, 1)), ExecList(72, ActivateDevice(S.this, 0)));					
					:end
				END
				Tick 5.5
				
				#include "AIBehaviour_Rules.inc"

			END	//STATE Aggressive
			
			///////  Defensive  ///////////////////////////////////
			STATE Defensive

				RULE 	event In 	
					:action
						O:tClearForbid(0);
						O:tSetForbid(#FORBID_MOTION_MOTIVATION);		//Osszes sajat mozgas tiltasa
						O:tSetForbid(#FORBID_FIRE_BOMBER);				//csak bomberkuldes tiltva, minden mas tuzeles engedelyezve				
						O:tSetForbid(#FORBID_FIRE_NOTSHOTBY);						//csak vdekez tzels

						LocalEvent(CollectDevices, 0);
						
						O:tEngineMode(0);
					:end
				END

				RULE 	event Tick
					:action
						SelectShips(10, S.race!=O.Own_Ship:race & GetRelation(O.Own_Ship:race, S.race)=2 & GetDetected(S.this, O.Own_Ship:race) & Range(S.this, O.Own_Ship)<=3);	// minden artillerynel kozelebb levo detektalt ellenseges hajo levalogatasa
						SelectShips(20, S.race!=O.Own_Ship:race & GetRelation(O.Own_Ship:race, S.race)=2 & GetDetected(O.Own_Ship, S.race) & Range(S.this, O.Own_Ship)<=3);	// minden artillerynel kozelebb levo engem detektalt ellenseges hajo levalogatasa
						If(NumOf(20)!=0, ExecList(70, ActivateDevice(S.this, 1)), ExecList(70, ActivateDevice(S.this, 0)));
						If(NumOf(10)!=0, ExecList(71, ActivateDevice(S.this, 1)), ExecList(71, ActivateDevice(S.this, 0)));
						ExecList(72, ActivateDevice(S.this, 0));
					:end
				END
				Tick 5.5

				#include "AIBehaviour_Rules.inc"

			END	//STATE Defensive
			
			///////  Cautious  ///////////////////////////////////
			STATE Cautious

				RULE 	event In 	
					:action
						O:tClearForbid(0);
						O:tSetForbid(#FORBID_MOTION_MOTIVATION);		//Osszes sajat mozgas tiltasa
						O:tSetForbid(#FORBID_FIRE_BOMBER);				//csak bomberkuldes tiltva, minden mas tuzeles engedelyezve				
						O:tClearForbid(#FORBID_MOTION_MOTIVATION_AWAY);			//Osszes sajat mozgas tiltasa, kivve Away
						O:tSetForbid(#FORBID_FIRE_NOTSHOTBY);					 	//csak vdekez tzels
						
						LocalEvent(CollectDevices, 0);
						
						SelectShips(15, S.race!=O.Own_Ship:race & GetRelation(O.Own_Ship:race, S.race)=2 & GetDetected(S.this, O.Own_Ship:race) & Range(S.this, O.Own_Ship)<=3 & IsShot(O.Own_Ship, S.this));	// minden artillerynel kozelebb levo detektalt ellenseges hajo levalogatasa, aki ranklott
						If(NumOf(15)!=0, O:tEngineMode(0), O:tEngineMode(2));
					:end
				END

				RULE 	event Tick
					:action
						SelectShips(15, S.race!=O.Own_Ship:race & GetRelation(O.Own_Ship:race, S.race)=2 & GetDetected(S.this, O.Own_Ship:race) & Range(S.this, O.Own_Ship)<=3 & IsShot(O.Own_Ship, S.this));	// minden artillerynel kozelebb levo detektalt ellenseges hajo levalogatasa, aki ranklott
						If(NumOf(15)!=0, O:tEngineMode(0), O:tEngineMode(2));

						SelectShips(10, S.race!=O.Own_Ship:race & GetRelation(O.Own_Ship:race, S.race)=2 & GetDetected(S.this, O.Own_Ship:race) & Range(S.this, O.Own_Ship)<=3);	// minden artillerynel kozelebb levo detektalt ellenseges hajo levalogatasa
						SelectShips(20, S.race!=O.Own_Ship:race & GetRelation(O.Own_Ship:race, S.race)=2 & GetDetected(O.Own_Ship, S.race) & Range(S.this, O.Own_Ship)<=3);	// minden artillerynel kozelebb levo engem detektalt ellenseges hajo levalogatasa
						If(NumOf(20)!=0, ExecList(70, ActivateDevice(S.this, 1)), ExecList(70, ActivateDevice(S.this, 0)));
						If(NumOf(10)!=0, ExecList(71, ActivateDevice(S.this, 1)), ExecList(71, ActivateDevice(S.this, 0)));
						If(NumOf(10)!=0, ExecList(72, ActivateDevice(S.this, 1)), ExecList(72, ActivateDevice(S.this, 0)));
					:end
				END
				Tick 5.5

				#include "AIBehaviour_Rules.inc"

			END	//STATE Cautious
			
			///////  NoFire  ///////////////////////////////////
			STATE NoFire

				RULE 	event In 	
					:action
						O:tClearForbid(0);
						O:tSetForbid(#FORBID_MOTION_MOTIVATION);		//Osszes sajat mozgas tiltasa
						O:tSetForbid(#FORBID_FIRE_BOMBER);				//csak bomberkuldes tiltva, minden mas tuzeles engedelyezve				
						O:tSetForbid(#FORBID_FIRE_FREE);								//CO tzels tiltsa

						LocalEvent(CollectDevices, 0);
						
						O:tEngineMode(1);
					:end
				END

				RULE 	event Tick
					:action
						SelectShips(10, S.race!=O.Own_Ship:race & GetRelation(O.Own_Ship:race, S.race)=2 & GetDetected(S.this, O.Own_Ship:race) & Range(S.this, O.Own_Ship)<=3);	// minden artillerynel kozelebb levo detektalt ellenseges hajo levalogatasa
						SelectShips(20, S.race!=O.Own_Ship:race & GetRelation(O.Own_Ship:race, S.race)=2 & GetDetected(O.Own_Ship, S.race) & Range(S.this, O.Own_Ship)<=3);	// minden artillerynel kozelebb levo engem detektalt ellenseges hajo levalogatasa
						If(NumOf(20)!=0, ExecList(70, ActivateDevice(S.this, 1)), ExecList(70, ActivateDevice(S.this, 0)));
						If(NumOf(10)!=0, ExecList(71, ActivateDevice(S.this, 1)), ExecList(71, ActivateDevice(S.this, 0)));
						If(NumOf(10)!=0, ExecList(72, ActivateDevice(S.this, 1)), ExecList(72, ActivateDevice(S.this, 0)));
					:end
				END
				Tick 5.5

				#include "AIBehaviour_Rules.inc"

			END	//STATE NoFire
		
		END	//MACHINE "Behaviour"
				
		#include "AICommand_Rules.inc"

		RULE	event CO_DeviceDisabled		//Celpont kijelolt berendezese/osszes berendezese uzemkeptelen
				condition E.ship=O.Main_Target
			:action
				Select(80, S.device & S.owner=O.Main_Target & S.destroyed=0);										// minden Main_Targeten levo nem teljesen lepusztult device
				If(NumOf(80)=0, 
					ChangeState(CancelTask, 0)
				, 
					0
				);	
			:end
		END	//Devicedisabled
				
	END	//STATE Approach
	
	///////  Executer  ////////////////////////////////////	
	STATE	Executer
	
		RULE 	event In 	
			:action	
				LocalEvent(CollectDevices, 0);
				ExecList(70, ActivateDevice(S.this, 1));
				ExecList(72, ActivateDevice(S.this, 1));
				
				O:tFireTo(Main_Target, 3);
				
				ChooseFirst(
					O.Cmd_Beh=1, GetMachine("Behaviour"):ChangeState(Aggressive, 0), 		// aggressziv allapot
					O.Cmd_Beh=2, GetMachine("Behaviour"):ChangeState(Defensive, 0), 		// defenziv allapot
					O.Cmd_Beh=3, GetMachine("Behaviour"):ChangeState(Cautious, 0),			// menekulo allapot
					O.Cmd_Beh=4, GetMachine("Behaviour"):ChangeState(NoFire, 0)	 			// clirnyos allapot
				);
			:end
		END
		
		RULE 	event Tick 	
			:action
				SelectShips(10, S.race!=O.Own_Ship:race & GetRelation(O.Own_Ship:race, S.race)=2 & GetDetected(S.this, O.Own_Ship:race) & Range(S.this, O.Own_Ship)<=3);	// minden artillerynel kozelebb levo detektalt ellenseges hajo levalogatasa
				If(NumOf(10)!=0, ExecList(71, ActivateDevice(S.this, 1)), ExecList(71, ActivateDevice(S.this, 0)));
			
				Range_Main_Target:=Range(O.Main_Target, O.Own_Ship); 	//Aktualis tavolsag az elsodleges celponttol
				If(Range_Main_Target=2 | Range_Main_Target=3, 
					Dam_Main_Target:=O:tDamage(Main_Target, C.Range_Main_Target, 3),
					Dam_Main_Target:=0
				);
				If(Range_Main_Target>3, ChangeState(Approach, 0));
			:end
		END
		Tick 5.5
	
		MACHINE "Behaviour"
		
			///////  Aggressive  ///////////////////////////////////
			STATE Aggressive
			
				RULE 	event In 	
					:action
						O:tClearForbid(0);
						O:tSetForbid(#FORBID_MOTION_MOTIVATION);		//Osszes sajat mozgas tiltasa
						O:tSetForbid(#FORBID_FIRE_BOMBER);				//csak bomberkuldes tiltva, minden mas tuzeles engedelyezve				
					:end
				END

				#include "AIBehaviour_Rules.inc"

			END	//STATE Aggressive
			
			///////  Defensive  ///////////////////////////////////
			STATE Defensive

				RULE 	event In 	
					:action
						O:tClearForbid(0);
						O:tSetForbid(#FORBID_MOTION_MOTIVATION);		//Osszes sajat mozgas tiltasa
						O:tSetForbid(#FORBID_FIRE_BOMBER);				//csak bomberkuldes tiltva, minden mas tuzeles engedelyezve				
						O:tSetForbid(#FORBID_FIRE_NOTSHOTBY);						//csak vdekez tzels
					:end
				END

				#include "AIBehaviour_Rules.inc"

			END	//STATE Defensive
			
			///////  Cautious  ///////////////////////////////////
			STATE Cautious

				RULE 	event In 	
					:action
						O:tClearForbid(0);
						O:tSetForbid(#FORBID_MOTION_MOTIVATION);		//Osszes sajat mozgas tiltasa
						O:tSetForbid(#FORBID_FIRE_BOMBER);				//csak bomberkuldes tiltva, minden mas tuzeles engedelyezve				
						O:tClearForbid(#FORBID_MOTION_MOTIVATION_AWAY);			//Osszes sajat mozgas tiltasa, kivve Away
						O:tSetForbid(#FORBID_FIRE_NOTSHOTBY);					 	//csak vdekez tzels
					:end
				END

				#include "AIBehaviour_Rules.inc"

			END	//STATE Cautious
			
			///////  NoFire  ///////////////////////////////////
			STATE NoFire

				RULE 	event In 	
					:action
						O:tClearForbid(0);
						O:tSetForbid(#FORBID_MOTION_MOTIVATION);		//Osszes sajat mozgas tiltasa
						O:tSetForbid(#FORBID_FIRE_BOMBER);				//csak bomberkuldes tiltva, minden mas tuzeles engedelyezve				
						O:tSetForbid(#FORBID_FIRE_FREE);								//CO tzels tiltsa
					:end
				END

				#include "AIBehaviour_Rules.inc"

			END	//STATE NoFire
		
		END	//MACHINE "Behaviour"
		
		#include "AICommand_Rules.inc"

		RULE	event CO_DeviceDisabled		//Celpont kijelolt berendezese/osszes berendezese uzemkeptelen
				condition E.ship=O.Main_Target
			:action
				Select(80, S.device & S.owner=O.Main_Target & S.destroyed=0);										// minden Main_Targeten levo nem teljesen lepusztult device
				If(NumOf(80)=0, 
					ChangeState(CancelTask, 0)
				, 
					0
				);	
			:end
		END	//Devicedisabled
	
	END	//STATE Executer

END	//MACHINE "Command"
	

////////// Global command events ///////////////

RULE	event CommandInit
	:action
		Cmd_Beh:=E.behaviour;			//kapott behaviour
		Main_Target:=E.target;		// az egyseg, amit tamadnia kell
		Own_Ship:=this; 				//Store own ship
		Fire_Mode:=3;

		tClearMove();
		tClearFire();
		tClearTerritory();
		
		SetRelation(race, Main_Target:race, 2);

		GetMachine("Command"):ChangeState(Approach, 0);
	:end
END

RULE	event ClearCommand
	:action
		tClearMove();
		tClearFire();
		tClearTerritory();
		tPlayerControl(1);
	:end
END
