Name AI_Artillery

CONST
END	//Const

////////// State machine Main ///////////////
MACHINE "Command"

	///////  CancelTask  ////////////////////////////////////
	STATE	CancelTask
	
		RULE 	event In	
			:action
				O:tClearCommand();
			:end
		END
		
	END	//STATE CancelTask
			
	///////  Approach  ////////////////////////////////////	
	STATE	Approach
	
		RULE 	event In 	
			:action
				O:tClearFire();
				
				ChooseFirst(
					O.Cmd_Beh=1, GetMachine("Behaviour"):ChangeState(Aggressive, 0), 		// aggressziv allapot
					O.Cmd_Beh=2, GetMachine("Behaviour"):ChangeState(Defensive, 0), 		// defenziv allapot
					O.Cmd_Beh=3, GetMachine("Behaviour"):ChangeState(Cautious, 0),			// menekulo allapot
					O.Cmd_Beh=4, GetMachine("Behaviour"):ChangeState(NoFire, 0)	 			// clirnyos allapot
				);
				
				LocalEvent(CollectAbility, 0);
				PEvent(PurposeDisabled, E.Ability:=Ability_Missile+Ability_EBomb);
			:end
		END
		
		RULE 	event Tick 	
			:action
				If(Range_Main_Target>=Move_Range & Range_Main_Target<5, ChangeState(Executer, 0));
			:end
		END
		Tick 5.5
		
		////////// State machine Behaviour ///////////////
		MACHINE "Behaviour"
		
			///////  Aggressive  ///////////////////////////////////
			STATE Aggressive
			
				RULE 	event In 	
					:action
						Move_Range:=3;
						O:tMoveTo(O.Main_Target, C.Move_Range, 0);		//Move to optimal Range

						O:tClearForbid(0);
						O:tSetForbid(#FORBID_MOTION_MOTIVATION);		//Osszes sajat mozgas tiltasa
						O:tSetForbid(#FORBID_FIRE_BOMBER);				//csak bomberkuldes tiltva, minden mas tuzeles engedelyezve				

						LocalEvent(CollectDevices, 0);

						O:tEngineMode(1);
					:end
				END

				RULE 	event Tick
					:action
						SelectShips(10, S.race!=O.Own_Ship:race & GetRelation(O.Own_Ship:race, S.race)=2 & GetDetected(S.this, O.Own_Ship:race) & Range(S.this, O.Own_Ship)<=3);	// minden artillerynel kozelebb levo detektalt ellenseges hajo levalogatasa
						ExecList(70, ActivateDevice(S.this, 1));
						If(NumOf(10)!=0, ExecList(71, ActivateDevice(S.this, 1)), ExecList(71, ActivateDevice(S.this, 0)));
						If(NumOf(10)!=0, ExecList(72, ActivateDevice(S.this, 1)), ExecList(72, ActivateDevice(S.this, 0)));					
					:end
				END
				Tick 5.5
				
				#include "AIBehaviour_Rules.inc"

			END	//STATE Aggressive
			
			///////  Defensive  ///////////////////////////////////
			STATE Defensive

				RULE 	event In 	
					:action
						Move_Range:=3;
						O:tMoveTo(O.Main_Target, C.Move_Range, 0);		//Move to optimal Range

						O:tClearForbid(0);
						O:tSetForbid(#FORBID_MOTION_MOTIVATION);		//Osszes sajat mozgas tiltasa
						O:tSetForbid(#FORBID_FIRE_BOMBER);				//csak bomberkuldes tiltva, minden mas tuzeles engedelyezve				
						O:tSetForbid(#FORBID_FIRE_NOTSHOTBY);						//csak vdekez tzels

						LocalEvent(CollectDevices, 0);
						
						O:tEngineMode(0);
					:end
				END

				RULE 	event Tick
					:action
						SelectShips(10, S.race!=O.Own_Ship:race & GetRelation(O.Own_Ship:race, S.race)=2 & GetDetected(S.this, O.Own_Ship:race) & Range(S.this, O.Own_Ship)<=3);	// minden artillerynel kozelebb levo detektalt ellenseges hajo levalogatasa
						SelectShips(20, S.race!=O.Own_Ship:race & GetRelation(O.Own_Ship:race, S.race)=2 & GetDetected(O.Own_Ship, S.race) & Range(S.this, O.Own_Ship)<=3);	// minden artillerynel kozelebb levo engem detektalt ellenseges hajo levalogatasa
						If(NumOf(20)!=0, ExecList(70, ActivateDevice(S.this, 1)), ExecList(70, ActivateDevice(S.this, 0)));
						If(NumOf(10)!=0, ExecList(71, ActivateDevice(S.this, 1)), ExecList(71, ActivateDevice(S.this, 0)));
						ExecList(72, ActivateDevice(S.this, 0));
					:end
				END
				Tick 5.5

				#include "AIBehaviour_Rules.inc"

			END	//STATE Defensive
			
			///////  Cautious  ///////////////////////////////////
			STATE	Cautious

				RULE 	event In 	
					:action
						Move_Range:=4;
						O:tMoveTo(O.Main_Target, C.Move_Range, 0);		//Move to optimal Range

						O:tClearForbid(0);
						O:tSetForbid(#FORBID_MOTION_MOTIVATION);		//Osszes sajat mozgas tiltasa
						O:tSetForbid(#FORBID_FIRE_BOMBER);				//csak bomberkuldes tiltva, minden mas tuzeles engedelyezve				
						O:tClearForbid(#FORBID_MOTION_MOTIVATION_AWAY);			//Osszes sajat mozgas tiltasa, kivve Away
						O:tSetForbid(#FORBID_FIRE_NOTSHOTBY);					 	//csak vdekez tzels
						
						LocalEvent(CollectDevices, 0);
						
						SelectShips(15, S.race!=O.Own_Ship:race & GetRelation(O.Own_Ship:race, S.race)=2 & GetDetected(S.this, O.Own_Ship:race) & Range(S.this, O.Own_Ship)<=3 & IsShot(O.Own_Ship, S.this));	// minden artillerynel kozelebb levo detektalt ellenseges hajo levalogatasa, aki ranklott
						If(NumOf(15)!=0, O:tEngineMode(0), O:tEngineMode(2));
					:end
				END

				RULE 	event Tick
					:action
						SelectShips(15, S.race!=O.Own_Ship:race & GetRelation(O.Own_Ship:race, S.race)=2 & GetDetected(S.this, O.Own_Ship:race) & Range(S.this, O.Own_Ship)<=3 & IsShot(O.Own_Ship, S.this));	// minden artillerynel kozelebb levo detektalt ellenseges hajo levalogatasa, aki ranklott
						If(NumOf(15)!=0, O:tEngineMode(0), O:tEngineMode(2));

						SelectShips(10, S.race!=O.Own_Ship:race & GetRelation(O.Own_Ship:race, S.race)=2 & GetDetected(S.this, O.Own_Ship:race) & Range(S.this, O.Own_Ship)<=3);	// minden artillerynel kozelebb levo detektalt ellenseges hajo levalogatasa
						SelectShips(20, S.race!=O.Own_Ship:race & GetRelation(O.Own_Ship:race, S.race)=2 & GetDetected(O.Own_Ship, S.race) & Range(S.this, O.Own_Ship)<=3);	// minden artillerynel kozelebb levo engem detektalt ellenseges hajo levalogatasa
						If(NumOf(20)!=0, ExecList(70, ActivateDevice(S.this, 1)), ExecList(70, ActivateDevice(S.this, 0)));
						If(NumOf(10)!=0, ExecList(71, ActivateDevice(S.this, 1)), ExecList(71, ActivateDevice(S.this, 0)));
						If(NumOf(10)!=0, ExecList(72, ActivateDevice(S.this, 1)), ExecList(72, ActivateDevice(S.this, 0)));
					:end
				END
				Tick 5.5

				#include "AIBehaviour_Rules.inc"

			END	//STATE Cautious
			
			///////  NoFire  ///////////////////////////////////
			STATE NoFire

				RULE 	event In 	
					:action
						Move_Range:=3;
						O:tMoveTo(O.Main_Target, C.Move_Range, 0);		//Move to optimal Range

						O:tClearForbid(0);
						O:tSetForbid(#FORBID_MOTION_MOTIVATION);		//Osszes sajat mozgas tiltasa
						O:tSetForbid(#FORBID_FIRE_BOMBER);				//csak bomberkuldes tiltva, minden mas tuzeles engedelyezve				
						O:tSetForbid(#FORBID_FIRE_FREE);								//CO tzels tiltsa

						LocalEvent(CollectDevices, 0);
						
						O:tEngineMode(1);
					:end
				END

				RULE 	event Tick
					:action
						SelectShips(10, S.race!=O.Own_Ship:race & GetRelation(O.Own_Ship:race, S.race)=2 & GetDetected(S.this, O.Own_Ship:race) & Range(S.this, O.Own_Ship)<=3);	// minden artillerynel kozelebb levo detektalt ellenseges hajo levalogatasa
						SelectShips(20, S.race!=O.Own_Ship:race & GetRelation(O.Own_Ship:race, S.race)=2 & GetDetected(O.Own_Ship, S.race) & Range(S.this, O.Own_Ship)<=3);	// minden artillerynel kozelebb levo engem detektalt ellenseges hajo levalogatasa
						If(NumOf(20)!=0, ExecList(70, ActivateDevice(S.this, 1)), ExecList(70, ActivateDevice(S.this, 0)));
						If(NumOf(10)!=0, ExecList(71, ActivateDevice(S.this, 1)), ExecList(71, ActivateDevice(S.this, 0)));
						If(NumOf(10)!=0, ExecList(72, ActivateDevice(S.this, 1)), ExecList(72, ActivateDevice(S.this, 0)));
					:end
				END
				Tick 5.5

				#include "AIBehaviour_Rules.inc"

			END	//STATE NoFire
		
		END	//MACHINE "Behaviour"
				
		#include "AICommand_Rules.inc"

		RULE	event Deleted	//Celpont hajo megsemmisult
				condition E.ship=O.Main_Target&E.ship:class!=0
			:action
				ChangeState(CancelTask, 0);
			:end
		END	//Deleted
				
	END	//STATE Approach
	
	///////  Executer  ////////////////////////////////////	
	STATE	Executer
	
		RULE 	event In 	
			:action	
				LocalEvent(CollectDevices, 0);
				ExecList(70, ActivateDevice(S.this, 1));
				ExecList(72, ActivateDevice(S.this, 1));

				SelectShips(21, S.race=O.Main_Target:O.Own_Ship:race & (Distance(S.this, O.Main_Target)=2000 | S.this=O.Main_Target) & S.this:isShielded);			// minden ellensges pajzsolt hajo Main_Target koruli combat Range-ben
				If(NumOf(21)>0, O.Enemy_Shielded:=1, O.Enemy_Shielded:=0);										// jelz billentese, ha van pajzsos egyseg a robbanasnal
				
				ChooseFirst(
					O.Cmd_Beh=1, GetMachine("Behaviour"):ChangeState(Aggressive, 0), 		// aggressziv allapot
					O.Cmd_Beh=2, GetMachine("Behaviour"):ChangeState(Defensive, 0), 		// defenziv allapot
					O.Cmd_Beh=3, GetMachine("Behaviour"):ChangeState(Cautious, 0),			// menekulo allapot
					O.Cmd_Beh=4, GetMachine("Behaviour"):ChangeState(NoFire, 0)	 			// clirnyos allapot
				);
			:end
		END
		
		RULE 	event Tick 	
			:action
				SelectShips(10, S.race!=O.Own_Ship:race & GetRelation(O.Own_Ship:race, S.race)=2 & GetDetected(S.this, O.Own_Ship:race) & Range(S.this, O.Own_Ship)<=3);	// minden artillerynel kozelebb levo detektalt ellenseges hajo levalogatasa
				If(NumOf(10)!=0, ExecList(71, ActivateDevice(S.this, 1)), ExecList(71, ActivateDevice(S.this, 0)));
							
				Range_Main_Target:=Range(O.Main_Target, O.Own_Ship); 	//Aktualis tavolsag az elsodleges celponttol
				If(Range_Main_Target>4 | Range_Main_Target<3, ChangeState(Approach, 0));
				
				SelectShips(22, S.race=O.Own_Ship:race & Distance(S.this, O.Main_Target)=2000);			// minden sajat hajo Main_Target koruli combat Range-ben
				If(NumOf(22)>0, O.Own_In_Danger:=1, O.Own_In_Danger:=0);							// veszely billentese, ha van sajat egyseg a robbanasnal
				
				SelectDevices(34, O.Own_Ship, S.weapon & S.working & InSet(S.this, 2) & InSet(S.this, 5) & S.count!=0); 	//Raketak levalogatasa
				n:=0;
				Ammo_Sum:=0;
				While(n<NumOf(34), 
					Ammo_Weap:=PickN(34, n):count;
					Ammo_Sum:=(Ammo_Sum+Ammo_Weap);
					n:=n+1
				);
				If(Ammo_Sum/n-1<=2, LocalEvent(RunOutOfAmmo, 0));
			:end
		END
		Tick 5.5
		
		RULE	event Out
			:action
				LocalEvent(CollectAbility, 0);
				Execlist(34, TargetWeapon(S.this, 0));			// tuzersegi tamadas letiltsa
				Execlist(35, TargetWeapon(S.this, 0));			// tuzersegi energiatamadas letiltsa			
			:end
		END
	
		MACHINE "Behaviour"
		
			///////  Aggressive  ///////////////////////////////////
			STATE Aggressive
			
				RULE 	event In 	
					:action
						O:tClearForbid(0);
						O:tSetForbid(#FORBID_MOTION_MOTIVATION);		//Osszes sajat mozgas tiltasa
						O:tSetForbid(#FORBID_FIRE_BOMBER);				//csak bomberkuldes tiltva, minden mas tuzeles engedelyezve				
						O:tSetForbid(#FORBID_FIRE_MISSILE);
					:end
				END

				RULE 	event Tick
					:action
						SelectDevices(34, O.Own_Ship, S.weapon & S.working & InSet(S.this, 2) & InSet(S.this, 5) & S.count!=0); 	//Raketak levalogatasa
						SelectDevices(35, O.Own_Ship, S.weapon & S.working & InSet(S.this, 3) & InSet(S.this, 5) & S.count!=0); 	//E-bombk levalogatasa
						If(O.Enemy_Shielded, 
							ExecList(35, TargetWeapon(S.this, O.Main_Target))			// tuzersegi energiatamadas meghivasa
						,
							ExecList(35, TargetWeapon(S.this, 0))						// tuzersegi energiatamadas letiltsa
						);
						ExecList(34, TargetWeapon(S.this, O.Main_Target));			// tuzersegi tamadas meghivasa
					:end
				END
				Tick 5.5

				#include "AIBehaviour_Rules.inc"

			END	//STATE Aggressive
			
			///////  Defensive  ///////////////////////////////////
			STATE Defensive

				RULE 	event In 	
					:action
						O:tClearForbid(0);
						O:tSetForbid(#FORBID_MOTION_MOTIVATION);		//Osszes sajat mozgas tiltasa
						O:tSetForbid(#FORBID_FIRE_BOMBER);				//csak bomberkuldes tiltva, minden mas tuzeles engedelyezve				
						O:tSetForbid(#FORBID_FIRE_NOTSHOTBY);						//csak vdekez tzels
						O:tSetForbid(#FORBID_FIRE_MISSILE);
					:end
				END

				RULE 	event Tick					
						condition O.Own_In_Danger=0
					:action
						SelectDevices(34, O.Own_Ship, S.weapon & S.working & InSet(S.this, 2) & InSet(S.this, 5) & S.count!=0); 	//Raketak levalogatasa
						SelectDevices(35, O.Own_Ship, S.weapon & S.working & InSet(S.this, 3) & InSet(S.this, 5) & S.count!=0); 	//E-bombk levalogatasa
						If(O.Enemy_Shielded, 
							ExecList(35, TargetWeapon(S.this, O.Main_Target))			// tuzersegi energiatamadas meghivasa
						,
							ExecList(35, TargetWeapon(S.this, 0))						// tuzersegi energiatamadas letiltsa
						);
						ExecList(34, TargetWeapon(S.this, O.Main_Target));			// tuzersegi tamadas meghivasa
					:end
				END
				Tick 5.5

				#include "AIBehaviour_Rules.inc"

			END	//STATE Defensive
			
			///////  Cautious  ///////////////////////////////////
			STATE Cautious

				RULE 	event In 	
					:action
						O:tClearForbid(0);
						O:tSetForbid(#FORBID_MOTION_MOTIVATION);		//Osszes sajat mozgas tiltasa
						O:tSetForbid(#FORBID_FIRE_BOMBER);				//csak bomberkuldes tiltva, minden mas tuzeles engedelyezve				
						O:tClearForbid(#FORBID_MOTION_MOTIVATION_AWAY);			//Osszes sajat mozgas tiltasa, kivve Away
						O:tSetForbid(#FORBID_FIRE_NOTSHOTBY);					 	//csak vdekez tzels
						O:tSetForbid(#FORBID_FIRE_MISSILE);
					:end
				END

				RULE 	event Tick
						condition O.Own_In_Danger=0
					:action
						SelectDevices(34, O.Own_Ship, S.weapon & S.working & InSet(S.this, 2) & InSet(S.this, 5) & S.count!=0); 	//Raketak levalogatasa
						SelectDevices(35, O.Own_Ship, S.weapon & S.working & InSet(S.this, 3) & InSet(S.this, 5) & S.count!=0); 	//E-bombk levalogatasa
						If(O.Enemy_Shielded, 
							ExecList(35, TargetWeapon(S.this, O.Main_Target))			// tuzersegi energiatamadas meghivasa
						,
							ExecList(35, TargetWeapon(S.this, 0))						// tuzersegi energiatamadas letiltsa
						);
						ExecList(34, TargetWeapon(S.this, O.Main_Target));			// tuzersegi tamadas meghivasa
					:end
				END
				Tick 5.5

				#include "AIBehaviour_Rules.inc"

			END	//STATE Cautious
			
			///////  NoFire  ///////////////////////////////////
			STATE NoFire

				RULE 	event In 	
					:action
						O:tClearForbid(0);
						O:tSetForbid(#FORBID_MOTION_MOTIVATION);		//Osszes sajat mozgas tiltasa
						O:tSetForbid(#FORBID_FIRE_BOMBER);				//csak bomberkuldes tiltva, minden mas tuzeles engedelyezve				
						O:tSetForbid(#FORBID_FIRE_FREE);								//CO tzels tiltsa
						O:tSetForbid(#FORBID_FIRE_MISSILE);
					:end
				END

				RULE 	event Tick
					:action
						SelectDevices(34, O.Own_Ship, S.weapon & S.working & InSet(S.this, 2) & InSet(S.this, 5) & S.count!=0); 	//Raketak levalogatasa
						SelectDevices(35, O.Own_Ship, S.weapon & S.working & InSet(S.this, 3) & InSet(S.this, 5) & S.count!=0); 	//E-bombk levalogatasa
						If(O.Enemy_Shielded, 
							ExecList(35, TargetWeapon(S.this, O.Main_Target))			// tuzersegi energiatamadas meghivasa
						,
							ExecList(35, TargetWeapon(S.this, 0))						// tuzersegi energiatamadas letiltsa
						);
						ExecList(34, TargetWeapon(S.this, O.Main_Target));			// tuzersegi tamadas meghivasa
					:end
				END
				Tick 5.5

				#include "AIBehaviour_Rules.inc"

			END	//STATE NoFire
		
		END	//MACHINE "Behaviour"

		#include "AICommand_Rules.inc"
		
		RULE	event ShieldDown	// Main_Target pajzsa leomlott, sajat fegyverek ujraertekelese
			:action
				SelectShips(21, S.race=O.Main_Target:O.Own_Ship:race & (Distance(S.this, O.Main_Target)=2000 | S.this=O.Main_Target) & S.this:isShielded);			// minden ellensges pajzsolt hajo Main_Target koruli combat Range-ben
				If(NumOf(21)>0, O.Enemy_Shielded:=1, O.Enemy_Shielded:=0);										// jelz billentese, ha van pajzsos egyseg a robbanasnal
			:end
		END	//CO_ShieldDown

		RULE	event ShieldUp	// Main_Target pajzsa leomlott, sajat fegyverek ujraertekelese
			:action
				SelectShips(21, S.race=O.Main_Target:O.Own_Ship:race & (Distance(S.this, O.Main_Target)=2000 | S.this=O.Main_Target) & S.this:isShielded);			// minden ellensges pajzsolt hajo Main_Target koruli combat Range-ben
				If(NumOf(21)>0, O.Enemy_Shielded:=1, O.Enemy_Shielded:=0);										// jelz billentese, ha van pajzsos egyseg a robbanasnal
			:end
		END	//CO_ShieldUp

		RULE	event RunOutOfAmmo			// Kifogy az osszes raketa
			:action
				//Warning: Most of missiles were fired!
			:end
		END	//RunOutOfAmmo

		RULE	event Deleted	//Celpont hajo megsemmisult
				condition E.ship=O.Main_Target&E.ship:class!=0
			:action
				ChangeState(CancelTask, 0);
			:end
		END	//Deleted
			
	END	//STATE Executer

END	//MACHINE "Command"
	

////////// Global command events ///////////////

RULE	event CommandInit
	:action
		Cmd_Beh:=E.behaviour;			//kapott behaviour
		Main_Target:=E.target;		// az egyseg, amit tamadnia kell
		Own_Ship:=this; 				//Store own ship
		Fire_Mode:=4;
		Enemy_Shielded:=0;
		Own_In_Danger:=0;

		tClearMove();
		tClearFire();
		tClearTerritory();
		
		SetRelation(race, Main_Target:race, 2);

		GetMachine("Command"):ChangeState(Approach, 0);
	:end
END

RULE	event ClearCommand
	:action
		tClearMove();
		tClearFire();
		tClearTerritory();
		tPlayerControl(1);
	:end
END
