Name C222_Platform

CONST
END	//Const

////////// State machine ///////////////

MACHINE "Command"
			
	///////  Seek  ////////////////////////////////////	
	STATE Seek

		RULE	event In
			:action
				SelectShips(1, S.race!=O.race & Distance(S.this, O.Own_Ship)<=12000);	// minden lassan Artillery rangbe r detektalt ellenseges hajo levalogatasa
				If(NumOf(1),
					ChangeState(Defensive, 0)
				);
			:end
		END
		
		RULE	event Tick
			:action
				SelectShips(1, S.race!=O.race & Distance(S.this, O.Own_Ship)<=12000);	// minden lassan Artillery rangbe r detektalt ellenseges hajo levalogatasa
				If(NumOf(1),
					ChangeState(Defensive, 0)
				);
			:end
		END
		Tick 5.5
						
	End 	//STATE Seek

	///////  Defensive  ////////////////////////////////////	
	STATE Defensive

		RULE	event In
			:action
				Miss_Target:=0;
			:end
		END
		
		RULE	event Tick
			:action
				SelectShips(1, S.race!=O.race & Distance(S.this, O.Own_Ship)<=12000);	// minden lassan Artillery rangbe r detektalt ellenseges hajo levalogatasa
				If(NumOf(1)=0,
					ChangeState(Seek, 0);	 		// Keres allapot
					,
					LocalEvent(OpenFire, 0);					
				);
			:end
		END
		Tick 5.5
		
		RULE	event Out
			:action
				TargetWeapon(O.Bazooka, 0);
			:end
		END

		RULE	event OpenFire
			:action
				If(O.Bazooka:count,
					SelectShips(2, S.race!=O.race & Distance(S.this, O.Own_Ship)<=18000 & Distance(S.this, O.Own_Ship)>=10000);	// minden Artillery rangbe r detektalt ellenseges hajo levalogatasa
					If(NumOf(2), 
						PosM_Target:=PickMax(2, 1/Distance(S.this, O.Own_Ship));
						While(PosM_Target & Miss_Target=0,						
							RemoveItem(2, PosM_Target);
							If(PosM_Target:race=15 & Rnd(0,100)<=O.g_var & O.g_r<O.g_rm, 
								Miss_Target:=PosM_Target;
								TargetWeapon(O.Bazooka, Miss_Target);
								Timer(NewTarget, 25, 0);
								,
								If(Rnd(0,100)<=O.e_var & O.e_r<O.e_rm, 
									Miss_Target:=PosM_Target;
									TargetWeapon(O.Bazooka, Miss_Target);
									Timer(NewTarget, 25, 0);
									,
									If(NumOf(2), PosM_Target:=PickMax(2, 1/Distance(S.this, O.Own_Ship)));
								);
							);
						);
					);
				);

				SelectShips(3, S.race!=O.race & Range(S.this, O.Own_Ship)<=2);	// minden Short rangbe r detektalt ellenseges hajo levalogatasa
				Plas_Target:=0;
				If(NumOf(3), 
					PosP_Target:=PickMax(3, 1/Distance(S.this, O.Own_Ship));
					While(PosP_Target & Plas_Target=0,						
						RemoveItem(3, PosP_Target);
						If(PosP_Target:race=15 & Rnd(0,100)<=O.g_var, 
							Plas_Target:=PosP_Target;
							,
							If(Rnd(0,100)<=O.e_var, 
								Plas_Target:=PosP_Target;
								,
								If(NumOf(3), PosP_Target:=PickMax(3, 1/Distance(S.this, O.Own_Ship)));
							);
						);
					);
					If(Plas_Target, O:tFireTo(C.Plas_Target, 2));
				);
			:end
		END
		
		RULE	event NewTarget
			:action
				If(Miss_Target:race=15, 
					O.g_r:=O.g_r+1;
					,
					O.e_r:=O.e_r+1;
				);
				Miss_Target:=0;
			:end
		END

		RULE	event Deleted
				condition E.ship=Miss_Target|E.ship=Plas_Target
			:action
				ChangeState(Seek, 0);	 		// Keres allapot
			:end
		END
				
	End 	//STATE Defensive
		
END	//MACHINE "Command"

////////// Global command events ///////////////

RULE	event CommandInit
	:action
		Own_Ship:=this; 				//Store own ship

		tClearForbid(0);
		tSetForbid(#FORBID_MOTION_MOTIVATION);		//Osszes sajat mozgas tiltasa
		tSetForbid(#FORBID_FIRE_MISSILE+#FORBID_FIRE_BOMBER); 	//csak bomberkuldes, raketakuldes tiltva, minden mas tuzeles engedelyezve
		
		SelectDevices(5, Own_Ship, S.weapon & S.working & InSet(S.this, 2) & InSet(S.this, 5));
		Bazooka:=PickFirst(5);

		//x_r trolja, hogy az adott hajra eddig az adott platform hny raktt ltt, x=a haj faja
		//x_rm megadja, hogy egy platform hny raktt kldhet egy faj clpontra
		//x_var megadja, hogy milyen esllyel indt a platform raktt a clpontra, ha minden egyb felttel adott.

		g_r:=0;
		g_rm:=2;
		g_var:=100;

		e_r:=0;
		e_rm:=1;
		e_var:=70;		

		tClearFire();
		
		SelectDevices(18, Own_Ship, InSet(s.this, 18));		//szkenner
		ExecList(18, ActivateDevice(s.this, 1));
	
		GetMachine("Command"):ChangeState(Seek, 0)	 		// keres allapot
	:end
END

RULE	event ClearCommand
	:action
		tClearMove();
		tClearFire();
		tClearTerritory();
		CloseOff(Own_ship);

		tClearForbid(0);
		SelectEx(S.weapon & S.owner=Own_Ship, ActivateDevice(S.this, 0));		// minden fegyver kikapcsolasa
	:end
END
