Name C061_White

CONST
END	//Const

////////// State machine ///////////////

MACHINE "Command"
			
	///////  JumpIn  ////////////////////////////////////	
	STATE JumpIn

		RULE	event In
			:action				
Debug("JumpIn In");
				CloseShip(O.Own_Ship, O.Target_Ship, 2);
				LocalEvent(OwnJump, 0);
			:end
		END

		RULE	event OwnJump
			:action				
Debug("JumpIn Jump");
				ActivateDevice(O.md, 1);			
			:end
		END
		
		RULE	event Tick
			:action
Debug("JumpIn Tick");
				If(O.Own_Ship:reserve>=2000, 
					ChangeState(Hide, 0);
				);												
			:end
		END
		Tick 3

		RULE	event Deleted	//Celpont hajo megsemmisult
				condition E.ship=O.Target_Ship
			:action				
				SelectShips(1, S.race=#race_Player);
				If(NumOf(1),
					O.Target_Ship:=PickMax(1, -S.hpMax);					
					SelectDevices(2, O.Own_ship, S.weapon);
					ExecList(2,
						TargetWeapon(S.this, O.Target_Ship);
					);
				);
			:end
		END	//Main Deleted
								
	End 	//STATE JumpIn
	
	///////  Hide  ////////////////////////////////////	
	STATE Hide

		RULE	event In
			:action
Debug("Hide In");
				HPlace:=O:Pick(HideS);
				CloseAbs(O.Own_Ship, Hplace:position,0,0);
				LocalEvent(OwnJump, 0);
			:end
		END

		RULE	event OwnJump
			:action				
Debug("Hide Jump");
				ActivateDevice(O.md, 1);			
			:end
		END

		RULE	event Tick
			:action			
Debug("Hide Tick");
				If(O.Own_Ship:reserve>=4000, 
					If(O.Target_Ship, 
						ChangeState(JumpIn, 0);
					,
						SelectShips(1, S.race=#race_Player);
						If(NumOf(1),
							O.Target_Ship:=PickMax(1, -S.hpMax);					
							SelectDevices(2, O.Own_ship, S.weapon);
							ExecList(2,
								TargetWeapon(S.this, O.Target_Ship);
							);
							ChangeState(JumpIn, 0);
						);
					);
				);								
			:end
		END
		Tick 8

		RULE	event Deleted	//Celpont hajo megsemmisult
				condition E.ship=O.Target_Ship
			:action				
				SelectShips(1, S.race=#race_Player);
				If(NumOf(1),
					O.Target_Ship:=PickMax(1, -S.hpMax);					
					SelectDevices(2, O.Own_ship, S.weapon);
					ExecList(2,
						TargetWeapon(S.this, O.Target_Ship);
					);
				);
			:end
		END	//Main Deleted
								
	End 	//STATE Hide
	
END	//MACHINE "Command"

////////// Global command events ///////////////

RULE	event CommandInit
	:action
		Own_Ship:=this; 				//Store own ship
		HideS:=8;
		AddItem(HideS, E.hideA);
		AddItem(HideS, E.hideB);
		
		EnableUnit(O.Own_Ship, 0);
		//tClearForbid(0);
		//tSetForbid(#FORBID_MOTION_MOTIVATION);		//Osszes sajat mozgas tiltasa
		//tSetForbid(#FORBID_FIRE_FREE);		//Osszes sajat lvs tiltasa

		SelectShips(1, S.race=#race_Player);
		If(NumOf(1),
			O.Target_Ship:=PickMax(1, -S.hpMax);	
			SelectDevices(2, O.Own_ship, S.weapon);
			ExecList(2,
				TargetWeapon(S.this, O.Target_Ship);
			);
		);

		SelectDevices(1, Own_Ship, InSet(S.this, 52));		
		ActivateDevice(PickFirst(1), 1);
		SelectDevices(1, Own_Ship, Inset(S.this, 54) & !InSet(S.this, 52));		
		md:=PickFirst(1);

		GetMachine("Command"):ChangeState(JumpIn, 0);	 		// keres allapot
	:end
END

RULE	event ClearCommand
	:action
	:end
END
