Name C014_Platform

CONST
END	//Const

////////// State machine ///////////////

MACHINE "Command"
			
	///////  Seek  ////////////////////////////////////	
	STATE Seek

		RULE	event In
			:action
				SelectShips(1, S.race!=O.race & Distance(S.this, O.Own_Ship)<=15000);	// minden lassan Artillery rangbe r detektalt ellenseges hajo levalogatasa
				If(NumOf(1),
					ChangeState(Defensive, 0)
				);
			:end
		END
		
		RULE	event Tick
			:action
				SelectShips(1, S.race!=O.race & Distance(S.this, O.Own_Ship)<=15000);	// minden lassan Artillery rangbe r detektalt ellenseges hajo levalogatasa
				If(NumOf(1),
					ChangeState(Defensive, 0)
				);
			:end
		END
		Tick 5.5
						
	End 	//STATE Seek

	///////  Defensive  ////////////////////////////////////	
	STATE Defensive

		RULE	event In
			:action
				Miss_Target:=0;
			:end
		END
		
		RULE	event Tick
			:action
				SelectShips(1, S.race!=O.race & Distance(S.this, O.Own_Ship)<=15000);	// minden lassan Artillery rangbe r detektalt ellenseges hajo levalogatasa
				If(NumOf(1)=0,
					ChangeState(Seek, 0);	 		// Keres allapot
					,
					LocalEvent(OpenFire, 0);					
				);
			:end
		END
		Tick 5.5
		
		RULE	event Out
			:action
				If(O.Bazooka, 
					TargetWeapon(O.Bazooka, 0);
				);
			:end
		END

		RULE	event OpenFire
			:action
				If(O.Bazooka:count,
					SelectShips(2, S.race!=O.race & Distance(S.this, O.Own_Ship)<=15000 & Distance(S.this, O.Own_Ship)>=10000);	// minden Artillery rangbe r detektalt ellenseges hajo levalogatasa
					If(NumOf(2), 
						PosM_Target:=PickMax(2, 1/Distance(S.this, O.Own_Ship));
Debug("befW PosM_Target: ", PosM_Target);
Debug("befW Miss_Target: ", Miss_Target);
						While(PosM_Target & Miss_Target=0,						
							RemoveItem(2, PosM_Target);							
							If(Rnd(0,100)<=O.e_var & O.e_r<O.e_rm, 
								Miss_Target:=PosM_Target;
								TargetWeapon(O.Bazooka, Miss_Target);
								Timer(NewTarget, 25, 0);
							,
								If(NumOf(2), 
									PosM_Target:=PickMax(2, 1/Distance(S.this, O.Own_Ship));
								,
									PosM_Target:=0;
								);
							);
Debug("inW PosM_Target: ", PosM_Target);
Debug("inW Miss_Target: ", Miss_Target);
						);
					);
				);

				SelectShips(3, S.race!=O.race & Distance(S.this, O.Own_Ship)<=O.p_tav);	// minden p_tav rangbe r detektalt ellenseges hajo levalogatasa
				Plas_Target:=0;
				If(NumOf(3), 
					Debug(O.p_tav);
					Dump(3);
					PosP_Target:=PickMax(3, 1/Distance(S.this, O.Own_Ship));
Debug("befW PosP_Target: ", PosP_Target);
Debug("befW Plas_Target: ", Plas_Target);
					While(PosP_Target & Plas_Target=0,						
						RemoveItem(3, PosP_Target);
						If(Rnd(0,100)<=O.e_var, 
							Plas_Target:=PosP_Target;
							,
							If(NumOf(3), 
								PosP_Target:=PickMax(3, 1/Distance(S.this, O.Own_Ship));
							,
								PosP_Target:=0;
							);
Debug("inW PosP_Target: ", PosP_Target);
Debug("inW Plas_Target: ", Plas_Target);
						);
					);
					If(Plas_Target, O:tFireTo(C.Plas_Target, 2));
				);
			:end
		END
		
		RULE	event NewTarget
			:action
				O.e_r:=O.e_r+1;
				Miss_Target:=0;
			:end
		END

		RULE	event CO_DeviceDestroyed		
				condition E.device=O.Bazooka
			:action
				O:tClearCommand();
			:end
		END

		RULE	event Deleted
				condition E.ship=Miss_Target|E.ship=Plas_Target
			:action
				ChangeState(Seek, 0);	 		// Keres allapot
			:end
		END


				
	End 	//STATE Defensive
		
END	//MACHINE "Command"

////////// Global command events ///////////////

RULE	event CommandInit
	:action
		DiffLevel:=uDifficultyLevel();
		
		Own_Ship:=this; 				//Store own ship

		tClearForbid(0);
		tSetForbid(#FORBID_MOTION_MOTIVATION);		//Osszes sajat mozgas tiltasa
		tSetForbid(#FORBID_FIRE_MISSILE+#FORBID_FIRE_BOMBER); 	//csak bomberkuldes, raketakuldes tiltva, minden mas tuzeles engedelyezve
		tSetForbid(#FORBID_FIRE_FREE);
		
		SelectDevices(5, Own_Ship, S.weapon & S.working & InSet(S.this, 2) & InSet(S.this, 5));
		Bazooka:=PickFirst(5);

		//e_r trolja, hogy az adott hajra eddig az adott platform hny raktt ltt, x=a haj faja
		//e_rm megadja, hogy egy platform hny raktt kldhet egy faj clpontra
		//e_var megadja, hogy milyen esllyel indt a platform raktt a clpontra, ha minden egyb felttel adott.

		e_r:=0;

	//// Difficulty ////
		ChooseFirst(
			DiffLevel=1,
				e_var:=5;		
				e_rm:=1;
				p_tav:=5000;
			,
			DiffLevel=2,
				e_var:=20;		
				e_rm:=1;
				p_tav:=6000;
			,
			DiffLevel=3,
				LoadWeapon(Bazooka, 2);
				e_var:=50;		
				e_rm:=2;
				p_tav:=10000;
			,
			1,
				e_var:=20;		
				e_rm:=1;
				p_tav:=6000;
		);
	//// Diff End ////
	
		tClearFire();
		
		SelectDevices(18, Own_Ship, InSet(s.this, 18));		//szkenner
		ExecList(18, ActivateDevice(s.this, 1));
	
		If(Bazooka, 
			GetMachine("Command"):ChangeState(Seek, 0);	 		// keres allapot
		);
	:end
END

RULE	event ClearCommand
	:action
		tClearMove();
		tClearFire();
		tClearTerritory();
		CloseOff(Own_ship);

		tClearForbid(0);
		SelectEx(S.weapon & S.owner=Own_Ship, ActivateDevice(S.this, 0));		// minden fegyver kikapcsolasa
	:end
END
