// This file encapsulates the Special Menu functionality
// I tried making this into a state machine but doing so caused
// The IP Jump not to work, so I guess it's just plain old events for now...

// This event is called to open the Special Menu. It will not work if a 
// Special Menu is already open. This is just a precaution however, as it should
// never be possible for the user to try and force such and option. The only
// way it might happen is if a scripter manually calls this event while the menu
// is active. This prevents any embarrasing screw-ups from happening...
RULE event SpecialMenuOpen
	 condition M.aShip=0
	 :action	 	
	 	M.aShip:=E.Ship;
	 	Dialog("SpecialMenuRoot",M.aShip,0);
	 	EnableGUIEvents(1);
	 :end
END

// If you de-select the ship you are currently playing with via the Special
// Menu the menu immediately closes...
RULE event Deselected
	 condition E.Ship=M.aShip
	 :action
	 	DeletePendingDialogs(1);
	 	LocalEvent(SpecialMenuClose,0);
	 :end
END

// Root menu events...
// Include the root menu events
#include "SpecialMenuRoot.inc"

// All child menus are included via include statements...
// Jukebox menu events...
#include "SpecialMenuJukebox.inc"

// IP menu events...
#include "SpecialMenuIP.inc"

// Ship settings events...
// #include "SpecialMenuShipSettings.inc"

// IFF settings events...
// #include "SpecialMenuIFFSettings.inc"

// Status readouts events
// #include "SpecialMenuStatusReadouts.inc"