// This file is included by all the missions. It handles ending the mission
// when the last ship belonging to the player jumps out.

// Long-range jump catcher...
RULE event RunAway
	 condition uGet(E.Ship:name)=U.FlagShip
  	 :action  	 	
  	 	// Create a list of all the player's ships...
  	 	E.CheckList:=GetFreeSel();
  	 	SelectShips(E.CheckList, S:Ship:race=#race_Player);
  	 	// Check if the list is empty. If so, call the exit handler...
  	 	If(NumOf(E.CheckList)=0, LocalEvent(HandleMissionExit, 0));
  	 	// Clear out the temporary list...
  	 	DeleteSelect(E.CheckList);
  	 :end
END

// The nasty bit. Check and determine which mission should come next.
// Relies on the U.FlagShip variable and the special Jump Computer
// support device...
RULE event HandleMissionExit
	 :action
	 	E.CheckList:=GetFreeSel();
	 	SelectDevices(E.CheckList,U.FlagShip,S.devType=401);
	 	JumpComputer:=PickFirst(E.CheckList);	 		 	
	 	// Determine what the next mission should be based on where the flagship is bound...	 	 	
	 	ChooseFirst(JumpComputer.damage=1.0, uSetNextMission(1,1),
	 				JumpComputer.damage=1.5, uSetNextMission(1,2),
	 				JumpComputer.damage=2.0, uSetNextMission(1,3),
	 				JumpComputer.damage=3.0, uSetNextMission(1,4),
	 				JumpComputer.damage=4.0, uSetNextMission(1,5),
	 				JumpComputer.damage=4.25, uSetNextMission(1,6),
	 				JumpComputer.damage=4.5, uSetNextMission(1,7),
	 				JumpComputer.damage=5.0, uSetNextMission(1,8),
	 				JumpComputer.damage=6.0, uSetNextMission(1,9),
	 				JumpComputer.damage=7.0, uSetNextMission(1,10),
	 				JumpComputer.damage=0, uSetNextMission(1, Round(Rnd(1,11))));	 				
	 	// We now end the mission. Transit time is handled elsewhere and is
	 	// handled for ALL ships, not just those in the mission...
	 	Delay(0,2,uQuitMission(1),0);
	 :end
END