#include "getkey.h"
#include <fstream.h>

const int VER_MAJ = 1;
const int VER_MIN = 0;
const int VER_REV = 0;
const char *FLDataFolder = "C:\\Program Files\\Microsoft Games\\Freelancer\\DATA\\";

void outputNickname(const char *folder, const char *name);

void
main() {
	system("@echo off");
	printf("Freelancer INI Nickname Exporter\nBuild %d.%d.%d\nby Silver_Fire\n###############################################################################\n\n",VER_MAJ,VER_MIN,VER_REV);

	// Print Freelancer Data folder
	printf("Freelancer DATA folder:\n%s\n\n",FLDataFolder);
	
	// Check for and parse files in filelist
	apstring buf = "";
	apstring fld = "";
	apstring nme = "";
		
	ifstream filelist("filelist.txt",ios::nocreate);
	while(!filelist.eof()) {
		int idx = 0;

		getline(filelist,buf);
		if(buf == "") break;
		while(!isspace(buf[idx])) idx++;
		fld = buf.substr(0,idx);
		nme = buf.substr(idx+1,buf.length()-idx);
		outputNickname(fld.c_str(),nme.c_str());		
	}

	// Check if there are any more files to check
	printf("\nAny more files to process?\n  Spacebar - No\n  Backspace - Yes");
	char choice = waitkey("\x008 ");
	printf("\n\n");
	if(choice == '\x008') {
		while(1) {
			printf("Enter blank field to exit\n");
			printf("Enter folder:\n>>");
			getline(cin,fld);
			if(fld == "") break;
			printf("Enter name:\n>>");
			getline(cin,nme);
			if(nme == "") break;
			outputNickname(fld.c_str(),nme.c_str());
		}
		printf("\n");
	}
	
	/*// Built-in parse
	outputNickname("Equipment","weapon_equip");
	outputNickname("Audio","sounds");
	outputNickname("FX","effects");
	outputNickname("FX","beam_effects");
	outputNickname("FX","explosions");*/

	printf("Done!");
	getkey();
	printf("\n");
}

void
outputNickname(const char *folder, const char *name) {
	apstring dir = FLDataFolder;
	dir += folder;
	dir += "\\";
	dir += name;
	apstring path = dir;
	path += ".ini";
	apstring filename = name;
	filename += ".txt";
	apstring inFile = name;
	inFile += ".ini";
	
	printf("Processing %s...",inFile.c_str());
	
	ifstream *input = new ifstream(path.c_str(),ios::nocreate);
	FILE *output = fopen(filename.c_str(),"wt");
	apstring data = "";
	// Check for BINI compression
	for(int a = 0;a < 4;a++) {
		char temp;
		*input >> temp;
		data += temp;
	}
	if(data == "BINI") {
		//apstring err = "ERROR: ";
		//err += inFile;
		//err += " is still BINI compressed\nOpen with BiniQDU or similar utility to decompress";
		//cout << endl << err << endl;
		//return;
		input->close();
		delete input;
		printf("\n");
		apstring cmd = "bini \"";
		cmd += path;
		cmd += "\"";
		system(cmd.c_str());
		path += ".txt";
		input = new ifstream(path.c_str());
	}

	while(!input->eof()) {
		getline(*input,data);
		if(data.substr(0,11) == "nickname = ") {
			apstring name = data.substr(11,data.length()-11);
			fprintf(output,"%s\n",name.c_str());
		}
	}
	input->close();
	fclose(output);
	if(path.substr(path.length()-8,8) == ".ini.txt") {
		apstring cmd = "";
		cmd = "del \"";
		cmd += path;
		cmd += "\"";
		system(cmd.c_str());
	}
	cout << "Done!" << endl;
}
