#ifndef _GETKEY_H
#define _GETKEY_H

#include <conio.h>
#include <time.h>
#include <stdlib.h>
#include <iostream.h>
#include <stdio.h>
#include "apstring.h"
#include <limits.h>

const int KEY_ESC		= 	27;
const int KEY_ENTER		=	13;
const int KEY_TAB		=    9;
const int KEY_SPACE		=	32;
const int KEY_BACKSPACE =	 8;

const char	CHAR_UP		=	30;
const char	CHAR_DOWN	=	31;
const char	CHAR_LEFT	=	17;
const char	CHAR_RIGHT	=	16;

const char
getkey(int z=0, char mask=0) {
	char k = 0;
	while(!_kbhit()) {
		k = k;
	}
	if(int(z) == 0 && int(mask) == 0) k = _getch();
	else if(int(z) != 0) k = _getche();
	else if(int(mask) != 0) {
		k = _getch();
		printf("%c",mask);
	}
	else {
		k = _getch();
	}
	while(k <= 0) {
		if(int(z) == 0 && int(mask) == 0) k = _getch();
		else if(int(z) != 0) k = _getche();
		else if(int(mask) != 0) {
			k = _getch();
			printf("%c",mask);
		}
		else {
			k = _getch();
		}
	}
	return k;
}

const char
waitkey(const char *valid = "", int z=0, char mask=0) {
	while(1) {
		char temp = getkey();
		// Check against valid keys
		for(unsigned int x = 0;x < strlen(valid);x++) {
			if(temp == valid[x]) return temp;
		}
	}
}

const int
keytest(int code) {
	char k = 0;
	if(_kbhit()) {
		if((_getch()) == code) return 1;
		else return 0;
	}
	else return 0;
}

const char
message(const char *prompt) {
	printf(prompt);
	char temp = getkey();
	return temp;
}

void
delay(double seconds, int interrupt = 0, int echo = 0) {
	clock_t wait = (clock_t)seconds*CLOCKS_PER_SEC;
	clock_t goal;
	int fullSec = 0;
	int secondCount = 0;
	int tick = 0;
	//int tickOff = 0;
	goal = wait + clock();
	while(goal > (tick = clock())) {
		fullSec = (goal-tick)%CLOCKS_PER_SEC;
		secondCount = (goal-tick)/CLOCKS_PER_SEC;
		//if(fullSec) tickOff = 0;
		if(!fullSec) {// && tickOff != 1) {
			if(echo == 1) {
				cout << secondCount << "..." << endl;
			} else if(echo == 2) {
				cout << (secondCount*-1)+seconds+1 << "..." << endl;
			}
			//tickOff = 1;
		}
		if(interrupt != 0) {
			if(_kbhit()) {
				if(interrupt == 1) {
					char temp = _getche();
					_ungetch(temp);
				}
				break;
			}
		} else {
			if(_kbhit()) {
				_getch();
			}
		}
	}
}

void
clrscr() {
	system("cls");
}

int
randInt(int number) {
	return (rand() % number);
}

int
execute(apstring str) {
	system("@echo off");
	return (system(str.c_str()));
}

apstring
textInput(char *prompt,int maxlen, char mask=0) {
	apstring buffer = "";
	char temp = 0;
	int len = 0;
	if(maxlen == 0) maxlen = INT_MAX;

	while(temp != KEY_ENTER && len < maxlen) {
		clrscr();
		printf(prompt);

		
		if(mask != 0) {
			for(int z = 0;z < len;z++) {
				printf("%c",mask);
			}
		}
		else {
			printf(buffer.c_str());
		}

		temp = getkey();

		if(temp == KEY_BACKSPACE) {
			if(len > 0) {
				apstring tempBuf = buffer;
				buffer = tempBuf.substr(0,tempBuf.length()-1);
				len--;
			}
			continue;
		}
		else if(temp == KEY_ENTER) {
			printf("%c",temp);
			break;
		}

		if(mask == 0) printf("%c",temp);
		else if(mask != 0) printf("%c",mask);

		if(temp != KEY_ENTER) buffer += temp;

		len++;
		temp = 0;
	}
	printf("\n");
	return buffer;
}

#endif