//---------------------------------------------------------------------------
// msCMPImporter.dll - Utilities.h
//
// Header for the miscelaneous stuff - helper functions and usefull classes
//
// Written by Kurt Fitzner <kfitzner@excelcia.org>
// Copyright  2003, Kurt Fitzner
//---------------------------------------------------------------------------
// This file is part of msCMPImporter.
//
// msCMPImporter is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// msCMPImporter is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
#ifndef UtilitiesH
#define UtilitiesH
//---------------------------------------------------------------------------
extern HINSTANCE hModuleDLL;
//---------------------------------------------------------------------------
unsigned int generate_crc (char *string);
AnsiString   TempFileName(AnsiString Extension);
bool         ConvertImage(AnsiString Source, AnsiString Dest);
int          CalcMaxStringWidth( TStrings * List, TWinControl * Control);
//---------------------------------------------------------------------------
// Class TBufferStream
//
// Borland's TMemoryStream hides the only really useful method that its
// base class offers, SetMemory.  Of course it hides it, because otherwise
// TMemoryStream would be far too useful.
//---------------------------------------------------------------------------
class TBufferStream : public TMemoryStream {
  public:
    __fastcall inline      TBufferStream(void *Buffer, int Size) : TMemoryStream() { SetPointer(Buffer, Size); };
    void __fastcall inline SetBuffer(void *Buffer, int Size) { SetPointer(Buffer, Size); }
};  // class TBufferStream
#endif
