//---------------------------------------------------------------------------
// LogDebug.h
//
// Header for the Debug and logging unit
//
// Written by Kurt Fitzner <kfitzner@excelcia.org>
// Copyright  2003, Kurt Fitzner
//---------------------------------------------------------------------------
// This file is part of msCMPImporter.
//
// msCMPImporter is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// msCMPImporter is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
//---------------------------------------------------------------------------

#ifndef TProgramLogH
#define TProgramLogH
//---------------------------------------------------------------------------
class TProgramLog {
  public:
      _fastcall  TProgramLog(AnsiString FileName, bool Synchronous = true, bool OverWrite = true);
      _fastcall ~TProgramLog();
    void _cdecl  LogEntry(AnsiString File, AnsiString Line, AnsiString Message, ...);

    TStack      *FunctionStack;
  protected:
    AnsiString   FileName;
    bool         Synchronous;
  private:
    int          FileHandle;
};  // class TProgramLog
//---------------------------------------------------------------------------


#ifdef _DEBUG
  extern TProgramLog *Log;
  #define __ENTERFUNCTION__ if (Log) { \
                              AnsiString *Func = new AnsiString(__FUNC__); \
                              Log->FunctionStack->Push(Func); \
                              Log->LogEntry(__FILE__, __LINE__, "-> Entering %s()", __FUNC__); \
                            }
  #define __LEAVEFUNCTION__ if (Log) { \
                              if (Log->FunctionStack->AtLeast(1)) \
                                delete (AnsiString *)Log->FunctionStack->Pop(); \
                              Log->LogEntry(__FILE__, __LINE__, "<- Leaving  %s()", __FUNC__); \
                            }
  #define LOG(FILE,LINE,STRING) \
                            if (Log) { \
                              Log->LogEntry(FILE, LINE, STRING);  \
                            }

  #define LOG1(FILE,LINE,STRING,ARG1) \
                            if (Log) { \
                              Log->LogEntry(FILE, LINE, STRING, ARG1);  \
                            }
#else
  #define __ENTERFUNCTION__ ;
  #define __LEAVEFUNCTION__ ;
  #define LOG(FILE,LINE,STRING) ;
  #define LOG1(FILE,LINE,STRING,ARG1) ;
#endif

#endif



