//---------------------------------------------------------------------------
// LogDebug.cpp
//
// Debug and logging unit
//
// Written by Kurt Fitzner <kfitzner@excelcia.org>
// Copyright  2003, Kurt Fitzner
//---------------------------------------------------------------------------
// This file is part of msCMPImporter.
//
// msCMPImporter is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// msCMPImporter is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
//---------------------------------------------------------------------------


#include <vcl.h>
#include <windows.h>
#pragma hdrstop

#include <stdio.h>
#include <StrUtils.hpp>

#include "TProgramLog.h"



//---------------------------------------------------------------------------
// TProgramLog()
//
// Class constructor
//
// Takes:   AnsiString filename
// Throws:  Nothing
//---------------------------------------------------------------------------
__fastcall TProgramLog::TProgramLog(AnsiString FileName, bool Synchronous, bool OverWrite)
{
  FunctionStack = new TStack;
  if (OverWrite)
    DeleteFile(FileName);
  if (!FileExists(FileName)) {
    FileHandle = FileCreate(FileName);
    FileClose(FileHandle);
  }  // if (!FileExists(FileName))
  if (!Synchronous) {
    FileHandle = FileOpen(FileName, fmOpenReadWrite);
    FileSeek(FileHandle, 0, 2);
  } else
    FileHandle = -1;
  this->FileName = ExpandFileName(FileName);
  this->Synchronous = Synchronous;
}  // _fastcall TProgramLog::TProgramLog(AnsiString FileName, bool Synchronous, bool OverWrite)
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
// ~TProgramLog()
//
// C'est une destructor
//
// Throws: Nothing
//---------------------------------------------------------------------------
__fastcall TProgramLog::~TProgramLog()
{
  if (FileHandle != -1)
    FileClose(FileHandle);
  delete FunctionStack;
}  // __fastcall TProgramLog::~TProgramLog()
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
// LogEntry()
//
// Write an entry into the log.
//
// Takes:   AnsiString with the filename, AnsiString with the line numnber,
//          a message with optional "printf" style format specifiers. and
//          optional arguments
// Returns: Nothing
// Throws:  Nothing
//---------------------------------------------------------------------------
void _cdecl TProgramLog::LogEntry(AnsiString File, AnsiString Line, AnsiString Message, ...)
{
  if (FileHandle == -1) {
    FileHandle = FileOpen(FileName, fmOpenReadWrite);
    FileSeek(FileHandle, 0, 2);
  }  // if (FileHandle == -1)

  if (FileHandle != -1) {
    char           Buffer[256];
    int            Count;
    unsigned short Hour, Minute, Second, MSec;
    AnsiString TimeStamp = "";

    TDateTime().CurrentTime().DecodeTime(&Hour, &Minute, &Second, &MSec);
    TimeStamp = TDateTime().CurrentDateTime().FormatString("ddmmmyyyy hh:nn:ss.") + String().sprintf("%3.3hu", MSec);

    Count = vsnprintf(Buffer, sizeof(Buffer)-1, (String("[") + TimeStamp + String("]-[") + LeftStr(ExtractFileName(File)+"                ",16) + String(":") + RightStr("000" + Line, 4) + "] " + Message + String("\r\n")).c_str(), &Message + 1);
    Buffer[Count] = '\000';
    FileWrite(FileHandle, Buffer, Count);
    if (Synchronous) {
      FileClose(FileHandle);
      FileHandle = -1;
    }  // if (Synchronous)
  }  //   if (FIleHandle != -1)
}  // void _cdecl LogEntry(AnsiString File, AnsiString Line, AnsiString Message, ...)
//---------------------------------------------------------------------------
#pragma package(smart_init)



