//---------------------------------------------------------------------------
// TPlugin.h
//
// TPlugin class implementation unit header file.  TPlugin is derived from
// the TMsPlugin class - a mostly virtual base class that sets the framework
// up for a Milkshape plugin.
//
// Written by Kurt Fitzner <kfitzner@excelcia.org>
// Copyright  2003-2005, Kurt Fitzner
//---------------------------------------------------------------------------
// This file is part of msCMPImporter.
//
// msCMPImporter is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// msCMPImporter is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
//---------------------------------------------------------------------------

#ifndef TPlugInH
#define TPlugInH
//---------------------------------------------------------------------------
#include <AppEvnts.hpp>

#include "msPlugin.h"
//---------------------------------------------------------------------------
extern HINSTANCE hModuleDLL;
//---------------------------------------------------------------------------
struct msModel;


class TPlugIn : public TMsPlugIn {

public:                                          // Fill in the virtual methods for the base class
	__msfastcall TPlugIn ();
  __msfastcall ~TPlugIn ();

  int                 __msfastcall GetType(void);
  const char *        __msfastcall GetTitle(void);
  int                 _stdcall     Execute(msModel *Model);

private:                                         // Do the real work in these methods
  int                 __fastcall   DoExecute(msModel *Model);

private:
  const int           PluginType;
  AnsiString          PluginTitle;
  AnsiString          BinDir;

private:                                        // Do not change this or the plugin will not work
//  void __inline __declspec(naked) ExecuteEpilog(void) {__emit__(0x89,0xEC, 0x5D, 0xC2, 0x08, 0x00, 0x90, 0x90);}
};
//---------------------------------------------------------------------------
#endif
