//---------------------------------------------------------------------------
// TPlugin.cpp
//
// TPlugin class implementation unit.  TPlugin is derived from the TMsPlugin
// class - a mostly virtual base class that sets the framework up for a
// Milkshape plugin.
//
// Written by Kurt Fitzner <kfitzner@excelcia.org>
// Copyright  2003-2005, Kurt Fitzner
//---------------------------------------------------------------------------
// This file is part of msCMPImporter.
//
// msCMPImporter is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// msCMPImporter is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
//---------------------------------------------------------------------------

#include <vcl.h>
#include <windows.h>
#pragma hdrstop

#include <stdio.h>

#include "msPlugin.h"
#include "TCMPImporter.h"
#include "TProgramLog.h"
#include "TPlugIn.h"

//---------------------------------------------------------------------------
// TPlugIn::TPlugin()
//
// Constructor for TPlugin, our plugin class derived from TMsPlugin
// It initializes the constant PluginType - change the initialization to
// match the type of plugin you want.
//
// Takes:   Nothing
// Returns: It's a constructor
// Throws:  Nothing
//---------------------------------------------------------------------------
__msfastcall TPlugIn::TPlugIn(void) : PluginType(eTypeImport)
{
  char buffer[256];

  __ENTERFUNCTION__;

  PluginTitle = "Freelancer CMP Importer";

  if (!GetModuleFileName(hModuleDLL, buffer, 256))
    BinDir = "";
  else
    BinDir = ExtractFileDir(buffer);
  Application->HelpFile = BinDir + "\\msCMPImporter.hlp";

  __LEAVEFUNCTION__;
}  // TPlugIn::TPlugIn(void)
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
// TPlugIn::~TPlugin()
//
// Destructor for TPlugin, our plugin class derived from TMsPlugin
//
// Takes:   It's a destructor
// Returns: It's a destructor
// Throws:  Nothing
//---------------------------------------------------------------------------
__msfastcall TPlugIn::~TPlugIn()
{
  __ENTERFUNCTION__;
  __LEAVEFUNCTION__;
}  // TPlugIn::~TPlugIn()
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// TPlugIn::GetType()
//
// Returns an enumerated value telling MilkShape what kind of plugin this is
// See msPlugin.h for the different types.
//
// Takes:   Nothing
// Returns: Integer indicating the type of plugin
// Throws:  Nothing
//---------------------------------------------------------------------------
int __msfastcall TPlugIn::GetType(void)
{
  __ENTERFUNCTION__;
  __LEAVEFUNCTION__;
  return PluginType;                            // Set this to change the plugin type
}  // int TPlugIn::GetType(void)
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
// TPlugIn::GetTitle
//
// Tells MilkShape the title of the plugin
//
// Takes:   Nothing
// Returns: Pointer to a null-terminated string with the plugin's title
// Throws:  Nothing
//---------------------------------------------------------------------------
const char * __msfastcall TPlugIn::GetTitle(void)
{
  __ENTERFUNCTION__;
  __LEAVEFUNCTION__;
  return PluginTitle.c_str();
}  // const char *TPlugIn::GetTitle(void)
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
// TPlugIn::Execute()
//
// Main function for the plugin called by MilkShape
//
// Takes:   Pointer to a msModel class
// Returns: Integer
// Throws:  Nothing.
//---------------------------------------------------------------------------
int _stdcall TPlugIn::Execute(msModel *Model)
{/*
  #-------------------------------------------------------------------------
  # Do not remove the following #include - it is the prolog code for this
  # function used to get around a bug in BC++ Builder
  #------------------------------------------------------------------------- */
  # include "ExecuteProlog.hpp"                                              /*
  #------------------------------------------------------------------------- */

  __ENTERFUNCTION__;
  int retval = DoExecute(Model);
  __LEAVEFUNCTION__;
  return retval;

}  // int TPlugIn::Execute(msModel *Model)
#pragma package(smart_init)

//---------------------------------------------------------------------------
// TPlugIn::DoExecute()
//
// Do the real work of importing.  All the putzing around with the prolog &
// epilog code in Execute() screws up the exception handling (probably
// because it doesn't know how to unwind the stack properly), so we do all
// the work in this function (which is a pretty normal function).
//
// Takes:   Pointer to a msModel class
// Returns: Integer
// Throws:  Nothing yet
//---------------------------------------------------------------------------
int __fastcall TPlugIn::DoExecute(msModel *Model)
{
  __ENTERFUNCTION__;

  if (!Model) {
    __LEAVEFUNCTION__;
    return -1;
  }  // if (!Model)

  try {
    TCMPImporter *CMPImporter;
    Application->CreateForm(__classid(TCMPImporter), &CMPImporter);
    CMPImporter->Execute(Model);
    CMPImporter->Release();
  }  // try
  catch (...) {
    #ifdef _DEBUG
    if (Log) {
      AnsiString Trace = "Unhandled exception occured in function " + *(AnsiString *)Log->FunctionStack->Peek();
      delete (AnsiString *)Log->FunctionStack->Pop();
      while (Log->FunctionStack->AtLeast(1)) {
        Trace += " called by " + *(AnsiString *)Log->FunctionStack->Peek();
        delete (AnsiString *)Log->FunctionStack->Pop();
      }  // while (Log->FunctionStack->AtLeast(1))
      MessageDlg(WrapText(Trace), mtError, TMsgDlgButtons() << mbOK, 0);
    }  // if (Log)
    else
    #else
    MessageDlg("Unhandled exception occured - cannot determine location", mtError, TMsgDlgButtons() << mbOK, 0);
    #endif
    return -1;
  }
  __LEAVEFUNCTION__;
  return 0;
}  // int __fastcall TPlugIn::DoExecute(msModel *Model)



