//---------------------------------------------------------------------------
// msCMPImporter.dll - TCMPImporter.h
//
// Header for the main import form and code.
//
// Written by Kurt Fitzner <kfitzner@excelcia.org>
// Copyright  2003, Kurt Fitzner
//---------------------------------------------------------------------------
// This file is part of msCMPImporter.
//
// msCMPImporter is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// msCMPImporter is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
//---------------------------------------------------------------------------

#ifndef TCMPImporterH
#define TCMPImporterH
//---------------------------------------------------------------------------
#include "TUTFFile.h"
#include "TVMesh.h"

#include "CSPIN.h"
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <Buttons.hpp>
#include <ComCtrls.hpp>
#include <ExtCtrls.hpp>
#include <Dialogs.hpp>
#include <ImgList.hpp>
#include <Grids.hpp>
#include <Outline.hpp>
//---------------------------------------------------------------------------
extern HINSTANCE hModuleDLL;
//---------------------------------------------------------------------------
class TCMPImporter : public TForm
{
__published:	// IDE-managed Components
  TPanel       *pnlClient;
  TGroupBox    *pnlFile;
  TEdit        *edtFileName;
  TSpeedButton *btnOpen;
  TGroupBox    *pnlLOD;
  TPanel       *pnlLODClient;
  TLabel       *lblLODPanelCaptionShadow;
  TLabel       *lblLODPanelCaptionHighlight;
  TListBox     *lbLOD;
  TGroupBox    *pnlMaterials;
  TLabel       *lblMaterialPanelCaptionShadow;
  TLabel       *lblMaterialPanelCaptionHighlight;
  TEdit        *edtMaterialLibrary;
  TSpeedButton *btnScan;
  TListBox     *lbMaterials;
  TGroupBox    *gbOptions;
  TCheckBox    *checkExtract;
  TRadioButton *radioTarga;
  TRadioButton *radioBMP;
  TRadioButton *radioJPEG;
  TCheckBox    *checkScale;
  TLabel       *lblScaleX;
  TCSpinEdit   *spinX;
  TLabel       *lblScaleY;
  TCSpinEdit   *spinY;
  TLabel       *lblScaleZ;
  TCSpinEdit   *spinZ;
  TPanel       *pnlButtons;
  TBitBtn      *btnOK;
  TBitBtn      *btnCancel;
  TBitBtn      *btnHelp;
  TStatusBar   *StatusBar;
  TOpenDialog  *OpenDialog;
  TImageList   *ImageList;
  TOpenDialog  *ScanDialog;
  TCheckBox    *checkLeaveDDS;

  void __fastcall btnOpenClick(TObject *Sender);
  void __fastcall FormShow(TObject *Sender);
  void __fastcall FormActivate(TObject *Sender);
  void __fastcall lbLODClick(TObject *Sender);
  void __fastcall btnOKClick(TObject *Sender);
  void __fastcall lbMaterialsDrawItem(TWinControl *Control, int Index, TRect &Rect, TOwnerDrawState State);
  void __fastcall StatusBarDrawPanel(TStatusBar *StatusBar, TStatusPanel *Panel, const TRect &Rect);
  void __fastcall btnScanClick(TObject *Sender);
  void __fastcall checkScaleClick(TObject *Sender);
  void __fastcall checkExtractClick(TObject *Sender);

public:		// User declarations
  __fastcall  TCMPImporter(TComponent* Owner);
  __fastcall ~TCMPImporter();

  int __fastcall Execute(msModel *pModel);
  void FileDropHandler(TWMDropFiles Message);

protected:
  enum TPanelIdent  {panelFile, panelLOD, panelMaterials};
  enum TPanelStatus {statusDisabled, statusEnabled, statusCurrent};

  AnsiString FLDir;
  AnsiString TextureDir;
  AnsiString LastDir;
  AnsiString ModelFileName;

  void __fastcall OpenCMPFile(AnsiString FileName);
  void __fastcall ScanMaterials(AnsiString FileName);
  void __fastcall UpdatePanels(void);
  void __fastcall UpdatePanel(TPanelIdent Panel, TPanelStatus Status);
  void __fastcall UpdateStatusBar(int MeshCount, int TriangleCount, int VerticeCount, int MaterialCount, int MaterialIDCount = 0);

private:	// User declarations
  bool         FirstActivate;
  AnsiString   CMPFileName;
  TUTFFile    *CMPFile;
  TVMesh      *VMesh;
  TWndMethod   edtFileNameOldMessageHandler;
  TWndMethod   pnlMaterialsOldMessageHandler;
  msModel     *Model;

  void __fastcall FormActivateFirst(TObject *Sender);
  void __fastcall edtFileNameMessageHandler(TMessage &Message);
  void __fastcall pnlMaterialsMessageHandler(TMessage &Message);

  // These are some structs used when the importer scans some ancillary data
  // in the UTF file.
  #pragma pack(push, 4)
  struct TRawVMeshRef {
    DWORD Signature1;                            // Always 0x0000003C ??
    DWORD VMeshID;
    WORD  StartVertex;
    WORD  EndVertex;
    WORD  StartVertexRef;
    WORD  EndVertexRef;
    WORD  StartMesh;
    WORD  MeshCount;
    float BoundingBox[6];
    float Unknown[4];
  };  // struct TRawVMeshRef  - 60 bytes, so 4-byte allignment
  #pragma pack(pop)

  struct TRawFixedCons {
    char  RootName[64];
    char  PartName[64];
    float OriginX;
    float OriginY;
    float OriginZ;
    float One;
    char  Unknown[32];
  };  // struct TRawFixedCons  - 176 bytes

  struct TRawRevoluteCons {
    char  RootName[64];
    char  PartName[64];
    float OriginX;
    float OriginY;
    float OriginZ;
    float One;
    char Unknown[64];
  };  // struct TRawRevoluteCons - 208 bytes

  #pragma pack(push,4)
  struct TRawSphereCons {
    char  RootName[64];
    char  PartName[64];
    float OriginX;
    float OriginY;
    float OriginZ;
    float One;
    char Unknown[68];
  };  // struct TRawSphereCons - 212 bytes
  #pragma pack(pop)

};
//---------------------------------------------------------------------------
// extern PACKAGE TCMPImporter *CMPImporter;
//---------------------------------------------------------------------------
#endif
