/**********************************************************************
 *
 * MilkShape 3D Model Import/Export API
 *
 * May 10 2000, Mete Ciragan, chUmbaLum sOft
 *
 * Ported to Borland C++ Builder by Kurt Fitzner <kfitzner@excelcia.org>
 *
 **********************************************************************/

#ifndef __MSLIB_H__
#define __MSLIB_H__



#ifdef MSLIB_EXPORTS
#define MSLIB_API __declspec(dllexport)
#else
#define MSLIB_API __declspec(dllimport)
#endif /* MSLIB_EXPORTS */

#define MSLIBDECL _cdecl

#pragma pack(push, 1);

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */



/**********************************************************************
 *
 * Constants
 *
 **********************************************************************/

#define MS_MAX_NAME             32
#define MS_MAX_PATH             256



/**********************************************************************
 *
 * Types
 *
 **********************************************************************/

#ifndef byte
typedef unsigned char byte;
#endif /* byte */

#ifndef word
typedef unsigned short word;
#endif /* word */

typedef float   msVec4[4];
typedef float   msVec3[3];
typedef float   msVec2[2];

/* msFlag */
typedef enum {
    eSelected = 1, eSelected2 = 2, eHidden = 4, eDirty = 8, eAveraged = 16, eUnused = 32
} msFlag;

/* msVertex */
typedef struct msVertex
{
    byte        nFlags;
    msVec3      Vertex;
    float       u, v;
    char        nBoneIndex;
} msVertex;

/* msTriangle */
typedef struct
{
    word        nFlags;
    word        nVertexIndices[3];
    word        nNormalIndices[3];
    msVec3      Normal;
    byte        nSmoothingGroup;
} msTriangle;

/* msMesh */
typedef struct msMesh
{
    byte        nFlags;
    char        szName[MS_MAX_NAME];
    char        nMaterialIndex;
    
    word        nNumVertices;
    word        nNumAllocedVertices;
    msVertex*   pVertices;

    word        nNumNormals;
    word        nNumAllocedNormals;
    msVec3*     pNormals;

    word        nNumTriangles;
    word        nNumAllocedTriangles;
    msTriangle* pTriangles;
} msMesh;

/* msMaterial */
typedef struct msMaterial
{
    int         nFlags;
    char        szName[MS_MAX_NAME];
    msVec4      Ambient;
    msVec4      Diffuse;
    msVec4      Specular;
    msVec4      Emissive;
    float       fShininess;
    float       fTransparency;
    char        szDiffuseTexture[MS_MAX_PATH];
    char        szAlphaTexture[MS_MAX_PATH];
    int         nName;
} msMaterial;

/* msPositionKey */
typedef struct msPositionKey
{
    float       fTime;
    msVec3      Position;
} msPositionKey;

/* msRotationKey */
typedef struct msRotationKey
{
    float   fTime;
    msVec3  Rotation;
} msRotationKey;

/* msBone */
typedef struct msBone
{
    int             nFlags;
    char            szName[MS_MAX_NAME];
    char            szParentName[MS_MAX_NAME];
    msVec3          Position;
    msVec3          Rotation;

    int             nNumPositionKeys;
    int             nNumAllocedPositionKeys;
    msPositionKey*  pPositionKeys;

    int             nNumRotationKeys;
    int             nNumAllocedRotationKeys;
    msRotationKey*  pRotationKeys;
} msBone;

/* msModel */
typedef struct msModel
{
    int         nNumMeshes;
    int         nNumAllocedMeshes;
    msMesh*     pMeshes;

    int         nNumMaterials;
    int         nNumAllocedMaterials;
    msMaterial* pMaterials;

    int         nNumBones;
    int         nNumAllocedBones;
    msBone*     pBones;

    int         nFrame;
    int         nTotalFrames;

    msVec3      Position;
    msVec3      Rotation;
} msModel;



/**********************************************************************
 *
 * MilkShape 3D Interface
 *
 **********************************************************************/

/**********************************************************************
 * msModel
 **********************************************************************/

MSLIB_API void          MSLIBDECL msModel_Destroy (msModel *pModel);

MSLIB_API int           MSLIBDECL msModel_GetMeshCount (msModel *pModel);
MSLIB_API int           MSLIBDECL msModel_AddMesh (msModel *pModel);
MSLIB_API msMesh*       MSLIBDECL msModel_GetMeshAt (msModel *pModel, int nIndex);
MSLIB_API int           MSLIBDECL msModel_FindMeshByName (msModel *pModel, const char *szName);

MSLIB_API int           MSLIBDECL msModel_GetMaterialCount (msModel *pModel);
MSLIB_API int           MSLIBDECL msModel_AddMaterial (msModel *pModel);
MSLIB_API msMaterial*   MSLIBDECL msModel_GetMaterialAt (msModel *pModel, int nIndex);
MSLIB_API int           MSLIBDECL msModel_FindMaterialByName (msModel *pModel, const char *szName);

MSLIB_API int           MSLIBDECL msModel_GetBoneCount (msModel *pModel);
MSLIB_API int           MSLIBDECL msModel_AddBone (msModel *pModel);
MSLIB_API msBone*       MSLIBDECL msModel_GetBoneAt (msModel *pModel, int nIndex);
MSLIB_API int           MSLIBDECL msModel_FindBoneByName (msModel *pModel, const char *szName);

MSLIB_API int           MSLIBDECL msModel_SetFrame (msModel *pModel, int nFrame);
MSLIB_API int           MSLIBDECL msModel_GetFrame (msModel *pModel);
MSLIB_API int           MSLIBDECL msModel_SetTotalFrames (msModel *pModel, int nTotalFrames);
MSLIB_API int           MSLIBDECL msModel_GetTotalFrames (msModel *pModel);
MSLIB_API void          MSLIBDECL msModel_SetPosition (msModel *pModel, msVec3 Position);
MSLIB_API void          MSLIBDECL msModel_GetPosition (msModel *pModel, msVec3 Position);
MSLIB_API void          MSLIBDECL msModel_SetRotation (msModel *pModel, msVec3 Rotation);
MSLIB_API void          MSLIBDECL msModel_GetRotation (msModel *pModel, msVec3 Rotation);

/**********************************************************************
 * msMesh
 **********************************************************************/

MSLIB_API void          MSLIBDECL msMesh_Destroy (msMesh *pMesh);
MSLIB_API void          MSLIBDECL msMesh_SetFlags (msMesh *pMesh, byte nFlags);
MSLIB_API byte          MSLIBDECL msMesh_GetFlags (msMesh *pMesh);
MSLIB_API void          MSLIBDECL msMesh_SetName (msMesh *pMesh, const char *szName);
MSLIB_API void          MSLIBDECL msMesh_GetName (msMesh *pMesh, char *szName, int nMaxLength);
MSLIB_API void          MSLIBDECL msMesh_SetMaterialIndex (msMesh *pMesh, int nIndex);
MSLIB_API int           MSLIBDECL msMesh_GetMaterialIndex (msMesh *pMesh);

MSLIB_API int           MSLIBDECL msMesh_GetVertexCount (msMesh *pMesh);
MSLIB_API int           MSLIBDECL msMesh_AddVertex (msMesh *pMesh);
MSLIB_API msVertex*     MSLIBDECL msMesh_GetVertexAt (msMesh *pMesh, int nIndex);
MSLIB_API msVertex*     MSLIBDECL msMesh_GetInterpolatedVertexAt (msMesh *pMesh, int nIndex); // NOT YET IMPLEMENTED

MSLIB_API int           MSLIBDECL msMesh_GetTriangleCount (msMesh *pMesh);
MSLIB_API int           MSLIBDECL msMesh_AddTriangle (msMesh *pMesh);
MSLIB_API msTriangle*   MSLIBDECL msMesh_GetTriangleAt (msMesh *pMesh, int nIndex);

MSLIB_API int           MSLIBDECL msMesh_GetVertexNormalCount (msMesh *pMesh);
MSLIB_API int           MSLIBDECL msMesh_AddVertexNormal (msMesh *pMesh);
MSLIB_API void          MSLIBDECL msMesh_SetVertexNormalAt (msMesh *pMesh, int nIndex, msVec3 Normal);
MSLIB_API void          MSLIBDECL msMesh_GetVertexNormalAt (msMesh *pMesh, int nIndex, msVec3 Normal);
MSLIB_API void          MSLIBDECL msMesh_GetInterpolatedVertexNormalAt (msMesh *pMesh, int nIndex, msVec3 Normal); // NOT YET IMPLEMENTED

/**********************************************************************
 * msTriangle
 **********************************************************************/

MSLIB_API void          MSLIBDECL msTriangle_SetFlags (msTriangle* pTriangle, word nFlags);
MSLIB_API word          MSLIBDECL msTriangle_GetFlags (msTriangle* pTriangle);
MSLIB_API void          MSLIBDECL msTriangle_SetVertexIndices (msTriangle *pTriangle, word nIndices[]);
MSLIB_API void          MSLIBDECL msTriangle_GetVertexIndices (msTriangle *pTriangle, word nIndices[]);
MSLIB_API void          MSLIBDECL msTriangle_SetNormalIndices (msTriangle *pTriangle, word nNormalIndices[]);
MSLIB_API void          MSLIBDECL msTriangle_GetNormalIndices (msTriangle *pTriangle, word nNormalIndices[]);
MSLIB_API void          MSLIBDECL msTriangle_SetSmoothingGroup (msTriangle *pTriangle, byte nSmoothingGroup);
MSLIB_API byte          MSLIBDECL msTriangle_GetSmoothingGroup (msTriangle *pTriangle);

/**********************************************************************
 * msVertex
 **********************************************************************/

MSLIB_API void          MSLIBDECL msVertex_SetFlags (msVertex* pVertex, byte nFlags);
MSLIB_API byte          MSLIBDECL msVertex_GetFlags (msVertex* pVertex);
MSLIB_API void          MSLIBDECL msVertex_SetVertex (msVertex* pVertex, msVec3 Vertex);
MSLIB_API void          MSLIBDECL msVertex_GetVertex (msVertex* pVertex, msVec3 Vertex);
MSLIB_API void          MSLIBDECL msVertex_SetTexCoords (msVertex* pVertex, msVec2 st);
MSLIB_API void          MSLIBDECL msVertex_GetTexCoords (msVertex* pVertex, msVec2 st);
MSLIB_API int           MSLIBDECL msVertex_SetBoneIndex (msVertex* pVertex, int nBoneIndex);
MSLIB_API int           MSLIBDECL msVertex_GetBoneIndex (msVertex* pVertex);

/**********************************************************************
 * msMaterial
 **********************************************************************/

MSLIB_API void          MSLIBDECL msMaterial_SetName (msMaterial *pMaterial, const char *szName);
MSLIB_API void          MSLIBDECL msMaterial_GetName (msMaterial *pMaterial, char *szName, int nMaxLength);
MSLIB_API void          MSLIBDECL msMaterial_SetAmbient (msMaterial *pMaterial, msVec4 Ambient);
MSLIB_API void          MSLIBDECL msMaterial_SetAmbient (msMaterial *pMaterial, msVec4 Ambient);
MSLIB_API void          MSLIBDECL msMaterial_GetAmbient (msMaterial *pMaterial, msVec4 Ambient);
MSLIB_API void          MSLIBDECL msMaterial_SetDiffuse (msMaterial *pMaterial, msVec4 Diffuse);
MSLIB_API void          MSLIBDECL msMaterial_GetDiffuse (msMaterial *pMaterial, msVec4 Diffuse);
MSLIB_API void          MSLIBDECL msMaterial_SetSpecular (msMaterial *pMaterial, msVec4 Specular);
MSLIB_API void          MSLIBDECL msMaterial_GetSpecular (msMaterial *pMaterial, msVec4 Specular);
MSLIB_API void          MSLIBDECL msMaterial_SetEmissive (msMaterial *pMaterial, msVec4 Emissive);
MSLIB_API void          MSLIBDECL msMaterial_GetEmissive (msMaterial *pMaterial, msVec4 Emissive);
MSLIB_API void          MSLIBDECL msMaterial_SetShininess (msMaterial *pMaterial, float fShininess);
MSLIB_API float         MSLIBDECL msMaterial_GetShininess (msMaterial *pMaterial);
MSLIB_API void          MSLIBDECL msMaterial_SetTransparency (msMaterial *pMaterial, float fTransparency);
MSLIB_API float         MSLIBDECL msMaterial_GetTransparency (msMaterial *pMaterial);
MSLIB_API void          MSLIBDECL msMaterial_SetDiffuseTexture (msMaterial *pMaterial, const char *szDiffuseTexture);
MSLIB_API void          MSLIBDECL msMaterial_GetDiffuseTexture (msMaterial *pMaterial, char *szDiffuseTexture, int nMaxLength);
MSLIB_API void          MSLIBDECL msMaterial_SetAlphaTexture (msMaterial *pMaterial, const char *szAlphaTexture);
MSLIB_API void          MSLIBDECL msMaterial_GetAlphaTexture (msMaterial *pMaterial, char *szAlphaTexture, int nMaxLength);

/**********************************************************************
 * msBone
 **********************************************************************/

MSLIB_API void          MSLIBDECL msBone_Destroy (msBone *pBone);
MSLIB_API void          MSLIBDECL msBone_SetFlags (msBone *pBone, int nFlags);
MSLIB_API int           MSLIBDECL msBone_GetFlags (msBone *pBone);
MSLIB_API void          MSLIBDECL msBone_SetName (msBone *pBone, const char *szName);
MSLIB_API void          MSLIBDECL msBone_GetName (msBone *pBone, char *szName, int nMaxLength);
MSLIB_API void          MSLIBDECL msBone_SetParentName (msBone *pBone, const char *szParentName);
MSLIB_API void          MSLIBDECL msBone_GetParentName (msBone *pBone, char *szParentName, int nMaxLength);
MSLIB_API void          MSLIBDECL msBone_SetPosition (msBone *pBone, msVec3 Position);
MSLIB_API void          MSLIBDECL msBone_GetPosition (msBone *pBone, msVec3 Position);
MSLIB_API void          MSLIBDECL msBone_GetInterpolatedPosition (msBone *pBone, msVec3 Position); // NOT YET IMPLEMENTED
MSLIB_API void          MSLIBDECL msBone_SetRotation (msBone *pBone, msVec3 Rotation);
MSLIB_API void          MSLIBDECL msBone_GetRotation (msBone *pBone, msVec3 Rotation);
MSLIB_API void          MSLIBDECL msBone_GetInterpolatedRotation (msBone *pBone, msVec3 Rotation); // NOT YET IMPLEMENTED

MSLIB_API int           MSLIBDECL msBone_GetPositionKeyCount (msBone *pBone);
MSLIB_API int           MSLIBDECL msBone_AddPositionKey (msBone *pBone, float fTime, msVec3 Position);
MSLIB_API msPositionKey* MSLIBDECL msBone_GetPositionKeyAt (msBone *pBone, int nIndex);

MSLIB_API int           MSLIBDECL msBone_GetRotationKeyCount (msBone *pBone);
MSLIB_API int           MSLIBDECL msBone_AddRotationKey (msBone *pBone, float fTime, msVec3 Rotation);
MSLIB_API msRotationKey* MSLIBDECL msBone_GetRotationKeyAt (msBone *pBone, int nIndex);



#ifdef __cplusplus
}
#endif /* __cplusplus */


#pragma pack(pop)
#endif /* __MSLIB_H__ */
