//---------------------------------------------------------------------------
// msCMPImporter.dll - MainUnit.cpp
//
// Main unit for the plugin.  Contains the only exported functions needed
// by the .dll - the DllMain() and CreatePlugIn() functions.
//
// Written by Kurt Fitzner <kfitzner@excelcia.org>
// Copyright  2003-2005, Kurt Fitzner
//---------------------------------------------------------------------------
// This file is part of msCMPImporter.
//
// msCMPImporter is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// msCMPImporter is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
//---------------------------------------------------------------------------

#include <vcl.h>
#include <windows.h>
#pragma hdrstop

#include "TPlugIn.h"
#include "TProgramLog.h"
#include "MainUnit.h"

#pragma argsused
//---------------------------------------------------------------------------
HINSTANCE    hModuleDLL;
#ifdef _DEBUG
TProgramLog *Log = NULL;
#endif
//---------------------------------------------------------------------------
// DllMain()
//
// Main entry point for the DLL
//---------------------------------------------------------------------------
int WINAPI DllEntryPoint(HINSTANCE hinst, unsigned long reason, void* lpReserved)
{
  static HWND Handle;

  LOG1(__FILE__, __LINE__, "-> Entering %s()", __FUNC__);

  switch (reason) {
    case DLL_PROCESS_ATTACH:
      #ifdef _DEBUG
      Log = new TProgramLog("c:\\msCMPImporter.log", true, true);
      Log->LogEntry(__FILE__, __LINE__, "-> Log objected created in DllEntryPoint()");
      #endif
      LOG(__FILE__, __LINE__, "   DllEntryPoint(): Creating DLL Handle.");
      Handle = Application->Handle;
      LOG(__FILE__, __LINE__, "   DllEntryPoint(): Initializaing Application object.");
      Application->Initialize();
      // Application->CreateHandle();
      // Application->Handle = GetActiveWindow();
      LOG(__FILE__, __LINE__, "   DllEntryPoint(): Initializaing hModuleDLL.");
      hModuleDLL = hinst;
      break;

    case DLL_THREAD_ATTACH:
    case DLL_THREAD_DETACH:
      break;

    case DLL_PROCESS_DETACH:
      LOG(__FILE__, __LINE__, "   DllEntryPoint(): Restoring original application handle.");
      Application->Handle = Handle;
      #ifdef _DEBUG
      if (Log) {
        Log->LogEntry(__FILE__, __LINE__, "<- Terminating Log object in DllEntryPoint()");
        delete Log;
        Log = NULL;
      }  // if (Log)
      #endif
      break;
  }  // switch (fdwReason)
  LOG1(__FILE__, __LINE__, "-> Leaving %s()", __FUNC__);
  return true;
}
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// CreatePlugin()
//
// The only function we export - this creates a new instance of TPlugin
// and returns a pointer to it.
//
// Takes:   Nothing
// Returns: Pointer to a TMsPlugin class
// Throws:  bad_alloc exception if the 'new' fails
//---------------------------------------------------------------------------
extern "C" TMsPlugIn * CreatePlugIn(void)
{
  TMsPlugIn *Plugin = new TPlugIn;

  return(Plugin);
}  // TMsPlugIn* CreatePlugIn(void)
//---------------------------------------------------------------------------

