//---------------------------------------------------------------------------
// LogDebug.h
//
// Header for the Debug and logging unit
//
// Written by Kurt Fitzner <kfitzner@excelcia.org>
// Copyright  2003, Kurt Fitzner
//---------------------------------------------------------------------------

#ifndef LogDebugH
#define LogDebugH
//---------------------------------------------------------------------------
class TProgramLog {
  public:
      _fastcall  TProgramLog(AnsiString FileName, bool Synchronous = true, bool OverWrite = true);
      _fastcall ~TProgramLog();
    void _cdecl  LogEntry(AnsiString File, AnsiString Line, AnsiString Message, ...);
  protected:
    AnsiString   FileName;
    bool         Synchronous;
  private:
    int          FileHandle;
};  // class TProgramLog
//---------------------------------------------------------------------------

extern TProgramLog *Log;

#ifndef _DEBUG
  #define __ENTERFUNCTION__ if (Log) { Log->LogEntry(__FILE__, __LINE__, "Entering function %s", __FUNC__); }
  #define __LEAVEFUNCTION__ if (Log) { Log->LogEntry(__FILE__, __LINE__, "Leaving function %s", __FUNC__); }
#else
  #define __ENTERFUNCTION__ ;
  #define __LEAVEFUNCTION__ ;
#endif

#endif



