//---------------------------------------------------------------------------
// LogDebug.cpp
//
// Debug and logging unit
//
// Written by Kurt Fitzner <kfitzner@excelcia.org>
// Copyright  2003, Kurt Fitzner
//---------------------------------------------------------------------------


#include <vcl.h>
#include <windows.h>
#pragma hdrstop

#include <stdio.h>

#include "LogDebug.h"



//---------------------------------------------------------------------------
// TProgramLog()
//
// Class constructor
//
// Takes:   AnsiString filename
// Throws:  Nothing
//---------------------------------------------------------------------------
__fastcall TProgramLog::TProgramLog(AnsiString FileName, bool Synchronous, bool OverWrite)
{
  if (OverWrite)
    DeleteFile(FileName);
  if (!FileExists(FileName)) {
    FileHandle = FileCreate(FileName);
    FileClose(FileHandle);
  }  // if (!FileExists(FileName))
  if (Synchronous)
    FileHandle = FileOpen(FileName, fmOpenReadWrite);
  else
    FileHandle = -1;
  this->FileName = FileName;
  this->Synchronous = Synchronous;
}  // _fastcall TProgramLog::TProgramLog(AnsiString FileName, bool Synchronous, bool OverWrite)
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
// ~TProgramLog()
//
// C'est une destructor
//
// Throws: Nothing
//---------------------------------------------------------------------------
__fastcall TProgramLog::~TProgramLog()
{
  if (FileHandle != -1)
    FileClose(FileHandle);
}  // __fastcall TProgramLog::~TProgramLog()
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
// LogEntry()
//
// Write an entry into the log.
//
// Takes:   AnsiString with the filename, AnsiString with the line numnber,
//          a message with optional "printf" style format specifiers. and
//          optional arguments
// Returns: Nothing
// Throws:  Nothing
//---------------------------------------------------------------------------
void _cdecl TProgramLog::LogEntry(AnsiString File, AnsiString Line, AnsiString Message, ...)
{
  if (FileHandle == -1)
    FileHandle = FileOpen(FileName, fmOpenReadWrite);

  if (FileHandle != -1) {
    char           Buffer[256];
    int            Count;
    unsigned short Hour, Minute, Second, MSec;

    AnsiString TimeStamp = TDateTime().FormatString("ddmmmyyyy hh:nn:ss.");
    TDateTime().CurrentTime().DecodeTime(&Hour, &Minute, &Second, &MSec);
    TimeStamp += TimeStamp.printf("%3.3n", MSec);

    Count = vsnprintf(Buffer, sizeof(Buffer)-1, (String("[") + TimeStamp + String("]-[") + File + String(":") + Line + "] " + Message + String("\r\n")).c_str(), &Message + 1);
    Buffer[Count] = '\000';
    FileWrite(FileHandle, Buffer, Count);
    if (Synchronous) {
      FileClose(FileHandle);
      FileHandle = -1;
    }  // if (Synchronous)
  }  //   if (FIleHandle != -1)
}  // void _cdecl LogEntry(AnsiString File, AnsiString Line, AnsiString Message, ...)
//---------------------------------------------------------------------------
#pragma package(smart_init)



