//-------------------------------------------------------------------------
// Prolog code fix - ugly hack for Borland's __msfastcall bug.
//
// We are converting a MSVC fastcall into a _stdcall below.  We need to
// have the two params (TPlugIn *this and msModel *Model) pushed onto the
// stack before the return address.  The second param is alread there, so
// we just need to (carefully) pop off the return address, push on the
// first param, and then replace the return address again before we set up
// a stack frame.
// We use _stdcall because it pushes right to left and functions clean up
// their own stack.  The caller won't expect to clean up the stack, so
// we can't use _cdecl.  We could use _pascal, but that pushes left to
// right.  We don't want that because then we'd have to pop off Param 2
// which is already on the stack.  If we do that, then we lose a register
// and we'd not be able to save the velue of the stack pointer.  This is
// important because the compiler sets the stack pointer to make room for
// the amount of local variable storage needed.  This way, with a
// _stdcall, we can leave Param 2 on the stack, and use EDX to save what
// the compiler sets the stack pointer to for local variables.
asm {
  mov  edx, esp;                                 // EDX is Param 2, but it's on the stack already so we reuse the register to save our stack pointer
  mov  esp, ebp;                                 // Undo the prolog's stack frame
  pop  ebp;                                      // Finish undoing the stack frame
  pop  eax;                                      // This is our return address - important.  Pop it off so we can add a parameter before it.
  push ecx;                                      // ECX is Param 1 (our "this" pointer) - since Param 2 is already on the stack, we push ECX on here.
  push eax;                                      // Push our return address back on
  push ebp;                                      // Remake our stack frame
  mov  ebp, esp;                                 // Finish remaking the stack frame
  add  edx, -0x04;                               // Add 4 to our stack frame because we just pushed a value on
  mov  esp, edx;                                 // Now we restore the stack pointer so we have local variable storage again.

  // And that does it.  We should have a normal _cdecl function framework
  // now.  The normal epilog code for a _stdcall should clean up this
  // function properly.

/*
  This is what we used to use for a prolog.  It was used in conjunction
  with a __declspec(naked) modifier and this replaced our prolog.  It
  worked, but issues with the way Borland processes a "return" in a
  __declspec(naked) function made it very hard to implement, so we swiched
  to the above method.

  pop  eax;                                    // Pop off function return address
                                               // EDX is Param 2 and is already on the stack
  push ecx;                                    // ECX is Param 1 (this) and gets pushed on here
  push eax;                                    // Push our function return address back on
  push ebp;                                    // Stack frame - save our base pointer
  mov  ebp, esp;                               // Move base pointer to top of stack
  add  esp, -0x400;                            // ** Make top of stack 1k higher for local variables
*/
}
//-------------------------------------------------------------------------
// End of Prolog code - anything under this point is the actual function
//-------------------------------------------------------------------------

