#include "ms3d.h"
#include "ms3dspec.h"
#include "utils.h"
#include "joint.h"

using namespace std;

bool IsBone(INode *node)
{
	// check for invalid nodes
	if(!node)
		return false;
	// check for root node
	if(node->IsRootNode())
		return false;
	// check for bone node
	ObjectState os;
	os = node->EvalWorldState(0);
	if(os.obj->ClassID() == Class_ID(DUMMY_CLASS_ID, 0))
		return false;
	if(os.obj->ClassID() == Class_ID(BONE_CLASS_ID, 0))
		return true;
	if(os.obj->ClassID() == BONE_OBJ_CLASSID)
		return true;
	// check for biped node
	Control *pControl;
	pControl = node->GetTMController();
	if((pControl->ClassID() == BIPSLAVE_CONTROL_CLASS_ID) || (pControl->ClassID() == BIPBODY_CONTROL_CLASS_ID))
		return true;

	return false;
}


bool IsBipedBone(INode *node)
{
	// first check if regular bone...
	if(!IsBone(node))
		return false;
		
	// check for biped node
	Control *pControl;
	pControl = node->GetTMController();
	if((pControl->ClassID() == BIPSLAVE_CONTROL_CLASS_ID) || (pControl->ClassID() == BIPBODY_CONTROL_CLASS_ID))
		return true;

	return false;
}

bool IsBipedRoot(INode *node)
{
	// first check if bipedbone...
	if(!IsBipedBone(node))
		return false;
		
	// check for biped node
	Control *pControl;
	pControl = node->GetTMController();
	if(pControl->ClassID() == BIPBODY_CONTROL_CLASS_ID)
		return true;
	return false;
}




// cut away path from a string.
// (ie it leaves the characters after the last / or \ found.
void stripPath(char *str)
{
	int i, cut, len = strlen(str);

	if(!len)
		return;

	cut = 0;
	for(i = 0; i < len; i++) {
		if(str[i] == '\\' || str[i] == '/')
			cut = i;
	}

	cut ++;
	for(i = 0; i < len; i++) {
		str[i] = str[cut + i];
		if(!str[i])
			break;
	}


	/*
	if(cut == len) // nothing behind the last path deliminator
		strcpy(str, "");
	else {
		char *tmp = new char[len - cut + 1];
		strncpy(tmp, str + cut + 1, len - cut - 1);
		strcpy(str, tmp);		
		delete[] tmp;
	}
	*/
}


void note(char *fmt, ...)
{
	va_list     argptr;
	char        txt[256];

	va_start (argptr,fmt); // Start list after variable fmt.  va_arg(argptr, double)  get list argument into a variable in this case (double).
	vsprintf (txt,fmt,argptr);
	va_end   (argptr);

	MessageBox(NULL, txt, "Note", MB_OK); 
}

float ReduceRotation(float rad)
{
	float range = 2 * M_PI;

	while (rad >= range)
		rad -= range;
	while (rad <= -range)
		rad += range;
	return rad;
}

// see phyexp.h in the character studio sdk!
Modifier* GetPhysiqueModifier(INode *node)
{
	Object *obj;

	obj = node->GetObjectRef();
	if(!obj)
		return NULL;

	// loop through all derived objects
	while(obj->SuperClassID() == GEN_DERIVOB_CLASS_ID) {

		IDerivedObject *derivedObject;
		derivedObject = static_cast<IDerivedObject *>(obj);
		
		// loop through all modifiers
		int stackId;
		for(stackId = 0; stackId < derivedObject->NumModifiers(); stackId++) {
			Modifier *mod;
			mod = derivedObject->GetModifier(stackId); 			// check if we found the physique modifier
			if(mod->ClassID() == Class_ID(PHYSIQUE_CLASS_ID_A, PHYSIQUE_CLASS_ID_B))
				return mod;
		}
		// continue with next derived object
		obj = derivedObject->GetObjRef();
	}

	return 0;
}


Modifier* GetSkinModifier(INode *node)
{
	Object *obj;

	obj = node->GetObjectRef();
	if(!obj)
		return NULL;

	// loop through all derived objects
	while(obj->SuperClassID() == GEN_DERIVOB_CLASS_ID) {

		IDerivedObject *derivedObject;
		derivedObject = static_cast<IDerivedObject *>(obj);
		
		// loop through all modifiers
		int stackId;
		for(stackId = 0; stackId < derivedObject->NumModifiers(); stackId++) {
			Modifier *mod;
			mod = derivedObject->GetModifier(stackId); 			// check if we found the physique modifier
			if(mod->ClassID() == SKIN_CLASSID)
				return mod;
		}
		// continue with next derived object
		obj = derivedObject->GetObjRef();
	}

	return 0;
}


