#include "scenenum.h"
#include "utils.h"
#include "joint.h"

using namespace std;

CSceneEnum::CSceneEnum(IScene *_maxScene, Interface *_iface) {
	maxScene = _maxScene;
	iface = _iface;
};

void CSceneEnum::Process(CScene *_target) {
	scene = _target;
	INode *node;

//	char buf[4024];
//	strcpy(buf, "List of all objects exported\n\n");

	for(int i = 0;  i < (int)nodes.size(); i++) {
		node = nodes[i];

/*
		char tmp[256];
		sprintf(tmp, "%s\n", node->GetName());
		strcat(buf, tmp);
*/
		char *name = node->GetName();

		TimeValue time = 0;
		Object *obj = node->EvalWorldState(0).obj;

		if(IsBone(node)) {  // Process regular bones.
			if(expOpt.bones)
				scene->ProcessJoint(node);
		}
		else if(obj->SuperClassID() == GEOMOBJECT_CLASS_ID) { // try processing it as a geometric object.
			if(expOpt.geom)
				scene->ProcessGeometricObject(obj, node);		
		}
	}

//	note(buf);

}

void CSceneEnum::GetNodes()
{
	maxScene->EnumTree(this);
}


// Used to process all nodes in the scene.
int	CSceneEnum::callback(INode *node)
{
	nodes.push_back(node);
	char *name = node->GetName();

	return TREE_CONTINUE;
}


void CSceneEnum::ShowResult()
{
	char buf[1024];
	int numRot = 0;
	int numTrans = 0;

	int numJoints = scene->joint.size();

	for(int i = 0; i < numJoints; i++) {
		numRot += scene->joint[i]->numKeyFramesRot;
		numTrans += scene->joint[i]->numKeyFramesTrans;
	}

	int numVertex = scene->vertex.size();
	int numFaces = scene->face.size();
	int numMaterials = scene->material.size();
	int numFrames = scene->totalFrames;

	sprintf(buf, "number of joints:\t%d\nnumber of vertices:\t%d\nfacecount:\t\t%d\nmaterials exported:\t%d\nrotation keys:\t\t%d\ntranslation keys:\t%d\nnumber of objects:\t%d\n\nFor updates and other cool stuff:\nwww.mds.mdh.se/~elt01mcg",
		numJoints, numVertex, numFaces, numMaterials, numRot, numTrans, scene->group.size());

	MessageBox(NULL, buf, "Done", MB_OK);
}