#ifndef __Mesh_Included__
#define __Mesh_Included__

#include <string.h>
#include "ms3d.h"

class CMs3dExporter;
class CJoint;


// Done this hack because the string length of 32 is frequently used in the milkshape format =)
class Str32 {
public:
	Str32() {
		strcpy(str, "");
	}
	Str32(char *s) {
		strncpy(str, s, 32);
	}
	operator =(const char *s) {
		strncpy(str, s, 32);
		return 0;
	}
	operator char*() {
		return (char*)str;
	}

private:
	char str[32];
};

// Ugly hack. Joint redirection...
struct joint_rd_t
{
	INode *from;
	INode *to;
};



// Storage container for each mesh in the scene 
class CScene {
friend class CMs3dExporter;
friend class CSceneEnum;
friend class CJoint;

public:
	CScene(Interface *iface);
	~CScene();

	void ProcessGeometricObject(Object *obj, INode*);		 
	void ProcessJoint(INode *);
	bool ProcessPhysiqueData(INode* node, Modifier* mod, int offset);

	bool ProcessSkinData(INode* node, Modifier* mod, int offset);



	// Functions called before the actual write... to finalize the dataset.
	void SetupJoints();
	void CalculateNormals();

	// First the mesh is put toghether by traversing through the 3dsmax scene.
	// When all is done. this function is called.
	void Write(const char *filename); 	


	inline float GetTime(float ticks) { // converts tick's to realtime (seconds).
		return ticks / (float)ticksPerFrame / animationFPS;
	}

private:
	INode *GetRedir(INode *from); // returns 'to' (or itself if no redirection was found from that node).
	int GetIndex(INode *joint);
	int GetNumChildren(INode *joint);
	int GetParentIndex(int);
	CJoint* GetJoint(INode *node);
	bool VertexInFace(int vert, int face);
	ms3d_material_t GetMaterial(char index);

	ms3d_header_t					header;
	std::vector<ms3d_Vector3_t *>	vertex;
	std::vector<ms3d_triangle_t *>	face;
	std::vector<CJoint *>			joint;
	std::vector<ms3d_group_t *>		group;	// a group is created for each geometric object in the scene.
	std::vector<Mtl *>				material;

	Interface						*iface;


	// Some other stuff.
	float							animationFPS;
	float							currentTime;
	int								totalFrames; 
	
	float							totalTime;
	int								ticksPerFrame;
	Interval						interval; // start and end of animation.

	// temporary storage of joint names for each vertex (used with setupjoints to assign each vertex to a bone).
	std::vector<Str32>				jointName;

	std::vector<joint_rd_t>			jointRedirect;
};

#endif