#ifndef __MS3D__H
#define __MS3D__H


#define MAX2MS3D_VERSION 112


#include <Max.h>
#include <stdmat.h>
#include <animtbl.h>
#include <modstack.h>
#include <bipexp.h>
#include <phyexp.h>
#include <ikctrl.h>
#include <math.h>
#include <vector>


#include <istdplug.h>
#include <iparamb2.h>
#include <iparamm2.h>
#include <iskin.h>

#include "ms3dspec.h"
#include "scene.h"
#include "resource.h"


// Some math.h does'nt define Pi
#ifndef M_PI 
#define M_PI 3.141592654f
#endif

extern TCHAR *GetString(int id);
extern HINSTANCE hInstance;

// Export options (global)
class CExportOptions {
public:
	CExportOptions() {
		SetAll(false);
	}

	bool bones;
	bool anim;
	bool materials;
	bool geom;
	bool selectedOnly;
	bool noSmooth;

	void SetAll(bool val) {
		bones = val;
		anim = val;
		materials = val;
		geom = val;
		selectedOnly = val;
		noSmooth = val;
	}


};


// Globals.
extern CExportOptions expOpt;
extern Matrix3 ms3d; // conversion matrix from 3dsmax coordinates to ms3d.

#endif
