#include "ms3d.h"
#include "utils.h"
#include "ms3dspec.h"
#include "scenenum.h"


#define CMS3DEXPORTER_CLASS_ID	Class_ID(0x174ded58, 0x6545b9e9)


// globals (externally declared in ms3d.h)
CExportOptions expOpt;
Matrix3 ms3d; // conversion matrix from 3dsmax coordinates to ms3d.

class CMs3dExporter : public SceneExport {
	public:


		static HWND hParams;


		int				ExtCount();					// Number of extensions supported
		const TCHAR *	Ext(int n);					// Extension #n (i.e. "3DS")
		const TCHAR *	LongDesc();					// Long ASCII description (i.e. "Autodesk 3D Studio File")
		const TCHAR *	ShortDesc();				// Short ASCII description (i.e. "3D Studio")
		const TCHAR *	AuthorName();				// ASCII Author name
		const TCHAR *	CopyrightMessage();			// ASCII Copyright message
		const TCHAR *	OtherMessage1();			// Other message #1
		const TCHAR *	OtherMessage2();			// Other message #2
		unsigned int	Version();					// Version number * 100 (i.e. v3.01 = 301)
		void			ShowAbout(HWND hWnd);		// Show DLL's "About..." box

		BOOL SupportsOptions(int ext, DWORD options);
		int				DoExport(const TCHAR *name,ExpInterface *ei,Interface *i, BOOL suppressPrompts=FALSE, DWORD options=0);

	
		//Constructor/Destructor

		CMs3dExporter();
		~CMs3dExporter();		

};


class CMs3dExporterClassDesc:public ClassDesc2 {
	public:
	int 			IsPublic() { return TRUE; }
	void *			Create(BOOL loading = FALSE) { return new CMs3dExporter(); }
	const TCHAR *	ClassName() { return GetString(IDS_CLASS_NAME); }
	SClass_ID		SuperClassID() { return SCENE_EXPORT_CLASS_ID; }
	Class_ID		ClassID() { return CMS3DEXPORTER_CLASS_ID; }
	const TCHAR* 	Category() { return GetString(IDS_CATEGORY); }

	const TCHAR*	InternalName() { return _T("CMs3dExporter"); }	// returns fixed parsable name (scripter-visible name)
	HINSTANCE		HInstance() { return hInstance; }				// returns owning module handle

};



static CMs3dExporterClassDesc CMs3dExporterDesc;
ClassDesc2* GetCMs3dExporterDesc() { return &CMs3dExporterDesc; }


BOOL CALLBACK CMs3dExporterOptionsDlgProc(HWND hWnd,UINT message,WPARAM wParam,LPARAM lParam) {
	static CMs3dExporter *imp = NULL;
	HWND hCtrl, tmp;
	WORD code;
	bool val;
	static char version[10];

//	MessageBox(hWnd, version, "Note", MB_OK);

	switch(message)
	{
		case WM_COMMAND: 
			hCtrl = (HWND)lParam;
			code = HIWORD(wParam); // notification code if the message is from a control
			val = (Button_GetCheck(hCtrl) != 0);

			if(code != BN_CLICKED)
				break;
			switch(LOWORD(wParam))
			{
				case IDC_CHECK_GEOM: 
					expOpt.geom = val;					

					tmp = GetDlgItem(hWnd, IDC_CHECK_MAT);
					if(!expOpt.geom) { // Cant have materials without geometric objects.
						EnableWindow(tmp, FALSE);
						Button_SetCheck(tmp, FALSE);
					}
					else
						EnableWindow(tmp, TRUE);
					break;
				case IDC_CHECK_BONES: 
					expOpt.bones = val;
					
					tmp = GetDlgItem(hWnd, IDC_CHECK_ANIM);
					if(!expOpt.bones) { // Cant have animation without bones.
						EnableWindow(tmp, FALSE);
						Button_SetCheck(tmp, FALSE);
					}
					else
						EnableWindow(tmp, TRUE);

					break;
				case IDC_CHECK_ANIM: 
					expOpt.anim = val;					
					break;
				case IDC_CHECK_MAT: 
					expOpt.materials = val;					
					break;
				case IDC_CHECK_SELONLY: 
					expOpt.selectedOnly = val;					
					break;
				case IDC_CHECK_NOSMOOTH: 
					expOpt.noSmooth = val;					
					break;
				case IDC_EXPORT_ALL:
					expOpt.anim = true;
					expOpt.bones = true;
					expOpt.geom = true;
					expOpt.materials = true;
				case IDC_EXPORT: 
					EndDialog( hWnd, 0);
					return FALSE;
			}
			return TRUE;
		case WM_INITDIALOG:
			imp = (CMs3dExporter *)lParam;
			CenterWindow(hWnd, GetParent(hWnd));
			// set the static version label..

			sprintf(version, "v%d.%02d", (int)(MAX2MS3D_VERSION / 100), MAX2MS3D_VERSION % 100);

			tmp = GetDlgItem(hWnd, IDC_VERSION);
			SetWindowText(tmp, (LPCTSTR)version);
			return TRUE;

		case WM_CLOSE:
			EndDialog(hWnd, 0);
			return TRUE;
	}
	return FALSE;
}


//--- CMs3dExporter -------------------------------------------------------
CMs3dExporter::CMs3dExporter()
{

}

CMs3dExporter::~CMs3dExporter() 
{

}

int CMs3dExporter::ExtCount()
{
	//TODO: Returns the number of file name extensions supported by the plug-in.
	return 1;
}

const TCHAR *CMs3dExporter::Ext(int n)
{		
	//TODO: Return the 'i-th' file name extension (i.e. "3DS").
	return _T("ms3d");
}

const TCHAR *CMs3dExporter::LongDesc()
{
	//TODO: Return long ASCII description (i.e. "Targa 2.0 Image File")
	return _T("Milkshape 3d format");
}
	
const TCHAR *CMs3dExporter::ShortDesc() 
{			
	//TODO: Return short ASCII description (i.e. "Targa")
	return _T("Milkeshape 3d");
}

const TCHAR *CMs3dExporter::AuthorName()
{			
	//TODO: Return ASCII Author name
	return _T("Martin Collberg");
}

const TCHAR *CMs3dExporter::CopyrightMessage() 
{	
	// Return ASCII Copyright message
	return _T("");
}

const TCHAR *CMs3dExporter::OtherMessage1() 
{		
	//TODO: Return Other message #1 if any
	return _T("");
}

const TCHAR *CMs3dExporter::OtherMessage2() 
{		
	//TODO: Return other message #2 in any
	return _T("");
}

unsigned int CMs3dExporter::Version()
{				
	//TODO: Return Version number * 100 (i.e. v3.01 = 301)
	return MAX2MS3D_VERSION;
}

void CMs3dExporter::ShowAbout(HWND hWnd)
{			
	// Optional
}

BOOL CMs3dExporter::SupportsOptions(int ext, DWORD options)
{
	// TODO Decide which options to support.  Simply return
	// true for each option supported by each Extension 
	// the exporter supports.

	return TRUE;
}


int	CMs3dExporter::DoExport(const TCHAR *name,ExpInterface *ei,Interface *i, BOOL suppressPrompts, DWORD options)
{
	CScene scene(i);
	char *filename;

	expOpt.SetAll(false); // reset export options.

	if(!suppressPrompts)
		DialogBoxParam(hInstance, MAKEINTRESOURCE(IDD_PANEL), GetActiveWindow(), CMs3dExporterOptionsDlgProc, (LPARAM)this);
	else
		expOpt.SetAll(true); // Export everything.

	// Setup coordinate conversion matrix.
	ms3d.IdentityMatrix();
	ms3d.RotateX(-M_PI / 2);

	filename = new char[strlen(name) + 1];
	strcpy(filename, name);

	CSceneEnum nodeEnumerator(ei->theScene, i);

	nodeEnumerator.GetNodes(); // First get all nodes into a vector.
	nodeEnumerator.Process(&scene); // process the whole scene and store the result in the given CScene structure.

	scene.SetupJoints(); // sort and assign correct jointId to each vertex in the mesh.

	scene.CalculateNormals();

	strlwr(filename);
	scene.Write(filename);

	// Output some export information (to indicate success also).
	nodeEnumerator.ShowResult();
	
	delete[] filename;
	return TRUE;

	return FALSE;
}


