#ifndef __Joint_H_Included__Ms3d_Export__
#define __Joint_H_Included__Ms3d_Export__


#include "ms3d.h"


class CScene;

// byte-align structure
#ifdef _MSC_VER
#	pragma pack( push, packing )
#	pragma pack( 1 )
#	define PACK_STRUCT
#elif defined( __GNUC__ )
#	define PACK_STRUCT	__attribute__((packed))
#else
#	error you must byte-align these structures with the appropriate compiler directives
#endif

class CJoint {
public:
	CJoint();
	~CJoint();

	struct { // ms3d_joint_t
		byte            flags;							// SELECTED | DIRTY
		char            name[32];						//
		char            parentName[32];					//
		float           rotation[3];					// local reference matrix
		float           position[3];

		word            numKeyFramesRot;                    
		word            numKeyFramesTrans;                  
	}; 

	// Dynamic size...
	std::vector<ms3d_keyframe_t *> keyFramesRot;		// local animation matrices
	std::vector<ms3d_keyframe_t *> keyFramesTrans;		// local animation matrices

	INode				*node;							// pointer to node that makes up joint.
	INode				*parent;						// pointer to parent INode.

	Point3				pos;							// Original relative position 
	CScene				*scene;

	int					numChildren;
	float				lengthToParent;


	// Extract the keyframe information functions.
	void GetKeyframes();
	bool GetPRSKeys(); // Returns true if any keys was found.
	void GetKeyframes(Animatable *obj);

	// Fills the rotation and translation arrays (xyz) with the bone's 
	// values at the given time.
	void GetTransformation(const TimeValue& time, float *rot, float *trans);

	// Another version. Used with the keyframes.
	// it takes two times and get the rotation & translation to get from a -> b.
	void GetTransformation(const TimeValue& a, const TimeValue& b, float *rot, float *trans);
	
	// return's the current size of this joint structure.
	long Size(); 
	
	// fills an array of bytes with the data for this joint (useful when writing).
	void FillByteBuffer(char *buf); 
	// merges keyframe's if they are keys in the same timestamp. (x, y, z is
	// keyed separately for both rotation and translation in 3dsmax).
	// Also adjust's the rotations to the ms3d coordinate system.
	void FinalizeKeys(); 

	Matrix3 GetMs3dTM(TimeValue time);
	Matrix3 GetParentMs3dTM(TimeValue time);

};

// restore Default alignment
#ifdef _MSC_VER
#	pragma pack( pop, packing )
#endif
#undef PACK_STRUCT


#endif