//---------------------------------------------------------------------------
// FLModelCloner - Freelancer Model Cloner
// FLModelCloner.cpp - TUTFFile - UTF file manipulation class header
// Copyright 2003-2005, Kurt Fitzner <kfitzner@excelcia.org>
//---------------------------------------------------------------------------
// This file is part of FLModelCloner.
//
// FLModelCloner is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// FLModelCloner is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
//---------------------------------------------------------------------------
#ifndef TUTFFileH
#define TUTFFileH

#include <classes.hpp>
//---------------------------------------------------------------------------
struct TUTFFileHeader
{
  DWORD Signature1;                     // "UTF "
  DWORD Signature2;                     // 0x101
  DWORD TreeSegmentOffset;
  DWORD TreeSegmentSize;
  DWORD HeaderOffset;                   // Is this used?  Always zero?
  DWORD HeaderSize;                     // Always 44?
  DWORD StringSegmentOffset;
  DWORD StringSegmentAllocatedSize;
  DWORD StringSegmentSize;
  DWORD DataSegmentOffset;
  DWORD Unknown;                        // Seems to be zero most of the time
};

struct TUTFFileTreeNode
{
  DWORD SiblingOffset;
  DWORD StringOffset;
  DWORD Flags;
  DWORD Unknown;                        // Is this always zero?
  DWORD ChildOffset;
  DWORD AllocatedSize;
  DWORD Size1;
  DWORD Size2;
  DWORD Time1;
  DWORD Time2;
  DWORD Time3;
};  // struct TUTFFileTreeNode

struct TUTFTreeNode
{
  AnsiString  Name;
  unsigned    Child;
  unsigned    Sibling;
  unsigned    Parent;
  bool        IsLeaf;
  unsigned    AllocatedDataSize;
  unsigned    DataSize;
  void       *Data;
  DWORD       Unknown;
  DWORD       Time1;
  DWORD       Time2;
  DWORD       Time3;
};  // struct TUTFTreeNode

class TUTFFile : public TObject {
private:

protected:
  TList *Nodes;

  int            __fastcall GetCount(void);
  TUTFTreeNode * __fastcall GetItems(int Index);
  AnsiString     __fastcall GetNames(int Index);
  void           __fastcall PutNames(int Index, AnsiString Name);

public:
  bool __fastcall LoadFromFile(AnsiString &FileName);
  bool __fastcall SaveToFile(AnsiString &FileName);
  void __fastcall SetData(int Index, AnsiString NewData);
  void __fastcall Clear(void);

  __property TUTFTreeNode * Items[int Index] = {read=GetItems};
  __property AnsiString     Names[int Index] = {read=GetNames, write=PutNames};
  __property int            Count = {read=GetCount};

__published:
  __fastcall TUTFFile(void);
  __fastcall ~TUTFFile(void);

};  // class TUTFFile : public TObject

#endif
