//---------------------------------------------------------------------------
// FLModelCloner - Freelancer Model Cloner
// FLModelCloner.cpp - Utility functions
// Copyright 2003-2005, Kurt Fitzner <kfitzner@excelcia.org>
//---------------------------------------------------------------------------
// This file is part of FLModelCloner.
//
// FLModelCloner is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// FLModelCloner is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "Utils.h"

//---------------------------------------------------------------------------
// generate_crc()
//
// Calculate a 32-bit crc based on the input string.
// This routine requires a resource to be included in the executable called
// "CRCTABLE" that holds the generator table.  It will load and lock this
// resource the first time the function is called, so no prior initialization
// is required.
//
// Takes:   char pointer pointing to a zstring
// Returns: integer containing crc
// Throws:  EResNotFound if it cannot find the CRCTABLE resource
//          generic Exception if it can't load or lock the CRCTABLE resource
//           or if the CRCTABLE resource is the wrong size (256 DWORDS) 
//---------------------------------------------------------------------------
unsigned int generate_crc (char *string)
{
  static DWORD *crctable = NULL;
  unsigned int crc;
  unsigned len = strlen(string);

  if (!crctable) {
    HRSRC CRCResource;
    HGLOBAL CRCGlobal;

    CRCResource = FindResource(NULL, "CRCTABLE", "CRCTABLE");
    if (!CRCResource)
      throw EResNotFound("generate_crc() could not find CRCTABLE resource.");
    if (SizeofResource(NULL, CRCResource) != sizeof(DWORD) * 256)
      throw Exception("generate_crc() CRCTABLE resource is wrong size.");
    CRCGlobal = LoadResource(NULL, CRCResource);
    if (!CRCGlobal)
      throw Exception("generate_crc(): Could not load CRCTABLE resource.");
    crctable = (DWORD *)LockResource(CRCGlobal);
    if (!crctable)
      throw Exception("generate_crc(): Could not lock CRCTABLE resource");
  }  // if (!crctable)

  crc = 0xFFFFFFFFL;

  for (unsigned n = 0; n < len; n++)
    crc = ((crc>>8) & 0x00FFFFFFL) ^ crctable[ (crc^ (tolower(string[n])) ) & 0xFF ];

  crc = crc^0xFFFFFFFFL;

  return crc;
}  // unsigned int crc (char *string)

//---------------------------------------------------------------------------

#pragma package(smart_init)
