//---------------------------------------------------------------------------
// FLModelCloner - Freelancer Model Cloner
// FLModelCloner.cpp - Main form header
// Copyright 2003-2005, Kurt Fitzner <kfitzner@excelcia.org>
//---------------------------------------------------------------------------
// This file is part of FLModelCloner.
//
// FLModelCloner is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// FLModelCloner is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
//---------------------------------------------------------------------------
#ifndef MainUnitH
#define MainUnitH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ComCtrls.hpp>
#include <ExtCtrls.hpp>
#include <Dialogs.hpp>
#include <Menus.hpp>
#include <ImgList.hpp>
//---------------------------------------------------------------------------
#define VMESH      0
#define VMESHREF   1
#define MATERIAL   2
#define NOTRENAMED 3
#define RENAMED    4
//---------------------------------------------------------------------------
struct TCRCName
{
  AnsiString    OldName;
  unsigned int  OldCRC;
  AnsiString    NewName;
  unsigned int  NewCRC;
  int           UTFNode;
  int           DataNode;
  bool          Identified;                      // Specified whether the name has been identified
  TList        *References;
};  // struct TCRCName

struct TVMeshHeader
{
  DWORD         Signature1;                      // Signature? Always 0x00000001 ? Version?
  DWORD         Signature2;                      // Signature? Always 0x00000004 ? Version?
  WORD          MeshCount;                       // Total number of meshes
  WORD          VertexRefCount;                  // Number of referenced vertices
  WORD          Signature3;                      // Always 0x112 ???
  WORD          VertexCount;                     // Total number of actual vertices
};  // struct VMeshHeader

struct TVMeshMesh
{
  DWORD         MaterialID;                      // CRC of Material name
  WORD          StartVertex;
  WORD          EndVertex;
  WORD          VertexRefCount;
  WORD          Padding;                         // DWORD padding?  Always 0x00CC ?
};  // struct VMeshMesh

struct TVMeshRef
{
  DWORD         Signature;                       // Signature? Always 0x0000003C ? Version?
  DWORD         VMeshID;
  WORD          StartVertex;
  WORD          EndVertex;
  WORD          StartVertexRef;
  WORD          EndVertexRef;
  WORD          MeshNumber;
  WORD          MeshCount;
  float         BoundingBox[6];
  float         Unknown[4];
};  // struct TVMeshRef

//---------------------------------------------------------------------------
class TMainForm : public TForm
{
__published:	// IDE-managed Components
  TPanel      *pnlClient;
  TGroupBox   *pnlIDList;
  TTreeView   *treeIDList;
  TSplitter   *SplitterVertical;
  TPanel      *pnlRight;
  TGroupBox   *pnlDetails;
  TEdit       *edtOldName;
  TLabel      *lblOldName;
  TLabel      *lblOldCRC;
  TEdit       *edtNewName;
  TLabel      *lblNewName;
  TLabel      *lblNewCRC;
  TGroupBox   *pnlModelInfo;
  TLabel      *lblVMeshInfo;
  TLabel      *lblVMeshRename;
  TLabel      *lblVMeshRefInfo;
  TLabel      *lblVMeshRefRename;
  TLabel      *lblMaterialInfo;
  TLabel      *lblMaterialIdentify;
  TLabel      *lblMaterialRename;

  TOpenDialog *OpenDialog;
  TOpenDialog *ScanDialog;
  TSaveDialog *ExportDialog;
  TStatusBar  *StatusBar;
  TImageList  *TreeImages;
  TImageList  *TreeStateImages;

  TMainMenu   *MainMenu;
  TMenuItem   *menuFile;
  TMenuItem   *menuFile_OpenModel;
  TMenuItem   *Separator1;
  TMenuItem   *menuFile_ScanMat;
  TMenuItem   *menuFile_ExportNewModel;
  TMenuItem   *Separator2;
  TMenuItem   *menuFile_Exit;
  TMenuItem   *menuEdit;
  TMenuItem   *menuEdit_Preferences;
  TMenuItem   *menuHelp;
  TMenuItem   *menuHelp_Contents;
  TMenuItem *Separator4;
  TMenuItem   *menuHelp_HowTo;
  TMenuItem   *menuHelp_Overview;
  TMenuItem *Separator5;
  TMenuItem   *menuHelp_About;
  TMenuItem *Separator3;
  TMenuItem *menuEdit_AutoRename;
        TMenuItem *menuHelp_License;

  void __fastcall edtNewNameChange(TObject *Sender);
  void __fastcall menuFile_OpenModelClick(TObject *Sender);
  void __fastcall FormActivate(TObject *Sender);
  void __fastcall FormActivateFirst(TObject *Sender);
  void __fastcall ConfigTimerFire(TObject *Sender);
  void __fastcall menuFile_ExitClick(TObject *Sender);
  void __fastcall FormClose(TObject *Sender, TCloseAction &Action);
  void __fastcall FormShow(TObject *Sender);
  void __fastcall menuFile_ScanMatClick(TObject *Sender);
  void __fastcall treeIDListClick(TObject *Sender);
  void __fastcall menuFile_ExportNewModelClick(TObject *Sender);
  void __fastcall menuHelp_HowToClick(TObject *Sender);
  void __fastcall menuHelp_OverviewClick(TObject *Sender);
  void __fastcall menuHelp_AboutClick(TObject *Sender);
  void __fastcall menuHelp_ContentsClick(TObject *Sender);
        void __fastcall menuHelp_LicenseClick(TObject *Sender);

private:	// User declarations
  TTimer      *ConfigTimer;
  TMemIniFile *IniFile;
  TUTFFile    *Model;
  AnsiString   BinDir;
  AnsiString   FLDir;
  AnsiString   WorkingDir;
  AnsiString   ModelFileName;

  TTreeNode   *RootVMesh;
  TTreeNode   *RootVMeshRef;
  TTreeNode   *RootMaterial;
  THashedStringList *VMeshCRCList;
  THashedStringList *VMeshRefList;
  THashedStringList *MaterialCRCList;

  int         VMeshRefCount;
  int         MaterialRefCount;

  void __fastcall ParseModel(void);
  void __fastcall ClearModel(void);
  void __fastcall ScanMaterialFile(AnsiString FileName);
  void __fastcall UpdateInfo(void);
  void __fastcall CommitChanges(void);

public:		// User declarations
  __fastcall TMainForm(TComponent* Owner);
  __fastcall ~TMainForm(void);

};  // class TMainForm : public TForm
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
extern PACKAGE TMainForm *MainForm;
//---------------------------------------------------------------------------

#endif
