//---------------------------------------------------------------------------
#include <stdio.h>
#include <string.h>
#include <math.h>
#pragma hdrstop

#include "resize_sur.h"
#include "sur.h"
#include "partname.h"
#include "main.h"
//---------------------------------------------------------------------------

#pragma package(smart_init)

extern TMemoryStream *SURFile;

extern TSURResizeData sur_resize_data;   // from cmp file
extern TSURResizeData sur_resize_data2;  // from sur file
extern bool got_cmp;
//---------------------------------------------------------------------------
AnsiString IntToBinary(DWORD input) {
    AnsiString result = "";

    if(input & 128) result += "1"; else result += "0";
    if(input & 64)  result += "1"; else result += "0";
    if(input & 32)  result += "1"; else result += "0";
    if(input & 16)  result += "1"; else result += "0";
    if(input & 8)   result += "1"; else result += "0";
    if(input & 4)   result += "1"; else result += "0";
    if(input & 2)   result += "1"; else result += "0";
    if(input & 1)   result += "1"; else result += "0";

    return result;
}
//---------------------------------------------------------------------------
void ResizeSUR(bool autosize) {
    TSurHeader              sur_header;
    TIDHeader               id_header;
    TIDHeaderB              id_header_b;
    TExtsPart               exts_part;
    TSurfaceHeader          surface_header;
    TSurface                surface;
    TSurTriangleGroupHeader triangle_group_header;
    TSurTriangle            triangle;
    TSurVertex              vertex;
    TBitsSection            bits_section;
    THPIDHeader             hpid_header;
    THPIDDataBlock          hpid_data_block;

    DWORD this_pos = 0;     // file position storage
    DWORD VertBufPtr = 0;   // stopping position for triangle data

    bool changed_type_once = false;
    int old_id_header_type;

    char tag[5];

    float radius_x = 0, radius_y = 0, radius_z = 0, tmp = 0;

    // temporary sur file to allow additions & removals for type changing
    TMemoryStream *NewSURFile;

    bool alloc_ok = true;

    try {
        NewSURFile = new TMemoryStream;
    }
    catch(std::bad_alloc) {
        MessageDlg("Memory allocation failed for the temporary SUR file.",
                mtError, TMsgDlgButtons() << mbOK, 0);

        alloc_ok = false;
    }

    if(!alloc_ok) {
        NewSURFile = NULL;

        return;
    }

    // initialize the crc class
	CNameCRC *NameCRC = new CNameCRC;

    // pre terminate the tag string
    tag[4] = '\0';

    float scale_factor_x, scale_factor_y, scale_factor_z;
    float center_shift_x, center_shift_y, center_shift_z;
    AnsiString temp;

    if(autosize) {
        scale_factor_x = sur_resize_data.x_length / sur_resize_data2.x_length;
        scale_factor_y = sur_resize_data.y_length / sur_resize_data2.y_length;
        scale_factor_z = sur_resize_data.z_length / sur_resize_data2.z_length;
    }
    else {
        if(ResizeSurForm->SurUniformRadioButton->Checked)
            scale_factor_x = scale_factor_y = scale_factor_z = ResizeSurForm->SurAllLMDMaskEdit->Text.ToDouble();
        else {
            scale_factor_x = ResizeSurForm->SurXLMDMaskEdit->Text.ToDouble();
            scale_factor_y = ResizeSurForm->SurYLMDMaskEdit->Text.ToDouble();
            scale_factor_z = ResizeSurForm->SurZLMDMaskEdit->Text.ToDouble();
        }
    }

    if((autosize) && (!got_cmp)) {
        MessageDlg("No CMP file loaded! Please select...",
                mtError, TMsgDlgButtons() << mbOK, 0);
        return;
    }
    else if(autosize) {
        if(MessageDlg("Use " + MainForm->CMPFileNameLabel->Caption + " for resize data?",
                        mtConfirmation, TMsgDlgButtons() << mbYes << mbNo, 0) == mrNo)
            return;
    }

    MainForm->SURMemo->Lines->Add("Scaling Factor :");
    temp.printf("x : %f\ty : %f\tz : %f", scale_factor_x, scale_factor_y, scale_factor_z);
    MainForm->SURMemo->Lines->Add(temp);

    SURFile->Seek(0, soFromBeginning);
    SURFile->Read(&sur_header, sizeof(TSurHeader));

    NewSURFile->Write(&sur_header, sizeof(TSurHeader));

    while(SURFile->Position < SURFile->Size) {
        // ID header or HPID?
        this_pos = SURFile->Position;
        SURFile->Read(tag, 4);
        SURFile->Seek(this_pos, soFromBeginning);

        if(!strnicmp(tag, "hpid", 4)) {
            // HPID header
            SURFile->Read(&hpid_header, sizeof(THPIDHeader));

            NewSURFile->Write(&hpid_header, sizeof(THPIDHeader));

            for(DWORD c = 0; c < hpid_header.noBlocks; c++) {
                SURFile->Read(&hpid_data_block, sizeof(THPIDDataBlock));

                NewSURFile->Write(&hpid_data_block, sizeof(THPIDDataBlock));
            }
        }
        else {
            // ID header
            //this_pos = SURFile->Position;
            SURFile->Read(&id_header, sizeof(TIDHeader));

            if((id_header.crc_id == 0x00000000) && (ResizeSurForm->MakeRootCheckBox->Checked))
                id_header.crc_id = 0x12688F2D;

            old_id_header_type = id_header.type;

            if(!changed_type_once) {
                switch(ResizeSurForm->SurTypeRadioGroup->ItemIndex) {
                    case 0 : id_header.type = 2; break;
                    case 1 : id_header.type = 3; break;
                    case 2 : id_header.type = 4; break;
                }

                changed_type_once = true;
            }

            //SURFile->Seek(this_pos, soFromBeginning);
            NewSURFile->Write(&id_header, sizeof(TIDHeader));

            this_pos = SURFile->Position;
            SURFile->Read(tag, 4);
            SURFile->Seek(this_pos, soFromBeginning);

            if(!strnicmp(tag, "!fxd", 4)) {
                // ID header b
                SURFile->Read(&id_header_b, sizeof(TIDHeaderB));

                // copy id_header_b if we want it
                if(id_header.type > 2)
                    NewSURFile->Write(&id_header_b, sizeof(TIDHeaderB));
            }

            // add id_header_b if required
            if((id_header.type > 2) && (old_id_header_type == 2)) {
                char fxd[4] = "!fxd";
                NewSURFile->Write(fxd, 4);
            }

            this_pos = SURFile->Position;

            // Bounding box (for whole model)
            SURFile->Read(&exts_part, sizeof(TExtsPart));

            // resize bbox here
            exts_part.xMin *= scale_factor_x;
            exts_part.yMin *= scale_factor_y;
            exts_part.zMin *= scale_factor_z;
            exts_part.xMax *= scale_factor_x;
            exts_part.yMax *= scale_factor_y;
            exts_part.zMax *= scale_factor_z;

            // calculate center of resized sur
            // store the center for re-aligning the sur file to the model
            // dodgy calculation but seems to work ok :D

            // debug - needs rework so will function when sur not resized
            tmp = exts_part.xMax + exts_part.xMin;
            if(tmp != 0) tmp /=2;
            sur_resize_data2.center_x = tmp;
            tmp = exts_part.yMax + exts_part.yMin;
            if(tmp != 0) tmp /=2;
            sur_resize_data2.center_y = tmp;
            tmp = exts_part.zMax + exts_part.zMin;
            if(tmp != 0) tmp /=2;
            sur_resize_data2.center_z = tmp;

            // center shifts
            //if(ResizeSurForm->CenterShiftCheckBox->Checked) {
                center_shift_x = sur_resize_data.center_x - sur_resize_data2.center_x;
                center_shift_y = sur_resize_data.center_y - sur_resize_data2.center_y;
                center_shift_z = sur_resize_data.center_z - sur_resize_data2.center_z;
            //}

            MainForm->SURMemo->Lines->Add("");
            MainForm->SURMemo->Lines->Add("Center Shift :");
            temp.printf("x : %f\ty : %f\tz : %f", center_shift_x, center_shift_y, center_shift_z);
            MainForm->SURMemo->Lines->Add(temp);

            // shift it
            //if(ResizeSurForm->CenterShiftCheckBox->Checked) {
                exts_part.xMin += center_shift_x;
                exts_part.yMin += center_shift_y;
                exts_part.zMin += center_shift_z;
                exts_part.xMax += center_shift_x;
                exts_part.yMax += center_shift_y;
                exts_part.zMax += center_shift_z;
            //}

            //SURFile->Seek(this_pos, soFromBeginning);
            NewSURFile->Write(&exts_part, sizeof(TExtsPart));

            // Surface header
            SURFile->Read(&surface_header, sizeof(TSurfaceHeader));

            NewSURFile->Write(&surface_header, sizeof(TSurfaceHeader));

            // absolute position of next component or hpid section
            DWORD Offset1Base = SURFile->Position;
            DWORD NextPos = Offset1Base + surface_header.Offset1;
            if(NextPos > SURFile->Size) NextPos = SURFile->Size;

            this_pos = SURFile->Position;
            // Surface
            SURFile->Read(&surface, sizeof(TSurface));

            // resize surface info
            //surface.center[0] *= scale_factor_x;
            //surface.center[1] *= scale_factor_y;
            //surface.center[2] *= scale_factor_z;
            //if(ResizeSurForm->CenterShiftCheckBox->Checked) {
                surface.center[0] += center_shift_x;
                surface.center[1] += center_shift_y;
                surface.center[2] += center_shift_z;
            //}

            radius_x = MAX(exts_part.xMin, fabs(exts_part.xMax));
            radius_y = MAX(exts_part.yMin, fabs(exts_part.yMax));
            radius_z = MAX(exts_part.zMin, fabs(exts_part.zMax));
            surface.radius = sqrt((radius_x * radius_x) + (radius_y * radius_y) + (radius_z * radius_z));

            surface.radius += (surface.radius * 0.25);

            // debug
            MainForm->SURMemo->Lines->Add("radius components :");
            temp.printf("x : %f\ty : %f\tz : %f", radius_x, radius_y, radius_z);
            MainForm->SURMemo->Lines->Add(temp);

            //SURFile->Seek(this_pos, soFromBeginning);
            NewSURFile->Write(&surface, sizeof(TSurface));

            // absolute position of bit_header
            DWORD BitsPos = Offset1Base + surface.Offset2;

            // for absolute position of vertex buffer
            this_pos = SURFile->Position;

            // First triangle group header
            SURFile->Read(&triangle_group_header, sizeof(TSurTriangleGroupHeader));
            VertBufPtr = this_pos + triangle_group_header.Offset3;  // vertex buffer absolute

            // rename ship components to root so will register damage from cmp - assumes only 1 3db in model
            // (not shiels, hardpoints, collision mesh or scenery)
            if(ResizeSurForm->MakeRootCheckBox->Checked) {
                AnsiString id = NameCRC->GenerateName(triangle_group_header.TriangleID);
                //                root                                                shield
                if((triangle_group_header.TriangleID != 0x12688F2D) && (triangle_group_header.TriangleID != 0xF00FB9DE) &&
                                ((triangle_group_header.TriangleID > 0xFFFF) || (triangle_group_header.TriangleID < 0x00000001)) && (!StrPos(id.c_str(), "Hp"))) {
                                    // 'bump' mesh                                  no hardpoints
                    triangle_group_header.TriangleID = 0x12688F2D; // make it root
                    //SURFile->Seek(this_pos, soFromBeginning);
                }
            }

            NewSURFile->Write(&triangle_group_header, sizeof(TSurTriangleGroupHeader));

            while(SURFile->Position < VertBufPtr) {
                for(DWORD count = 0; count < triangle_group_header.Tricount; count++) {
                    SURFile->Read(&triangle, sizeof(TSurTriangle));

                    NewSURFile->Write(&triangle, sizeof(TSurTriangle));
                }

                // read next tri header if exists
                if(SURFile->Position < VertBufPtr) {
                    this_pos = SURFile->Position;
                    SURFile->Read(&triangle_group_header, sizeof(TSurTriangleGroupHeader));

                    // rename ship components to root so will register damage from cmp - assumes only 1 3db in model
                    // (not shiels, hardpoints, collision mesh or scenery)
                    if(ResizeSurForm->MakeRootCheckBox->Checked) {
                        AnsiString id = NameCRC->GenerateName(triangle_group_header.TriangleID);
                        //                root                                                shield
                        if((triangle_group_header.TriangleID != 0x12688F2D) && (triangle_group_header.TriangleID != 0xF00FB9DE) &&
                                ((triangle_group_header.TriangleID > 0xFFFF) || (triangle_group_header.TriangleID < 0x00000001)) && (!StrPos(id.c_str(), "Hp"))) {
                                    // 'bump' mesh                                  no hardpoints
                            triangle_group_header.TriangleID = 0x12688F2D; // make it root
                            //SURFile->Seek(this_pos, soFromBeginning);
                        }
                    }

                    NewSURFile->Write(&triangle_group_header, sizeof(TSurTriangleGroupHeader));
                }
            }

            // vertices
            while(SURFile->Position < BitsPos) {
                this_pos = SURFile->Position;

                SURFile->Read(&vertex, sizeof(TSurVertex));

                AnsiString id = NameCRC->GenerateName(vertex.TriID);
                // calculate resizing data if part of main model (not hardpoint, shield, collision or debris)
                // is ship/station/dmg component & not hardpoint
                //if((id_header.type > 2) && (!StrPos(id.c_str(), "Hp"))) {
                //if((!StrPos(id.c_str(), "Hp"))) {
                    // resize vert positions here
                    vertex.X *= scale_factor_x;
                    vertex.Y *= scale_factor_y;
                    vertex.Z *= scale_factor_z;
                    vertex.X += center_shift_x;
                    vertex.Y += center_shift_y;
                    vertex.Z += center_shift_z;

                    // rename ship components to root so will register damage from cmp - assumes only 1 3db in model
                    // (not shiels, hardpoints, collision mesh or scenery)
                    if(ResizeSurForm->MakeRootCheckBox->Checked) {
                        AnsiString id = NameCRC->GenerateName(vertex.TriID);
                        //                root                        shield
                        if((vertex.TriID != 0x12688F2D) && (vertex.TriID != 0xF00FB9DE) &&
                                ((triangle_group_header.TriangleID > 0xFFFF) || (triangle_group_header.TriangleID < 0x00000001)) && (!StrPos(id.c_str(), "Hp"))) {
                                // 'bump' mesh                  no hardpoints
                            vertex.TriID = 0x12688F2D; // make it root
                        }
                    }

                    //SURFile->Seek(this_pos, soFromBeginning);
                    NewSURFile->Write(&vertex, sizeof(TSurVertex));
                //}
            }

            // bits section
            while(SURFile->Position < NextPos) {
                this_pos = SURFile->Position;
                SURFile->Read(&bits_section, sizeof(TBitsSection));

                // resize bits section info here
                bits_section.cenX *= scale_factor_x;
                bits_section.cenY *= scale_factor_y;
                bits_section.cenZ *= scale_factor_z;
                //if(ResizeSurForm->CenterShiftCheckBox->Checked) {
                    bits_section.cenX += center_shift_x;
                    bits_section.cenY += center_shift_y;
                    bits_section.cenZ += center_shift_z;
                //}

                // this radius value a bodge - needs replacing
                radius_x = MAX(exts_part.xMin, fabs(exts_part.xMax));
                radius_y = MAX(exts_part.yMin, fabs(exts_part.yMax));
                radius_z = MAX(exts_part.zMin, fabs(exts_part.zMax));
                bits_section.radius = sqrt((radius_x * radius_x) + (radius_y * radius_y) + (radius_z * radius_z));

                bits_section.radius += (bits_section.radius * 0.25);

                //SURFile->Seek(this_pos, soFromBeginning);
                NewSURFile->Write(&bits_section, sizeof(TBitsSection));
            }

            // add hpid section if required
            if((id_header.type == 4) && (old_id_header_type < 4)) {
                char hpid[4] = "hpid";
                DWORD fake_no = 1;
                DWORD fake_id = 0xF00FB9DE;
                NewSURFile->Write(hpid, 4);
                NewSURFile->Write(&fake_no, 4);
                NewSURFile->Write(&fake_id, 4);
            }
        }
    }

    // copy the temp sur file
    //SURFile->Clear();
    //SURFile->CopyFrom(NewSURFile, NewSURFile->Size);
    SURFile->LoadFromStream(NewSURFile);
    delete NewSURFile;
    
    //MainForm->SURResizeButton->Enabled = false;
    MainForm->SURMemo->Lines->Clear();
    DumpSURFile("Resized File");

    delete NameCRC;
}
//---------------------------------------------------------------------------
// modified version of Colin Sandby's routine
void DumpSURFile(AnsiString filename) {
    TSurHeader              sur_header;
    TIDHeader               id_header;
    TIDHeaderB              id_header_b;
    TExtsPart               exts_part;
    TSurfaceHeader          surface_header;
    TSurface                surface;
    TSurTriangleGroupHeader triangle_group_header;
    TSurTriangle            triangle;
    TSurVertex              vertex;
    TBitsSection            bits_section;
    THPIDHeader             hpid_header;
    THPIDDataBlock          hpid_data_block;

    FILE *dump_file = NULL;
    DWORD this_pos = 0;     // file position storage
    DWORD VertBufPtr = 0;

    char tag[5];
    AnsiString temp, file;

    // initialize the crc class
	CNameCRC *NameCRC = new CNameCRC;

    // pre terminate the tag string
    tag[4] = '\0';

    // reset the size storage
    sur_resize_data2.xmin = sur_resize_data2.xmax = 0;
    sur_resize_data2.ymin = sur_resize_data2.ymax = 0;
    sur_resize_data2.zmin = sur_resize_data2.zmax = 0;

    SURFile->Seek(0, soFromBeginning);

    file = ExtractFilePath(Application->ExeName) + "sur.txt";
    if((dump_file = fopen(file.c_str(), "w+"))) {
        fprintf(dump_file, "File : %s\n\n", filename.c_str());

        // File header
        SURFile->Read(&sur_header, sizeof(TSurHeader));
        StrLCopy(tag, (char *)&sur_header.tag, 4);

        if(strnicmp(tag, "vers", 4)) {
		    MessageDlg("Old style sur file, check with HEX Editor", mtInformation, TMsgDlgButtons() << mbOK, 0);
		    fclose(dump_file);
		    delete NameCRC;
		    return;
	    }

        fprintf(dump_file, "SurHeader :\n");
        fprintf(dump_file, "\"%s\" %3.2f\n\n", tag, sur_header.version);

        while(SURFile->Position < SURFile->Size) {
            // ID header or HPID?
            this_pos = SURFile->Position;
            SURFile->Read(tag, 4);
            SURFile->Seek(this_pos, soFromBeginning);

            if(!strnicmp(tag, "hpid", 4)) {
                // HPID header
                SURFile->Read(&hpid_header, sizeof(THPIDHeader));

                fprintf(dump_file, "\nHPID_Header :\n");
                StrLCopy(tag, (char *)&hpid_header.tag, 4);
                fprintf(dump_file, "tag      : \"%s\"\n", tag);
                fprintf(dump_file, "noBlocks : %d\n\n", hpid_header.noBlocks);

                fprintf(dump_file, "HPID_data_block :\n");

                for(DWORD c = 0; c < hpid_header.noBlocks; c++) {
                    SURFile->Read(&hpid_data_block, sizeof(THPIDDataBlock));
                    fprintf(dump_file, "0x%08X  - \"%s\"\n", hpid_data_block.crc_id, NameCRC->GenerateName(hpid_data_block.crc_id));
			    }

                fprintf(dump_file, "\n");
            }
            else {
                // ID header
                SURFile->Read(&id_header, sizeof(TIDHeader));

                fprintf(dump_file, "IDHeader :\n");
                fprintf(dump_file, "crc_id : 0x%08X  - \"%s\"\n", id_header.crc_id, NameCRC->GenerateName(id_header.crc_id));

                switch(id_header.type) {
                    case 2 : {
                                fprintf(dump_file, "type   : 2  - Scenery\n\n");
                                if(ResizeSurForm->SurTypeRadioGroup->ItemIndex == -1)
                                    ResizeSurForm->SurTypeRadioGroup->ItemIndex = 0;
                             } break;
                    case 3 : {
                                fprintf(dump_file, "type   : 3  - Equip/Ammo/Damage Section\n\n");
                                if(ResizeSurForm->SurTypeRadioGroup->ItemIndex == -1)
                                    ResizeSurForm->SurTypeRadioGroup->ItemIndex = 1;
                             } break;

                    case 4 : {
                                fprintf(dump_file, "type   : 4  - Ship/Station\n\n");
                                if(ResizeSurForm->SurTypeRadioGroup->ItemIndex == -1)
                                    ResizeSurForm->SurTypeRadioGroup->ItemIndex = 2;
                             } break;
                    default : fprintf(dump_file, "type   : Unknown\n\n");
                }

                this_pos = SURFile->Position;
                SURFile->Read(tag, 4);
                SURFile->Seek(this_pos, soFromBeginning);

                if(!strnicmp(tag, "!fxd", 4)) {
                    // ID header b
                    SURFile->Read(&id_header_b, sizeof(TIDHeaderB));
                    StrLCopy(tag, (char *)&id_header_b.tag, 4);

                    fprintf(dump_file, "IDHeader_B :\n");
                    fprintf(dump_file, "tag : \"%s\"\n\n", tag);
                }

                // Bounding box (for whole model)
                SURFile->Read(&exts_part, sizeof(TExtsPart));
                StrLCopy(tag, (char *)&exts_part.tag, 4);

                fprintf(dump_file, "exts_part (bounding box) :\n");
                fprintf(dump_file, "tag  : \"%s\"\n", tag);
                fprintf(dump_file, "xMin : %f\tyMin : %f\tzMin : %f\n", exts_part.xMin, exts_part.yMin, exts_part.zMin);
                fprintf(dump_file, "xMax :  %f\tyMax :  %f\tzMax :  %f\n\n", exts_part.xMax, exts_part.yMax, exts_part.zMax);

                // Surface header
                SURFile->Read(&surface_header, sizeof(TSurfaceHeader));
                StrLCopy(tag, (char *)&surface_header.tag, 4);

                fprintf(dump_file, "Surface header :\n");
                fprintf(dump_file, "tag     :\"%s\"\n", tag);;
                fprintf(dump_file, "Offset1 : 0x%04X   (%d) - Offset to next component of HPID\n", surface_header.Offset1, surface_header.Offset1);;
                fprintf(dump_file, "Padding : 0x%04X   - Always 0\n\n", surface_header.Padding1);

                // absolute position of next component or hpid section
                DWORD Offset1Base = SURFile->Position;
			    DWORD NextPos = Offset1Base + surface_header.Offset1;
			    if(NextPos > SURFile->Size) NextPos = SURFile->Size;

                // Surface
                SURFile->Read(&surface, sizeof(TSurface));

                fprintf(dump_file, "Surface      :\n");
                fprintf(dump_file, "CenterX      : %f\t CenterY : %f\t CenterZ : %f\n", surface.center[0], surface.center[1], surface.center[2]);
                fprintf(dump_file, "InertiaX     : %f\t InertiaY : %f\t InertiaZ : %f\n", surface.inertia_moment[0], surface.inertia_moment[1], surface.inertia_moment[2]);
                fprintf(dump_file, "Radius       : %f\n", surface.radius);
                AnsiString binary = IntToBinary(surface.unknown);
                fprintf(dump_file, "unknown byte : 0x%02X             - (%d decimal %s binary)\n", surface.unknown, surface.unknown, binary.c_str());
                fprintf(dump_file, "Offset1b     : 0x%04X   (%d) - always identical to surface_header.offset1\n", surface.Offset1b, surface.Offset1b);
                fprintf(dump_file, "padding byte : 0x%02X             - Always 0\n", surface.Padding2);
                fprintf(dump_file, "Offset2      : 0x%08X       - Offset to bit header\n", surface.Offset2);

                // absolute position of bit_header
                DWORD BitsPos = Offset1Base + surface.Offset2;

                fprintf(dump_file, "Padding3     : 0x%08X\t0x%08X\t0x%08X    - Always 0\n\n", surface.Padding3[0], surface.Padding3[1], surface.Padding3[2]);

                // for absolute position of vertex buffer
                this_pos = SURFile->Position;

                // First triangle group header
                SURFile->Read(&triangle_group_header, sizeof(TSurTriangleGroupHeader));
                VertBufPtr = this_pos + triangle_group_header.Offset3;  // vertex buffer absolute

                while(SURFile->Position < VertBufPtr) {
                    fprintf(dump_file, "Triangle group header :\n");
                    fprintf(dump_file, "Offset3      : 0x%08X    - (%d) Offset to vertex buffer\n", triangle_group_header.Offset3, triangle_group_header.Offset3);
                    fprintf(dump_file, "TriangleID   : 0x%08X    - \"%s\"\n", triangle_group_header.TriangleID, NameCRC->GenerateName(triangle_group_header.TriangleID));

                    switch(triangle_group_header.type) {
                        case 4 : fprintf(dump_file, "type         : 4             - Primitive = D3DPT_TRIANGLELIST\n"); break;
                        case 5 : fprintf(dump_file, "type         : 5             - Primitive = D3DPT_TRIANGLESTRIP\n"); break;
                        default : fprintf(dump_file, "type         : ?             - Unknown Primitive");
                    }

                    fprintf(dump_file, "no_ref_verts : %d\n", triangle_group_header.no_ref_verts);
                    fprintf(dump_file, "Padding4     : 0x%02X\n", triangle_group_header.padding4);
                    fprintf(dump_file, "Tricount     : %d\t     - No of triangles in group (0 -> n-1)\n\n", triangle_group_header.Tricount);

                    // triangle list
                    fprintf(dump_file, "Triangle list :\n");
                    fprintf(dump_file, "Number\tOpp Tri\tFlag\tVert1\tOffset1\tFlags1\tVert2\tOffset2\tFlag2\tVert3\tOffset3\tFlag3\n");

                    for(DWORD count = 0; count < triangle_group_header.Tricount; count++) {
                        SURFile->Read(&triangle, sizeof(TSurTriangle));
                        fprintf(dump_file, "%d\t%d\t%d\t%d\t%d\t%d\t%d\t%d\t%d\t%d\t%d\t%d\n", triangle.TriNumber, triangle.tri_op, triangle.flag, triangle.Vertex1, triangle.offset1, triangle.flag1, triangle.Vertex2, triangle.offset2, triangle.flag2, triangle.Vertex3, triangle.offset3, triangle.flag3);
                    }
                    fprintf(dump_file, "\n");

                    // read next tri header if exists
                    if(SURFile->Position < VertBufPtr)
                        SURFile->Read(&triangle_group_header, sizeof(TSurTriangleGroupHeader));
                }

                // vertices
                fprintf(dump_file, "Vertex list :\n");
                fprintf(dump_file, "No\tVertex X\tVertex Y\tVertex Z\tMesh ID\n");

                while(SURFile->Position < BitsPos) {
                    SURFile->Read(&vertex, sizeof(TSurVertex));

                    AnsiString id = NameCRC->GenerateName(vertex.TriID);
                    // calculate resizing data if part of main model (not hardpoint, shield, collision or debris)
                    //        not shield             not hardpoint
                    if((vertex.TriID != 0xF00FB9DE)  && (!StrPos(id.c_str(), "Hp"))) {
                        if(vertex.X > sur_resize_data2.xmax) sur_resize_data2.xmax = vertex.X;
                        else if(vertex.X < sur_resize_data2.xmin) sur_resize_data2.xmin = vertex.X;

                        if(vertex.Y > sur_resize_data2.ymax) sur_resize_data2.ymax = vertex.Y;
                        else if(vertex.Y < sur_resize_data2.ymin) sur_resize_data2.ymin = vertex.Y;

                        if(vertex.Z > sur_resize_data2.zmax) sur_resize_data2.zmax = vertex.Z;
                        else if(vertex.Z < sur_resize_data2.zmin) sur_resize_data2.zmin = vertex.Z;
                    }

                    fprintf(dump_file, "%f\t%f\t%f\t%s\n", vertex.X, vertex.Y, vertex.Z, NameCRC->GenerateName(vertex.TriID));
                }
                fprintf(dump_file, "\n");

                // these for quick calculation of sizing multiplier
                sur_resize_data2.x_length = sur_resize_data2.xmax + fabs(sur_resize_data2.xmin);
                sur_resize_data2.y_length = sur_resize_data2.ymax + fabs(sur_resize_data2.ymin);
                sur_resize_data2.z_length = sur_resize_data2.zmax + fabs(sur_resize_data2.zmin);

                // bits section
                fprintf(dump_file, "Bits section :\n");
                fprintf(dump_file, "Sibling\tTriangles\tCenter X\tCenter Y\tCenter Z\tRadius\t\tUnknown\n");

                while(SURFile->Position < NextPos) {
                    SURFile->Read(&bits_section, sizeof(TBitsSection));

                    fprintf(dump_file, "%d\t%d\t\t%f\t%f\t%f\t%f\t0x%08X\n", bits_section.offset_to_next_sibling, bits_section.offset_to_triangles, bits_section.cenX, bits_section.cenY, bits_section.cenZ, bits_section.radius, bits_section.color);
                }
            }
        }

        fclose(dump_file);
        MainForm->SURMemo->Lines->LoadFromFile(file);
    }

    delete NameCRC;
}
//---------------------------------------------------------------------------
