//---------------------------------------------------------------------------

#ifndef cmpH
#define cmpH

#include <vcl.h>
#pragma hdrstop
//---------------------------------------------------------------------------
// CMP File Structs

// data header - 16 bytes long
struct TVMeshDataHeader {
    DWORD unknown1;              // 0x00000001
    DWORD unknown2;              // 0x00000004
    WORD  no_meshes;
    WORD  no_ref_vertices;
    WORD  fvf;             // 0x0112
    WORD  no_vertices;
};

// repeated <no_meshes> times in segment - 12 bytes
struct TMeshHeader {
    DWORD material_id;           // crc of texture name for mesh
    WORD  start_vertex;
    WORD  end_vertex;
    WORD  no_ref_vertices;
    WORD  padding;         // 0x00CC
};

// triangle definition - 6 bytes
struct TTriangle {
    WORD  vertex1;
    WORD  vertex2;
    WORD  vertex3;
};

// vertex definition - 32 bytes
struct TVertex {
    float x;
    float y;
    float z;
    float normal_x;
    float normal_y;
    float normal_z;
    float u;
    float v;
};

// one per lod for each .3db section of cmp - 60 bytes
struct TVMeshRef {
    DWORD header_size;           // 0x0000003C
    DWORD vmesh_id;              // crc of 3db name
    WORD  start_vert;
    WORD  end_vert;
    WORD  start_vert_ref;
    WORD  end_vert_ref;
    WORD  mesh_no;
    WORD  no_of_meshes;

    float bounding_box[6];
    float center[3];
    float radius;
};

// header for the .cmp or .3db file - 44 bytes
struct TUTFHeader {
    DWORD UTF;                   // "UTF "
    DWORD version;               // version
    DWORD tree_seg_offset;
    DWORD tree_seg_size;
    DWORD unknown1;              // header offset?
    DWORD header_size;           // 44
    DWORD string_seg_offset;
    DWORD string_seg_space_allocated;  // } can be the same
    DWORD string_seg_space_used;       // }
    DWORD data_seg_offset;
    DWORD unknown2;
};

// node structure - one per leaf or intermediate node - 44 bytes
struct TUTFNode {
    DWORD sibling_offset;    // next node on same level
    DWORD string_offset;     // string for this node
    DWORD flags;             // bit 4 set = intermediate, bit 7 set = leaf
    DWORD unknown;           // always seems to be zero
    DWORD child_offset;      // next node in if intermediate, offset to data if leaf
    DWORD allocated_size;    // leaf node only, 0 for intermediate
    DWORD size1;             // leaf node only, 0 for intermediate
    DWORD size2;             // leaf node only, 0 for intermediate
    DWORD time1;             // seems to be timestamps. can be zero
    DWORD time2;
    DWORD time3;
};

// structures by Mario Brito
//---------------------------------------------------------------------------
struct TVWireData {
    DWORD header_size;
    DWORD vmeshlib_crc_id;
    WORD  unknown1;       // offset into vertex buffer?
    WORD  no_vertices;
    WORD  no_ref_vertices;
    WORD  unknown2;
};

struct TVWireDataLine {
    WORD point1;
    WORD point2;
};
// structures by Colin Sandby
//---------------------------------------------------------------------------
struct THPPosition {
    float x, y, z;
};
//---------------------------------------------------------------------------
struct TNewInfo {
    float xmin;
    float xmax;
    float ymin;
    float ymax;
    float zmin;
    float zmax;
    float center[3];
    float radius;
};
//---------------------------------------------------------------------------
AnsiString GetNodeName(UINT offset);
void ReadNode(UINT pos, TUTFNode *node);
TUTFNode *AllocNodeMem(void);
void CMPResize(float x_scale, float y_scale, float z_scale);
void GetFileInfo(void);
void PrescanModel(void);
void DumpVMeshData(void);
void DumpVWireData(void);
void DumpVMeshRef(void);
//---------------------------------------------------------------------------
#endif
