//---------------------------------------------------------------------------
#include <vcl.h>
#include <math.h>
#include <exception>
#include <iostream>
#pragma hdrstop

#include "main.h"
#include "cmp.h"
#include "partname.h"
//---------------------------------------------------------------------------
extern TMemoryStream *CMPFile, *NewCMPFile;
extern DWORD CMPDataOffset;
extern TSURResizeData sur_resize_data;

DWORD Lod_Offset[20];
DWORD Mesh_Info[20][2];
//---------------------------------------------------------------------------
AnsiString GetNodeName(UINT offset) {
    char c;
    AnsiString name = "";

    CMPFile->Seek(offset, soFromBeginning);
    CMPFile->Read(&c, (int)(sizeof(char)));

    while((BYTE)c != 0) {
        name += c;
        CMPFile->Read(&c, (int)(sizeof(char)));
    }

    return name;
}
//---------------------------------------------------------------------------
void ReadNode(UINT pos, TUTFNode *node) {
    CMPFile->Seek(pos, soFromBeginning);
    CMPFile->Read(node, (int)(sizeof(TUTFNode)));
}
//---------------------------------------------------------------------------
TUTFNode *AllocNodeMem(void) {
    TUTFNode *node = NULL;

    try {
        node = new TUTFNode;
    }
    catch (std::bad_alloc) {
        MessageDlg("Memory allocation failed - UTF node.",
               mtError, TMsgDlgButtons() << mbOK, 0);
    }

    return node;
}
//---------------------------------------------------------------------------
void CalculateSURResizeData(void) {
    TVMeshDataHeader vmeshdataheader;
    TMeshHeader      mesh;
    TTriangle        tri;
    TVertex          vert;

    DWORD vertex_offset = 0, lod = 0;

    float temp = 0;

    // LOD data
    //if(Lod_Offset[1]) lod = Lod_Offset[1];
    //else lod = Lod_Offset[0];

    lod = Mesh_Info[0][1];

    CMPFile->Seek(lod, soFromBeginning);
    CMPFile->Read(&vmeshdataheader, sizeof(TVMeshDataHeader));

    //vertex_offset = (vmeshdataheader.no_meshes * sizeof(TMeshHeader));
    //vertex_offset += ((vmeshdataheader.no_ref_vertices / 3) * sizeof(TTriangle));

    //CMPFile->Seek((CMPDataOffset + vertex_offset), soFromBeginning);

    // reset the size storage
    sur_resize_data.xmin = sur_resize_data.xmax = 0;
    sur_resize_data.ymin = sur_resize_data.ymax = 0;
    sur_resize_data.zmin = sur_resize_data.zmax = 0;

    for(int i = 0; i < vmeshdataheader.no_meshes; i++)
        CMPFile->Read(&mesh, sizeof(TMeshHeader));

    int c = vmeshdataheader.no_ref_vertices / 3; // no triangles
    for(int i = 0; i < c; i++)
        CMPFile->Read(&tri, sizeof(TTriangle));

    for(int i = 0; i < vmeshdataheader.no_vertices; i++) {
        CMPFile->Read(&vert, sizeof(TVertex));

        if(vert.x > sur_resize_data.xmax) sur_resize_data.xmax = vert.x;
        else if(vert.x < sur_resize_data.xmin) sur_resize_data.xmin = vert.x;

        if(vert.y > sur_resize_data.ymax) sur_resize_data.ymax = vert.y;
        else if(vert.y < sur_resize_data.ymin) sur_resize_data.ymin = vert.y;

        if(vert.z > sur_resize_data.zmax) sur_resize_data.zmax = vert.z;
        else if(vert.z < sur_resize_data.zmin) sur_resize_data.zmin = vert.z;
    }

    // these for quick calculation of sizing multiplier
    sur_resize_data.x_length = sur_resize_data.xmax + fabs(sur_resize_data.xmin);
    sur_resize_data.y_length = sur_resize_data.ymax + fabs(sur_resize_data.ymin);
    sur_resize_data.z_length = sur_resize_data.zmax + fabs(sur_resize_data.zmin);

    // store the center for re-aligning the sur file to the model
    // dodgy calculation but seems to work ok :D
    temp = sur_resize_data.xmax + sur_resize_data.xmin;
    if(temp != 0) temp /=2;
    sur_resize_data.center_x = temp;
    temp = sur_resize_data.ymax + sur_resize_data.ymin;
    if(temp != 0) temp /=2;
    sur_resize_data.center_y = temp;
    temp = sur_resize_data.zmax + sur_resize_data.zmin;
    if(temp != 0) temp /=2;
    sur_resize_data.center_z = temp;
}
//---------------------------------------------------------------------------
/*   Dev version - change to old version of vertex finding and should work
void Update(DWORD vmeshref_pos) {
    // calculate bounding box info from vertices for cmp fix
    TVMeshDataHeader vmeshdataheader;
    TMeshHeader      mesh, mesh2;
    TTriangle        tri;
    TVertex          vert;
    TVMeshRef        vmeshref, new_vmeshref;

    DWORD vertex_offset = 0, mesh_offset = 0, this_pos = 0;

    float xmin = 0, xmax = 0;
    float ymin = 0, ymax = 0;
    float zmin = 0, zmax = 0;
    float radius_x, radius_y, radius_z = 0;
    float temp;

    int count, mesh_count, mesh_no, no_verts;

    // read the current vmeshref
    CMPFile->Seek(vmeshref_pos, soFromBeginning);
    CMPFile->Read(&vmeshref, sizeof(TVMeshRef));

    mesh_count = vmeshref.no_of_meshes;
    mesh_no = vmeshref.mesh_no;

    //mesh_offset = (CMPDataOffset + sizeof(TVMeshDataHeader));
    CMPFile->Seek(CMPDataOffset, soFromBeginning);
    CMPFile->Read(&vmeshdataheader, sizeof(TVMeshDataHeader));

    for(count = 0; count < mesh_no; count++) {
        CMPFile->Read(&mesh, sizeof(TMeshHeader));
    }

    // loop through all meshes in the 3db
    do {
        CMPFile->Read(&mesh, sizeof(TMeshHeader));

        this_pos = CMPFile->Position;

        // skip rest of meshes
        for(int i = mesh_no; i < vmeshdataheader.no_meshes; i++)
        CMPFile->Read(&mesh2, sizeof(TMeshHeader));

        // skip triangles
        int c = vmeshdataheader.no_ref_vertices / 3; // no triangles
        for(int i = 0; i < c; i++)
            CMPFile->Read(&tri, sizeof(TTriangle));

        // skip vertices before ones we want 
        for(int i = 0; i < mesh.start_vertex; i++)
            CMPFile->Read(&vert, sizeof(TVertex));

        no_verts = mesh.end_vertex - mesh.start_vertex;

        for(int i = 0; i < no_verts; i++) {
            CMPFile->Read(&vert, sizeof(TVertex));

            if(vert.x > xmax) xmax = vert.x;
            else if(vert.x < xmin) xmin = vert.x;

            if(vert.y > ymax) ymax = vert.y;
            else if(vert.y < ymin) ymin = vert.y;

            if(vert.z > zmax) zmax = vert.z;
            else if(vert.z < zmin) zmin = vert.z;
        }

        new_vmeshref.bounding_box[1] = xmin;
        new_vmeshref.bounding_box[0] = xmax;
        new_vmeshref.bounding_box[3] = ymin;
        new_vmeshref.bounding_box[2] = ymax;
        new_vmeshref.bounding_box[5] = zmin;
        new_vmeshref.bounding_box[4] = zmax;

        // next mesh if exists
        CMPFile->Seek(this_pos, soFromBeginning);
    } while(--mesh_count > 0);

    // dodgy calculation but seems to work ok :D
    temp = xmax + xmin;
    if(temp != 0) temp /=2;
    new_vmeshref.center[0] = temp;
    temp = ymax + ymin;
    if(temp != 0) temp /=2;
    new_vmeshref.center[1] = temp;
    temp = zmax + zmin;
    if(temp != 0) temp /=2;
    new_vmeshref.center[2] = temp;

    radius_x = MAX(xmax, abs(xmin));
    radius_y = MAX(ymax, abs(ymin));
    radius_z = MAX(zmax, abs(zmin));
    // Ta Colin
    new_vmeshref.radius = sqrt((radius_x * radius_x) + (radius_y * radius_y) + (radius_z * radius_z));

    // write new info
    AnsiString temp_s;
    temp_s.printf("new radius : %f", new_vmeshref.radius);
    MainForm->CMPMemo->Lines->Add(temp_s);
}
*/
//---------------------------------------------------------------------------
void Update(DWORD vmeshref_pos) {
    TVMeshDataHeader vmeshdataheader;
    TMeshHeader      mesh;
    TTriangle        tri;
    TVertex          vert;
    TVMeshRef        vmeshref;

    DWORD vertex_offset = 0, lod = 0;
    float radius_x = 0, radius_y = 0, radius_z = 0, temp = 0;

    AnsiString temp_s;

    // vmesh ref for current 3db section
    CMPFile->Seek(vmeshref_pos, soFromBeginning);
    CMPFile->Read(&vmeshref, sizeof(TVMeshRef));

    // first LOD data
    //if(Lod_Offset[1]) lod = Lod_Offset[1];
    //else lod = Lod_Offset[0];

    // search stored vms crc's for appropriate one
    for(int count = 0; count < 20; count++) {
        if(vmeshref.vmesh_id == Mesh_Info[count][0]) {
            lod = Mesh_Info[count][1];
            break;
        }
    }
    //lod = Mesh_Info[0][1];

    CMPFile->Seek(lod, soFromBeginning);
    CMPFile->Read(&vmeshdataheader, sizeof(TVMeshDataHeader));

    for(int i = 0; i < vmeshdataheader.no_meshes; i++)
        CMPFile->Read(&mesh, sizeof(TMeshHeader));

    int c = vmeshdataheader.no_ref_vertices / 3; // no triangles
    for(int i = 0; i < c; i++)
        CMPFile->Read(&tri, sizeof(TTriangle));

    MainForm->CMPMemo->Lines->Add("Original Data");
    MainForm->CMPMemo->Lines->Add("-------------");
    MainForm->CMPMemo->Lines->Add("");
    MainForm->CMPMemo->Lines->Add("Bounding box info :");
    temp_s.printf("x1 %.6f\tx2 %.6f", vmeshref.bounding_box[0], vmeshref.bounding_box[1]);
    MainForm->CMPMemo->Lines->Add(temp_s);
    temp_s.printf("y1 %.6f\ty2 %.6f", vmeshref.bounding_box[2], vmeshref.bounding_box[3]);
    MainForm->CMPMemo->Lines->Add(temp_s);
    temp_s.printf("z1 %.6f\tz2 %.6f", vmeshref.bounding_box[4], vmeshref.bounding_box[5]);
    MainForm->CMPMemo->Lines->Add(temp_s);
    MainForm->CMPMemo->Lines->Add("Center :");
    temp_s.printf("%.6f\t%.6f\t%.6f", vmeshref.center[0], vmeshref.center[1], vmeshref.center[2]);
    MainForm->CMPMemo->Lines->Add(temp_s);
    MainForm->CMPMemo->Lines->Add("Radius :");
    temp_s.printf("%.6f", vmeshref.radius);
    MainForm->CMPMemo->Lines->Add(temp_s);
    MainForm->CMPMemo->Lines->Add("");

    vmeshref.bounding_box[0] = 0;
    vmeshref.bounding_box[1] = 0;
    vmeshref.bounding_box[2] = 0;
    vmeshref.bounding_box[3] = 0;
    vmeshref.bounding_box[4] = 0;
    vmeshref.bounding_box[5] = 0;

    // calculate new bounding box (many custom ships have values reversed)
    for(int i = 0; i < vmeshdataheader.no_vertices; i++) {
        CMPFile->Read(&vert, sizeof(TVertex));

        if(vert.x < vmeshref.bounding_box[1]) vmeshref.bounding_box[1] = vert.x;
        else if(vert.x > vmeshref.bounding_box[0]) vmeshref.bounding_box[0] = vert.x;

        if(vert.y < vmeshref.bounding_box[3]) vmeshref.bounding_box[3] = vert.y;
        else if(vert.y > vmeshref.bounding_box[2]) vmeshref.bounding_box[2] = vert.y;

        if(vert.z < vmeshref.bounding_box[5])
            vmeshref.bounding_box[5] = vert.z;
        else if(vert.z > vmeshref.bounding_box[4]) vmeshref.bounding_box[4] = vert.z;
    }

    // dodgy calculation but seems to work ok :D
    temp = vmeshref.bounding_box[0] + vmeshref.bounding_box[1];
    if(temp != 0) temp /=2;
    vmeshref.center[0] = temp;
    temp = vmeshref.bounding_box[2] + vmeshref.bounding_box[3];
    if(temp != 0) temp /=2;
    vmeshref.center[1] = temp;
    temp = vmeshref.bounding_box[4] + vmeshref.bounding_box[5];
    if(temp != 0) temp /=2;
    vmeshref.center[2] = temp;

    radius_x = MAX(vmeshref.bounding_box[0], fabs(vmeshref.bounding_box[1]));
    radius_y = MAX(vmeshref.bounding_box[2], fabs(vmeshref.bounding_box[3]));
    radius_z = MAX(vmeshref.bounding_box[4], fabs(vmeshref.bounding_box[5]));
    // Ta Colin
    vmeshref.radius = sqrt((radius_x * radius_x) + (radius_y * radius_y) + (radius_z * radius_z));
    // extra 25% to cover cuboid object corners
    vmeshref.radius += (vmeshref.radius * 0.25);

    // user feedback
    MainForm->CMPMemo->Lines->Add("New Data");
    MainForm->CMPMemo->Lines->Add("--------");
    MainForm->CMPMemo->Lines->Add("");
    MainForm->CMPMemo->Lines->Add("Bounding box info :");
    temp_s.printf("x1 %.6f\tx2 %.6f", vmeshref.bounding_box[0], vmeshref.bounding_box[1]);
    MainForm->CMPMemo->Lines->Add(temp_s);
    temp_s.printf("y1 %.6f\ty2 %.6f", vmeshref.bounding_box[2], vmeshref.bounding_box[3]);
    MainForm->CMPMemo->Lines->Add(temp_s);
    temp_s.printf("z1 %.6f\tz2 %.6f", vmeshref.bounding_box[4], vmeshref.bounding_box[5]);
    MainForm->CMPMemo->Lines->Add(temp_s);
    MainForm->CMPMemo->Lines->Add("Center :");
    temp_s.printf("%.6f\t%.6f\t%.6f", vmeshref.center[0], vmeshref.center[1], vmeshref.center[2]);
    MainForm->CMPMemo->Lines->Add(temp_s);
    MainForm->CMPMemo->Lines->Add("Radius :");
    temp_s.printf("%.6f", vmeshref.radius);
    MainForm->CMPMemo->Lines->Add(temp_s);
    MainForm->CMPMemo->Lines->Add("");
    MainForm->CMPMemo->Lines->Add("Hit Save button to finalise new values");

    // update vmesh ref in cmp file
    CMPFile->Seek(vmeshref_pos, soFromBeginning);
    CMPFile->Write(&vmeshref, sizeof(TVMeshRef));
}
//---------------------------------------------------------------------------
void CMPResize(float x_scale, float y_scale, float z_scale) {
    TVMeshDataHeader vmeshdataheader;
    TMeshHeader      mesh;
    TTriangle        tri;
    TVertex          vert;
    TVMeshRef        vmeshref;
    TUTFHeader       utf;
    THPPosition      hp_pos;
    
    DWORD this_pos = 0;

    AnsiString temp_s;
    UINT tree_pos = 0;

    CMPFile->Seek(0, soFromBeginning);
    CMPFile->Read(&utf, sizeof(TUTFHeader));

    // data reference for operations
    CMPDataOffset = utf.data_seg_offset;

    tree_pos = utf.tree_seg_offset;

    MainForm->UTFTreeView->Items->Clear(); // remove any existing nodes

    // Add a root node
    TUTFNode *root = NULL;
    TTreeNode *RootNode = NULL;

    if(root = AllocNodeMem()) {
        TTreeNode *Lvl1Node = NULL;

        ReadNode(tree_pos, root);
        RootNode = MainForm->UTFTreeView->Items->Add(NULL, GetNodeName(utf.string_seg_offset + root->string_offset));

        TUTFNode *lvl1 = NULL;
        tree_pos = utf.tree_seg_offset + root->child_offset;

        if(lvl1 = AllocNodeMem()) {
            do {
                ReadNode(tree_pos, lvl1);
                Lvl1Node = MainForm->UTFTreeView->Items->AddChild(RootNode, GetNodeName(utf.string_seg_offset + lvl1->string_offset));

                if((lvl1->flags & 0x10)) {  // if an intermediate node
                    TUTFNode *lvl2 = NULL;
                    TTreeNode *Lvl2Node = NULL;
                    tree_pos = utf.tree_seg_offset + lvl1->child_offset;

                    if(lvl2 = AllocNodeMem()) {
                        do {
                            ReadNode(tree_pos, lvl2);
                            Lvl2Node = MainForm->UTFTreeView->Items->AddChild(Lvl1Node, GetNodeName(utf.string_seg_offset + lvl2->string_offset));

                            if((lvl2->flags & 0x10)) {  // if an intermediate node
                                TUTFNode *lvl3 = NULL;
                                TTreeNode *Lvl3Node = NULL;
                                tree_pos = utf.tree_seg_offset + lvl2->child_offset;

                                if(lvl3 = AllocNodeMem()) {
                                    do {
                                        ReadNode(tree_pos, lvl3);
                                        Lvl3Node = MainForm->UTFTreeView->Items->AddChild(Lvl2Node, GetNodeName(utf.string_seg_offset + lvl3->string_offset));

                                        if((lvl3->flags & 0x10)) {  // if an intermediate node
                                            TUTFNode *lvl4 = NULL;
                                            TTreeNode *Lvl4Node = NULL;
                                            tree_pos = utf.tree_seg_offset + lvl3->child_offset;

                                            if(lvl4 = AllocNodeMem()) {
                                                do {
                                                    ReadNode(tree_pos, lvl4);
                                                    Lvl4Node = MainForm->UTFTreeView->Items->AddChild(Lvl3Node, GetNodeName(utf.string_seg_offset + lvl4->string_offset));

                                                    if((lvl4->flags & 0x10)) {  // if an intermediate node
                                                        TUTFNode *lvl5 = NULL;
                                                        TTreeNode *Lvl5Node = NULL;
                                                        tree_pos = utf.tree_seg_offset + lvl4->child_offset;

                                                        if(lvl5 = AllocNodeMem()) {
                                                            do {
                                                                ReadNode(tree_pos, lvl5);
                                                                Lvl5Node = MainForm->UTFTreeView->Items->AddChild(Lvl4Node, GetNodeName(utf.string_seg_offset + lvl5->string_offset));

                                                                if((lvl5->flags & 0x10)) {  // if an intermediate node
                                                                    TUTFNode *lvl6 = NULL;
                                                                    TTreeNode *Lvl6Node = NULL;
                                                                    tree_pos = utf.tree_seg_offset + lvl5->child_offset;

                                                                    if(lvl6 = AllocNodeMem()) {
                                                                        do {
                                                                            ReadNode(tree_pos, lvl6);
                                                                            Lvl6Node = MainForm->UTFTreeView->Items->AddChild(Lvl5Node, GetNodeName(utf.string_seg_offset + lvl6->string_offset));

                                                                            Lvl6Node->Data = (void *)(utf.data_seg_offset + lvl6->child_offset);

                                                                            tree_pos = utf.tree_seg_offset + lvl6->sibling_offset;
                                                                        } while(lvl6->sibling_offset != 0);

                                                                        delete lvl6;
                                                                    }
                                                                }
                                                                else {
                                                                    Lvl5Node->Data = (void *)(utf.data_seg_offset + lvl5->child_offset);

                                                                    // resize hardpoint positions
                                                                    if(Lvl5Node->Text.LowerCase() == "position") {
                                                                        CMPFile->Seek((utf.data_seg_offset + lvl5->child_offset), soFromBeginning);
                                                                        this_pos = CMPFile->Position;
                                                                        CMPFile->Read(&hp_pos, sizeof(THPPosition));

                                                                        hp_pos.x *= x_scale;
                                                                        hp_pos.y *= y_scale;
                                                                        hp_pos.z *= z_scale;

                                                                        CMPFile->Seek(this_pos, soFromBeginning);
                                                                        CMPFile->Write(&hp_pos, sizeof(THPPosition));
                                                                    }

                                                                    // fix up radius etc. after resize
                                                                    if(Lvl5Node->Text.LowerCase() == "vmeshref") {
                                                                        //CMPFile->Seek((utf.data_seg_offset + lvl5->child_offset), soFromBeginning);
                                                                        //this_pos = CMPFile->Position;
                                                                        //CMPFile->Read(&vmeshref, sizeof(TVMeshRef));

                                                                        //CMPFile->Seek(this_pos, soFromBeginning);
                                                                        //CMPFile->Write(&vmeshref, sizeof(TVMeshRef));

                                                                        Update(utf.data_seg_offset + lvl5->child_offset);
                                                                    }
                                                                }

                                                                tree_pos = utf.tree_seg_offset + lvl5->sibling_offset;
                                                            } while(lvl5->sibling_offset != 0);

                                                            delete lvl5;
                                                        }
                                                    }
                                                    else {
                                                        Lvl4Node->Data = (void *)(utf.data_seg_offset + lvl4->child_offset);

                                                        // resize hardpoint positions for 3db files
                                                        if(Lvl4Node->Text.LowerCase() == "position") {
                                                            CMPFile->Seek((utf.data_seg_offset + lvl4->child_offset), soFromBeginning);
                                                            this_pos = CMPFile->Position;
                                                            CMPFile->Read(&hp_pos, sizeof(THPPosition));

                                                            hp_pos.x *= x_scale;
                                                            hp_pos.y *= y_scale;
                                                            hp_pos.z *= z_scale;

                                                            CMPFile->Seek(this_pos, soFromBeginning);
                                                            CMPFile->Write(&hp_pos, sizeof(THPPosition));
                                                        }
                                                    }

                                                    tree_pos = utf.tree_seg_offset + lvl4->sibling_offset;
                                                } while(lvl4->sibling_offset != 0);

                                                delete lvl4;
                                            }
                                        }
                                        else {
                                            Lvl3Node->Data = (void *)(utf.data_seg_offset + lvl3->child_offset);

                                            // resize LOD data
                                            if(Lvl3Node->Text.LowerCase() == "vmeshdata") {
                                                CMPFile->Seek((utf.data_seg_offset + lvl3->child_offset), soFromBeginning);
                                                CMPFile->Read(&vmeshdataheader, sizeof(TVMeshDataHeader));

                                                for(int i = 0; i < vmeshdataheader.no_meshes; i++)
                                                    CMPFile->Read(&mesh, sizeof(TMeshHeader));

                                                int c = vmeshdataheader.no_ref_vertices / 3; // no triangles
                                                for(int i = 0; i < c; i++)
                                                    CMPFile->Read(&tri, sizeof(TTriangle));

                                                for(int i = 0; i < vmeshdataheader.no_vertices; i++) {
                                                    this_pos = CMPFile->Position;
                                                    CMPFile->Read(&vert, sizeof(TVertex));

                                                    vert.x *= x_scale;
                                                    vert.y *= y_scale;
                                                    vert.z *= z_scale;
                                                    CMPFile->Seek(this_pos, soFromBeginning);
                                                    CMPFile->Write(&vert, sizeof(TVertex));
                                                }
                                            }

                                            // fix up radius etc. after resize
                                            if(Lvl3Node->Text.LowerCase() == "vmeshref") {
                                                Update(utf.data_seg_offset + lvl3->child_offset);
                                            }

                                        }

                                        tree_pos = utf.tree_seg_offset + lvl3->sibling_offset;
                                    } while(lvl3->sibling_offset != 0);

                                    delete lvl3;
                                }
                            }
                            else {
                                Lvl2Node->Data = (void *)(utf.data_seg_offset + lvl2->child_offset);

                                // fix up radius etc. after resize for 3db file
                                if(Lvl2Node->Text.LowerCase() == "vmeshref") {
                                    Update(utf.data_seg_offset + lvl2->child_offset);
                                }
                            }

                            tree_pos = utf.tree_seg_offset + lvl2->sibling_offset;
                        } while(lvl2->sibling_offset != 0);

                        delete lvl2;
                    }
                }
                else {   // leaf node so store the data for viewing if required
                    //FillNodeData(Lvl1Node->Text, utf.data_seg_offset + lvl1->child_offset, lvl1->size1);
                    Lvl1Node->Data = (void *)(utf.data_seg_offset + lvl1->child_offset);
                }

                tree_pos = utf.tree_seg_offset + lvl1->sibling_offset;
            } while(lvl1->sibling_offset != 0);

            delete lvl1;
        }

        delete root;
    }

    CalculateSURResizeData();

    MainForm->CMPMemo->Clear();
    GetFileInfo();

    MainForm->CMPMemo->Lines->Add("");
    MainForm->CMPMemo->Lines->Add("Resize Complete...");
    MainForm->CMPMemo->Lines->Add("Hit Save button to finalise new values");
}
//---------------------------------------------------------------------------
void GetFileInfo(void) {
    TUTFHeader *utf = NULL;

    try {
        utf = new TUTFHeader;
    }
    catch (std::bad_alloc) {
        MessageDlg("Memory allocation failed - UTF header.",
               mtError, TMsgDlgButtons() << mbOK, 0);

        return;
    }

    // traverse the UTF tree to fill in node names (6 levels down as that seems the most used)
    if(utf) {
        UINT tree_pos = 0;

        CMPFile->Seek(0, soFromBeginning);
        CMPFile->Read(utf, (int)(sizeof(TUTFHeader)));

        // data reference for operations
        CMPDataOffset = utf->data_seg_offset;

        tree_pos = utf->tree_seg_offset;

        MainForm->UTFTreeView->Items->Clear(); // remove any existing nodes

        // Add a root node
        TUTFNode *root = NULL;
        TTreeNode *RootNode = NULL;

        if(root = AllocNodeMem()) {
            TTreeNode *Lvl1Node = NULL;

            ReadNode(tree_pos, root);
            RootNode = MainForm->UTFTreeView->Items->Add(NULL, GetNodeName(utf->string_seg_offset + root->string_offset));

            TUTFNode *lvl1 = NULL;
            tree_pos = utf->tree_seg_offset + root->child_offset;

            if(lvl1 = AllocNodeMem()) {
                do {
                    ReadNode(tree_pos, lvl1);
                    Lvl1Node = MainForm->UTFTreeView->Items->AddChild(RootNode, GetNodeName(utf->string_seg_offset + lvl1->string_offset));

                    if((lvl1->flags & 0x10)) {  // if an intermediate node
                        TUTFNode *lvl2 = NULL;
                        TTreeNode *Lvl2Node = NULL;
                        tree_pos = utf->tree_seg_offset + lvl1->child_offset;

                        if(lvl2 = AllocNodeMem()) {
                            do {
                                ReadNode(tree_pos, lvl2);
                                Lvl2Node = MainForm->UTFTreeView->Items->AddChild(Lvl1Node, GetNodeName(utf->string_seg_offset + lvl2->string_offset));

                                if((lvl2->flags & 0x10)) {  // if an intermediate node
                                    TUTFNode *lvl3 = NULL;
                                    TTreeNode *Lvl3Node = NULL;
                                    tree_pos = utf->tree_seg_offset + lvl2->child_offset;

                                    if(lvl3 = AllocNodeMem()) {
                                        do {
                                            ReadNode(tree_pos, lvl3);
                                            Lvl3Node = MainForm->UTFTreeView->Items->AddChild(Lvl2Node, GetNodeName(utf->string_seg_offset + lvl3->string_offset));

                                            if((lvl3->flags & 0x10)) {  // if an intermediate node
                                                TUTFNode *lvl4 = NULL;
                                                TTreeNode *Lvl4Node = NULL;
                                                tree_pos = utf->tree_seg_offset + lvl3->child_offset;

                                                if(lvl4 = AllocNodeMem()) {
                                                    do {
                                                        ReadNode(tree_pos, lvl4);
                                                        Lvl4Node = MainForm->UTFTreeView->Items->AddChild(Lvl3Node, GetNodeName(utf->string_seg_offset + lvl4->string_offset));

                                                        if((lvl4->flags & 0x10)) {  // if an intermediate node
                                                            TUTFNode *lvl5 = NULL;
                                                            TTreeNode *Lvl5Node = NULL;
                                                            tree_pos = utf->tree_seg_offset + lvl4->child_offset;

                                                            if(lvl5 = AllocNodeMem()) {
                                                                do {
                                                                    ReadNode(tree_pos, lvl5);
                                                                    Lvl5Node = MainForm->UTFTreeView->Items->AddChild(Lvl4Node, GetNodeName(utf->string_seg_offset + lvl5->string_offset));

                                                                    if((lvl5->flags & 0x10)) {  // if an intermediate node
                                                                        TUTFNode *lvl6 = NULL;
                                                                        TTreeNode *Lvl6Node = NULL;
                                                                        tree_pos = utf->tree_seg_offset + lvl5->child_offset;

                                                                        if(lvl6 = AllocNodeMem()) {
                                                                            do {
                                                                                ReadNode(tree_pos, lvl6);
                                                                                Lvl6Node = MainForm->UTFTreeView->Items->AddChild(Lvl5Node, GetNodeName(utf->string_seg_offset + lvl6->string_offset));

                                                                                Lvl6Node->Data = (void *)(utf->data_seg_offset + lvl6->child_offset);

                                                                                tree_pos = utf->tree_seg_offset + lvl6->sibling_offset;
                                                                            } while(lvl6->sibling_offset != 0);

                                                                            delete lvl6;
                                                                        }
                                                                    }
                                                                    else {
                                                                        Lvl5Node->Data = (void *)(utf->data_seg_offset + lvl5->child_offset);

                                                                        // get data to fix up radius etc...
                                                                        if(Lvl5Node->Text.LowerCase() == "vmeshref") {
                                                                            Update(utf->data_seg_offset + lvl5->child_offset);
                                                                        }
                                                                    }

                                                                    tree_pos = utf->tree_seg_offset + lvl5->sibling_offset;
                                                                } while(lvl5->sibling_offset != 0);

                                                                delete lvl5;
                                                            }
                                                        }
                                                        else {
                                                            Lvl4Node->Data = (void *)(utf->data_seg_offset + lvl4->child_offset);

                                                            // scan for vertex details here - only collect first LOD as that's what SUR file needs to resize

                                                            // get data to fix up radius etc... for stock cmp file with single lod
                                                            if(Lvl4Node->Text.LowerCase() == "vmeshref") {
                                                                Update(utf->data_seg_offset + lvl4->child_offset);
                                                            }
                                                        }

                                                        tree_pos = utf->tree_seg_offset + lvl4->sibling_offset;
                                                    } while(lvl4->sibling_offset != 0);

                                                    delete lvl4;
                                                }
                                            }
                                            else {
                                                Lvl3Node->Data = (void *)(utf->data_seg_offset + lvl3->child_offset);

                                                // scan for vertex details here - only collect first LOD as that's what SUR file needs to resize

                                                // get data to fix up radius etc... for stock cmp file with single lod
                                                if(Lvl3Node->Text.LowerCase() == "vmeshref") {
                                                    Update(utf->data_seg_offset + lvl3->child_offset);
                                                }

                                            }

                                            tree_pos = utf->tree_seg_offset + lvl3->sibling_offset;
                                        } while(lvl3->sibling_offset != 0);

                                        delete lvl3;
                                    }
                                }
                                else {
                                    Lvl2Node->Data = (void *)(utf->data_seg_offset + lvl2->child_offset);

                                    // get data to fix up radius etc... for 3db file
                                    if(Lvl2Node->Text.LowerCase() == "vmeshref") {
                                        Update(utf->data_seg_offset + lvl2->child_offset);
                                    }

                                }

                                tree_pos = utf->tree_seg_offset + lvl2->sibling_offset;
                            } while(lvl2->sibling_offset != 0);

                            delete lvl2;
                        }
                    }
                    else {   // leaf node so store the data for viewing if required
                        //FillNodeData(Lvl1Node->Text, utf->data_seg_offset + lvl1->child_offset, lvl1->size1);
                        Lvl1Node->Data = (void *)(utf->data_seg_offset + lvl1->child_offset);
                    }

                    tree_pos = utf->tree_seg_offset + lvl1->sibling_offset;
                } while(lvl1->sibling_offset != 0);

                delete lvl1;
            }

            delete root;
        }
    }

    delete utf;

    // get info for SUR resizing
    CalculateSURResizeData();
}
//---------------------------------------------------------------------------
void PrescanModel(void) {
    TUTFHeader *utf = NULL;

    try {
        utf = new TUTFHeader;
    }
    catch (std::bad_alloc) {
        MessageDlg("Memory allocation failed - UTF header.",
               mtError, TMsgDlgButtons() << mbOK, 0);

        return;
    }

    // get LOD offsets  (only first two need to be zeroed for later checks)
    Lod_Offset[0] = 0;
    Lod_Offset[1] = 0;

    int mesh_name_count = 0;
    int mesh_pointer_count = 0;

    // initialize the crc class
	CNameCRC *NameCRC = new CNameCRC;

    int lod_index = 0;

    // traverse the UTF tree to fill in node names (6 levels down as that seems the most used)
    if(utf) {
        UINT tree_pos = 0;

        CMPFile->Seek(0, soFromBeginning);
        CMPFile->Read(utf, (int)(sizeof(TUTFHeader)));

        // data reference for operations
        CMPDataOffset = utf->data_seg_offset;

        tree_pos = utf->tree_seg_offset;

        MainForm->UTFTreeView->Items->Clear(); // remove any existing nodes

        // Add a root node
        TUTFNode *root = NULL;
        TTreeNode *RootNode = NULL;

        if(root = AllocNodeMem()) {
            TTreeNode *Lvl1Node = NULL;

            ReadNode(tree_pos, root);
            RootNode = MainForm->UTFTreeView->Items->Add(NULL, GetNodeName(utf->string_seg_offset + root->string_offset));

            TUTFNode *lvl1 = NULL;
            tree_pos = utf->tree_seg_offset + root->child_offset;

            if(lvl1 = AllocNodeMem()) {
                do {
                    ReadNode(tree_pos, lvl1);
                    Lvl1Node = MainForm->UTFTreeView->Items->AddChild(RootNode, GetNodeName(utf->string_seg_offset + lvl1->string_offset));

                    if((lvl1->flags & 0x10)) {  // if an intermediate node
                        TUTFNode *lvl2 = NULL;
                        TTreeNode *Lvl2Node = NULL;
                        tree_pos = utf->tree_seg_offset + lvl1->child_offset;

                        if(lvl2 = AllocNodeMem()) {
                            do {
                                ReadNode(tree_pos, lvl2);
                                Lvl2Node = MainForm->UTFTreeView->Items->AddChild(Lvl1Node, GetNodeName(utf->string_seg_offset + lvl2->string_offset));

                                if((lvl2->flags & 0x10)) {  // if an intermediate node
                                    TUTFNode *lvl3 = NULL;
                                    TTreeNode *Lvl3Node = NULL;
                                    tree_pos = utf->tree_seg_offset + lvl2->child_offset;

                                    if(AnsiPos((AnsiString)".vms", Lvl2Node->Text)) {
                                        // stash the CRC of the vms name for any resizing
                                        Mesh_Info[mesh_name_count++][0] = NameCRC->GenerateCRC(Lvl2Node->Text.c_str());
                                    }

                                    if(lvl3 = AllocNodeMem()) {
                                        do {
                                            ReadNode(tree_pos, lvl3);
                                            Lvl3Node = MainForm->UTFTreeView->Items->AddChild(Lvl2Node, GetNodeName(utf->string_seg_offset + lvl3->string_offset));

                                            if((lvl3->flags & 0x10)) {  // if an intermediate node
                                                TUTFNode *lvl4 = NULL;
                                                TTreeNode *Lvl4Node = NULL;
                                                tree_pos = utf->tree_seg_offset + lvl3->child_offset;

                                                if(lvl4 = AllocNodeMem()) {
                                                    do {
                                                        ReadNode(tree_pos, lvl4);
                                                        Lvl4Node = MainForm->UTFTreeView->Items->AddChild(Lvl3Node, GetNodeName(utf->string_seg_offset + lvl4->string_offset));

                                                        if((lvl4->flags & 0x10)) {  // if an intermediate node
                                                            TUTFNode *lvl5 = NULL;
                                                            TTreeNode *Lvl5Node = NULL;
                                                            tree_pos = utf->tree_seg_offset + lvl4->child_offset;

                                                            if(lvl5 = AllocNodeMem()) {
                                                                do {
                                                                    ReadNode(tree_pos, lvl5);
                                                                    Lvl5Node = MainForm->UTFTreeView->Items->AddChild(Lvl4Node, GetNodeName(utf->string_seg_offset + lvl5->string_offset));

                                                                    if((lvl5->flags & 0x10)) {  // if an intermediate node
                                                                        TUTFNode *lvl6 = NULL;
                                                                        TTreeNode *Lvl6Node = NULL;
                                                                        tree_pos = utf->tree_seg_offset + lvl5->child_offset;

                                                                        if(lvl6 = AllocNodeMem()) {
                                                                            do {
                                                                                ReadNode(tree_pos, lvl6);
                                                                                Lvl6Node = MainForm->UTFTreeView->Items->AddChild(Lvl5Node, GetNodeName(utf->string_seg_offset + lvl6->string_offset));

                                                                                Lvl6Node->Data = (void *)(utf->data_seg_offset + lvl6->child_offset);

                                                                                tree_pos = utf->tree_seg_offset + lvl6->sibling_offset;
                                                                            } while(lvl6->sibling_offset != 0);

                                                                            delete lvl6;
                                                                        }
                                                                    }
                                                                    else {
                                                                        Lvl5Node->Data = (void *)(utf->data_seg_offset + lvl5->child_offset);
                                                                    }

                                                                    tree_pos = utf->tree_seg_offset + lvl5->sibling_offset;
                                                                } while(lvl5->sibling_offset != 0);

                                                                delete lvl5;
                                                            }
                                                        }
                                                        else {
                                                            Lvl4Node->Data = (void *)(utf->data_seg_offset + lvl4->child_offset);
                                                        }

                                                        tree_pos = utf->tree_seg_offset + lvl4->sibling_offset;
                                                    } while(lvl4->sibling_offset != 0);

                                                    delete lvl4;
                                                }
                                            }
                                            else {
                                                Lvl3Node->Data = (void *)(utf->data_seg_offset + lvl3->child_offset);

                                                // offset to correct LOD data
                                                if(Lvl3Node->Text.LowerCase() == "vmeshdata") {
                                                    Mesh_Info[mesh_pointer_count++][1] = utf->data_seg_offset + lvl3->child_offset;
                                                }
                                            }

                                            tree_pos = utf->tree_seg_offset + lvl3->sibling_offset;
                                        } while(lvl3->sibling_offset != 0);

                                        delete lvl3;
                                    }
                                }
                                else {

                                    Lvl2Node->Data = (void *)(utf->data_seg_offset + lvl2->child_offset);

                                }

                                tree_pos = utf->tree_seg_offset + lvl2->sibling_offset;
                            } while(lvl2->sibling_offset != 0);

                            delete lvl2;
                        }
                    }
                    else {   // leaf node so store the data for viewing if required
                        Lvl1Node->Data = (void *)(utf->data_seg_offset + lvl1->child_offset);
                    }

                    tree_pos = utf->tree_seg_offset + lvl1->sibling_offset;
                } while(lvl1->sibling_offset != 0);

                delete lvl1;
            }

            delete root;
        }
    }

    delete utf;
}
//---------------------------------------------------------------------------
void DumpVMeshData(void) {
    TVMeshDataHeader mesh_data_header;
    TMeshHeader      mesh_header;
    TTriangle        triangle;
    TVertex          vertex;

    AnsiString temp;
    int count, no_triangles;

    // find the data from stored offset
    CMPFile->Seek((int)MainForm->UTFTreeView->Selected->Data, soFromBeginning);

    CMPFile->Read(&mesh_data_header, sizeof(TVMeshDataHeader));
    MainForm->CMPMemo->Lines->Add("VMeshData Section");
    MainForm->CMPMemo->Lines->Add("-----------------");
    MainForm->CMPMemo->Lines->Add("");

    MainForm->CMPMemo->Lines->Add("VMeshData header:");
    temp.printf("Unknown1        : 0x%08X\t(always 0x00000001)", mesh_data_header.unknown1);
    MainForm->CMPMemo->Lines->Add(temp);
    temp.printf("Unknown2        : 0x%08X\t(always 0x00000004)", mesh_data_header.unknown2);
    MainForm->CMPMemo->Lines->Add(temp);
    temp.printf("no_meshes       : %d", mesh_data_header.no_meshes);
    MainForm->CMPMemo->Lines->Add(temp);
    temp.printf("no_ref_vertices : %d", mesh_data_header.no_ref_vertices);
    MainForm->CMPMemo->Lines->Add(temp);
    temp.printf("fvf             : 0x%04X\t(always 0x0112)", mesh_data_header.fvf);
    MainForm->CMPMemo->Lines->Add(temp);
    temp.printf("no_vertices     : %d", mesh_data_header.no_vertices);
    MainForm->CMPMemo->Lines->Add(temp);
    MainForm->CMPMemo->Lines->Add("");

    // mesh headers
    MainForm->CMPMemo->Lines->Add("Mesh headers :");
    MainForm->CMPMemo->Lines->Add("");
    for(count = 0; count < mesh_data_header.no_meshes; count++) {
        CMPFile->Read(&mesh_header, sizeof(TMeshHeader));

        temp.printf("material_id     : 0x%08X", mesh_header.material_id);
        MainForm->CMPMemo->Lines->Add(temp);
        temp.printf("start_vertex    : %d", mesh_header.start_vertex);
        MainForm->CMPMemo->Lines->Add(temp);
        temp.printf("end_vertex      : %d", mesh_header.end_vertex);
        MainForm->CMPMemo->Lines->Add(temp);
        temp.printf("no_ref_vertices : %d", mesh_header.no_ref_vertices);
        MainForm->CMPMemo->Lines->Add(temp);
        temp.printf("padding         : 0x%04X\t(always 0x00CC)", mesh_header.padding);
        MainForm->CMPMemo->Lines->Add(temp);
        MainForm->CMPMemo->Lines->Add("");
    }

    // triangle data
    no_triangles = mesh_data_header.no_ref_vertices / 3;

    MainForm->CMPMemo->Lines->Add("Triangles :");
    MainForm->CMPMemo->Lines->Add("");
    temp.printf("Vertex 0\tVertex 1\tVertex 2");
    MainForm->CMPMemo->Lines->Add(temp);

    for(count = 0; count < no_triangles; count++) {
        CMPFile->Read(&triangle, sizeof(TTriangle));

        temp.printf("%d\t\t%d\t\t%d\t\t", triangle.vertex1, triangle.vertex2, triangle.vertex3);
        MainForm->CMPMemo->Lines->Add(temp);
    }
    MainForm->CMPMemo->Lines->Add("");
    
    // vertex data
    MainForm->CMPMemo->Lines->Add("Vertices :");
    MainForm->CMPMemo->Lines->Add("");
    temp.printf("Vertex X\tVertex Y\tVertex Z\tnormal X\tnormal Y\tnormal Z\tu\t\tv");
    MainForm->CMPMemo->Lines->Add(temp);

    for(count = 0; count < mesh_data_header.no_vertices; count++) {
        CMPFile->Read(&vertex, sizeof(TVertex));

        temp.printf("%f\t%f\t%f\t%f\t%f\t%f\t%f\t%f", vertex.x, vertex.x, vertex.z, vertex.normal_x, vertex.normal_y, vertex.normal_z, vertex.u, vertex.v);
        MainForm->CMPMemo->Lines->Add(temp);
    }
}
//---------------------------------------------------------------------------
void DumpVWireData(void) {
    TVWireData      wire_data;
    TVWireDataLine  wire_line;

    AnsiString temp;
    int count, no_lines;

    // find the data from stored offset
    CMPFile->Seek((int)MainForm->UTFTreeView->Selected->Data, soFromBeginning);

    CMPFile->Read(&wire_data, sizeof(TVWireData));
    MainForm->CMPMemo->Lines->Add("VWireData Section");
    MainForm->CMPMemo->Lines->Add("-----------------");
    MainForm->CMPMemo->Lines->Add("");

    MainForm->CMPMemo->Lines->Add("VWireData header :");
    temp.printf("header_size          : 0x%08X\t(always 0x00000010", wire_data.header_size);
    MainForm->CMPMemo->Lines->Add(temp);
    temp.printf("vmeshlib_crc_id      : 0x%08X\t(crc of .vms used for vertices)", wire_data.vmeshlib_crc_id);
    MainForm->CMPMemo->Lines->Add(temp);
    temp.printf("vertex_offset        : 0x%04X", wire_data.unknown1);
    MainForm->CMPMemo->Lines->Add(temp);
    temp.printf("no_vertices          : %d", wire_data.no_vertices);
    MainForm->CMPMemo->Lines->Add(temp);
    temp.printf("no_ref_vertices      : %d", wire_data.no_ref_vertices);
    MainForm->CMPMemo->Lines->Add(temp);
    temp.printf("max_vert_no_plus_one : %d", wire_data.unknown2);
    MainForm->CMPMemo->Lines->Add(temp);
    MainForm->CMPMemo->Lines->Add("");

    // line data
    no_lines = wire_data.no_ref_vertices / 2;
    MainForm->CMPMemo->Lines->Add("VWireData lines :");
    temp.printf("Vert\t->\tVert");
    MainForm->CMPMemo->Lines->Add(temp);

    for(count = 0; count < no_lines; count++) {
        CMPFile->Read(&wire_line, sizeof(TVWireDataLine));

        temp.printf("%d\t->\t%d", wire_line.point1, wire_line.point2);
        MainForm->CMPMemo->Lines->Add(temp);
    }
}
//---------------------------------------------------------------------------
void DumpVMeshRef(void) {
    TVMeshRef vmeshref;

    AnsiString temp;

    // find the data from stored offset
    CMPFile->Seek((int)MainForm->UTFTreeView->Selected->Data, soFromBeginning);

    CMPFile->Read(&vmeshref, sizeof(TVMeshRef));
    MainForm->CMPMemo->Lines->Add("VMeshRef Section");
    MainForm->CMPMemo->Lines->Add("----------------");
    MainForm->CMPMemo->Lines->Add("");

    MainForm->CMPMemo->Lines->Add("VMeshRef :");
    temp.printf("header_size : 0x%08X", vmeshref.header_size);
    MainForm->CMPMemo->Lines->Add(temp);
    temp.printf("vmesh_id : 0x%08X", vmeshref.vmesh_id);
    MainForm->CMPMemo->Lines->Add(temp);
    temp.printf("start_vert : %d", vmeshref.start_vert);
    MainForm->CMPMemo->Lines->Add(temp);
    temp.printf("end_vert : %d", vmeshref.end_vert);
    MainForm->CMPMemo->Lines->Add(temp);
    temp.printf("start_vert_ref : %d", vmeshref.start_vert_ref);
    MainForm->CMPMemo->Lines->Add(temp);
    temp.printf("end_vert_ref : %d", vmeshref.end_vert_ref);
    MainForm->CMPMemo->Lines->Add(temp);
    temp.printf("mesh_no : %d", vmeshref.mesh_no);
    MainForm->CMPMemo->Lines->Add(temp);
    temp.printf("no_of_meshes : %d", vmeshref.no_of_meshes);
    MainForm->CMPMemo->Lines->Add(temp);
    temp.printf("Bounding Box :");
    MainForm->CMPMemo->Lines->Add(temp);
    temp.printf("xmin\tymin\tzmin");
    MainForm->CMPMemo->Lines->Add(temp);
    temp.printf("%f\t%f\t%f", vmeshref.bounding_box[1], vmeshref.bounding_box[3], vmeshref.bounding_box[5]);
    MainForm->CMPMemo->Lines->Add(temp);
    temp.printf("xmaxn\tymax\tzmax");
    MainForm->CMPMemo->Lines->Add(temp);
    temp.printf("%f\t%f\t%f", vmeshref.bounding_box[0], vmeshref.bounding_box[2], vmeshref.bounding_box[4]);
    MainForm->CMPMemo->Lines->Add(temp);
    temp.printf("Center : %f\t%f\t%f", vmeshref.center[0], vmeshref.center[1], vmeshref.center[2]);
    MainForm->CMPMemo->Lines->Add(temp);
    temp.printf("Radius : %f", vmeshref.radius);
    MainForm->CMPMemo->Lines->Add(temp);
}
//---------------------------------------------------------------------------
#pragma package(smart_init)
