//---------------------------------------------------------------------------

#ifndef surH
#define surH

#include <vcl.h>
#pragma hdrstop

//---------------------------------------------------------------------------
// SUR File Structs

// Updated October 13th 2004
struct TSurHeader {
    DWORD tag;          //should be "vers";
    float version;      //should be 2.0
};

struct TIDHeader {          //--- 8 bytes
    DWORD crc_id;
    DWORD type;             // 2 (scenery eg asteroids)
                            // 3 (equip, ammo & damaged sections)
                            // 4 (ships and stations)
};

struct TIDHeaderB {
    DWORD tag;              // (ansi "!fxd" - only exists if m_type > 2)
};

struct TExtsPart {          // (Bounding Box data) --- 28 bytes
    DWORD tag;              // "exts"
    float xMin;
    float yMin;
    float zMin;
    float xMax;
    float yMax;
    float zMax;
};

struct TSurfaceHeader {     // --- 8 bytes
    DWORD tag;              // "surf"
    WORD  Offset1;          // (number of bytes to hpid section or next component)
    WORD  Padding1;         // always 0
};

struct TSurface {            // --- Offset1
    float center[3];
    float inertia_moment[3];   ///<<<<< that's almost certain now
    float radius;
    BYTE  unknown;         // The only one left?
    WORD  Offset1b;        // Always identical to Offset1
    BYTE  Padding2;        // Always 0
    DWORD Offset2;         // (offset to triangle group data including this structure)
    DWORD Padding3[3];     // always 0 ?
};

struct TSurTriangleGroupHeader {  //--- 16 bytes ***repeats every <Tricount> Triangle Sections***
    DWORD Offset3;                // (number of bytes to first Vertex Section, including this header)
    DWORD TriangleID;             // (the reference id used assosiate triangles with vertices)
    BYTE  type;                   // ('4' = D3DPT_TRIANGLELIST or '5' = D3DPT_TRIANGLESTRIP)
    WORD  no_ref_verts;           // number of referenced verticies ?
    BYTE  padding4;
    DWORD Tricount;               // (number of triangle sections in group (note indexed from 0 to N-1))
};

struct TSurTriangle {      // --- 16 bytes ***Reapeats <Tricount> times***
    DWORD TriNumber:12;    // (the triangle index, starting at 0, 12 bits)
    DWORD tri_op:12;       //opposite triangle index, 12 bits  ??
    DWORD flag:8;          //exit flag ? , 8 bits If set it's always the last batch before the vertices declaration. I don't know how significant that is.
    WORD  Vertex1;         // (index of the first vertex in the triangle (vertexes are incrementally numbered from the start of the vertex section)
    short offset1:15;      //offset /4 of to the same next edge, 15 bits
    short flag1:1;         //1 one bit
    WORD  Vertex2;         // (index of the second vertex)
    short offset2:15;      //offset / 4 to the same next edge
    short flag2:1;
    WORD  Vertex3;         //(index of the third Vertex)
    short offset3:15;      //offset / 4 to the same next edge
    short flag3:1;
};

struct TSurVertex {             //--- 16 bytes
    float X;              // (coordinate on the X Axe)
    float Y;              // (coordinate on the Y Axe)
    float Z;              // (coordinate on the Z Axe)
    DWORD TriID;          // (reference to the Triangle group Header Section (the TriangleID)
};

struct TBitsSection {         //--- 28 bytes ***unknown Section***
    int   offset_to_next_sibling;   //the offset to the child of the tree (this header included)
    int   offset_to_triangles;      //the offset to the Triangle_group_Header linked to this bit
    float cenX;           // (X coord of the center point of a triangle section, and other stuff)
    float cenY;           // (y coord)
    float cenZ;           // (z coord)
    float radius;
    DWORD color;          // That's more a guess than anything else but i can't see any other explanation.
                          // my addition - internal reference number? siblings without triangle offsets
                          // share this number with the triangle group they're related to.
};

struct THPIDHeader {        //--- 8 bytes ***this is not in all sections***
    DWORD tag;              //"hpid" (ansi)
    DWORD noBlocks;         // (number of hpid data blocks)
};

struct THPIDDataBlock {     //--- 4 bytes ***repeats <noBlocks> times***
    DWORD crc_id;
};

//compiled by Twex, Phantom Fox, Free Spirit, Dr Del, CCCP, shsan and Skyshooter
//---------------------------------------------------------------------------
AnsiString IntToBinary(DWORD input);
void ResizeSUR(bool autosize);
void DumpSURFile(AnsiString filename);
//---------------------------------------------------------------------------
#endif
