//---------------------------------------------------------------------------

#include <vcl.h>
#include <exception>
#include <iostream>
#pragma hdrstop

#include "main.h"
#include "cmp.h"
#include "sur.h"
#include "resize_cmp.h"
#include "resize_sur.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TMainForm *MainForm;

TMemoryStream *CMPFile;
TMemoryStream *SURFile;

DWORD CMPDataOffset;
TSURResizeData sur_resize_data;   // from cmp file
TSURResizeData sur_resize_data2;  // from sur file

bool got_cmp = false;
//---------------------------------------------------------------------------
__fastcall TMainForm::TMainForm(TComponent* Owner)
    : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::SUROpenButtonClick(TObject *Sender)
{
    bool alloc_ok = true;

    if(SUROpenDialog->Execute()) {
        try {
            SURFile = new TMemoryStream;
        }
        catch(std::bad_alloc) {
            MessageDlg("Memory allocation failed for the SUR file.",
                mtError, TMsgDlgButtons() << mbOK, 0);

            alloc_ok = false;
        }

        if(!alloc_ok) {
            // cleanup
            if(SURFile) delete SURFile;

            SURFile = NULL;

            return;
        }

        // setup sur type radio group
        ResizeSurForm->SurTypeRadioGroup->ItemIndex = -1;
        ResizeSurForm->SetFocusedControl(ResizeSurForm->OkButton);

        SURResizeButton->Enabled = false;
        SURSaveButton->Enabled = false;
        SURTextSaveButton->Enabled = false;

        SURFileNameLabel->Caption = "-";
        SURFile->Clear();
        SURMemo->Lines->Clear();

        SURFile->LoadFromFile(SUROpenDialog->FileName);
        SURFileNameLabel->Caption = ExtractFileName(SUROpenDialog->FileName);

        DumpSURFile(SUROpenDialog->FileName);

        SURResizeButton->Enabled = true;
        SURSaveButton->Enabled = true;
        SURTextSaveButton->Enabled = true;
    }
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::FormCreate(TObject *Sender)
{
    CMPFile = SURFile = NULL;
    sur_resize_data.xmin = 0;
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::FormClose(TObject *Sender, TCloseAction &Action)
{
    delete CMPFile;
    delete SURFile;
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::SURTextSaveButtonClick(TObject *Sender)
{
    TextSaveDialog->FileName = SUROpenDialog->FileName + ".txt";

    if(TextSaveDialog->Execute())
        SURMemo->Lines->SaveToFile(TextSaveDialog->FileName);
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::CMPOpenButtonClick(TObject *Sender)
{
    bool alloc_ok = true;

    if(CMPOpenDialog->Execute()) {
        try {
            CMPFile = new TMemoryStream;
        }
        catch(std::bad_alloc) {
            MessageDlg("Memory allocation failed for the CMP file.",
                mtError, TMsgDlgButtons() << mbOK, 0);

            alloc_ok = false;
        }

        if(!alloc_ok) {
            // cleanup
            if(CMPFile) delete CMPFile;

            CMPFile = NULL;

            return;
        }

        CMPResizeButton->Enabled = false;
        CMPSaveButton->Enabled = false;

        CMPFileNameLabel->Caption = "-";
        CMPFile->Clear();
        CMPMemo->Clear();

        CMPFile->LoadFromFile(CMPOpenDialog->FileName);
        CMPFileNameLabel->Caption = ExtractFileName(CMPOpenDialog->FileName);

        PrescanModel();
        GetFileInfo();

        CMPResizeButton->Enabled = true;
        CMPSaveButton->Enabled = true;

        got_cmp = true;
    }
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::UTFTreeViewDblClick(TObject *Sender)
{
    // dump node data
    CMPMemo->Clear();

    if(UTFTreeView->Selected->Text.LowerCase() == "vmeshdata")
        DumpVMeshData();

    if(UTFTreeView->Selected->Text.LowerCase() == "vwiredata")
        DumpVWireData();

    if(UTFTreeView->Selected->Text.LowerCase() == "vmeshref")
        DumpVMeshRef();

}
//---------------------------------------------------------------------------

void __fastcall TMainForm::CMPSaveButtonClick(TObject *Sender)
{
    CMPSaveDialog->FileName = CMPOpenDialog->FileName;

    if(CMPSaveDialog->Execute()) {
        CMPFile->SaveToFile(CMPSaveDialog->FileName);
        CMPMemo->Lines->Clear();
        CMPMemo->Lines->Add("Updated CMP saved.");
    }
}
//---------------------------------------------------------------------------


void __fastcall TMainForm::SURResizeButtonClick(TObject *Sender)
{
    //AutoResizeSUR();
    ResizeSurForm->Visible = true;
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::SURSaveButtonClick(TObject *Sender)
{
    SURSaveDialog->FileName = SUROpenDialog->FileName;

    if(SURSaveDialog->Execute())
        SURFile->SaveToFile(SURSaveDialog->FileName);
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::CMPResizeButtonClick(TObject *Sender)
{
    ResizeCMPForm->Visible = true;
}
//---------------------------------------------------------------------------

