using System;

namespace TLR.Freelancer.Utility
{
	/// <summary>
	/// Manipulates Freelancer saved game information.
	/// </summary>
	public class SavedGame
	{

		// Get line from file, decoded as list of words
		// Code pinched from "flcodec" by Jor <flcodec@jors.net>
		/// <summary>
		/// Decodes data from a Freelancer .fl save game file
		/// </summary>
		/// <param name="filepath">Path to the savegame file.</param>
		/// <returns>human-readable content of the savegame file.</returns>
		public string DecodeCharacter(string filepath)
		{
			// read the entire raw file as a character array;
			// we immediately strip out the FLS1 using Substring(4).
			char[] data = (new System.IO.StreamReader(filepath, System.Text.Encoding.UTF7)).
				ReadToEnd().Substring(4).ToCharArray();
			// create a pre-sized stringbuilder.
			System.Text.StringBuilder sb =
				new System.Text.StringBuilder(data.Length);
			char[] gene = "Gene".ToCharArray();
			for(int i = 0; i < data.GetLength(0); i++)
			{
				sb.Append((char)(data[i] ^ (((gene[i % 4] + i) % 256) | 0x80)));
			}
			return(sb.ToString());
		}

	}
}
