using System;

namespace TLR.Freelancer.Utility
{
	/// <summary>
	/// Provides support for manipulating ids name/info strings.
	/// </summary>
	public class IdsData
	{


		/// <summary>
		/// Generates RDL string for a Freelancer item.
		/// </summary>
		/// <param name="displayName">In-game display name for the item.</param>
		/// <param name="idsInfo">Extended in-game information display for the item.</param>
		/// <returns>RDL-formatted string ready to directly insert into a resource DLL.</returns>
		public string MakeIdsName(string displayName, string idsInfo)
		{
			return
				("<?xml version=\"1.0\" encoding=\"UTF-16\"?><RDL><PUSH/>"
				+ "<TRA data=\"1\" mask=\"1\" def=\"-2\"/><JUST loc=\"center\"/><TEXT>"
				+ displayName
				+ "</TEXT><PARA/><TEXT> </TEXT><PARA/><TRA data=\"0\" mask=\"1\" def=\"-1\"/>"
				+ "<JUST loc=\"left\"/><TEXT>"
				+ idsInfo
				+ "</TEXT><PARA/><POP/></RDL>");
      }


	}
}
