' SetM1Reward.vbs
' Resets the single player first mission reward money
' Based on a TLR posting by Chips
' http://www.lancersreactor.com/t/forum/topic.asp?topic_id=30979
' Script by Watercooler Warrior

' NOTES:
' + If you run the script with the starting money as an argument,
'   you are not prompted for the starting money.
' + If you use the /S option, it suppresses the confirmation.
Dim m_Suppress: m_Suppress = WScript.Arguments.Named.Exists("S")

Dim iniPath: iniPath = "MISSIONS\M01A\m01a.ini"
filepath = GetFlIniPath(iniPath)
Dim data: data = ReadFile(filepath)
If Len(data) < 4 Then
	Die "Could not find data in mission 1a file " & filepath, 2
ElseIf Left(data, 4) = "BINI" Then
	Die "Your mission file is a compressed BINI file. Get the Freelancer SDK at http://www.lancersreactor.com before using this script.", 3
End If

Dim newValue: newValue = GetSingleValueInput( _
	"How many credits do want as mission 1 reward?", _
	"Mission 1 Reward amount", 2000)
If Not IsNumeric(newValue) Then Die newValue & " is not a number.", 4
' 4000


Dim rx: Set rx = New RegExp
rx.IgnoreCase = True
rx.Multiline = True
rx.Pattern = "^\s*reward\s*=.+$"
If Not rx.Test(data) Then Die "Sorry, couldn't find start money value.", 5

data = rx.Replace(data, "reward = " & newValue)

WriteFile filepath, data

Die "Start money updated.", 0 ' 0 means no error, of course.



Function GetFlIniPath(ByVal relativePath)
	' Given the path to a Freelancer INI file, returns the file content
	Dim path: path = CreateObject("WScript.Shell").RegRead( _
		"HKLM\SOFTWARE\Microsoft\Microsoft Games\Freelancer\1.0\AppPath")
	Dim fso: Set fso = CreateObject("Scripting.FileSystemObject")
	GetFlIniPath = fso.BuildPath(fso.BuildPath(path, "Data"), relativePath)
End Function

Function GetSingleValueInput(ByVal prompt, ByVal title, ByVal defaultValue)
	' Checks for a single value from the command line.
	' If not found, prompts with the value of prompt
	If WScript.Arguments.UnNamed.Count > 0 Then
		GetSingleValueInput = WScript.Arguments.UnNamed(0)
	Else
		GetSingleValueInput = InputBox(prompt, title, defaultValue)
	End If
End Function

Function ReadFile(FilePath)
	Dim fso, file
	Set fso = createobject("Scripting.FileSystemObject")
	If fso.FileExists(FilePath) Then
		Set file = fso.OpenTextFile(FilePath, 1, False, -2)
		If file.AtEndOfStream = False Then ReadFile = file.ReadAll
		file.Close
	End If
End Function

Sub WriteFile(filepath, data)
	'writes sData to FilePath
	With CreateObject("Scripting.FileSystemObject")._
		OpenTextFile(filepath, 2, True)
		.Write data: .Close
	End With
End Sub


Sub Die(ByVal message, ByVal errorCode)
	If Not m_Suppress Then WScript.Echo message
	WScript.Quit errorCode
End Sub