/*
 * Decompiled with CFR 0.152.
 */
package freelancer.traderoutes;

import freelancer.filter.TradeRouteFilter;
import java.awt.Color;
import java.awt.Component;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class TradeRouteCellRenderer
extends DefaultTableCellRenderer {
    private Color mo_ExcludeColor = new Color(255, 164, 164);
    private Color mo_SelectedExcludeColor = new Color(255, 154, 210);
    private TradeRouteFilter mo_Filter = null;
    private NumberFormat mo_DollarFormat = NumberFormat.getCurrencyInstance(Locale.US);
    private NumberFormat mo_DollarFractionFormat;

    public TradeRouteCellRenderer() {
        this.mo_DollarFormat.setMaximumFractionDigits(0);
        this.mo_DollarFractionFormat = NumberFormat.getCurrencyInstance(Locale.US);
        this.mo_DollarFractionFormat.setMaximumFractionDigits(2);
        this.mo_DollarFractionFormat.setMinimumFractionDigits(2);
    }

    public Component getTableCellRendererComponent(JTable ao_Table, Object ao_Value, boolean ab_IsSelected, boolean ab_HasFocus, int ai_Row, int ai_Column) {
        Component lo_Result = super.getTableCellRendererComponent(ao_Table, ao_Value, ab_IsSelected, ab_HasFocus, ai_Row, ai_Column);
        if (ao_Value instanceof Integer) {
            ((JLabel)lo_Result).setText(this.mo_DollarFormat.format(ao_Value));
            ((JLabel)lo_Result).setHorizontalAlignment(11);
        } else if (ao_Value instanceof Double) {
            ((JLabel)lo_Result).setText(this.mo_DollarFractionFormat.format(ao_Value));
            ((JLabel)lo_Result).setHorizontalAlignment(11);
        } else if (ao_Value instanceof Short) {
            ((JLabel)lo_Result).setHorizontalAlignment(11);
        } else {
            ((JLabel)lo_Result).setHorizontalAlignment(10);
        }
        if (!(this.mo_Filter == null || this.mo_Filter.hideFactions() && this.mo_Filter.hideCommodities() || this.mo_Filter.getMode() != 0)) {
            if (this.mo_Filter.acceptFaction((String)ao_Table.getModel().getValueAt(ai_Row, 0)) && this.mo_Filter.acceptFaction((String)ao_Table.getModel().getValueAt(ai_Row, 1)) && this.mo_Filter.acceptCommodity((String)ao_Table.getModel().getValueAt(ai_Row, 2))) {
                if (ab_IsSelected) {
                    lo_Result.setBackground(ao_Table.getSelectionBackground());
                } else {
                    lo_Result.setBackground(ao_Table.getBackground());
                }
            } else if (ab_IsSelected) {
                lo_Result.setBackground(this.mo_SelectedExcludeColor);
            } else {
                lo_Result.setBackground(this.mo_ExcludeColor);
            }
        } else if (ab_IsSelected) {
            lo_Result.setBackground(ao_Table.getSelectionBackground());
        } else {
            lo_Result.setBackground(ao_Table.getBackground());
        }
        return lo_Result;
    }

    public void setFilter(TradeRouteFilter ao_Filter) {
        this.mo_Filter = ao_Filter;
    }
}

