/*
 * Decompiled with CFR 0.152.
 */
package freelancer;

import freelancer.DataParser;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MapDialog
extends JDialog {
    private String ms_Start;
    private String ms_Destination;
    private MapCanvas mo_MapCanvas;
    private DataParser mo_DataParser = null;
    private JLabel mo_LblFrom;
    private JPanel mo_PnlMap;
    private JLabel mo_LblStart;
    private JLabel mo_LblTo;
    private JLabel mo_LblDestination;

    public MapDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setBackground(SystemColor.control);
        this.getContentPane().setBackground(SystemColor.control);
        this.setLocation(0, 50);
        this.mo_MapCanvas = new MapCanvas();
        this.mo_PnlMap.add(this.mo_MapCanvas);
        this.mo_MapCanvas.setBounds(0, 0, 372, 373);
    }

    public void setStart(String as_SystemName) {
        this.ms_Start = as_SystemName;
    }

    public void setDestination(String as_SystemName) {
        this.ms_Destination = as_SystemName;
    }

    public void updateMap() {
        Object lo_Destination = null;
        if (this.ms_Start != null && this.ms_Destination != null) {
            this.mo_LblStart.setText(this.ms_Start + " (" + this.mo_DataParser.getTradePoint(this.ms_Start).getParent() + ")");
            this.mo_LblDestination.setText(this.ms_Destination + " (" + this.mo_DataParser.getTradePoint(this.ms_Destination).getParent() + ")");
            this.mo_MapCanvas.paint(this.mo_MapCanvas.getGraphics());
        }
    }

    public void setDataParser(DataParser ao_DataParser) {
        this.mo_DataParser = ao_DataParser;
    }

    private void initComponents() {
        this.mo_LblFrom = new JLabel();
        this.mo_LblStart = new JLabel();
        this.mo_LblTo = new JLabel();
        this.mo_LblDestination = new JLabel();
        this.mo_PnlMap = new JPanel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Universe Map");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                MapDialog.this.closeDialog(evt);
            }
        });
        this.mo_LblFrom.setFont(new Font("Dialog", 0, 12));
        this.mo_LblFrom.setText("From");
        this.mo_LblFrom.setPreferredSize(new Dimension(100, 16));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.mo_LblFrom, gridBagConstraints);
        this.mo_LblStart.setFont(new Font("Dialog", 0, 12));
        this.mo_LblStart.setText("not selected");
        this.mo_LblStart.setPreferredSize(new Dimension(100, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.mo_LblStart, gridBagConstraints);
        this.mo_LblTo.setFont(new Font("Dialog", 0, 12));
        this.mo_LblTo.setText("To");
        this.mo_LblTo.setPreferredSize(new Dimension(100, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.mo_LblTo, gridBagConstraints);
        this.mo_LblDestination.setFont(new Font("Dialog", 0, 12));
        this.mo_LblDestination.setText("not selected");
        this.mo_LblDestination.setPreferredSize(new Dimension(100, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.mo_LblDestination, gridBagConstraints);
        this.mo_PnlMap.setBackground(SystemColor.control);
        this.mo_PnlMap.setMaximumSize(new Dimension(372, 373));
        this.mo_PnlMap.setMinimumSize(new Dimension(372, 373));
        this.mo_PnlMap.setPreferredSize(new Dimension(372, 373));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.mo_PnlMap, gridBagConstraints);
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) {
        new MapDialog((Frame)new JFrame(), true).show();
        System.exit(0);
    }

    class MapCanvas
    extends Canvas {
        private Image mo_MapImage = new ImageIcon(this.getClass().getResource("/freelancer/images/map.jpg")).getImage();

        public void paint(Graphics ao_Graphics) {
            Point lo_Destination = null;
            ao_Graphics.drawImage(this.mo_MapImage, 0, 0, this);
            if (MapDialog.this.ms_Start != null && MapDialog.this.ms_Destination != null) {
                ao_Graphics.setColor(Color.RED);
                Vector lv_Route = MapDialog.this.mo_DataParser.calcRoute(MapDialog.this.mo_DataParser.getTradePoint(MapDialog.this.ms_Start).getParent(), MapDialog.this.mo_DataParser.getTradePoint(MapDialog.this.ms_Destination).getParent());
                Point lo_Start = (Point)MapDialog.this.mo_DataParser.getPositions().get((String)lv_Route.get(0));
                ao_Graphics.fillOval(lo_Start.x - 3, lo_Start.y - 3, 7, 7);
                int i = 1;
                while (i < lv_Route.size()) {
                    lo_Destination = (Point)MapDialog.this.mo_DataParser.getPositions().get((String)lv_Route.get(i));
                    ao_Graphics.drawLine(lo_Start.x, lo_Start.y, lo_Destination.x, lo_Destination.y);
                    ao_Graphics.fillOval(lo_Destination.x - 3, lo_Destination.y - 3, 7, 7);
                    lo_Start = lo_Destination;
                    ++i;
                }
                lo_Start = (Point)MapDialog.this.mo_DataParser.getPositions().get((String)lv_Route.get(0));
                this.showName(ao_Graphics, MapDialog.this.mo_DataParser.getTradePoint(MapDialog.this.ms_Start).getParent(), lo_Start.x + 5, lo_Start.y + 5);
                if (lo_Destination != null) {
                    this.showName(ao_Graphics, MapDialog.this.mo_DataParser.getTradePoint(MapDialog.this.ms_Destination).getParent(), lo_Destination.x + 5, lo_Destination.y + 5);
                }
            }
        }

        private void showName(Graphics ao_Graphics, String as_Name, int ai_X, int ai_Y) {
            Color lo_Color = ao_Graphics.getColor();
            int li_Width = ao_Graphics.getFontMetrics().stringWidth(as_Name) + 4;
            if (ai_X + li_Width > ((MapDialog)MapDialog.this).mo_MapCanvas.getSize().width - 5) {
                ai_X = ((MapDialog)MapDialog.this).mo_MapCanvas.getSize().width - li_Width - 5;
            }
            ao_Graphics.setColor(SystemColor.info);
            ao_Graphics.fillRect(ai_X, ai_Y, li_Width, 18);
            ao_Graphics.setColor(Color.BLACK);
            ao_Graphics.drawRect(ai_X, ai_Y, li_Width, 18);
            ao_Graphics.drawString(as_Name, ai_X + 2, ai_Y + 14);
            ao_Graphics.setColor(lo_Color);
        }
    }
}

